/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.admin.archivesearch;

import com.adventnet.sym.adsm.common.server.admin.archivesearch.ArchFileIndexState;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import org.json.JSONArray;
import org.json.JSONObject;

public class ArchEmberUtil {
    public static JSONObject getArchReportTableData(JSONObject jResult, AdventNetResourceBundle clientRb) throws Exception {
        JSONObject jOutputTableInfo = new JSONObject();
        JSONObject jTableData = new JSONObject();
        JSONArray jTableDataList = new JSONArray();
        JSONArray jOutputRows = new JSONArray();
        JSONArray jHeaderInfo = new JSONArray();
        int totalCount = 0;
        int startValue = 0;
        int rangeValue = 0;
        int tableId = -1;
        int outputRowCount = 0;
        int totalColCount = 0;
        if (!jResult.has("noIndex") && jResult.has("colInfo") && jResult.has("outputRows")) {
            jOutputRows = jResult.getJSONArray("outputRows");
            jHeaderInfo = jResult.getJSONArray("colInfo");
            totalCount = jResult.getInt("totalCount");
            startValue = jResult.getInt("startValue");
            rangeValue = jResult.getInt("rangeValue");
            tableId = jResult.getInt("tableId");
            outputRowCount = jOutputRows.length();
            if (!jOutputRows.isNull(0)) {
                totalColCount = jOutputRows.getJSONArray(0).length();
            }
        }
        for (int i = 0; i < outputRowCount; ++i) {
            JSONArray jOrigRowValues = jOutputRows.getJSONArray(i);
            JSONArray jColumnValues = new JSONArray();
            for (int colIndex = 0; colIndex < totalColCount; ++colIndex) {
                JSONObject jCellObj = new JSONObject();
                jCellObj.put("visible", true);
                jCellObj.put("isData", true);
                jCellObj.put("columnValue", jOrigRowValues.get(colIndex));
                jColumnValues.put((Object)jCellObj);
            }
            JSONObject jRowObj = new JSONObject();
            jRowObj.put("columnValues", (Object)jColumnValues);
            jRowObj.put("isReportTable", false);
            jTableDataList.put((Object)jRowObj);
        }
        jTableData.put("tableDataList", (Object)jTableDataList);
        jTableData.put("tableColumnList", (Object)jHeaderInfo);
        JSONObject jTableInputParams = ArchEmberUtil.getDefaultTableInputParams();
        jTableInputParams.put("totalCount", totalCount);
        jTableInputParams.put("startValue", startValue);
        jTableInputParams.put("rangeValue", rangeValue);
        jTableInputParams.put("tableId", tableId);
        jTableInputParams.put("showAddOrRemove", true);
        if (jResult.has("noIndex") && totalCount == 0) {
            jTableInputParams.put("emptyTableMessage", (Object)clientRb.getString("adap.archive.no_archive_files_indexed"));
            jTableInputParams.put("emptyTableAction", (Object)"emptyTableAction");
            jTableInputParams.put("emptyTableMessage2", (Object)clientRb.getString("adap.archive.click_here_to_index"));
            jTableInputParams.put("noIndex", true);
        } else if (totalCount == 0) {
            jTableInputParams.put("emptyTableMessage", (Object)clientRb.getString("adap.ChartUtil.No_Data_Available"));
            jTableInputParams.put("noIndex", false);
        }
        jOutputTableInfo.put("tableData", (Object)jTableData);
        jOutputTableInfo.put("tableInputParams", (Object)jTableInputParams);
        jOutputTableInfo.put("count", totalCount);
        return jOutputTableInfo;
    }

    public static JSONObject getArchIndexFileTableData(JSONObject jResult, AdventNetResourceBundle clientRb) throws Exception {
        JSONObject jColObj;
        JSONObject jArchIndexFileInfo = new JSONObject();
        JSONArray jFileList = new JSONArray();
        JSONObject jArchFileCount = new JSONObject();
        int totalCount = 0;
        int startValue = 0;
        int rangeValue = 0;
        if (jResult != null && jResult.has("archIndexFileList")) {
            jFileList = jResult.getJSONArray("archIndexFileList");
            jArchFileCount = jResult.getJSONObject("archIndexFileCount");
            totalCount = jResult.getInt("totalCount");
            startValue = jResult.getInt("startValue");
            rangeValue = jResult.getInt("rangeValue");
        }
        JSONObject jTableInputParams = new JSONObject();
        JSONObject jArchIndexTableInfo = new JSONObject();
        JSONObject jTableData = new JSONObject();
        JSONArray jTableDataList = new JSONArray();
        JSONArray jTableColumnList = new JSONArray();
        int listLen = jFileList.length();
        for (int i = 0; i < listLen; ++i) {
            JSONArray jOrigRow = jFileList.getJSONArray(i);
            JSONArray jColumnValues = new JSONArray();
            int indexStatus = jOrigRow.getInt(5);
            jColObj = new JSONObject();
            jColObj.put("visible", false);
            jColObj.put("isCheckBox", true);
            jColObj.put("columnValue", jOrigRow.get(2));
            jColumnValues.put((Object)jColObj);
            jColObj = new JSONObject();
            jColObj.put("visible", true);
            jColObj.put("isCheckBox", true);
            jColObj.put("columnValue", (Object)new JSONObject().put("fileName", jOrigRow.get(2)).put("categoryType", jOrigRow.getInt(0)));
            jColumnValues.put((Object)jColObj);
            jColObj = new JSONObject();
            jColObj.put("visible", true);
            jColObj.put("isActions", true);
            jColObj.put("widthstyle", (Object)"min-width:26px");
            jColObj.put("columnValue", (Object)new JSONObject().put("fileName", jOrigRow.get(2)).put("categoryType", jOrigRow.getInt(0)));
            if (indexStatus == ArchFileIndexState.INDEXING.ordinal() || indexStatus == ArchFileIndexState.INDEXING_SCH.ordinal() || indexStatus == ArchFileIndexState.INDEXED.ordinal()) {
                jColObj.put("unindexActionMethod", (Object)"indexAction");
                jColObj.put("unindexTooltip", (Object)clientRb.getString("adap.archive.unindex"));
                jColObj.put("unindexAction", (Object)"true");
            } else if (indexStatus == ArchFileIndexState.UN_INDEXING.ordinal() || indexStatus == ArchFileIndexState.UN_INDEXING_SCH.ordinal() || indexStatus == ArchFileIndexState.UN_INDEXED.ordinal()) {
                jColObj.put("indexActionMethod", (Object)"indexAction");
                jColObj.put("indexTooltip", (Object)clientRb.getString("adap.archive.index"));
                jColObj.put("indexAction", (Object)"true");
            }
            jColumnValues.put((Object)jColObj);
            for (int colIndex = 1; colIndex <= 4; ++colIndex) {
                jColObj = new JSONObject();
                jColObj.put("visible", true);
                jColObj.put("isData", true);
                jColObj.put("columnValue", jOrigRow.get(colIndex));
                jColumnValues.put((Object)jColObj);
            }
            jColObj = new JSONObject();
            jColObj.put("visible", true);
            jColObj.put("isData", true);
            jColObj.put("columnValue", (Object)ArchFileIndexState.values()[jOrigRow.getInt(5)].toString());
            jColumnValues.put((Object)jColObj);
            JSONObject jRowObj = new JSONObject();
            jRowObj.put("columnValues", (Object)jColumnValues);
            jRowObj.put("isReportTable", false);
            jRowObj.put("categoryType", jOrigRow.getInt(0));
            jTableDataList.put((Object)jRowObj);
        }
        jColObj = new JSONObject();
        jColObj.put("visible", true);
        jColObj.put("isCheckBox", true);
        jColObj.put("searchenabled", false);
        jColObj.put("sortenabled", false);
        jColObj.put("columnalias", (Object)"");
        jColObj.put("displayname", (Object)"");
        jTableColumnList.put((Object)jColObj);
        jColObj = new JSONObject();
        jColObj.put("visible", true);
        jColObj.put("isActions", true);
        jColObj.put("searchenabled", false);
        jColObj.put("sortenabled", false);
        jColObj.put("columnalias", (Object)clientRb.getString("adap.archive.actions"));
        jColObj.put("displayname", (Object)clientRb.getString("adap.archive.actions"));
        jTableColumnList.put((Object)jColObj);
        jColObj = new JSONObject();
        jColObj.put("visible", true);
        jColObj.put("isData", true);
        jColObj.put("searchenabled", false);
        jColObj.put("sortenabled", false);
        jColObj.put("columnalias", (Object)clientRb.getString("adap.archive.category"));
        jColObj.put("displayname", (Object)clientRb.getString("adap.archive.category"));
        jTableColumnList.put((Object)jColObj);
        jColObj = new JSONObject();
        jColObj.put("visible", true);
        jColObj.put("isData", true);
        jColObj.put("searchenabled", false);
        jColObj.put("sortenabled", false);
        jColObj.put("columnalias", (Object)clientRb.getString("adap.archive.file_name"));
        jColObj.put("displayname", (Object)clientRb.getString("adap.archive.file_name"));
        jTableColumnList.put((Object)jColObj);
        jColObj = new JSONObject();
        jColObj.put("visible", true);
        jColObj.put("isData", true);
        jColObj.put("searchenabled", false);
        jColObj.put("sortenabled", false);
        jColObj.put("columnalias", (Object)clientRb.getString("adap.archive.from"));
        jColObj.put("displayname", (Object)clientRb.getString("adap.archive.from"));
        jTableColumnList.put((Object)jColObj);
        jColObj = new JSONObject();
        jColObj.put("visible", true);
        jColObj.put("isData", true);
        jColObj.put("searchenabled", false);
        jColObj.put("sortenabled", false);
        jColObj.put("columnalias", (Object)clientRb.getString("adap.archive.to"));
        jColObj.put("displayname", (Object)clientRb.getString("adap.archive.to"));
        jTableColumnList.put((Object)jColObj);
        jColObj = new JSONObject();
        jColObj.put("visible", true);
        jColObj.put("isData", true);
        jColObj.put("searchenabled", false);
        jColObj.put("sortenabled", false);
        jColObj.put("columnalias", (Object)clientRb.getString("adap.archive.index_status"));
        jColObj.put("displayname", (Object)clientRb.getString("adap.archive.index_status"));
        jTableColumnList.put((Object)jColObj);
        jTableData.put("tableDataList", (Object)jTableDataList);
        jTableData.put("tableColumnList", (Object)jTableColumnList);
        jTableInputParams = ArchEmberUtil.getDefaultTableInputParams();
        int unIndexFileCount = jArchFileCount.getInt("archIndexedFileCount");
        jTableInputParams = ArchEmberUtil.updateIndexTableInputParams(jTableInputParams, unIndexFileCount, clientRb);
        jTableInputParams.put("totalCount", totalCount);
        jTableInputParams.put("startValue", startValue);
        jTableInputParams.put("rangeValue", rangeValue);
        jTableInputParams.put("emptyTableMessage", (Object)clientRb.getString("adap.archive.no_archive_files_available"));
        jArchIndexTableInfo.put("tableData", (Object)jTableData);
        jArchIndexTableInfo.put("tableInputParams", (Object)jTableInputParams);
        jArchIndexTableInfo.put("count", jArchFileCount.get("archTotalFileCount"));
        jArchIndexFileInfo.put("archIndexTableInfo", (Object)jArchIndexTableInfo);
        jArchIndexFileInfo.put("archIndexFileCount", (Object)jArchFileCount);
        return jArchIndexFileInfo;
    }

    public static JSONObject parseGSResultsIntoCols(JSONObject jSummary) throws Exception {
        if (jSummary != null && jSummary.has("globalSearchSummary")) {
            JSONArray jFacetColList = jSummary.getJSONArray("globalSearchSummary");
            JSONArray jColArr = new JSONArray();
            int recPerCol = 7;
            int len = jFacetColList.length();
            int noCols = (int)Math.ceil((double)len / (double)recPerCol);
            for (int i = 0; i < noCols; ++i) {
                JSONArray jCol = new JSONArray();
                int endVal = len < (i + 1) * recPerCol ? len : (i + 1) * recPerCol;
                for (int j = i * recPerCol; j < endVal; ++j) {
                    jCol.put(jFacetColList.get(j));
                }
                jColArr.put((Object)jCol);
            }
            jSummary.put("globalSearchSummary", (Object)jColArr);
        }
        return jSummary;
    }

    private static JSONObject updateIndexTableInputParams(JSONObject jTableInputParams, int unIndexFileCount, AdventNetResourceBundle clientRb) {
        try {
            jTableInputParams.put("isReportTable", false);
            jTableInputParams.put("showRefresh", true);
            jTableInputParams.put("showIndexAction", true);
            jTableInputParams.put("indexTooltip", (Object)clientRb.getString("adap.archive.index"));
            jTableInputParams.put("indexActionMethod", (Object)"indexAction");
            jTableInputParams.put("showUnindexAction", true);
            jTableInputParams.put("unindexTooltip", (Object)clientRb.getString("adap.archive.unindex"));
            jTableInputParams.put("unindexActionMethod", (Object)"indexAction");
            if (unIndexFileCount > 0) {
                jTableInputParams.put("showUnindexAllAction", true);
                jTableInputParams.put("unindexAllTooltip", (Object)clientRb.getString("adap.archive.unindex_all"));
                jTableInputParams.put("unindexAllLabel", (Object)clientRb.handleGetObject("adap.archive.unindex_all_count", new String[]{"" + unIndexFileCount}));
                jTableInputParams.put("unindexAllActionMethod", (Object)"indexAction");
            }
            jTableInputParams.put("sortColumn", (Object)"START_TIME");
            jTableInputParams.put("hideTopDivider", false);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return jTableInputParams;
    }

    private static JSONObject getDefaultTableInputParams() {
        JSONObject jTableInputParams = null;
        try {
            jTableInputParams = new JSONObject();
            JSONArray jRangeList = new JSONArray();
            jRangeList.put((Object)new JSONObject().put("value", 25));
            jRangeList.put((Object)new JSONObject().put("value", 50));
            jRangeList.put((Object)new JSONObject().put("value", 75));
            jRangeList.put((Object)new JSONObject().put("value", 100));
            jTableInputParams.put("rangeList", (Object)jRangeList);
            jTableInputParams.put("hideTopDivider", true);
            jTableInputParams.put("hideBorder", true);
            jTableInputParams.put("sortOrder", (Object)"DESC");
            jTableInputParams.put("sortColumn", (Object)"TIME_GENERATED");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return jTableInputParams;
    }
}

