/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.admin.archivesearch;

import com.adventnet.db.api.RelationalAPI;
import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.DataSet;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.Query;
import com.adventnet.ds.query.Range;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.SortColumn;
import com.adventnet.ds.query.Table;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.admin.archivesearch.ArchFileIndexState;
import com.adventnet.sym.adsm.common.server.admin.archivesearch.ArchFileIndexThread;
import com.adventnet.sym.adsm.common.server.admin.archivesearch.ArchLogCategoryHandler;
import com.adventnet.sym.adsm.common.server.admin.archivesearch.ArchLogCategoryManager;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.TimeUtil;
import java.io.File;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.JSONArray;
import org.json.JSONObject;

public class ArchFileIndexHandler {
    private static HashMap<Integer, Object> lockObjMap;
    private static final String BACKUP_META_TABLE = "AUDBackUpMetaTable";
    private static final String ARCH_CATEGORY_TABLE = "AUDArchCategory";
    private static AdventNetResourceBundle rb;
    private static Logger logger;

    public static void resetProcessingArchFileIndexStatus() {
        Criteria criteria = null;
        DataObject dataObj = null;
        try {
            Row matchRow;
            Iterator iterator;
            Integer[] queryStates1 = new Integer[]{ArchFileIndexState.INDEXING.ordinal(), ArchFileIndexState.INDEXING_SCH.ordinal()};
            Integer[] queryStates2 = new Integer[]{ArchFileIndexState.UN_INDEXING.ordinal(), ArchFileIndexState.UN_INDEXING_SCH.ordinal()};
            criteria = new Criteria(Column.getColumn((String)BACKUP_META_TABLE, (String)"TABLE_NAME"), null, 1);
            criteria = criteria.and(new Criteria(Column.getColumn((String)BACKUP_META_TABLE, (String)"LUC_FILE_INDEX_STATE"), (Object)queryStates1, 8));
            dataObj = CommonUtil.getPersistence(new boolean[0]).get(BACKUP_META_TABLE, criteria);
            if (!dataObj.isEmpty()) {
                iterator = dataObj.getRows(BACKUP_META_TABLE);
                while (iterator.hasNext()) {
                    matchRow = (Row)iterator.next();
                    matchRow.set("LUC_FILE_INDEX_STATE", (Object)ArchFileIndexState.UN_INDEXED.ordinal());
                    dataObj.updateRow(matchRow);
                }
                CommonUtil.getPersistence(new boolean[0]).update(dataObj);
            }
            criteria = new Criteria(Column.getColumn((String)BACKUP_META_TABLE, (String)"TABLE_NAME"), null, 1);
            criteria = criteria.and(new Criteria(Column.getColumn((String)BACKUP_META_TABLE, (String)"LUC_FILE_INDEX_STATE"), (Object)queryStates2, 8));
            dataObj = CommonUtil.getPersistence(new boolean[0]).get(BACKUP_META_TABLE, criteria);
            if (!dataObj.isEmpty()) {
                iterator = dataObj.getRows(BACKUP_META_TABLE);
                while (iterator.hasNext()) {
                    matchRow = (Row)iterator.next();
                    matchRow.set("LUC_FILE_INDEX_STATE", (Object)ArchFileIndexState.INDEXED.ordinal());
                    dataObj.updateRow(matchRow);
                }
                CommonUtil.getPersistence(new boolean[0]).update(dataObj);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void indexRecentArchFiles() {
        try {
            JSONObject indexFileListObj = new JSONObject();
            JSONObject unindexFileListObj = new JSONObject();
            JSONObject indexCategoryFileListObj = new JSONObject();
            JSONObject unindexCategoryFileListObj = new JSONObject();
            ArchLogCategoryManager catManager = ArchLogCategoryManager.getInstance();
            ArrayList<Integer> categoryIdList = catManager.getArchCategoryIdList();
            for (Integer categoryId : categoryIdList) {
                JSONObject jTopArchFileObj;
                if (!catManager.getArchCategoryHandler(categoryId).isIndexUpdateSchduleEnabled()) continue;
                logger.log(Level.INFO, "Going to index/unindex for archive log category '" + catManager.getArchCategoryName(categoryId) + "'");
                int defaultIndexCount = catManager.getArchCategoryHandler(categoryId).getScheduleFileIndexCount();
                int indexedCount = ArchFileIndexHandler.fetchArchFileCount(categoryId, new Integer[]{ArchFileIndexState.INDEXED.ordinal(), ArchFileIndexState.INDEXING.ordinal(), ArchFileIndexState.INDEXING_SCH.ordinal()});
                if (indexedCount == 0) {
                    jTopArchFileObj = ArchFileIndexHandler.fetchArchFileList(categoryId, null, null, "START_TIME", "DESC", 1, defaultIndexCount, null);
                    JSONArray jTopArchFileList = jTopArchFileObj.getJSONArray("archIndexFileList");
                    if (jTopArchFileList.length() == 0) {
                        logger.log(Level.INFO, "SKIPPING index/unindex for archive log category '" + catManager.getArchCategoryName(categoryId) + "' as NO ARCHIVE FILES available...");
                        continue;
                    }
                    JSONArray indexCategoryFileList = new JSONArray();
                    int listLen = jTopArchFileList.length();
                    for (int i = 0; i < listLen; ++i) {
                        indexCategoryFileList.put((Object)jTopArchFileList.getJSONArray(i).getString(2));
                    }
                    indexCategoryFileListObj.put(categoryId + "", (Object)indexCategoryFileList);
                    continue;
                }
                if (defaultIndexCount == indexedCount) {
                    JSONArray jTopIndexedArchFileList;
                    jTopArchFileObj = ArchFileIndexHandler.fetchArchFileList(categoryId, null, null, "START_TIME", "DESC", 1, defaultIndexCount, null);
                    JSONObject jTopIndexedArchFileObj = ArchFileIndexHandler.fetchArchFileList(categoryId, null, null, "START_TIME", "DESC", 1, defaultIndexCount, ArchFileIndexState.INDEXED.ordinal());
                    JSONArray jTopArchFileList = jTopArchFileObj.getJSONArray("archIndexFileList");
                    JSONObject fileListObj = ArchFileIndexHandler.getFilesToProcess(jTopArchFileList, jTopIndexedArchFileList = jTopIndexedArchFileObj.getJSONArray("archIndexFileList"));
                    if (fileListObj == null || fileListObj.length() == 0) {
                        logger.log(Level.INFO, "SKIPPING index/unindex for archive log category '" + catManager.getArchCategoryName(categoryId) + "' as TOP files are ALREADY INDEXED...");
                        continue;
                    }
                    if (fileListObj.has("topFilesNotMatched")) {
                        indexCategoryFileListObj.put(categoryId + "", (Object)fileListObj.getJSONArray("topFilesNotMatched"));
                    }
                    if (!fileListObj.has("topIndexedFilesNotMatched")) continue;
                    unindexCategoryFileListObj.put(categoryId + "", (Object)fileListObj.getJSONArray("topIndexedFilesNotMatched"));
                    continue;
                }
                logger.log(Level.INFO, "SKIPPING index/unindex for archive log category '" + catManager.getArchCategoryName(categoryId) + "' as user has ALREADY " + indexedCount + " INDEXED files...");
            }
            if (unindexCategoryFileListObj.length() > 0) {
                unindexFileListObj.put("categoryFileList", (Object)unindexCategoryFileListObj);
                unindexFileListObj.put("actionType", (Object)"unindex");
                ArchFileIndexHandler.indexArchFiles(unindexFileListObj, rb);
            }
            if (indexCategoryFileListObj.length() > 0) {
                indexFileListObj.put("categoryFileList", (Object)indexCategoryFileListObj);
                indexFileListObj.put("actionType", (Object)"index");
                ArchFileIndexHandler.indexArchFiles(indexFileListObj, rb);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String indexArchFiles(JSONObject archFileList, AdventNetResourceBundle clientRb) {
        String errMsg;
        block22: {
            errMsg = "";
            try {
                logger.log(Level.INFO, "Scheduling to index/un-index archive files -- :: " + archFileList);
                String actionType = archFileList.getString("actionType");
                if (actionType.equals("unindexAll")) {
                    Object lockObj;
                    int logCategoryId = archFileList.getInt("logCategoryId");
                    if (logCategoryId == 0) {
                        ArrayList<Integer> categoryIdList = ArchLogCategoryManager.getInstance().getArchCategoryIdList();
                        for (int categoryId : categoryIdList) {
                            Object lockObj2;
                            Object object = lockObj2 = lockObjMap.get(categoryId);
                            synchronized (object) {
                                ArchFileIndexHandler.updateAllArchFileIndexStatus(categoryId, ArchFileIndexState.UN_INDEXING_SCH);
                            }
                            new ArchFileIndexThread(categoryId, 3, null);
                        }
                        break block22;
                    }
                    Object i$ = lockObj = lockObjMap.get(logCategoryId);
                    synchronized (i$) {
                        ArchFileIndexHandler.updateAllArchFileIndexStatus(logCategoryId, ArchFileIndexState.UN_INDEXING_SCH);
                    }
                    new ArchFileIndexThread(logCategoryId, 3, null);
                    break block22;
                }
                JSONObject jCategoryFileList = archFileList.getJSONObject("categoryFileList");
                Iterator keyIterator = jCategoryFileList.keys();
                while (keyIterator.hasNext()) {
                    String logCategoryIdStr = (String)keyIterator.next();
                    int logCategoryId = Integer.parseInt(logCategoryIdStr);
                    ArchLogCategoryHandler handler = ArchLogCategoryManager.getInstance().getArchCategoryHandler(logCategoryId);
                    JSONArray jFileList = jCategoryFileList.getJSONArray(logCategoryIdStr);
                    if (actionType.equals("index")) {
                        Object lockObj;
                        ArrayList<String> indexList = new ArrayList<String>();
                        boolean canScheduleIndex = false;
                        Object object = lockObj = lockObjMap.get(logCategoryId);
                        synchronized (object) {
                            int curIndexedCount = ArchFileIndexHandler.fetchArchFileCount(logCategoryId, new Integer[]{ArchFileIndexState.INDEXED.ordinal(), ArchFileIndexState.INDEXING.ordinal(), ArchFileIndexState.INDEXING_SCH.ordinal()});
                            logger.log(Level.INFO, "Current indexed files count for category '" + rb.getString(handler.getDisplayName()) + "' is " + curIndexedCount);
                            if (curIndexedCount < handler.getMaxFileIndexCount()) {
                                int avaliableCount;
                                int toIndexCount = jFileList.length();
                                if (toIndexCount > (avaliableCount = handler.getMaxFileIndexCount() - curIndexedCount)) {
                                    errMsg = errMsg + clientRb.handleGetObject("adap.archive.indexing_max_limit_error", new String[]{"" + handler.getMaxFileIndexCount(), rb.getString(handler.getDisplayName())});
                                    errMsg = errMsg + clientRb.handleGetObject("adap.archive.indexing_skipping_files", new String[]{"" + (toIndexCount - avaliableCount)});
                                    toIndexCount = avaliableCount;
                                }
                                canScheduleIndex = true;
                                for (int i = 0; i < toIndexCount; ++i) {
                                    indexList.add(jFileList.getString(i));
                                }
                                ArchFileIndexHandler.updateArchFileIndexStatusWithPreCheck(indexList, ArchFileIndexState.INDEXING_SCH);
                            } else {
                                errMsg = errMsg + clientRb.handleGetObject("adap.archive.indexing_max_limit_error", new String[]{"" + handler.getMaxFileIndexCount(), rb.getString(handler.getDisplayName())});
                            }
                        }
                        if (canScheduleIndex) {
                            new ArchFileIndexThread(logCategoryId, 1, indexList);
                        }
                    }
                    if (!actionType.equals("unindex")) continue;
                    ArrayList<String> unindexList = new ArrayList<String>();
                    int len = jFileList.length();
                    for (int i = 0; i < len; ++i) {
                        unindexList.add(jFileList.getString(i));
                    }
                    ArchFileIndexHandler.updateArchFileIndexStatusWithPreCheck(unindexList, ArchFileIndexState.UN_INDEXING_SCH);
                    new ArchFileIndexThread(Integer.parseInt(logCategoryIdStr), 2, unindexList);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return errMsg;
    }

    public static void updateArchFileIndexStatus(ArrayList<String> fileList, ArchFileIndexState indexState) {
        try {
            Criteria criteria = new Criteria(Column.getColumn((String)BACKUP_META_TABLE, (String)"FILE_NAME"), (Object)fileList.toArray(), 8);
            DataObject dataObj = CommonUtil.getPersistence(new boolean[0]).get(BACKUP_META_TABLE, criteria);
            if (!dataObj.isEmpty()) {
                Iterator iterator = dataObj.getRows(BACKUP_META_TABLE);
                while (iterator.hasNext()) {
                    Row matchRow = (Row)iterator.next();
                    matchRow.set("LUC_FILE_INDEX_STATE", (Object)indexState.ordinal());
                    dataObj.updateRow(matchRow);
                }
                CommonUtil.getPersistence(new boolean[0]).update(dataObj);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void updateArchFileIndexStatusWithPreCheck(ArrayList<String> fileList, ArchFileIndexState indexState) {
        try {
            Criteria criteria = new Criteria(Column.getColumn((String)BACKUP_META_TABLE, (String)"FILE_NAME"), (Object)fileList.toArray(), 8);
            if (indexState == ArchFileIndexState.INDEXING_SCH) {
                criteria = criteria.and(new Criteria(Column.getColumn((String)BACKUP_META_TABLE, (String)"LUC_FILE_INDEX_STATE"), (Object)ArchFileIndexState.UN_INDEXED.ordinal(), 0));
            } else if (indexState == ArchFileIndexState.UN_INDEXING_SCH) {
                criteria = criteria.and(new Criteria(Column.getColumn((String)BACKUP_META_TABLE, (String)"LUC_FILE_INDEX_STATE"), (Object)ArchFileIndexState.INDEXED.ordinal(), 0));
            } else if (indexState == ArchFileIndexState.INDEXING) {
                criteria = criteria.and(new Criteria(Column.getColumn((String)BACKUP_META_TABLE, (String)"LUC_FILE_INDEX_STATE"), (Object)ArchFileIndexState.INDEXING_SCH.ordinal(), 0));
            } else if (indexState == ArchFileIndexState.UN_INDEXING) {
                criteria = criteria.and(new Criteria(Column.getColumn((String)BACKUP_META_TABLE, (String)"LUC_FILE_INDEX_STATE"), (Object)ArchFileIndexState.UN_INDEXING_SCH.ordinal(), 0));
            } else if (indexState == ArchFileIndexState.INDEXED) {
                criteria = criteria.and(new Criteria(Column.getColumn((String)BACKUP_META_TABLE, (String)"LUC_FILE_INDEX_STATE"), (Object)ArchFileIndexState.INDEXING.ordinal(), 0));
            } else if (indexState == ArchFileIndexState.UN_INDEXED) {
                criteria = criteria.and(new Criteria(Column.getColumn((String)BACKUP_META_TABLE, (String)"LUC_FILE_INDEX_STATE"), (Object)ArchFileIndexState.UN_INDEXING.ordinal(), 0));
            }
            DataObject dataObj = CommonUtil.getPersistence(new boolean[0]).get(BACKUP_META_TABLE, criteria);
            if (!dataObj.isEmpty()) {
                Iterator iterator = dataObj.getRows(BACKUP_META_TABLE);
                while (iterator.hasNext()) {
                    Row matchRow = (Row)iterator.next();
                    matchRow.set("LUC_FILE_INDEX_STATE", (Object)indexState.ordinal());
                    dataObj.updateRow(matchRow);
                }
                CommonUtil.getPersistence(new boolean[0]).update(dataObj);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void updateAllArchFileIndexStatus(int logCategoryId, ArchFileIndexState indexState) {
        try {
            Criteria criteria = null;
            if (logCategoryId == -1 || logCategoryId == 0) {
                criteria = new Criteria(Column.getColumn((String)BACKUP_META_TABLE, (String)"TABLE_NAME"), null, 1);
            } else {
                String tableName = ArchLogCategoryManager.getInstance().getArchCategoryHandler(logCategoryId).getTableName();
                criteria = new Criteria(Column.getColumn((String)BACKUP_META_TABLE, (String)"TABLE_NAME"), (Object)tableName, 0);
            }
            if (indexState == ArchFileIndexState.INDEXING_SCH) {
                criteria = criteria.and(new Criteria(Column.getColumn((String)BACKUP_META_TABLE, (String)"LUC_FILE_INDEX_STATE"), (Object)ArchFileIndexState.UN_INDEXED.ordinal(), 0));
            } else if (indexState == ArchFileIndexState.UN_INDEXING_SCH) {
                criteria = criteria.and(new Criteria(Column.getColumn((String)BACKUP_META_TABLE, (String)"LUC_FILE_INDEX_STATE"), (Object)ArchFileIndexState.INDEXED.ordinal(), 0));
            } else if (indexState == ArchFileIndexState.INDEXING) {
                criteria = criteria.and(new Criteria(Column.getColumn((String)BACKUP_META_TABLE, (String)"LUC_FILE_INDEX_STATE"), (Object)ArchFileIndexState.INDEXING_SCH.ordinal(), 0));
            } else if (indexState == ArchFileIndexState.UN_INDEXING) {
                criteria = criteria.and(new Criteria(Column.getColumn((String)BACKUP_META_TABLE, (String)"LUC_FILE_INDEX_STATE"), (Object)ArchFileIndexState.UN_INDEXING_SCH.ordinal(), 0));
            } else if (indexState == ArchFileIndexState.INDEXED) {
                criteria = criteria.and(new Criteria(Column.getColumn((String)BACKUP_META_TABLE, (String)"LUC_FILE_INDEX_STATE"), (Object)ArchFileIndexState.INDEXING.ordinal(), 0));
            } else if (indexState == ArchFileIndexState.UN_INDEXED) {
                criteria = criteria.and(new Criteria(Column.getColumn((String)BACKUP_META_TABLE, (String)"LUC_FILE_INDEX_STATE"), (Object)ArchFileIndexState.UN_INDEXING.ordinal(), 0));
            }
            DataObject dataObj = CommonUtil.getPersistence(new boolean[0]).get(BACKUP_META_TABLE, criteria);
            if (!dataObj.isEmpty()) {
                Iterator iterator = dataObj.getRows(BACKUP_META_TABLE);
                while (iterator.hasNext()) {
                    Row matchRow = (Row)iterator.next();
                    matchRow.set("LUC_FILE_INDEX_STATE", (Object)indexState.ordinal());
                    dataObj.updateRow(matchRow);
                }
                CommonUtil.getPersistence(new boolean[0]).update(dataObj);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static int fetchArchFileIndexStatus(String fileName) {
        int indexStatus = -1;
        try {
            Criteria criteria = new Criteria(Column.getColumn((String)BACKUP_META_TABLE, (String)"FILE_NAME"), (Object)fileName, 0);
            DataObject dataObj = CommonUtil.getPersistence(new boolean[0]).get(BACKUP_META_TABLE, criteria);
            if (!dataObj.isEmpty()) {
                Row matchRow = dataObj.getRow(BACKUP_META_TABLE);
                indexStatus = (Integer)matchRow.get("LUC_FILE_INDEX_STATE");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return indexStatus;
    }

    public static Row fetchArchFileInfo(String fileName) {
        Row matchRow = null;
        try {
            Criteria criteria = new Criteria(Column.getColumn((String)BACKUP_META_TABLE, (String)"FILE_NAME"), (Object)fileName, 0);
            DataObject dataObj = CommonUtil.getPersistence(new boolean[0]).get(BACKUP_META_TABLE, criteria);
            if (!dataObj.isEmpty()) {
                matchRow = dataObj.getRow(BACKUP_META_TABLE);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return matchRow;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JSONObject fetchArchFileMinMaxTime(int logCategoryId) {
        JSONObject jo = null;
        Long maxTime = 0L;
        Long minTime = 0L;
        RelationalAPI relationalAPI = null;
        Connection connection = null;
        DataSet dataSet = null;
        try {
            jo = new JSONObject();
            relationalAPI = RelationalAPI.getInstance();
            connection = relationalAPI.getConnection();
            SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)BACKUP_META_TABLE));
            if (logCategoryId == 0) {
                query.setCriteria(new Criteria(Column.getColumn((String)BACKUP_META_TABLE, (String)"TABLE_NAME"), null, 1));
            } else {
                String tableName = ArchLogCategoryManager.getInstance().getArchCategoryHandler(logCategoryId).getTableName();
                query.setCriteria(new Criteria(Column.getColumn((String)BACKUP_META_TABLE, (String)"TABLE_NAME"), (Object)tableName, 0));
            }
            Column minCol = Column.getColumn((String)BACKUP_META_TABLE, (String)"START_TIME").minimum();
            minCol.setColumnAlias("START_TIME_MIN");
            query.addSelectColumn(minCol);
            Column maxCol = Column.getColumn((String)BACKUP_META_TABLE, (String)"END_TIME").maximum();
            maxCol.setColumnAlias("END_TIME_MAX");
            query.addSelectColumn(maxCol);
            dataSet = relationalAPI.executeQuery((Query)query, connection);
            if (dataSet != null && dataSet.next()) {
                if (dataSet.getValue("START_TIME_MIN") != null) {
                    minTime = (Long)dataSet.getValue("START_TIME_MIN");
                }
                if (dataSet.getValue("END_TIME_MAX") != null) {
                    maxTime = (Long)dataSet.getValue("END_TIME_MAX");
                }
            }
            jo.put("startTime", (Object)minTime);
            jo.put("endTime", (Object)maxTime);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (dataSet != null) {
                    dataSet.close();
                }
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException se) {
                se.printStackTrace();
            }
        }
        return jo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int fetchArchFileCount(int logCategoryId, Integer[] fileStates) {
        int curCount = -1;
        RelationalAPI relationalAPI = null;
        Connection connection = null;
        DataSet dataSet = null;
        try {
            String tableName = ArchLogCategoryManager.getInstance().getArchCategoryHandler(logCategoryId).getTableName();
            relationalAPI = RelationalAPI.getInstance();
            connection = relationalAPI.getConnection();
            SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)BACKUP_META_TABLE));
            Criteria criteria = new Criteria(Column.getColumn((String)BACKUP_META_TABLE, (String)"TABLE_NAME"), (Object)tableName, 0);
            criteria = criteria.and(new Criteria(Column.getColumn((String)BACKUP_META_TABLE, (String)"LUC_FILE_INDEX_STATE"), (Object)fileStates, 8));
            query.setCriteria(criteria);
            Column countCol = Column.getColumn((String)BACKUP_META_TABLE, (String)"LUC_FILE_INDEX_STATE").count();
            countCol.setColumnAlias("LUC_FILE_INDEX_STATE_COUNT");
            query.addSelectColumn(countCol);
            dataSet = relationalAPI.executeQuery((Query)query, connection);
            if (dataSet != null && dataSet.next() && dataSet.getValue("LUC_FILE_INDEX_STATE_COUNT") != null) {
                curCount = (Integer)dataSet.getValue("LUC_FILE_INDEX_STATE_COUNT");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (dataSet != null) {
                    dataSet.close();
                }
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException se) {
                se.printStackTrace();
            }
        }
        return curCount;
    }

    public static JSONObject fetchArchFileListCount(Integer logCategoryId, Long fromTime, Long toTime, Integer loadType) {
        JSONObject jResult = new JSONObject();
        int archIndexedFileCount = 0;
        int archIndexingFileCount = 0;
        int archUnIndexingFileCount = 0;
        int archTotalFileCount = 0;
        try {
            SelectQueryImpl selectQuery = new SelectQueryImpl(Table.getTable((String)ARCH_CATEGORY_TABLE));
            Join backUpMetaTableCategoriesJoin = new Join(ARCH_CATEGORY_TABLE, BACKUP_META_TABLE, new String[]{"CAT_TABLE_NAME"}, new String[]{"TABLE_NAME"}, 2);
            selectQuery.addJoin(backUpMetaTableCategoriesJoin);
            Criteria crit = null;
            crit = logCategoryId == null || logCategoryId == 0 ? new Criteria(Column.getColumn((String)ARCH_CATEGORY_TABLE, (String)"CATEGORY_ID"), null, 1) : new Criteria(Column.getColumn((String)ARCH_CATEGORY_TABLE, (String)"CATEGORY_ID"), (Object)logCategoryId, 0);
            if (loadType != null) {
                crit = loadType.intValue() == ArchFileIndexState.PROCESSING.ordinal() ? crit.and(new Criteria(Column.getColumn((String)BACKUP_META_TABLE, (String)"LUC_FILE_INDEX_STATE"), (Object)new Integer[]{ArchFileIndexState.INDEXED.ordinal(), ArchFileIndexState.UN_INDEXED.ordinal()}, 9)) : crit.and(new Criteria(Column.getColumn((String)BACKUP_META_TABLE, (String)"LUC_FILE_INDEX_STATE"), (Object)loadType, 0));
            }
            if (fromTime != null && toTime != null) {
                Criteria fileTimeWithinCrit = new Criteria(Column.getColumn((String)BACKUP_META_TABLE, (String)"START_TIME"), (Object)fromTime, 4);
                fileTimeWithinCrit = fileTimeWithinCrit.and(new Criteria(Column.getColumn((String)BACKUP_META_TABLE, (String)"END_TIME"), (Object)toTime, 6));
                Criteria selectedTimeWithinCrit = new Criteria(Column.getColumn((String)BACKUP_META_TABLE, (String)"START_TIME"), (Object)fromTime, 6);
                selectedTimeWithinCrit = selectedTimeWithinCrit.and(new Criteria(Column.getColumn((String)BACKUP_META_TABLE, (String)"END_TIME"), (Object)toTime, 4));
                Criteria startTimeOverlapCrit = new Criteria(Column.getColumn((String)BACKUP_META_TABLE, (String)"START_TIME"), (Object)fromTime, 4);
                startTimeOverlapCrit = startTimeOverlapCrit.and(new Criteria(Column.getColumn((String)BACKUP_META_TABLE, (String)"START_TIME"), (Object)toTime, 6));
                Criteria endTimeOverlapCrit = new Criteria(Column.getColumn((String)BACKUP_META_TABLE, (String)"END_TIME"), (Object)fromTime, 4);
                endTimeOverlapCrit = endTimeOverlapCrit.and(new Criteria(Column.getColumn((String)BACKUP_META_TABLE, (String)"END_TIME"), (Object)toTime, 6));
                Criteria timeCrit = fileTimeWithinCrit.or(selectedTimeWithinCrit).or(startTimeOverlapCrit).or(endTimeOverlapCrit);
                crit = crit.and(timeCrit);
            }
            selectQuery.setCriteria(crit);
            selectQuery.addSelectColumn(Column.getColumn((String)ARCH_CATEGORY_TABLE, (String)"CATEGORY_ID"));
            selectQuery.addSelectColumn(Column.getColumn((String)ARCH_CATEGORY_TABLE, (String)"CAT_TABLE_NAME"));
            selectQuery.addSelectColumn(Column.getColumn((String)BACKUP_META_TABLE, (String)"TABLE_NAME"));
            selectQuery.addSelectColumn(Column.getColumn((String)BACKUP_META_TABLE, (String)"LOOKUP_TABLENAME"));
            selectQuery.addSelectColumn(Column.getColumn((String)BACKUP_META_TABLE, (String)"LUC_FILE_INDEX_STATE"));
            DataObject dataObj = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)selectQuery);
            Iterator iterator = dataObj.getRows(BACKUP_META_TABLE);
            while (iterator.hasNext()) {
                Row row = (Row)iterator.next();
                int searchAction = Integer.parseInt(row.get("LUC_FILE_INDEX_STATE").toString());
                if (searchAction == ArchFileIndexState.INDEXING.ordinal() || searchAction == ArchFileIndexState.INDEXING_SCH.ordinal()) {
                    ++archIndexingFileCount;
                } else if (searchAction == ArchFileIndexState.UN_INDEXING.ordinal() || searchAction == ArchFileIndexState.UN_INDEXING_SCH.ordinal()) {
                    ++archUnIndexingFileCount;
                } else if (searchAction == ArchFileIndexState.INDEXED.ordinal()) {
                    ++archIndexedFileCount;
                }
                ++archTotalFileCount;
            }
            JSONObject jFileCount = new JSONObject();
            jFileCount.put("archTotalFileCount", archTotalFileCount);
            jFileCount.put("archIndexedFileCount", archIndexedFileCount);
            jFileCount.put("archIndexingFileCount", archIndexingFileCount);
            jFileCount.put("archUnIndexingFileCount", archUnIndexingFileCount);
            jFileCount.put("archProcessingFileCount", archIndexingFileCount + archUnIndexingFileCount);
            jFileCount.put("archUnIndexedFileCount", archTotalFileCount - archIndexedFileCount - archIndexingFileCount - archUnIndexingFileCount);
            jFileCount.put("indexedLoadType", ArchFileIndexState.INDEXED.ordinal());
            jFileCount.put("unIndexedLoadType", ArchFileIndexState.UN_INDEXED.ordinal());
            jFileCount.put("processingLoadType", ArchFileIndexState.PROCESSING.ordinal());
            jResult.put("archIndexFileCount", (Object)jFileCount);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return jResult;
    }

    public static JSONObject fetchArchFileList(Integer logCategoryId, Long fromTime, Long toTime, String sortColumn, String sortOrder, Integer fromIndex, Integer range, Integer loadType) {
        JSONObject jResult = new JSONObject();
        JSONArray jArchFileList = new JSONArray();
        try {
            boolean isAsc = true;
            if (sortOrder != null && (sortOrder.equals("DSC") || sortOrder.equals("DESC"))) {
                isAsc = false;
            }
            if (sortColumn == null || sortColumn.equals("")) {
                sortColumn = "START_TIME";
            }
            if (fromIndex == null || fromIndex.equals("")) {
                fromIndex = 1;
            }
            if (range == null || range.equals("")) {
                range = 25;
            }
            SelectQueryImpl selectQuery = new SelectQueryImpl(Table.getTable((String)ARCH_CATEGORY_TABLE));
            Join backUpMetaTableCategoriesJoin = new Join(ARCH_CATEGORY_TABLE, BACKUP_META_TABLE, new String[]{"CAT_TABLE_NAME"}, new String[]{"TABLE_NAME"}, 2);
            selectQuery.addJoin(backUpMetaTableCategoriesJoin);
            Criteria crit = null;
            crit = logCategoryId == null || logCategoryId == 0 ? new Criteria(Column.getColumn((String)ARCH_CATEGORY_TABLE, (String)"CATEGORY_ID"), null, 1) : new Criteria(Column.getColumn((String)ARCH_CATEGORY_TABLE, (String)"CATEGORY_ID"), (Object)logCategoryId, 0);
            if (loadType != null) {
                crit = loadType.intValue() == ArchFileIndexState.PROCESSING.ordinal() ? crit.and(new Criteria(Column.getColumn((String)BACKUP_META_TABLE, (String)"LUC_FILE_INDEX_STATE"), (Object)new Integer[]{ArchFileIndexState.INDEXED.ordinal(), ArchFileIndexState.UN_INDEXED.ordinal()}, 9)) : crit.and(new Criteria(Column.getColumn((String)BACKUP_META_TABLE, (String)"LUC_FILE_INDEX_STATE"), (Object)loadType, 0));
            }
            if (fromTime != null && toTime != null) {
                Criteria fileTimeWithinCrit = new Criteria(Column.getColumn((String)BACKUP_META_TABLE, (String)"START_TIME"), (Object)fromTime, 4);
                fileTimeWithinCrit = fileTimeWithinCrit.and(new Criteria(Column.getColumn((String)BACKUP_META_TABLE, (String)"END_TIME"), (Object)toTime, 6));
                Criteria selectedTimeWithinCrit = new Criteria(Column.getColumn((String)BACKUP_META_TABLE, (String)"START_TIME"), (Object)fromTime, 6);
                selectedTimeWithinCrit = selectedTimeWithinCrit.and(new Criteria(Column.getColumn((String)BACKUP_META_TABLE, (String)"END_TIME"), (Object)toTime, 4));
                Criteria startTimeOverlapCrit = new Criteria(Column.getColumn((String)BACKUP_META_TABLE, (String)"START_TIME"), (Object)fromTime, 4);
                startTimeOverlapCrit = startTimeOverlapCrit.and(new Criteria(Column.getColumn((String)BACKUP_META_TABLE, (String)"START_TIME"), (Object)toTime, 6));
                Criteria endTimeOverlapCrit = new Criteria(Column.getColumn((String)BACKUP_META_TABLE, (String)"END_TIME"), (Object)fromTime, 4);
                endTimeOverlapCrit = endTimeOverlapCrit.and(new Criteria(Column.getColumn((String)BACKUP_META_TABLE, (String)"END_TIME"), (Object)toTime, 6));
                Criteria timeCrit = fileTimeWithinCrit.or(selectedTimeWithinCrit).or(startTimeOverlapCrit).or(endTimeOverlapCrit);
                crit = crit.and(timeCrit);
            }
            selectQuery.setCriteria(crit);
            selectQuery.addSelectColumn(Column.getColumn((String)ARCH_CATEGORY_TABLE, (String)"CATEGORY_ID"));
            selectQuery.addSelectColumn(Column.getColumn((String)ARCH_CATEGORY_TABLE, (String)"DISPLAY_NAME"));
            selectQuery.addSelectColumn(Column.getColumn((String)ARCH_CATEGORY_TABLE, (String)"CAT_TABLE_NAME", (String)"TABLE_NAME_ALIAS"));
            selectQuery.addSelectColumn(Column.getColumn((String)BACKUP_META_TABLE, (String)"*"));
            selectQuery.addSortColumn(new SortColumn(Column.getColumn((String)BACKUP_META_TABLE, (String)sortColumn), isAsc));
            selectQuery.setRange(new Range(fromIndex.intValue(), range.intValue()));
            DataObject dataObj = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)selectQuery);
            Iterator iterator = dataObj.getRows(BACKUP_META_TABLE);
            while (iterator.hasNext()) {
                Row row = (Row)iterator.next();
                JSONArray jRow = new JSONArray();
                String zipFileName = (String)row.get("FILE_NAME");
                String tableName = (String)row.get("TABLE_NAME");
                long startTime = new Long(row.get("START_TIME").toString());
                long endTime = new Long(row.get("END_TIME").toString());
                int searchAction = Integer.parseInt(row.get("LUC_FILE_INDEX_STATE").toString());
                String startTimeStr = TimeUtil.formatDate(startTime * 1000L);
                String endTimeStr = TimeUtil.formatDate(endTime * 1000L);
                Criteria categoryCrit = new Criteria(Column.getColumn((String)ARCH_CATEGORY_TABLE, (String)"CAT_TABLE_NAME"), (Object)tableName, 0);
                Row categoryRow = dataObj.getRow(ARCH_CATEGORY_TABLE, categoryCrit);
                int categoryId = (Integer)categoryRow.get("CATEGORY_ID");
                String categoryNameKey = (String)categoryRow.get("DISPLAY_NAME");
                jRow.put(categoryId);
                jRow.put((Object)rb.getString(categoryNameKey));
                jRow.put((Object)zipFileName);
                jRow.put((Object)startTimeStr);
                jRow.put((Object)endTimeStr);
                jRow.put(searchAction);
                jArchFileList.put((Object)jRow);
            }
            jResult.put("archIndexFileList", (Object)jArchFileList);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return jResult;
    }

    public static JSONObject getArchIndexSettings() {
        JSONObject jRetObj = new JSONObject();
        JSONObject jSetObj = new JSONObject();
        try {
            ArrayList<Integer> categoryIdList = ArchLogCategoryManager.getInstance().getArchCategoryIdList();
            ArchLogCategoryHandler handler = ArchLogCategoryManager.getInstance().getArchCategoryHandler(categoryIdList.get(0));
            String baseIndexDirPath = handler.getBaseIndexDirPath();
            if (baseIndexDirPath.equals("archive_index")) {
                baseIndexDirPath = System.getProperty("server.home") + File.separator + "archive_index";
            }
            jSetObj.put("indexPath", (Object)baseIndexDirPath);
            jSetObj.put("maxFileIndexCount", handler.getMaxFileIndexCount());
            jRetObj.put("settings", (Object)jSetObj);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return jRetObj;
    }

    public static JSONObject updateArchIndexSettings(JSONObject newSettingsObj) {
        JSONObject jRetObj = new JSONObject();
        try {
            String indexPath = newSettingsObj.getString("indexPath");
            Criteria criteria = new Criteria(Column.getColumn((String)ARCH_CATEGORY_TABLE, (String)"CATEGORY_ID"), null, 1);
            DataObject dataObj = CommonUtil.getPersistence(new boolean[0]).get(ARCH_CATEGORY_TABLE, criteria);
            if (!dataObj.isEmpty()) {
                Iterator iterator = dataObj.getRows(ARCH_CATEGORY_TABLE);
                while (iterator.hasNext()) {
                    Row matchRow = (Row)iterator.next();
                    matchRow.set("BASE_INDEX_PATH", (Object)indexPath);
                    dataObj.updateRow(matchRow);
                }
                CommonUtil.getPersistence(new boolean[0]).update(dataObj);
            }
            ArrayList<Integer> categoryIdList = ArchLogCategoryManager.getInstance().getArchCategoryIdList();
            for (int categoryId : categoryIdList) {
                ArchLogCategoryHandler handler = ArchLogCategoryManager.getInstance().getArchCategoryHandler(categoryId);
                handler.setBaseIndexDirPath(indexPath);
            }
            jRetObj.put("success", true);
            jRetObj.put("text", (Object)rb.getString("adap.archive.arch_index_settings_update_success"));
            jRetObj.put("autoClose", false);
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
                jRetObj.put("failure", true);
                jRetObj.put("text", (Object)(rb.getString("adap.archive.arch_index_settings_update_error") + e));
                jRetObj.put("autoClose", false);
            }
            catch (Exception es) {
                es.printStackTrace();
            }
        }
        return jRetObj;
    }

    private static JSONObject getFilesToProcess(JSONArray jTopArchFileList, JSONArray jTopIndexedArchFileList) throws Exception {
        int topFilesCount = jTopArchFileList.length();
        int topIndexedFilesCount = jTopIndexedArchFileList.length();
        JSONObject fileListObj = null;
        JSONArray topFilesNotMatchedList = new JSONArray();
        JSONArray topIndexedFilesNotMatchedList = new JSONArray();
        if (topFilesCount == topIndexedFilesCount) {
            String fileName2;
            int j;
            boolean matches;
            String fileName1;
            int i;
            for (i = 0; i < topFilesCount; ++i) {
                fileName1 = jTopArchFileList.getJSONArray(i).getString(2);
                matches = false;
                for (j = 0; j < topIndexedFilesCount; ++j) {
                    fileName2 = jTopIndexedArchFileList.getJSONArray(j).getString(2);
                    if (!fileName1.equals(fileName2)) continue;
                    matches = true;
                    break;
                }
                if (matches) continue;
                topFilesNotMatchedList.put((Object)fileName1);
            }
            for (i = 0; i < topIndexedFilesCount; ++i) {
                fileName1 = jTopIndexedArchFileList.getJSONArray(i).getString(2);
                matches = false;
                for (j = 0; j < topFilesCount; ++j) {
                    fileName2 = jTopArchFileList.getJSONArray(j).getString(2);
                    if (!fileName1.equals(fileName2)) continue;
                    matches = true;
                    break;
                }
                if (matches) continue;
                topIndexedFilesNotMatchedList.put((Object)fileName1);
            }
            fileListObj = new JSONObject();
            if (topFilesNotMatchedList.length() != 0) {
                fileListObj.put("topFilesNotMatched", (Object)topFilesNotMatchedList);
            }
            if (topIndexedFilesNotMatchedList.length() != 0) {
                fileListObj.put("topIndexedFilesNotMatched", (Object)topIndexedFilesNotMatchedList);
            }
        }
        return fileListObj;
    }

    static {
        rb = ResourceBundleMgr.getInstance().getBundle();
        logger = Logger.getLogger(ArchFileIndexHandler.class.getName());
        try {
            lockObjMap = new HashMap();
            ArrayList<Integer> categoryIdList = ArchLogCategoryManager.getInstance().getArchCategoryIdList();
            for (int categoryId : categoryIdList) {
                lockObjMap.put(categoryId, new Object());
            }
            ArchFileIndexHandler.resetProcessingArchFileIndexStatus();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

