/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.admin.archivesearch;

import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.admin.archivesearch.ArchFileIndexHandler;
import com.adventnet.sym.adsm.common.server.admin.archivesearch.ArchFileIndexState;
import com.adventnet.sym.adsm.common.server.admin.archivesearch.ArchLogCategoryHandler;
import com.adventnet.sym.adsm.common.server.admin.archivesearch.ArchLogCategoryManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ArchFileIndexThread
implements Runnable {
    private Thread indexThread = new Thread(this);
    private int logCategoryId;
    private int indexAction;
    private ArrayList<String> fileList;
    private final Logger logger = Logger.getLogger(ArchFileIndexThread.class.getName());

    public ArchFileIndexThread(int logCategoryId, int indexAction, ArrayList<String> fileList) {
        this.logCategoryId = logCategoryId;
        this.indexAction = indexAction;
        this.fileList = fileList;
        this.startIndex();
    }

    private void startIndex() {
        this.indexThread.start();
    }

    @Override
    public void run() {
        block17: {
            try {
                this.logger.log(Level.INFO, "ArchFileIndexThread :: Starting thread to index/un-index files for category id :: " + this.logCategoryId);
                if (this.indexAction == 1) {
                    for (String fileName : this.fileList) {
                        try {
                            this.logger.log(Level.INFO, "ArchFileIndexThread :: Started to index file :: '" + fileName + "'");
                            Row archFileInfo = ArchFileIndexHandler.fetchArchFileInfo(fileName);
                            int indexStatus = (Integer)archFileInfo.get("LUC_FILE_INDEX_STATE");
                            String baseDir = (String)archFileInfo.get("BASE_DB_BACKUP_DIRECTORY");
                            if (indexStatus == ArchFileIndexState.INDEXING_SCH.ordinal()) {
                                ArchFileIndexHandler.updateArchFileIndexStatusWithPreCheck(new ArrayList<String>(Arrays.asList(fileName)), ArchFileIndexState.INDEXING);
                                ArchLogCategoryHandler handler = ArchLogCategoryManager.getInstance().getArchCategoryHandler(this.logCategoryId);
                                if (handler.indexArchFilesWithDupRecords(baseDir, new String[]{fileName})) {
                                    ArchFileIndexHandler.updateArchFileIndexStatusWithPreCheck(new ArrayList<String>(Arrays.asList(fileName)), ArchFileIndexState.INDEXED);
                                    continue;
                                }
                                ArchFileIndexHandler.updateArchFileIndexStatusWithPreCheck(new ArrayList<String>(Arrays.asList(fileName)), ArchFileIndexState.UN_INDEXED);
                                continue;
                            }
                            this.logger.log(Level.SEVERE, "ArchFileIndexThread ERROR :: Index state of file '" + fileName + "' is not expected!! Current State : " + indexStatus + ", Expected State : " + ArchFileIndexState.INDEXING_SCH.ordinal());
                        }
                        catch (Exception e1) {
                            e1.printStackTrace();
                            ArchFileIndexHandler.updateArchFileIndexStatusWithPreCheck(new ArrayList<String>(Arrays.asList(fileName)), ArchFileIndexState.UN_INDEXED);
                        }
                    }
                    break block17;
                }
                if (this.indexAction == 2) {
                    for (String fileName : this.fileList) {
                        try {
                            this.logger.log(Level.INFO, "ArchFileIndexThread :: Started to un-index file :: '" + fileName + "'");
                            int indexStatus = ArchFileIndexHandler.fetchArchFileIndexStatus(fileName);
                            if (indexStatus == ArchFileIndexState.UN_INDEXING_SCH.ordinal()) {
                                ArchFileIndexHandler.updateArchFileIndexStatusWithPreCheck(new ArrayList<String>(Arrays.asList(fileName)), ArchFileIndexState.UN_INDEXING);
                                ArchLogCategoryHandler handler = ArchLogCategoryManager.getInstance().getArchCategoryHandler(this.logCategoryId);
                                if (handler.unIndexArchFiles(new String[]{fileName})) {
                                    ArchFileIndexHandler.updateArchFileIndexStatusWithPreCheck(new ArrayList<String>(Arrays.asList(fileName)), ArchFileIndexState.UN_INDEXED);
                                    continue;
                                }
                                ArchFileIndexHandler.updateArchFileIndexStatusWithPreCheck(new ArrayList<String>(Arrays.asList(fileName)), ArchFileIndexState.INDEXED);
                                continue;
                            }
                            this.logger.log(Level.SEVERE, "ArchFileIndexThread ERROR :: Index state of file '" + fileName + "' is not expected!! Current State : " + indexStatus + ", Expected State : " + ArchFileIndexState.UN_INDEXING.ordinal());
                        }
                        catch (Exception e1) {
                            e1.printStackTrace();
                            ArchFileIndexHandler.updateArchFileIndexStatusWithPreCheck(new ArrayList<String>(Arrays.asList(fileName)), ArchFileIndexState.INDEXED);
                        }
                    }
                    break block17;
                }
                if (this.indexAction != 3) break block17;
                try {
                    this.logger.log(Level.INFO, "ArchFileIndexThread :: Started to un-index all files for category id : " + this.logCategoryId);
                    ArchFileIndexHandler.updateAllArchFileIndexStatus(this.logCategoryId, ArchFileIndexState.UN_INDEXING);
                    ArchLogCategoryHandler handler = ArchLogCategoryManager.getInstance().getArchCategoryHandler(this.logCategoryId);
                    if (handler.unIndexAllArchFiles()) {
                        ArchFileIndexHandler.updateAllArchFileIndexStatus(this.logCategoryId, ArchFileIndexState.UN_INDEXED);
                        break block17;
                    }
                    ArchFileIndexHandler.updateAllArchFileIndexStatus(this.logCategoryId, ArchFileIndexState.INDEXED);
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                    ArchFileIndexHandler.updateAllArchFileIndexStatus(this.logCategoryId, ArchFileIndexState.INDEXED);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

