/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.admin.archivesearch;

import com.adventnet.sym.adsm.common.server.admin.archivesearch.ArchLogCategoryManager;
import com.adventnet.sym.adsm.common.server.admin.archivesearch.ArchReportManager;
import com.adventnet.sym.adsm.common.server.admin.archivesearch.LucMultiSearcher;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.JSONArray;
import org.json.JSONObject;

public class ArchGlobalSearchHandler {
    private static LucMultiSearcher searcher = new LucMultiSearcher();
    private static Logger logger = Logger.getLogger(ArchGlobalSearchHandler.class.getName());
    private static AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle();

    public static String parseSearchFields(String searchStr) {
        if (searchStr.contains("(USERNAME=")) {
            String userFields = "USERNAME,CALLER_USER_NAME,CLIENT_USER_NAME,ACCOUNT_NAME";
            searchStr = searchStr.replaceAll("\\(USERNAME=", "\\(" + userFields + "=");
        } else if (searchStr.contains("(MACHINE_NAME=")) {
            String hostNameFields = "SOURCE";
            searchStr = searchStr.replaceAll("\\(MACHINE_NAME=", "\\(" + hostNameFields + "=");
        } else if (searchStr.contains("(*=")) {
            try {
                String searchFields = "";
                HashSet<String> hashSet = new HashSet<String>();
                ArrayList<Integer> categoryIdList = ArchLogCategoryManager.getInstance().getArchCategoryIdList();
                for (int categoryId : categoryIdList) {
                    JSONArray jsonArray = ArchReportManager.getInstance().getSearchableFields(categoryId);
                    int len = jsonArray.length();
                    for (int i = 0; i < len; ++i) {
                        String[] fields;
                        JSONObject jObj = jsonArray.getJSONObject(i);
                        if (jObj == null || !jObj.getString("fieldName").startsWith(rb.getString("adap.archive.any_field"))) continue;
                        for (String field : fields = jObj.getString("fieldKey").split(",")) {
                            hashSet.add(field);
                        }
                    }
                }
                searchFields = hashSet.toString().replace("[", "").replace("]", "").replaceAll(" ", "");
                searchStr = searchStr.replaceAll("\\(*=", "\\(" + searchFields + "=");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return searchStr;
    }

    public static JSONObject fetchReportSummary(String searchStr, Long fromTime, Long toTime) throws Exception {
        logger.log(Level.INFO, "Global Search ::: " + searchStr);
        return searcher.queryRepo(ArchGlobalSearchHandler.parseSearchFields(searchStr), fromTime, toTime);
    }

    public static JSONObject fetchReport(int reportId, JSONObject facetList, String searchQueryStr, int reportFromIndex, int reportToIndex, Long fromTime, Long toTime, Long userId) throws Exception {
        return ArchReportManager.getInstance().getReport(reportId, facetList, ArchGlobalSearchHandler.parseSearchFields(searchQueryStr), reportFromIndex, reportToIndex, fromTime, toTime, userId);
    }

    public static JSONObject fetchFacets(int reportId, String searchQueryStr, Long fromTime, Long toTime) throws Exception {
        return ArchReportManager.getInstance().getFacets(reportId, ArchGlobalSearchHandler.parseSearchFields(searchQueryStr), fromTime, toTime);
    }
}

