/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.admin.archivesearch;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.SortColumn;
import com.adventnet.ds.query.Table;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.auditing.server.backupdata.RestoreUtil;
import com.adventnet.sym.adsm.common.server.DomainHandler;
import com.adventnet.sym.adsm.common.server.admin.archivesearch.ArchFileIndexHandler;
import com.adventnet.sym.adsm.common.server.admin.archivesearch.ArchFileIndexState;
import com.adventnet.sym.adsm.common.server.admin.archivesearch.ArchIndexField;
import com.adventnet.sym.adsm.common.server.admin.archivesearch.LucIndexer;
import com.adventnet.sym.adsm.common.server.admin.archivesearch.LucSearcher;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.LongField;
import org.apache.lucene.document.SortedDocValuesField;
import org.apache.lucene.document.StringField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.facet.FacetField;
import org.apache.lucene.facet.FacetsConfig;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.NumericRangeQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.BytesRef;
import org.json.JSONArray;
import org.json.JSONObject;

public class ArchLogCategoryHandler {
    private int categoryId;
    private String displayName;
    private String tableName;
    private String indexDirPath;
    private boolean isArchiveEnabled;
    private int priorityId;
    private String baseIndexDirPath;
    private int maxFileIndexCount;
    private int scheduleFileIndexCount;
    private boolean isIndexUpdateSchduleEnabled;
    private int uniqueFieldType;
    private LucIndexer lucIndexer;
    private LucSearcher lucSearcher;
    private FacetsConfig facetsConfig;
    private HashMap<String, ArrayList<String>> domainList = null;
    private final FieldType longSortField = new FieldType(LongField.TYPE_STORED);
    private final FieldType strSortField = new FieldType(StringField.TYPE_STORED);
    private static final String ARCH_SEARCH_FIELD_TABLE = "AUDArchSearchField";
    private static final String UNIQUE_FIELD = "UNIQUE_FIELD";
    private static final String TIME_GENERATED = "TIME_GENERATED";
    private static final String RECORD_NUMBER = "RECORD_NUMBER";
    private static Logger logger = Logger.getLogger(ArchLogCategoryHandler.class.getName());
    private static AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle();

    public ArchLogCategoryHandler(int categoryId, String displayName, String tableName) {
        this.categoryId = categoryId;
        this.displayName = displayName;
        this.tableName = tableName;
        this.initFacetsConfig();
        this.lucIndexer = new LucIndexer(this);
        this.lucSearcher = new LucSearcher(this);
        this.longSortField.setDocValuesType(DocValuesType.SORTED_NUMERIC);
        this.longSortField.freeze();
        this.strSortField.setDocValuesType(DocValuesType.SORTED);
        this.strSortField.freeze();
    }

    public int getCategoryId() {
        return this.categoryId;
    }

    public void setCategoryId(int categoryId) {
        this.categoryId = categoryId;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public boolean isArchiveEnabled() {
        return this.isArchiveEnabled;
    }

    public void setArchiveEnabled(boolean isArchiveEnabled) {
        this.isArchiveEnabled = isArchiveEnabled;
    }

    public int getPriorityId() {
        return this.priorityId;
    }

    public void setPriorityId(int priorityId) {
        this.priorityId = priorityId;
    }

    public String getIndexDirPath() {
        return this.indexDirPath;
    }

    public String getBaseIndexDirPath() {
        return this.baseIndexDirPath;
    }

    public void setBaseIndexDirPath(String baseIndexDirPath) {
        this.baseIndexDirPath = baseIndexDirPath;
        this.indexDirPath = baseIndexDirPath.equals("archive_index") ? System.getProperty("server.home") + File.separator + "archive_index" + File.separator + this.tableName : baseIndexDirPath + File.separator + this.tableName;
    }

    public int getMaxFileIndexCount() {
        return this.maxFileIndexCount;
    }

    public void setMaxFileIndexCount(int maxFileIndexCount) {
        this.maxFileIndexCount = maxFileIndexCount;
    }

    public int getScheduleFileIndexCount() {
        return this.scheduleFileIndexCount;
    }

    public void setScheduleFileIndexCount(int scheduleFileIndexCount) {
        this.scheduleFileIndexCount = scheduleFileIndexCount;
    }

    public boolean isIndexUpdateSchduleEnabled() {
        return this.isIndexUpdateSchduleEnabled;
    }

    public void setIndexUpdateSchduleEnabled(boolean isIndexUpdateSchduleEnabled) {
        this.isIndexUpdateSchduleEnabled = isIndexUpdateSchduleEnabled;
    }

    public int getUniqueFieldType() {
        return this.uniqueFieldType;
    }

    public void setUniqueFieldType(int uniqueFieldType) {
        this.uniqueFieldType = uniqueFieldType;
    }

    public FacetsConfig getFacetsConfig() {
        return this.facetsConfig;
    }

    public LucIndexer getLucIndexer() {
        return this.lucIndexer;
    }

    public LucSearcher getLucSearcher() {
        return this.lucSearcher;
    }

    private void updateDomainList() {
        this.domainList = DomainHandler.getConfiguredDomainsList();
    }

    private HashMap<String, ArrayList<String>> getDomainList() {
        return this.domainList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean indexArchFilesWithDupRecords(String baseDir, String[] fileList) {
        boolean isSuccess = true;
        BufferedReader br = null;
        try {
            String fileAbsName = null;
            Long startTime = System.currentTimeMillis();
            int uniqueFieldType = this.getUniqueFieldType();
            ArrayList<ArchIndexField> categoryFieldList = this.fetchCategoryFields();
            int timeFieldIndex = -1;
            int recordNoFieldIndex = -1;
            this.updateDomainList();
            for (String fileName : fileList) {
                try {
                    String[] str;
                    String line;
                    String dbServerName = CommonUtil.getDBServerName();
                    boolean isMySqlDb = false;
                    fileAbsName = baseDir + fileName;
                    String encoding = "UTF8";
                    String splitBy = "\t";
                    logger.log(Level.INFO, "ArchLogCategoryHandler :: Starting to unzip file : " + fileAbsName + " .....");
                    RestoreUtil.unZip(fileAbsName, baseDir);
                    Long endTime = System.currentTimeMillis();
                    logger.log(Level.INFO, "ArchLogCategoryHandler :: Unzipped file : " + fileAbsName + ", total time :: " + (endTime - startTime));
                    if (dbServerName.equalsIgnoreCase("mysql")) {
                        splitBy = ",";
                        encoding = "UTF8";
                        isMySqlDb = true;
                    } else {
                        br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(fileAbsName.replace(".zip", ".csv")), encoding));
                        String firstLine = br.readLine();
                        if (!firstLine.contains("\t")) {
                            splitBy = "\\|\\*\\*\\|";
                            encoding = "UTF-16LE";
                        }
                        br.close();
                    }
                    logger.log(Level.INFO, "ArchLogCategoryHandler :: Delimeter for file '" + fileAbsName + "' :: " + splitBy);
                    logger.log(Level.INFO, "ArchLogCategoryHandler :: Encoding for file '" + fileAbsName + "' :: " + encoding);
                    br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(fileAbsName.replace(".zip", ".csv")), encoding));
                    startTime = System.currentTimeMillis();
                    timeFieldIndex = this.getFieldIndex(categoryFieldList, TIME_GENERATED);
                    if (uniqueFieldType == 1) {
                        recordNoFieldIndex = this.getFieldIndex(categoryFieldList, RECORD_NUMBER);
                        while ((line = br.readLine()) != null) {
                            str = this.splitLine(line, splitBy, categoryFieldList.size(), isMySqlDb);
                            this.lucIndexer.updateIndexedFacetRecord(UNIQUE_FIELD, str[timeFieldIndex] + str[recordNoFieldIndex], this.getLucDocument(str, categoryFieldList));
                        }
                    } else {
                        while ((line = br.readLine()) != null) {
                            str = this.splitLine(line, splitBy, categoryFieldList.size(), isMySqlDb);
                            this.lucIndexer.updateIndexedFacetRecord(UNIQUE_FIELD, str[timeFieldIndex], this.getLucDocument(str, categoryFieldList));
                        }
                    }
                    this.lucIndexer.commit();
                    endTime = System.currentTimeMillis();
                    logger.log(Level.INFO, "ArchLogCategoryHandler :: Total time to index file '" + fileAbsName + "' :: " + (endTime - startTime));
                    logger.log(Level.INFO, "ArchLogCategoryHandler :: Total docs indexed :: " + this.lucIndexer.getDocumentCount());
                }
                catch (Exception e) {
                    ArchFileIndexHandler.updateArchFileIndexStatus(new ArrayList<String>(Arrays.asList(fileName)), ArchFileIndexState.UN_INDEXED);
                    e.printStackTrace();
                }
                finally {
                    br.close();
                    new File(fileAbsName.replace(".zip", ".csv")).delete();
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            isSuccess = false;
        }
        return isSuccess;
    }

    public boolean unIndexArchFiles(String[] fileList) {
        boolean isSuccess = true;
        try {
            for (String fileName : fileList) {
                Long startTime = System.currentTimeMillis();
                Row fileDbRow = ArchFileIndexHandler.fetchArchFileInfo(fileName);
                Long archStartIndex = (Long)fileDbRow.get("START_INDEX");
                Long archEndIndex = (Long)fileDbRow.get("END_INDEX");
                Long archStartTime = (Long)fileDbRow.get("START_TIME");
                Long archEndTime = (Long)fileDbRow.get("END_TIME");
                Query query = this.getDocDelQuery(archStartIndex, archEndIndex, archStartTime, archEndTime);
                this.lucIndexer.deleteDocs(query);
                Long endTime = System.currentTimeMillis();
                logger.log(Level.INFO, "ArchLogCategoryHandler :: Total Time to un-index file '" + fileName + "' :: " + (endTime - startTime));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            isSuccess = false;
        }
        return isSuccess;
    }

    public boolean unIndexAllArchFiles() {
        boolean isSuccess = true;
        try {
            this.lucIndexer.deleteAllDocs();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            isSuccess = false;
        }
        return isSuccess;
    }

    public JSONObject getMinMaxTime() throws Exception {
        return this.lucSearcher.getMinMaxLongField(TIME_GENERATED);
    }

    public JSONArray fetchSearchableFields() throws Exception {
        JSONArray jFieldList = new JSONArray();
        JSONObject jSearchFields = null;
        String allFieldKey = "";
        SelectQueryImpl selectQuery = new SelectQueryImpl(Table.getTable((String)ARCH_SEARCH_FIELD_TABLE));
        Criteria criteria = new Criteria(Column.getColumn((String)ARCH_SEARCH_FIELD_TABLE, (String)"CATEGORY_ID"), (Object)this.categoryId, 0);
        criteria = criteria.and(new Criteria(Column.getColumn((String)ARCH_SEARCH_FIELD_TABLE, (String)"IS_SEARCHABLE"), (Object)true, 0));
        selectQuery.setCriteria(criteria);
        selectQuery.addSelectColumn(Column.getColumn((String)ARCH_SEARCH_FIELD_TABLE, (String)"FIELD_ID"));
        selectQuery.addSelectColumn(Column.getColumn((String)ARCH_SEARCH_FIELD_TABLE, (String)"FIELD_NAME"));
        selectQuery.addSelectColumn(Column.getColumn((String)ARCH_SEARCH_FIELD_TABLE, (String)"DISPLAY_NAME"));
        selectQuery.addSelectColumn(Column.getColumn((String)ARCH_SEARCH_FIELD_TABLE, (String)"PRIORITY_ID"));
        selectQuery.addSortColumn(new SortColumn(Column.getColumn((String)ARCH_SEARCH_FIELD_TABLE, (String)"PRIORITY_ID"), true));
        DataObject dataObj = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)selectQuery);
        if (!dataObj.isEmpty()) {
            Iterator iterator = dataObj.getRows(ARCH_SEARCH_FIELD_TABLE);
            while (iterator.hasNext()) {
                Row row = (Row)iterator.next();
                jSearchFields = new JSONObject();
                jSearchFields.put("fieldKey", row.get("FIELD_NAME"));
                jSearchFields.put("fieldName", (Object)rb.getString((String)row.get("DISPLAY_NAME")));
                jFieldList.put((Object)jSearchFields);
                allFieldKey = allFieldKey + "," + row.get("FIELD_NAME");
            }
            if (!allFieldKey.equals("")) {
                allFieldKey = allFieldKey.substring(1);
                jSearchFields = new JSONObject();
                jSearchFields.put("fieldKey", (Object)allFieldKey);
                jSearchFields.put("fieldName", (Object)(rb.getString("adap.archive.any_field") + "(*)"));
                jFieldList.put((Object)jSearchFields);
            }
        }
        return jFieldList;
    }

    private void initFacetsConfig() {
        this.facetsConfig = new FacetsConfig();
        try {
            Criteria criteria = new Criteria(Column.getColumn((String)ARCH_SEARCH_FIELD_TABLE, (String)"CATEGORY_ID"), (Object)this.categoryId, 0);
            criteria = criteria.and(new Criteria(Column.getColumn((String)ARCH_SEARCH_FIELD_TABLE, (String)"IS_FACET_ENABLED"), (Object)true, 0));
            DataObject dataObj = CommonUtil.getPersistence(new boolean[0]).get(ARCH_SEARCH_FIELD_TABLE, criteria);
            if (!dataObj.isEmpty()) {
                Iterator iterator = dataObj.getRows(ARCH_SEARCH_FIELD_TABLE);
                while (iterator.hasNext()) {
                    Row row = (Row)iterator.next();
                    this.facetsConfig.setHierarchical((String)row.get("FIELD_NAME"), true);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private int getFieldIndex(ArrayList<ArchIndexField> lucArchFieldList, String fieldName) {
        int index = -1;
        for (ArchIndexField field : lucArchFieldList) {
            if (!fieldName.equals(field.getName())) continue;
            index = field.getIndex();
            break;
        }
        return index;
    }

    private Document getLucDocument(String[] actualColStr, ArrayList<ArchIndexField> lucArchFieldList) {
        Document doc = null;
        try {
            doc = new Document();
            String timeFieldVal = "";
            String recordNoFieldVal = "";
            for (ArchIndexField field : lucArchFieldList) {
                String fieldDataType = field.getDataType();
                String fieldVal = this.parseField(actualColStr[field.getIndex()], field.getParseType());
                if (fieldDataType.equals("text")) {
                    doc.add((IndexableField)new TextField(field.getName(), fieldVal, Field.Store.YES));
                } else if (fieldDataType.equals("long")) {
                    doc.add((IndexableField)new LongField(field.getName(), Long.parseLong(fieldVal), this.longSortField));
                }
                if (field.isFacetEnabled()) {
                    String fieldValLower = fieldVal.toLowerCase();
                    doc.add((IndexableField)new SortedDocValuesField(field.getName() + "_DOC", new BytesRef((CharSequence)fieldValLower)));
                    doc.add((IndexableField)new FacetField(field.getName(), new String[]{fieldValLower}));
                }
                if (TIME_GENERATED.equals(field.getName())) {
                    timeFieldVal = fieldVal;
                    continue;
                }
                if (!RECORD_NUMBER.equals(field.getName())) continue;
                recordNoFieldVal = fieldVal;
            }
            doc.add((IndexableField)new SortedDocValuesField("UNIQUE_FIELD_DOC", new BytesRef((CharSequence)(timeFieldVal + recordNoFieldVal))));
            doc.add((IndexableField)new StringField(UNIQUE_FIELD, timeFieldVal + recordNoFieldVal, Field.Store.YES));
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "EXCEPTION:: ArchLogCategoryHandler.getLucDocument : " + e);
        }
        return doc;
    }

    private ArrayList<ArchIndexField> fetchCategoryFields() throws Exception {
        ArrayList<ArchIndexField> categoryFields = new ArrayList<ArchIndexField>();
        SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)ARCH_SEARCH_FIELD_TABLE));
        query.setCriteria(new Criteria(Column.getColumn((String)ARCH_SEARCH_FIELD_TABLE, (String)"CATEGORY_ID"), (Object)this.getCategoryId(), 0));
        query.addSelectColumn(Column.getColumn((String)ARCH_SEARCH_FIELD_TABLE, (String)"*"));
        DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)query);
        if (!dataObject.isEmpty()) {
            Iterator iterator = dataObject.getRows(ARCH_SEARCH_FIELD_TABLE);
            while (iterator.hasNext()) {
                Row row = (Row)iterator.next();
                ArchIndexField field = new ArchIndexField((Integer)row.get("FIELD_ID"), (Integer)row.get("CATEGORY_ID"), (Integer)row.get("COL_INDEX"), (String)row.get("FIELD_NAME"), (String)row.get("DATA_TYPE"));
                field.setParseType((Integer)row.get("PARSE_TYPE"));
                field.setFacetEnabled((Boolean)row.get("IS_FACET_ENABLED"));
                field.setSearchable((Boolean)row.get("IS_SEARCHABLE"));
                field.setStore((Boolean)row.get("STORE"));
                categoryFields.add(field);
            }
        }
        return categoryFields;
    }

    private String[] splitLine(String line, String splitBy, int totalCols, boolean isMySql) {
        int i;
        String[] rColStr = new String[totalCols];
        String[] aColStr = isMySql ? this.splitMySqlLine(line, totalCols) : line.split(splitBy, -1);
        int actualColLen = aColStr.length;
        int indexLen = totalCols;
        if (actualColLen < totalCols) {
            indexLen = actualColLen;
        }
        for (i = 0; i < indexLen; ++i) {
            rColStr[i] = aColStr[i] == null || aColStr[i].isEmpty() ? "-" : aColStr[i];
        }
        for (i = actualColLen; i < totalCols; ++i) {
            rColStr[i] = "-";
        }
        return rColStr;
    }

    private String[] splitMySqlLine(String line, int totalCols) {
        String[] splitStr = new String[totalCols];
        int len = line.length();
        int commaBeginIndex = 0;
        int commaEndIndex = 0;
        int splitStrIndex = 0;
        while (commaEndIndex < len) {
            boolean isQuoteChk = false;
            if (line.charAt(commaBeginIndex) == '\"') {
                commaEndIndex = line.indexOf(34, ++commaBeginIndex);
                isQuoteChk = true;
            } else {
                commaEndIndex = line.indexOf(44, commaBeginIndex);
            }
            if (commaEndIndex == -1) {
                commaEndIndex = len;
            }
            splitStr[splitStrIndex++] = line.substring(commaBeginIndex, commaEndIndex);
            commaEndIndex = commaBeginIndex = commaEndIndex + (isQuoteChk ? 2 : 1);
        }
        return splitStr;
    }

    private String parseField(String fieldValue, int parseType) {
        String parsedValue = fieldValue;
        if (parseType == 1) {
            parsedValue = this.parseDomainName(fieldValue);
        }
        return parsedValue;
    }

    private String parseDomainName(String evtDomainName) {
        if (evtDomainName.startsWith("krbtgt/")) {
            evtDomainName = evtDomainName.replace("krbtgt/", "");
        }
        try {
            HashMap<String, ArrayList<String>> ddd = this.getDomainList();
            ArrayList<String> domainFlatList = ddd.get("DomainFlatNameList");
            if (domainFlatList != null && domainFlatList.contains(evtDomainName.toUpperCase())) {
                int index = domainFlatList.indexOf(evtDomainName.toUpperCase());
                evtDomainName = ddd.get("DomainNameList").get(index).toLowerCase();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return evtDomainName;
    }

    private Query getDocDelQuery(Long startRecord, Long endRecord, Long startTime, Long endTime) {
        BooleanQuery query = null;
        BooleanQuery.Builder booleanQuery = new BooleanQuery.Builder();
        NumericRangeQuery timeRangeQuery1 = NumericRangeQuery.newLongRange((String)TIME_GENERATED, (Long)startTime, (Long)endTime, (boolean)true, (boolean)true);
        booleanQuery.add((Query)timeRangeQuery1, BooleanClause.Occur.MUST);
        query = booleanQuery.build();
        return query;
    }
}

