/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.admin.archivesearch;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.SortColumn;
import com.adventnet.ds.query.Table;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.admin.archivesearch.ArchLogCategoryHandler;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.logging.Logger;

public final class ArchLogCategoryManager {
    private static ArchLogCategoryManager lucManagerObj = null;
    private static HashMap<Integer, ArchLogCategoryHandler> handlersMap = null;
    private static ArrayList<Integer> categoryIdList = null;
    private static HashMap<Integer, Integer> viewCategoryMap = null;
    private static final String ARCH_CATEGORY_TABLE = "AUDArchCategory";
    private static final String ARCH_VIEW_CATEGORY_TABLE = "AUDArchViewCategory";
    private static AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle();
    private static Logger logger = Logger.getLogger(ArchLogCategoryManager.class.getName());

    private ArchLogCategoryManager() {
        this.initHandlers();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArchLogCategoryManager getInstance() {
        Class<ArchLogCategoryManager> clazz = ArchLogCategoryManager.class;
        synchronized (ArchLogCategoryManager.class) {
            if (lucManagerObj == null) {
                lucManagerObj = new ArchLogCategoryManager();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return lucManagerObj;
        }
    }

    public ArrayList<Integer> getArchCategoryIdList() {
        return categoryIdList;
    }

    public ArchLogCategoryHandler getArchCategoryHandler(int categoryId) {
        return handlersMap.get(categoryId);
    }

    public String getArchCategoryName(int categoryId) {
        return rb.getString(handlersMap.get(categoryId).getDisplayName());
    }

    public Integer getCategoryIdForView(int viewCategoryId) {
        return viewCategoryMap.get(viewCategoryId);
    }

    private void initHandlers() {
        handlersMap = new HashMap();
        categoryIdList = new ArrayList();
        viewCategoryMap = new HashMap();
        try {
            SelectQueryImpl selectQuery = new SelectQueryImpl(Table.getTable((String)ARCH_CATEGORY_TABLE));
            Join categoryJoin = new Join(ARCH_CATEGORY_TABLE, ARCH_VIEW_CATEGORY_TABLE, new String[]{"CATEGORY_ID"}, new String[]{"CATEGORY_ID"}, 2);
            selectQuery.addJoin(categoryJoin);
            selectQuery.addSelectColumn(Column.getColumn((String)ARCH_CATEGORY_TABLE, (String)"*"));
            selectQuery.addSelectColumn(Column.getColumn((String)ARCH_VIEW_CATEGORY_TABLE, (String)"*"));
            selectQuery.addSortColumn(new SortColumn(Column.getColumn((String)ARCH_CATEGORY_TABLE, (String)"PRIORITY_ID"), true));
            selectQuery.addSortColumn(new SortColumn(Column.getColumn((String)ARCH_VIEW_CATEGORY_TABLE, (String)"PRIORITY_ID"), true));
            DataObject dataObj = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)selectQuery);
            Iterator iterator = dataObj.getRows(ARCH_CATEGORY_TABLE);
            while (iterator.hasNext()) {
                Row catRow = (Row)iterator.next();
                int catId = (Integer)catRow.get("CATEGORY_ID");
                ArchLogCategoryHandler handler = new ArchLogCategoryHandler(catId, (String)catRow.get("DISPLAY_NAME"), (String)catRow.get("CAT_TABLE_NAME"));
                handler.setArchiveEnabled((Boolean)catRow.get("IS_ARCHIVE_ENABLED"));
                handler.setPriorityId((Integer)catRow.get("PRIORITY_ID"));
                handler.setBaseIndexDirPath((String)catRow.get("BASE_INDEX_PATH"));
                handler.setIndexUpdateSchduleEnabled((Boolean)catRow.get("IS_INDEX_SCHEDULE_ENABLED"));
                handler.setMaxFileIndexCount((Integer)catRow.get("MAX_FILE_INDEX_COUNT"));
                handler.setScheduleFileIndexCount((Integer)catRow.get("SCHEDULE_FILE_INDEX_COUNT"));
                handler.setUniqueFieldType((Integer)catRow.get("UNIQUE_FIELD_TYPE"));
                handlersMap.put((int)((Integer)catRow.get("CATEGORY_ID")), handler);
                categoryIdList.add((int)((Integer)catRow.get("CATEGORY_ID")));
                Criteria viewCatCrit = new Criteria(Column.getColumn((String)ARCH_VIEW_CATEGORY_TABLE, (String)"CATEGORY_ID"), (Object)catId, 0);
                Iterator viewCatIterator = dataObj.getRows(ARCH_VIEW_CATEGORY_TABLE, viewCatCrit);
                while (viewCatIterator.hasNext()) {
                    Row viewRow = (Row)viewCatIterator.next();
                    int viewCatId = (Integer)viewRow.get("VIEW_CATEGORY_ID");
                    viewCategoryMap.put(viewCatId, catId);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

