/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.admin.archivesearch;

import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.lucene.queryparser.classic.QueryParser;

public class ArchQueryParser {
    private static ArrayList<String> parseTokenList;
    private static AdventNetResourceBundle rb;

    private static void initTokenMap() {
        parseTokenList = new ArrayList();
        parseTokenList.add("I18N");
        parseTokenList.add("LUC-ESCAPE");
    }

    private static String parseString(String parseStr, String token) {
        if (token.equals("I18N")) {
            parseStr = rb.getString(parseStr);
        } else if (token.equals("LUC-ESCAPE")) {
            parseStr = QueryParser.escape((String)parseStr);
        }
        return parseStr;
    }

    public static String parseQuery(String query) {
        for (String token : parseTokenList) {
            String patternStr = "\\{\\{" + token + ":\\}\\}((?!\\{\\{:).)*\\{\\{:" + token + "\\}\\}";
            String startToken = "{{" + token + ":}}";
            String endToken = "{{:" + token + "}}";
            Pattern pattern = Pattern.compile(patternStr);
            Matcher match = pattern.matcher(query);
            while (match.find()) {
                String tokenValue = match.group().replace(startToken, "");
                tokenValue = tokenValue.replace(endToken, "");
                query = query.replace(startToken + tokenValue + endToken, ArchQueryParser.parseString(tokenValue, token));
            }
        }
        return query;
    }

    static {
        rb = ResourceBundleMgr.getInstance().getBundle();
        try {
            ArchQueryParser.initTokenMap();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

