/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.admin.archivesearch;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.SortColumn;
import com.adventnet.ds.query.Table;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.admin.archivesearch.ArchLogCategoryHandler;
import com.adventnet.sym.adsm.common.server.admin.archivesearch.ArchLogCategoryManager;
import com.adventnet.sym.adsm.common.server.admin.archivesearch.ArchQueryParser;
import com.adventnet.sym.adsm.common.server.admin.archivesearch.ArchReport;
import com.adventnet.sym.adsm.common.server.admin.archivesearch.LucQueryConstructor;
import com.adventnet.sym.adsm.common.server.admin.archivesearch.LucSearcher;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.LicenseUtil;
import com.adventnet.sym.adsm.common.server.util.TimeUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.lucene.document.Document;
import org.apache.lucene.facet.DrillDownQuery;
import org.apache.lucene.facet.FacetResult;
import org.apache.lucene.facet.Facets;
import org.apache.lucene.facet.LabelAndValue;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.NumericRangeQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.SortedNumericSortField;
import org.apache.lucene.search.TopDocs;
import org.json.JSONArray;
import org.json.JSONObject;

public final class ArchReportManager {
    private static ArchReportManager archReportManager = null;
    private static Logger logger = Logger.getLogger(ArchReportManager.class.getName());
    private static AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle();
    private static LinkedHashMap<Integer, ArchReport> logRepoReportMap = new LinkedHashMap();
    private static LinkedHashMap<Integer, Integer> logRepoGSReportId = new LinkedHashMap();
    private static ArrayList<Integer> gsReportList = new ArrayList();
    private static final String ARCH_CATEGORY_TABLE = "AUDArchCategory";
    private static final String ARCH_VIEW_CATEGORY_TABLE = "AUDArchViewCategory";
    private static final String ARCH_REPORT_TABLE = "AUDArchReport";
    private static final String ARCH_SEARCH_FIELD_TABLE = "AUDArchSearchField";
    private static final String ARCH_REPORT_VIEW_MAPPING_TABLE = "AUDArchReportViewMapping";
    private static final String ARCH_FACET_COL_MAPPING_TABLE = "AUDArchFacetColMapping";
    private static final String ARCH_TABLE_COL_MAPPING_TABLE = "AUDArchTableColMapping";
    private static final String ARCH_TABLE_USER_COL_MAPPING_TABLE = "AUDArchTableUserColMapping";

    private ArchReportManager() {
        this.initReports();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArchReportManager getInstance() {
        Class<ArchReportManager> clazz = ArchReportManager.class;
        synchronized (ArchReportManager.class) {
            if (archReportManager == null) {
                archReportManager = new ArchReportManager();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return archReportManager;
        }
    }

    public int getReportArchCategoryId(int reportId) {
        return logRepoReportMap.get(reportId).getCategoryId();
    }

    public String getReportName(int reportId) {
        return rb.getString(logRepoReportMap.get(reportId).getName());
    }

    public String getGSReportName(int reportId) {
        return rb.getString(logRepoReportMap.get(reportId).getGSReportName());
    }

    public int getReportTableId(int reportId) {
        return logRepoReportMap.get(reportId).getDefaultOutputTableId();
    }

    public int getReportFacetGroupId(int reportId) {
        return logRepoReportMap.get(reportId).getDefaultFacetGroupId();
    }

    public Integer getGSReportId(int categoryId) {
        return logRepoGSReportId.get(categoryId);
    }

    public ArrayList<Integer> getGSReportList() {
        return gsReportList;
    }

    public JSONObject getReportCount(int reportId, String searchQueryStr, Long fromTime, Long toTime) throws Exception {
        JSONObject jQueryResult = new JSONObject();
        try {
            Query query = this.getQuery(reportId, searchQueryStr, fromTime, toTime);
            jQueryResult = this.queryLogRepoCount(query, reportId);
        }
        catch (OutOfMemoryError oome) {
            jQueryResult.put("failure", true);
            jQueryResult.put("text", (Object)(rb.getString("adap.archive.out_of_memory") + rb.getString("adap.archive.cause") + " : " + oome.getMessage()));
            oome.printStackTrace();
        }
        catch (Exception e) {
            jQueryResult.put("failure", true);
            jQueryResult.put("text", (Object)e.getMessage());
            e.printStackTrace();
        }
        return jQueryResult;
    }

    public JSONObject getReport(int reportId, JSONObject facetList, String searchQueryStr, int reportFromIndex, int reportToIndex, Long fromTime, Long toTime, Long userId) throws Exception {
        JSONObject jQueryResult = new JSONObject();
        try {
            Query query = this.getQuery(reportId, searchQueryStr, fromTime, toTime);
            JSONObject jTableColObj = this.fetchReportTableCols(userId, this.getReportTableId(reportId));
            JSONArray jTableColList = jTableColObj.getJSONArray("colInfo");
            JSONArray jVisibleTableColList = jTableColObj.getJSONArray("visibleColInfo");
            JSONArray jFacetColList = this.fetchReportFacetCols(this.getReportFacetGroupId(reportId));
            if (facetList != null && facetList.length() != 0) {
                query = this.getDrillDownQuery(reportId, query, facetList, jFacetColList);
            }
            if ((jQueryResult = this.queryLogRepo(query, reportId, reportFromIndex, reportToIndex, jVisibleTableColList)) == null) {
                jQueryResult = new JSONObject();
                jQueryResult.put("noIndex", true);
            } else {
                jQueryResult.put("colInfo", (Object)jTableColList);
            }
        }
        catch (Throwable throwable) {
            if (throwable instanceof OutOfMemoryError) {
                jQueryResult.put("text", (Object)(rb.getString("adap.archive.out_of_memory") + rb.getString("adap.archive.cause") + " : " + throwable));
            } else {
                jQueryResult.put("text", (Object)throwable);
            }
            jQueryResult.put("failure", true);
            throwable.printStackTrace();
        }
        return jQueryResult;
    }

    public JSONObject getFacets(int reportId, String searchQueryStr, Long fromTime, Long toTime) throws Exception {
        JSONObject jOutputObj = new JSONObject();
        JSONArray jFacetResult = new JSONArray();
        try {
            Query query = this.getQuery(reportId, searchQueryStr, fromTime, toTime);
            JSONArray jFacetColList = this.fetchReportFacetCols(this.getReportFacetGroupId(reportId));
            int listLen = jFacetColList.length();
            LucSearcher lucSearcher = this.getArchCategoryHandler(reportId).getLucSearcher();
            Facets facets = lucSearcher.getFacets(query, 10);
            if (facets != null) {
                for (int i = 0; i < listLen; ++i) {
                    JSONObject jColInfo = jFacetColList.getJSONObject(i);
                    FacetResult facetRes = facets.getTopChildren(10, jColInfo.getString("facetColKey"), new String[0]);
                    if (facetRes == null) continue;
                    JSONObject jFacetColObj = new JSONObject();
                    JSONArray jFacetColCount = new JSONArray();
                    for (LabelAndValue labVal : facetRes.labelValues) {
                        JSONObject jCountObj = new JSONObject();
                        jCountObj.put("facetLabel", (Object)labVal.label);
                        jCountObj.put("facetColLabel", jColInfo.get("facetColDisplayName"));
                        jCountObj.put("facetCount", (Object)labVal.value);
                        jCountObj.put("isFacetChecked", false);
                        jFacetColCount.put((Object)jCountObj);
                    }
                    jFacetColObj.put("facetColDisplayName", jColInfo.get("facetColDisplayName"));
                    jFacetColObj.put("facetColKey", jColInfo.get("facetColKey"));
                    jFacetColObj.put("facetCountList", (Object)jFacetColCount);
                    jFacetResult.put((Object)jFacetColObj);
                }
            }
            if (jFacetResult != null && !jFacetResult.isNull(1)) {
                jOutputObj.put("facetDisplayList", (Object)jFacetResult);
                jOutputObj.put("facetHitCount", 10);
            }
        }
        catch (Throwable throwable) {
            if (throwable instanceof OutOfMemoryError) {
                jOutputObj.put("text", (Object)(rb.getString("adap.archive.out_of_memory") + rb.getString("adap.archive.cause") + " : " + throwable));
            } else {
                jOutputObj.put("text", (Object)throwable);
            }
            jOutputObj.put("failure", true);
            throwable.printStackTrace();
        }
        return jOutputObj;
    }

    public JSONObject getSuggestions(int reportId, String fieldsStr, String sugKey) throws Exception {
        JSONObject jOutputObj = new JSONObject();
        try {
            String[] fields = fieldsStr.split(",");
            jOutputObj.put("suggestions", (Object)this.getArchCategoryHandler(reportId).getLucSearcher().getSuggestions(fields, sugKey));
        }
        catch (OutOfMemoryError oome) {
            jOutputObj.put("failure", true);
            jOutputObj.put("text", (Object)(rb.getString("adap.archive.out_of_memory") + rb.getString("adap.archive.cause") + " : " + oome));
            oome.printStackTrace();
        }
        catch (Exception e) {
            jOutputObj.put("failure", true);
            jOutputObj.put("text", (Object)e);
            e.printStackTrace();
        }
        return jOutputObj;
    }

    public JSONArray getSearchableFields(int reportId) throws Exception {
        int categoryId = this.getReportArchCategoryId(reportId);
        JSONArray jFieldList = ArchLogCategoryManager.getInstance().getArchCategoryHandler(categoryId).fetchSearchableFields();
        return jFieldList;
    }

    public ArchLogCategoryHandler getArchCategoryHandler(int reportId) {
        ArchReport report = logRepoReportMap.get(reportId);
        ArchLogCategoryHandler categoryHandler = null;
        if (report == null) {
            logger.log(Level.SEVERE, "ERROR :: Category Id for report id : " + reportId + ", not found!!");
        } else {
            categoryHandler = ArchLogCategoryManager.getInstance().getArchCategoryHandler(report.getCategoryId());
        }
        return categoryHandler;
    }

    public JSONObject fetchReportList(ArrayList<Long> actionList) {
        JSONObject jResult = new JSONObject();
        try {
            SelectQueryImpl selectQuery = new SelectQueryImpl(Table.getTable((String)ARCH_VIEW_CATEGORY_TABLE));
            Join categoryReportJoin = new Join(ARCH_VIEW_CATEGORY_TABLE, ARCH_REPORT_TABLE, new String[]{"VIEW_CATEGORY_ID"}, new String[]{"VIEW_CATEGORY_ID"}, 2);
            selectQuery.addJoin(categoryReportJoin);
            Criteria crit = new Criteria(Column.getColumn((String)ARCH_VIEW_CATEGORY_TABLE, (String)"VIEW_CATEGORY_ID"), null, 1);
            if (actionList != null) {
                Criteria actionCrit = new Criteria(Column.getColumn((String)ARCH_VIEW_CATEGORY_TABLE, (String)"ACTION_ID"), (Object)actionList.toArray(), 8);
                actionCrit = actionCrit.or(new Criteria(Column.getColumn((String)ARCH_VIEW_CATEGORY_TABLE, (String)"ACTION_ID"), null, 0));
                crit.and(actionCrit);
            }
            selectQuery.setCriteria(crit);
            selectQuery.addSelectColumn(Column.getColumn((String)ARCH_VIEW_CATEGORY_TABLE, (String)"VIEW_CATEGORY_ID"));
            selectQuery.addSelectColumn(Column.getColumn((String)ARCH_VIEW_CATEGORY_TABLE, (String)"DISPLAY_NAME"));
            selectQuery.addSelectColumn(Column.getColumn((String)ARCH_REPORT_TABLE, (String)"*"));
            selectQuery.addSortColumn(new SortColumn(Column.getColumn((String)ARCH_VIEW_CATEGORY_TABLE, (String)"PRIORITY_ID"), true));
            DataObject dataObj = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)selectQuery);
            JSONArray jCategoryList = new JSONArray();
            JSONObject reportCategoriesMap = new JSONObject();
            reportCategoriesMap.put("name", (Object)rb.getString("adap.archive.index_files_for_search"));
            reportCategoriesMap.put("hasDropdown", false);
            reportCategoriesMap.put("routeName", (Object)"admin.search-archived-events.index-files");
            jCategoryList.put((Object)reportCategoriesMap);
            reportCategoriesMap = new JSONObject();
            reportCategoriesMap.put("name", (Object)rb.getString("adap.archive.global_search"));
            reportCategoriesMap.put("hasDropdown", false);
            reportCategoriesMap.put("routeName", (Object)"admin.search-archived-events.global-search");
            jCategoryList.put((Object)reportCategoriesMap);
            reportCategoriesMap = new JSONObject();
            reportCategoriesMap.put("isSplitBar", true);
            jCategoryList.put((Object)reportCategoriesMap);
            Iterator iterator = dataObj.getRows(ARCH_VIEW_CATEGORY_TABLE);
            while (iterator.hasNext()) {
                Row categoryRow = (Row)iterator.next();
                int categoryId = (Integer)categoryRow.get("VIEW_CATEGORY_ID");
                String categoryName = (String)categoryRow.get("DISPLAY_NAME");
                Criteria categoryCrit = new Criteria(Column.getColumn((String)ARCH_REPORT_TABLE, (String)"VIEW_CATEGORY_ID"), (Object)categoryId, 0);
                if (!LicenseUtil.isProfEdn()) {
                    categoryCrit = categoryCrit.and(new Criteria(Column.getColumn((String)ARCH_REPORT_TABLE, (String)"LICENSE_TYPE"), (Object)1, 0));
                }
                if (actionList != null) {
                    Criteria actionCrit = new Criteria(Column.getColumn((String)ARCH_REPORT_TABLE, (String)"ACTION_ID"), (Object)actionList.toArray(), 8);
                    actionCrit = actionCrit.or(new Criteria(Column.getColumn((String)ARCH_REPORT_TABLE, (String)"ACTION_ID"), null, 0));
                    categoryCrit.and(actionCrit);
                }
                Iterator reportIterator = dataObj.getRows(ARCH_REPORT_TABLE, categoryCrit);
                JSONArray jReportList = new JSONArray();
                while (reportIterator.hasNext()) {
                    Row reportRow = (Row)reportIterator.next();
                    String reportName = (String)reportRow.get("REPORT_NAME");
                    int reportId = (Integer)reportRow.get("REPORT_ID");
                    JSONObject jReportObj = new JSONObject();
                    jReportObj.put("modelId", reportId);
                    jReportObj.put("name", (Object)rb.getString(reportName));
                    jReportObj.put("routeName", (Object)"admin.search-archived-events.arch-report");
                    jReportList.put((Object)jReportObj);
                }
                reportCategoriesMap = new JSONObject();
                reportCategoriesMap.put("REPORT_CATEGORY_ID", categoryId);
                reportCategoriesMap.put("name", (Object)rb.getString(categoryName));
                reportCategoriesMap.put("hasDropdown", true);
                reportCategoriesMap.put("SR_NAME", (Object)rb.getString(categoryName));
                reportCategoriesMap.put("list", (Object)jReportList);
                jCategoryList.put((Object)reportCategoriesMap);
            }
            jResult.put("treeDataList", (Object)jCategoryList);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return jResult;
    }

    public JSONArray fetchArchLogCategories(boolean appendAll) {
        JSONArray jRepoArr = new JSONArray();
        JSONObject jCategory = null;
        try {
            SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)ARCH_CATEGORY_TABLE));
            query.addSelectColumn(Column.getColumn((String)ARCH_CATEGORY_TABLE, (String)"CATEGORY_ID"));
            query.addSelectColumn(Column.getColumn((String)ARCH_CATEGORY_TABLE, (String)"DISPLAY_NAME"));
            query.addSortColumn(new SortColumn(Column.getColumn((String)ARCH_CATEGORY_TABLE, (String)"PRIORITY_ID"), true));
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)query);
            if (!dataObject.isEmpty()) {
                Iterator iterator = dataObject.getRows(ARCH_CATEGORY_TABLE);
                if (appendAll) {
                    jCategory = new JSONObject();
                    jCategory.put("name", (Object)rb.getString("All"));
                    jCategory.put("value", 0);
                    jRepoArr.put((Object)jCategory);
                }
                while (iterator.hasNext()) {
                    Row row = (Row)iterator.next();
                    jCategory = new JSONObject();
                    jCategory.put("name", (Object)rb.getString((String)row.get("DISPLAY_NAME")));
                    jCategory.put("value", row.get("CATEGORY_ID"));
                    jRepoArr.put((Object)jCategory);
                }
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "EXCEPTION while fetching archive categories :\n" + e.getMessage());
            e.printStackTrace();
        }
        return jRepoArr;
    }

    public boolean updateTableColumnList(Long userId, int tableId, JSONArray jSelColIds) {
        boolean isSuccess = true;
        try {
            int i;
            Iterator rowIterator;
            int colLen = jSelColIds.length();
            int[] selColIds = new int[colLen];
            boolean isNewEntry = false;
            Criteria userTableColCrit = new Criteria(Column.getColumn((String)ARCH_TABLE_USER_COL_MAPPING_TABLE, (String)"TABLE_ID"), (Object)tableId, 0);
            userTableColCrit = userTableColCrit.and(new Criteria(Column.getColumn((String)ARCH_TABLE_USER_COL_MAPPING_TABLE, (String)"USER_ID"), (Object)userId, 0));
            DataObject userTableColDataObj = CommonUtil.getPersistence(new boolean[0]).get(ARCH_TABLE_USER_COL_MAPPING_TABLE, userTableColCrit);
            Criteria tableColCrit = new Criteria(Column.getColumn((String)ARCH_TABLE_COL_MAPPING_TABLE, (String)"TABLE_ID"), (Object)tableId, 0);
            DataObject tableColDataObj = CommonUtil.getPersistence(new boolean[0]).get(ARCH_TABLE_COL_MAPPING_TABLE, tableColCrit);
            if (userTableColDataObj.isEmpty()) {
                isNewEntry = true;
            }
            int index = 1;
            Criteria mandatoryColCriteria = new Criteria(Column.getColumn((String)ARCH_TABLE_COL_MAPPING_TABLE, (String)"MANDATORY"), (Object)true, 0);
            Iterator iterator = rowIterator = tableColDataObj.getRows(ARCH_TABLE_COL_MAPPING_TABLE, mandatoryColCriteria);
            while (iterator.hasNext()) {
                Row fieldRow;
                Row row = (Row)iterator.next();
                int fieldId = (Integer)row.get("FIELD_ID");
                if (isNewEntry) {
                    fieldRow = new Row(ARCH_TABLE_USER_COL_MAPPING_TABLE);
                    fieldRow.set("USER_ID", (Object)userId);
                    fieldRow.set("TABLE_ID", (Object)tableId);
                    fieldRow.set("FIELD_ID", (Object)fieldId);
                } else {
                    Criteria crit = new Criteria(Column.getColumn((String)ARCH_TABLE_USER_COL_MAPPING_TABLE, (String)"FIELD_ID"), (Object)fieldId, 0);
                    fieldRow = userTableColDataObj.getRow(ARCH_TABLE_USER_COL_MAPPING_TABLE, crit);
                }
                fieldRow.set("PRIORITY_ID", (Object)index++);
                fieldRow.set("VISIBLE", (Object)true);
                if (isNewEntry) {
                    userTableColDataObj.addRow(fieldRow);
                    continue;
                }
                userTableColDataObj.updateRow(fieldRow);
            }
            for (i = 0; i < colLen; ++i) {
                Row fieldRow;
                int fieldId = jSelColIds.getInt(i);
                if (isNewEntry) {
                    fieldRow = new Row(ARCH_TABLE_USER_COL_MAPPING_TABLE);
                    fieldRow.set("USER_ID", (Object)userId);
                    fieldRow.set("TABLE_ID", (Object)tableId);
                    fieldRow.set("FIELD_ID", (Object)fieldId);
                } else {
                    Criteria crit = new Criteria(Column.getColumn((String)ARCH_TABLE_USER_COL_MAPPING_TABLE, (String)"FIELD_ID"), (Object)fieldId, 0);
                    fieldRow = userTableColDataObj.getRow(ARCH_TABLE_USER_COL_MAPPING_TABLE, crit);
                }
                fieldRow.set("PRIORITY_ID", (Object)(index + i));
                fieldRow.set("VISIBLE", (Object)true);
                if (isNewEntry) {
                    userTableColDataObj.addRow(fieldRow);
                } else {
                    userTableColDataObj.updateRow(fieldRow);
                }
                selColIds[i] = fieldId;
            }
            index += i;
            Criteria notSelUserColCriteria = new Criteria(Column.getColumn((String)ARCH_TABLE_COL_MAPPING_TABLE, (String)"FIELD_ID"), (Object)selColIds, 9);
            Iterator iterator2 = rowIterator = tableColDataObj.getRows(ARCH_TABLE_COL_MAPPING_TABLE, notSelUserColCriteria);
            while (iterator2.hasNext()) {
                Row fieldRow;
                Row row = (Row)iterator2.next();
                int fieldId = (Integer)row.get("FIELD_ID");
                boolean isMandatory = (Boolean)row.get("MANDATORY");
                if (isNewEntry) {
                    fieldRow = new Row(ARCH_TABLE_USER_COL_MAPPING_TABLE);
                    fieldRow.set("USER_ID", (Object)userId);
                    fieldRow.set("TABLE_ID", (Object)tableId);
                    fieldRow.set("FIELD_ID", (Object)fieldId);
                } else {
                    Criteria crit = new Criteria(Column.getColumn((String)ARCH_TABLE_USER_COL_MAPPING_TABLE, (String)"FIELD_ID"), (Object)fieldId, 0);
                    fieldRow = userTableColDataObj.getRow(ARCH_TABLE_USER_COL_MAPPING_TABLE, crit);
                }
                if (isMandatory) continue;
                fieldRow.set("PRIORITY_ID", (Object)index++);
                fieldRow.set("VISIBLE", (Object)false);
                if (isNewEntry) {
                    userTableColDataObj.addRow(fieldRow);
                    continue;
                }
                userTableColDataObj.updateRow(fieldRow);
            }
            CommonUtil.getPersistence(new boolean[0]).update(userTableColDataObj);
        }
        catch (Exception e) {
            e.printStackTrace();
            isSuccess = false;
        }
        return isSuccess;
    }

    private void initReports() {
        try {
            SelectQueryImpl selectQuery = new SelectQueryImpl(Table.getTable((String)ARCH_REPORT_TABLE));
            Join reportViewJoin = new Join(ARCH_REPORT_TABLE, ARCH_REPORT_VIEW_MAPPING_TABLE, new String[]{"REPORT_ID"}, new String[]{"REPORT_ID"}, 2);
            selectQuery.addJoin(reportViewJoin);
            selectQuery.addSelectColumn(Column.getColumn((String)ARCH_REPORT_TABLE, (String)"*"));
            selectQuery.addSelectColumn(Column.getColumn((String)ARCH_REPORT_VIEW_MAPPING_TABLE, (String)"*"));
            DataObject dataObj = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)selectQuery);
            Iterator iterator = dataObj.getRows(ARCH_REPORT_TABLE);
            while (iterator.hasNext()) {
                Row reportRow = (Row)iterator.next();
                int reportId = (Integer)reportRow.get("REPORT_ID");
                int viewCategoryId = (Integer)reportRow.get("VIEW_CATEGORY_ID");
                ArchReport report = new ArchReport(reportId, viewCategoryId, (String)reportRow.get("REPORT_NAME"));
                report.setCategoryId(ArchLogCategoryManager.getInstance().getCategoryIdForView(viewCategoryId));
                Criteria reportCrit = new Criteria(Column.getColumn((String)ARCH_REPORT_VIEW_MAPPING_TABLE, (String)"REPORT_ID"), (Object)reportId, 0);
                Iterator reportViewIterator = dataObj.getRows(ARCH_REPORT_VIEW_MAPPING_TABLE, reportCrit);
                while (reportViewIterator.hasNext()) {
                    Row viewRow = (Row)reportViewIterator.next();
                    int tableId = (Integer)viewRow.get("TABLE_ID");
                    int facetGroupId = (Integer)viewRow.get("FACET_GROUP_ID");
                    report.addReportViewConfig(tableId, facetGroupId);
                }
                report.setGSReport((Boolean)reportRow.get("IS_GLOBAL_SEARCH_REPORT"));
                if (report.isGSReport()) {
                    gsReportList.add(report.getReportId());
                    report.setGSReportName((String)reportRow.get("GS_DISPLAY_NAME"));
                }
                logRepoReportMap.put(report.getReportId(), report);
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "EXCEPTION while initializing archive reports :\n" + e.getMessage());
            e.printStackTrace();
        }
    }

    private JSONObject queryLogRepoCount(Query query, int reportId) throws Exception {
        JSONObject jResult = null;
        LucSearcher lucSearcher = this.getArchCategoryHandler(reportId).getLucSearcher();
        TopDocs topDocs = lucSearcher.queryRepo(query);
        jResult = new JSONObject();
        if (topDocs == null) {
            jResult.put("totalHits", 0);
        } else {
            jResult.put("totalHits", topDocs.totalHits);
        }
        return jResult;
    }

    private JSONObject queryLogRepo(Query query, int reportId, int resultFromIndex, int resultToIndex, JSONArray jTableColList) throws Exception {
        JSONObject jResult = null;
        int resultOffset = resultFromIndex - 1;
        int resultCount = resultToIndex - resultFromIndex + 1;
        LucSearcher lucSearcher = this.getArchCategoryHandler(reportId).getLucSearcher();
        TopDocs topDocs = lucSearcher.queryRepo(query, this.getSortField(this.getArchCategoryHandler(reportId).getUniqueFieldType()), resultOffset, resultCount);
        if (topDocs != null) {
            JSONArray jsonArray = new JSONArray();
            ScoreDoc[] hits = topDocs.scoreDocs;
            IndexSearcher indexSearcher = lucSearcher.getIndexSearcher(true);
            for (int i = resultOffset; i < hits.length; ++i) {
                Document doc = indexSearcher.doc(hits[i].doc);
                jsonArray.put((Object)this.getOutputFieldValues(doc, jTableColList));
            }
            jResult = new JSONObject();
            jResult.put("outputRows", (Object)jsonArray);
            jResult.put("colInfo", (Object)jTableColList);
            jResult.put("totalCount", topDocs.totalHits);
            jResult.put("startValue", resultFromIndex);
            jResult.put("rangeValue", resultCount);
            jResult.put("tableId", this.getReportTableId(reportId));
        }
        return jResult;
    }

    private Query getQuery(int reportId, String searchQueryStr, Long fromTime, Long toTime) throws Exception {
        Query reportQuery = null;
        NumericRangeQuery rangeQuery = null;
        Query searchQuery = null;
        BooleanQuery.Builder booleanQuery = new BooleanQuery.Builder();
        reportQuery = this.constructLucQuery(this.fetchQueryStr(reportId));
        booleanQuery.add(reportQuery, BooleanClause.Occur.MUST);
        if (searchQueryStr != null && !searchQueryStr.isEmpty()) {
            searchQuery = this.constructLucQuery(searchQueryStr);
            booleanQuery.add(searchQuery, BooleanClause.Occur.MUST);
        }
        if (fromTime != null && toTime != null) {
            rangeQuery = NumericRangeQuery.newLongRange((String)"TIME_GENERATED", (Long)fromTime, (Long)toTime, (boolean)true, (boolean)true);
            booleanQuery.add((Query)rangeQuery, BooleanClause.Occur.MUST);
        }
        return booleanQuery.build();
    }

    private Query constructLucQuery(String searchQuery) {
        Query query = null;
        if (searchQuery != null) {
            query = LucQueryConstructor.constructMultiQuery(LucQueryConstructor.removeExtraBrac(searchQuery));
        } else {
            logger.log(Level.SEVERE, "ERROR :: query string null while constructing lucene query");
        }
        return query;
    }

    private String fetchQueryStr(int reportId) throws Exception {
        String queryStr = null;
        Criteria criteria = new Criteria(Column.getColumn((String)ARCH_REPORT_TABLE, (String)"REPORT_ID"), (Object)reportId, 0);
        DataObject dataObj = CommonUtil.getPersistence(new boolean[0]).get(ARCH_REPORT_TABLE, criteria);
        if (!dataObj.isEmpty()) {
            Row row = dataObj.getRow(ARCH_REPORT_TABLE);
            queryStr = (String)row.get("REPORT_QUERY");
            queryStr = ArchQueryParser.parseQuery(queryStr);
        }
        return queryStr;
    }

    private DrillDownQuery getDrillDownQuery(int reportId, Query query, JSONObject ddList, JSONArray jFacetColList) throws Exception {
        DrillDownQuery ddq = new DrillDownQuery(this.getArchCategoryHandler(reportId).getFacetsConfig(), query);
        int listLen = jFacetColList.length();
        for (int i = 0; i < listLen; ++i) {
            String facetColName = jFacetColList.getJSONObject(i).getString("facetColKey");
            if (!ddList.has(facetColName)) continue;
            JSONArray jArr = ddList.getJSONArray(facetColName);
            for (int j = 0; j < jArr.length(); ++j) {
                ddq.add(facetColName, new String[]{(String)jArr.get(j)});
            }
        }
        return ddq;
    }

    private Sort getSortField(int type) {
        Sort sortBy = null;
        if (type == 1) {
            sortBy = new Sort();
            SortedNumericSortField timeSortField = new SortedNumericSortField("TIME_GENERATED", SortField.Type.LONG, true);
            SortedNumericSortField recordSortField = new SortedNumericSortField("RECORD_NUMBER", SortField.Type.LONG, true);
            sortBy.setSort(new SortField[]{timeSortField, recordSortField});
        } else if (type == 2) {
            sortBy = new Sort();
            SortedNumericSortField timeSortField = new SortedNumericSortField("TIME_GENERATED", SortField.Type.LONG, true);
            sortBy.setSort((SortField)timeSortField);
        }
        return sortBy;
    }

    private JSONArray getOutputFieldValues(Document doc, JSONArray jTableColList) throws Exception {
        JSONArray jColValueArr = null;
        jColValueArr = new JSONArray();
        int listLen = jTableColList.length();
        for (int i = 0; i < listLen; ++i) {
            String colName = jTableColList.getJSONObject(i).getString("columnalias");
            String colValue = "";
            colValue = colName.equals("TIME_GENERATED") ? TimeUtil.formatDate(Long.parseLong(doc.get(colName)) * 1000L) : (colName.equals("OBJECT_NAME") || colName.equals("UNC_NAME") || colName.equals("FILE_LOCATION") || colName.equals("PROCESS_NAME") || colName.equals("FORMAT_MESSAGE") ? doc.get(colName).toString().replace("\\\\", "\\") : doc.get(colName));
            jColValueArr.put((Object)colValue);
        }
        return jColValueArr;
    }

    private JSONObject fetchReportTableCols(Long userId, int tableId) throws Exception {
        JSONObject jResult = new JSONObject();
        JSONArray jColInfoList = new JSONArray();
        JSONArray jVisisbleColInfoList = new JSONArray();
        Table tableFieldMappingTable = Table.getTable((String)ARCH_TABLE_COL_MAPPING_TABLE);
        SelectQueryImpl selectQuery = new SelectQueryImpl(tableFieldMappingTable);
        Criteria crit = new Criteria(Column.getColumn((String)ARCH_TABLE_COL_MAPPING_TABLE, (String)"TABLE_ID"), (Object)tableId, 0);
        selectQuery.setCriteria(crit);
        Join tableFieldJoin = new Join(ARCH_TABLE_COL_MAPPING_TABLE, ARCH_SEARCH_FIELD_TABLE, new String[]{"FIELD_ID"}, new String[]{"FIELD_ID"}, 2);
        Join tableUserColJoin = new Join(ARCH_TABLE_COL_MAPPING_TABLE, ARCH_TABLE_USER_COL_MAPPING_TABLE, new String[]{"TABLE_ID", "FIELD_ID"}, new String[]{"TABLE_ID", "FIELD_ID"}, 1);
        selectQuery.addJoin(tableFieldJoin);
        selectQuery.addJoin(tableUserColJoin);
        selectQuery.addSelectColumn(Column.getColumn((String)ARCH_TABLE_COL_MAPPING_TABLE, (String)"*"));
        selectQuery.addSelectColumn(Column.getColumn((String)ARCH_TABLE_USER_COL_MAPPING_TABLE, (String)"*"));
        selectQuery.addSelectColumn(Column.getColumn((String)ARCH_SEARCH_FIELD_TABLE, (String)"FIELD_ID"));
        selectQuery.addSelectColumn(Column.getColumn((String)ARCH_SEARCH_FIELD_TABLE, (String)"FIELD_NAME"));
        selectQuery.addSelectColumn(Column.getColumn((String)ARCH_SEARCH_FIELD_TABLE, (String)"DISPLAY_NAME"));
        selectQuery.addSortColumn(new SortColumn(Column.getColumn((String)ARCH_TABLE_USER_COL_MAPPING_TABLE, (String)"PRIORITY_ID"), true));
        selectQuery.addSortColumn(new SortColumn(Column.getColumn((String)ARCH_TABLE_COL_MAPPING_TABLE, (String)"PRIORITY_ID"), true));
        DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)selectQuery);
        Iterator iterator = dataObject.getRows(ARCH_TABLE_COL_MAPPING_TABLE);
        while (iterator.hasNext()) {
            Row row = (Row)iterator.next();
            JSONObject jObj = new JSONObject();
            int fieldId = (Integer)row.get("FIELD_ID");
            String displayName = (String)row.get("DISPLAY_NAME");
            boolean isVisible = (Boolean)row.get("VISIBLE");
            jObj.put("isData", true);
            jObj.put("mandatory", row.get("MANDATORY"));
            jObj.put("searchenabled", row.get("SEARCH_ENABLED"));
            jObj.put("sortenabled", row.get("SORT_ENABLED"));
            jObj.put("colClass", row.get("CSS_CLASS"));
            jObj.put("column_conf_id", fieldId);
            Criteria fieldCrit = new Criteria(Column.getColumn((String)ARCH_SEARCH_FIELD_TABLE, (String)"FIELD_ID"), (Object)fieldId, 0);
            Row fieldRow = dataObject.getRow(ARCH_SEARCH_FIELD_TABLE, fieldCrit);
            if (fieldRow != null) {
                jObj.put("columnalias", fieldRow.get("FIELD_NAME"));
                if (displayName == null || displayName.isEmpty()) {
                    displayName = (String)fieldRow.get("DISPLAY_NAME");
                }
            }
            Criteria userFieldCrit = new Criteria(Column.getColumn((String)ARCH_TABLE_USER_COL_MAPPING_TABLE, (String)"FIELD_ID"), (Object)fieldId, 0);
            Row userFieldRow = dataObject.getRow(ARCH_TABLE_USER_COL_MAPPING_TABLE, userFieldCrit = userFieldCrit.and(new Criteria(Column.getColumn((String)ARCH_TABLE_USER_COL_MAPPING_TABLE, (String)"USER_ID"), (Object)userId, 0)));
            if (userFieldRow != null) {
                isVisible = (Boolean)userFieldRow.get("VISIBLE");
            }
            jObj.put("displayname", (Object)rb.getString(displayName));
            jObj.put("visible", isVisible);
            jColInfoList.put((Object)jObj);
            if (!isVisible) continue;
            jVisisbleColInfoList.put((Object)jObj);
        }
        jResult.put("colInfo", (Object)jColInfoList);
        jResult.put("visibleColInfo", (Object)jVisisbleColInfoList);
        return jResult;
    }

    private JSONArray fetchReportFacetCols(int facetGroupId) throws Exception {
        JSONArray jFacetInfoList = new JSONArray();
        Table facetFieldMappingTable = Table.getTable((String)ARCH_FACET_COL_MAPPING_TABLE);
        SelectQueryImpl selectQuery = new SelectQueryImpl(facetFieldMappingTable);
        Criteria crit = new Criteria(Column.getColumn((String)ARCH_FACET_COL_MAPPING_TABLE, (String)"FACET_GROUP_ID"), (Object)facetGroupId, 0);
        selectQuery.setCriteria(crit);
        Join tableFieldJoin = new Join(ARCH_FACET_COL_MAPPING_TABLE, ARCH_SEARCH_FIELD_TABLE, new String[]{"FIELD_ID"}, new String[]{"FIELD_ID"}, 2);
        selectQuery.addJoin(tableFieldJoin);
        selectQuery.addSelectColumn(Column.getColumn((String)ARCH_FACET_COL_MAPPING_TABLE, (String)"*"));
        selectQuery.addSelectColumn(Column.getColumn((String)ARCH_SEARCH_FIELD_TABLE, (String)"FIELD_ID"));
        selectQuery.addSelectColumn(Column.getColumn((String)ARCH_SEARCH_FIELD_TABLE, (String)"FIELD_NAME"));
        selectQuery.addSelectColumn(Column.getColumn((String)ARCH_SEARCH_FIELD_TABLE, (String)"DISPLAY_NAME"));
        selectQuery.addSortColumn(new SortColumn(Column.getColumn((String)ARCH_FACET_COL_MAPPING_TABLE, (String)"PRIORITY_ID"), true));
        DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)selectQuery);
        Iterator iterator = dataObject.getRows(ARCH_FACET_COL_MAPPING_TABLE);
        while (iterator.hasNext()) {
            Row row = (Row)iterator.next();
            JSONObject jObj = new JSONObject();
            int fieldId = (Integer)row.get("FIELD_ID");
            String displayName = (String)row.get("DISPLAY_NAME");
            Criteria fieldCrit = new Criteria(Column.getColumn((String)ARCH_SEARCH_FIELD_TABLE, (String)"FIELD_ID"), (Object)fieldId, 0);
            Row fieldRow = dataObject.getRow(ARCH_SEARCH_FIELD_TABLE, fieldCrit);
            jObj.put("facetColKey", fieldRow.get("FIELD_NAME"));
            if (displayName == null || displayName.isEmpty()) {
                jObj.put("facetColDisplayName", (Object)rb.getString((String)fieldRow.get("DISPLAY_NAME")));
            } else {
                jObj.put("facetColDisplayName", (Object)rb.getString(displayName));
            }
            jFacetInfoList.put((Object)jObj);
        }
        return jFacetInfoList;
    }
}

