/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.admin.archivesearch;

import com.adventnet.sym.adsm.common.server.admin.archivesearch.ArchLogCategoryHandler;
import com.adventnet.sym.adsm.common.server.admin.archivesearch.CaseInsensitiveWhitespaceAnalyzer;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.logging.Logger;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.facet.taxonomy.TaxonomyWriter;
import org.apache.lucene.facet.taxonomy.directory.DirectoryTaxonomyWriter;
import org.apache.lucene.facet.taxonomy.writercache.LruTaxonomyWriterCache;
import org.apache.lucene.facet.taxonomy.writercache.TaxonomyWriterCache;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;

public class LucIndexer {
    private ArchLogCategoryHandler categoryHandler;
    private IndexWriter indexWriter;
    private DirectoryTaxonomyWriter taxoWriter;
    private Directory dir;
    private static Logger logger = Logger.getLogger(LucIndexer.class.getName());

    public LucIndexer(ArchLogCategoryHandler categoryHandler) {
        this.categoryHandler = categoryHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IndexWriter getIndexWriter(boolean create) throws IOException {
        Class<LucIndexer> clazz = LucIndexer.class;
        synchronized (LucIndexer.class) {
            if (this.indexWriter == null || create) {
                this.dir = FSDirectory.open((Path)Paths.get(this.categoryHandler.getIndexDirPath(), new String[0]));
                IndexWriterConfig iwc = new IndexWriterConfig((Analyzer)new CaseInsensitiveWhitespaceAnalyzer());
                iwc.setOpenMode(create ? IndexWriterConfig.OpenMode.CREATE : IndexWriterConfig.OpenMode.CREATE_OR_APPEND);
                iwc.setRAMBufferSizeMB(10.0);
                this.indexWriter = new IndexWriter(this.dir, iwc);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return this.indexWriter;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DirectoryTaxonomyWriter getTaxoWriter() throws IOException {
        Class<LucIndexer> clazz = LucIndexer.class;
        synchronized (LucIndexer.class) {
            if (this.taxoWriter == null) {
                this.dir = FSDirectory.open((Path)Paths.get(this.categoryHandler.getIndexDirPath() + "_FACET", new String[0]));
                LruTaxonomyWriterCache cache = new LruTaxonomyWriterCache(1000);
                this.taxoWriter = new DirectoryTaxonomyWriter(this.dir, IndexWriterConfig.OpenMode.CREATE_OR_APPEND, (TaxonomyWriterCache)cache);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.taxoWriter;
        }
    }

    public void closeWriter() throws IOException {
        if (this.taxoWriter != null) {
            this.taxoWriter.close();
        }
        if (this.indexWriter != null) {
            this.indexWriter.close();
        }
    }

    public void commit() throws IOException {
        if (this.taxoWriter != null) {
            this.taxoWriter.commit();
        }
        if (this.indexWriter != null) {
            this.indexWriter.commit();
        }
    }

    public void deleteAllDocs() throws IOException {
        IndexWriter writer = this.getIndexWriter(false);
        if (writer != null) {
            writer.deleteAll();
            writer.commit();
        }
    }

    public void deleteDocs(Query query) throws IOException {
        IndexWriter writer = this.getIndexWriter(false);
        if (writer != null) {
            writer.deleteDocuments(new Query[]{query});
            writer.commit();
            writer.forceMergeDeletes();
            writer.commit();
        }
    }

    public void indexRecord(Document doc) throws IOException {
        IndexWriter writer = this.getIndexWriter(false);
        writer.addDocument((Iterable)doc);
    }

    public void indexFacetRecord(Document doc) throws IOException {
        IndexWriter writer = this.getIndexWriter(false);
        DirectoryTaxonomyWriter taxoWriter = this.getTaxoWriter();
        writer.addDocument((Iterable)this.categoryHandler.getFacetsConfig().build((TaxonomyWriter)taxoWriter, doc));
    }

    public void updateIndexedFacetRecord(String termField, String termValue, Document doc) throws IOException {
        IndexWriter writer = this.getIndexWriter(false);
        DirectoryTaxonomyWriter taxoWriter = this.getTaxoWriter();
        writer.updateDocument(new Term(termField, termValue), (Iterable)this.categoryHandler.getFacetsConfig().build((TaxonomyWriter)taxoWriter, doc));
    }

    public int getDocumentCount() throws IOException {
        int count = 0;
        IndexWriter writer = this.getIndexWriter(false);
        count = writer.numDocs();
        return count;
    }
}

