/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.admin.archivesearch;

import com.adventnet.sym.adsm.common.server.admin.archivesearch.ArchLogCategoryHandler;
import com.adventnet.sym.adsm.common.server.admin.archivesearch.CaseInsensitiveWhitespaceAnalyzer;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.facet.FacetResult;
import org.apache.lucene.facet.Facets;
import org.apache.lucene.facet.FacetsCollector;
import org.apache.lucene.facet.LabelAndValue;
import org.apache.lucene.facet.taxonomy.FastTaxonomyFacetCounts;
import org.apache.lucene.facet.taxonomy.TaxonomyReader;
import org.apache.lucene.facet.taxonomy.directory.DirectoryTaxonomyReader;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.LRUQueryCache;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryCache;
import org.apache.lucene.search.QueryCachingPolicy;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.SortedNumericSortField;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopFieldDocs;
import org.apache.lucene.search.UsageTrackingQueryCachingPolicy;
import org.apache.lucene.search.grouping.AbstractGroupFacetCollector;
import org.apache.lucene.search.grouping.GroupingSearch;
import org.apache.lucene.search.grouping.TopGroups;
import org.apache.lucene.search.grouping.term.TermGroupFacetCollector;
import org.apache.lucene.search.spell.Dictionary;
import org.apache.lucene.search.spell.LuceneDictionary;
import org.apache.lucene.search.suggest.Lookup;
import org.apache.lucene.search.suggest.analyzing.AnalyzingSuggester;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.util.BytesRef;
import org.json.JSONArray;
import org.json.JSONObject;

public class LucSearcher {
    private FSDirectory directory = null;
    private IndexReader indexReader = null;
    private IndexSearcher indexSearcher = null;
    private AnalyzingSuggester analyzingSuggester = null;
    private ArchLogCategoryHandler categoryHandler = null;
    private TaxonomyReader taxoReader = null;
    private final int maxNumberOfCachedQueries = 256;
    private final long maxRamBytesUsed = 0x1400000L;
    private static Logger logger = Logger.getLogger(LucSearcher.class.getName());

    public LucSearcher(ArchLogCategoryHandler categoryHandler) {
        this.categoryHandler = categoryHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IndexSearcher getIndexSearcher(boolean reOpen) throws Exception {
        Class<LucSearcher> clazz = LucSearcher.class;
        synchronized (LucSearcher.class) {
            if (this.indexSearcher == null || reOpen) {
                this.directory = FSDirectory.open((Path)Paths.get(this.categoryHandler.getIndexDirPath(), new String[0]));
                if (DirectoryReader.indexExists((Directory)this.directory)) {
                    this.indexReader = DirectoryReader.open((Directory)this.directory);
                    this.indexSearcher = new IndexSearcher(this.indexReader);
                    this.indexSearcher.setQueryCache((QueryCache)new LRUQueryCache(256, 0x1400000L));
                    this.indexSearcher.setQueryCachingPolicy((QueryCachingPolicy)new UsageTrackingQueryCachingPolicy());
                }
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return this.indexSearcher;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IndexReader getIndexReader(boolean reOpen) throws Exception {
        Class<LucSearcher> clazz = LucSearcher.class;
        synchronized (LucSearcher.class) {
            if (this.indexReader == null || reOpen) {
                this.directory = FSDirectory.open((Path)Paths.get(this.categoryHandler.getIndexDirPath(), new String[0]));
                if (DirectoryReader.indexExists((Directory)this.directory)) {
                    this.indexReader = DirectoryReader.open((Directory)this.directory);
                }
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return this.indexReader;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TaxonomyReader getTaxoReader(boolean reOpen) throws Exception {
        Class<LucSearcher> clazz = LucSearcher.class;
        synchronized (LucSearcher.class) {
            FSDirectory dir;
            if ((this.taxoReader == null || reOpen) && DirectoryReader.indexExists((Directory)(dir = FSDirectory.open((Path)Paths.get(this.categoryHandler.getIndexDirPath() + "_FACET", new String[0]))))) {
                this.taxoReader = new DirectoryTaxonomyReader((Directory)dir);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return this.taxoReader;
        }
    }

    public boolean containsDoc(Query query) throws Exception {
        IndexSearcher searcher = this.getIndexSearcher(true);
        boolean contains = false;
        TopDocs topDocs = searcher.search(query, 1);
        contains = topDocs.totalHits != 0;
        return contains;
    }

    public TopDocs queryRepo(Query query) throws Exception {
        IndexSearcher searcher = this.getIndexSearcher(true);
        TopDocs topDocs = null;
        logger.log(Level.INFO, "Archive Search Query : " + query);
        if (searcher != null) {
            topDocs = searcher.search(query, 1);
            logger.log(Level.INFO, "Results found : " + topDocs.totalHits);
        }
        return topDocs;
    }

    public TopDocs queryRepo(Query query, Sort sortBy, int resOffset, int resLimit) throws Exception {
        IndexSearcher searcher = this.getIndexSearcher(true);
        TopFieldDocs topDocs = null;
        logger.log(Level.INFO, "Archive Search Query : " + query);
        if (searcher != null) {
            topDocs = searcher.search(query, resOffset + resLimit, sortBy);
            logger.log(Level.INFO, "Results found : " + topDocs.totalHits);
        }
        return topDocs;
    }

    public JSONObject queryRepoByGrouping(Query query, int reportId, String groupBy, Sort sortBy, int groupOffset, int groupLimit, JSONArray jTableColList) throws Exception {
        IndexSearcher searcher = this.getIndexSearcher(true);
        JSONArray jsonArray = new JSONArray();
        JSONObject jsonResult = new JSONObject();
        TopGroups groups = null;
        logger.log(Level.INFO, "Query by group : " + query);
        GroupingSearch groupingSearch = new GroupingSearch(groupBy);
        groupingSearch.setGroupSort(sortBy);
        groupingSearch.setSortWithinGroup(sortBy);
        groupingSearch.setAllGroups(true);
        groupingSearch.setGroupDocsLimit(1);
        groups = groupingSearch.search(searcher, query, groupOffset, groupLimit);
        logger.log(Level.INFO, "Total hit count: " + groups.totalHitCount);
        logger.log(Level.INFO, "Total group : " + groups.totalGroupCount);
        logger.log(Level.INFO, "Total group len : " + groups.groups.length);
        for (int i = 0; i < groups.groups.length; ++i) {
            ScoreDoc[] hits = groups.groups[i].scoreDocs;
            for (int j = 0; j < hits.length; ++j) {
                Document doc = searcher.doc(hits[j].doc);
            }
        }
        jsonResult.put("outputRows", (Object)jsonArray);
        jsonResult.put("outputCount", (Object)groups.totalGroupCount);
        return jsonResult;
    }

    public JSONObject getMinMaxLongField(String field) throws Exception {
        IndexSearcher searcher = this.getIndexSearcher(true);
        JSONObject jsonResult = new JSONObject();
        Sort sortBy = null;
        TopFieldDocs topDocs = null;
        ScoreDoc[] hits = null;
        jsonResult.put("maxTime", -1);
        jsonResult.put("minTime", -1);
        if (searcher != null) {
            sortBy = new Sort();
            sortBy.setSort((SortField)new SortedNumericSortField(field, SortField.Type.LONG, true));
            topDocs = searcher.search((Query)new MatchAllDocsQuery(), 1, sortBy);
            if (topDocs != null && (hits = topDocs.scoreDocs).length > 0) {
                jsonResult.put("maxTime", (Object)searcher.doc(hits[0].doc).get(field));
            }
            sortBy = new Sort();
            sortBy.setSort((SortField)new SortedNumericSortField(field, SortField.Type.LONG, false));
            topDocs = searcher.search((Query)new MatchAllDocsQuery(), 1, sortBy);
            if (topDocs != null && (hits = topDocs.scoreDocs).length > 0) {
                jsonResult.put("minTime", (Object)searcher.doc(hits[0].doc).get(field));
            }
        }
        return jsonResult;
    }

    public Facets getFacets(Query query, int count) throws Exception {
        IndexSearcher searcher = this.getIndexSearcher(true);
        TaxonomyReader locTaxoReader = this.getTaxoReader(true);
        FastTaxonomyFacetCounts facets = null;
        if (searcher != null && locTaxoReader != null) {
            FacetsCollector fc = new FacetsCollector();
            FacetsCollector.search((IndexSearcher)searcher, (Query)query, (int)count, (Collector)fc);
            facets = new FastTaxonomyFacetCounts(locTaxoReader, this.categoryHandler.getFacetsConfig(), fc);
        }
        return facets;
    }

    public JSONArray getFacets(Query query, String[] facetByList, int count) throws Exception {
        JSONArray facetResult = new JSONArray();
        IndexSearcher searcher = this.getIndexSearcher(true);
        TaxonomyReader taxoReader = this.getTaxoReader(true);
        if (searcher != null && taxoReader != null) {
            FacetsCollector fc = new FacetsCollector();
            FacetsCollector.search((IndexSearcher)searcher, (Query)query, (int)count, (Collector)fc);
            FastTaxonomyFacetCounts facets = new FastTaxonomyFacetCounts(taxoReader, this.categoryHandler.getFacetsConfig(), fc);
            for (String facetBy : facetByList) {
                FacetResult facetRes = facets.getTopChildren(count, facetBy, new String[0]);
                JSONArray facetColResult = new JSONArray();
                if (facetRes != null) {
                    for (LabelAndValue labVal : facetRes.labelValues) {
                        JSONObject jsonObj = new JSONObject();
                        jsonObj.put("facetLabel", (Object)labVal.label);
                        jsonObj.put("facetCount", (Object)labVal.value);
                        facetColResult.put((Object)jsonObj);
                    }
                }
                facetResult.put((Object)facetColResult);
            }
        }
        return facetResult;
    }

    public JSONArray getFacetsByGrouping(Query query, String facetBy, String groupBy, int groupOffset, int groupLimit) throws Exception {
        JSONArray facetResult = new JSONArray();
        JSONObject jsonObj = new JSONObject();
        int facetMaxCount = 20;
        IndexSearcher searcher = this.getIndexSearcher(true);
        TaxonomyReader taxoReader = this.getTaxoReader(true);
        boolean facetFieldMultivalued = false;
        BytesRef facetPrefix = null;
        logger.log(Level.INFO, "Query" + query.toString());
        TermGroupFacetCollector groupedAirportFacetCollector = TermGroupFacetCollector.createTermGroupFacetCollector((String)groupBy, (String)facetBy, (boolean)facetFieldMultivalued, facetPrefix, (int)10);
        searcher.search(query, (Collector)groupedAirportFacetCollector);
        boolean orderFacetEntriesByCount = true;
        AbstractGroupFacetCollector.GroupedFacetResult airportResult = groupedAirportFacetCollector.mergeSegmentResults(groupOffset + groupLimit, 0, orderFacetEntriesByCount);
        logger.log(Level.INFO, "Total facet hit count" + airportResult.getTotalCount());
        logger.log(Level.INFO, "Total facet hit missing count" + airportResult.getTotalMissingCount());
        int facetCount = 0;
        List facetEntries = airportResult.getFacetEntries(groupOffset, groupLimit);
        for (AbstractGroupFacetCollector.FacetEntry facetEntry : facetEntries) {
            if (facetEntry.getCount() > 0) {
                jsonObj = new JSONObject();
                jsonObj.put("facetEntry", (Object)new String(facetEntry.getValue().bytes));
                jsonObj.put("facetCount", facetEntry.getCount());
                facetResult.put((Object)jsonObj);
                ++facetCount;
            }
            if (facetCount < facetMaxCount) continue;
            break;
        }
        return facetResult;
    }

    public JSONArray getSuggestions(String[] fields, String sugKey) throws Exception {
        JSONArray jArr = new JSONArray();
        int sugCount = 10;
        IndexReader reader = this.getIndexReader(true);
        if (fields != null && fields.length > 1) {
            sugCount = 3;
        }
        for (String field : fields) {
            LuceneDictionary dictionary = new LuceneDictionary(reader, field);
            this.analyzingSuggester = new AnalyzingSuggester((Analyzer)new CaseInsensitiveWhitespaceAnalyzer());
            this.analyzingSuggester.build((Dictionary)dictionary);
            List lookupResultList = this.analyzingSuggester.lookup((CharSequence)sugKey, false, sugCount);
            for (Lookup.LookupResult lookupResult : lookupResultList) {
                jArr.put((Object)lookupResult.key);
            }
        }
        return jArr;
    }
}

