/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.admin.authentication;

import com.adventnet.authentication.PAMException;
import com.adventnet.authentication.lm.ADAuthenticator;
import com.adventnet.authentication.util.AuthDBUtil;
import com.adventnet.authentication.util.AuthUtil;
import com.adventnet.persistence.DataAccessException;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.auditing.server.reports.ReportUtil;
import com.adventnet.sym.adsm.common.server.ADHandler;
import com.adventnet.sym.adsm.common.server.DomainHandler;
import com.adventnet.sym.adsm.common.server.admin.TechnicianHandler;
import com.adventnet.sym.adsm.common.server.admin.authentication.ADAPAuthObject;
import com.adventnet.sym.adsm.common.server.admin.delegation.TDConstants;
import com.adventnet.sym.adsm.common.server.admin.delegation.TDHandler;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Properties;
import java.util.logging.Level;
import javax.security.auth.login.LoginException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class ADAPADAuthenticator
extends ADAuthenticator {
    public static final String ADAP_AUTHENTICATION = "ADAuditPlus Authentication";
    public static AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle();

    public boolean authenticate() throws LoginException {
        boolean result = false;
        try {
            block24: {
                String domainName;
                block25: {
                    HttpSession session = this.request.getSession();
                    this.loginName = this.loginName.toLowerCase();
                    int backSlashindex = this.loginName.indexOf("\\");
                    int atIndex = this.loginName.indexOf("@");
                    domainName = this.request.getParameter("domainName");
                    Properties properties = new Properties();
                    if (backSlashindex != -1) {
                        domainName = this.loginName.substring(0, backSlashindex);
                        this.loginName = this.loginName.substring(backSlashindex + 1);
                        properties = DomainHandler.getUnAuthenticatedDomainDetails(domainName, "DOMAIN_FLAT_NAME");
                    } else if (atIndex != -1) {
                        domainName = this.loginName.substring(atIndex + 1);
                        this.loginName = this.loginName.substring(0, atIndex);
                        properties = DomainHandler.getUnAuthenticatedDomainDetails(domainName, "DOMAIN_DNS_NAME");
                    } else if (domainName != null && !domainName.equals(ADAP_AUTHENTICATION)) {
                        properties = DomainHandler.getUnAuthenticatedDomainDetails(domainName, "DOMAIN_FLAT_NAME");
                    }
                    String serverName = "";
                    if (properties.get("DOMAIN_CONTROLLER_LIST") != null) {
                        ArrayList dcList = (ArrayList)properties.get("DOMAIN_CONTROLLER_LIST");
                        serverName = (String)dcList.get(0);
                        for (int i = 0; i < dcList.size(); ++i) {
                        }
                    }
                    if ((domainName = properties.getProperty("DOMAIN_FLAT_NAME")) == null) {
                        domainName = ADAP_AUTHENTICATION;
                    }
                    if (domainName.equals(ADAP_AUTHENTICATION)) {
                        logger.log(Level.FINEST, "authenticate invoked with loginName and password");
                        try {
                            this.accountDO = AuthDBUtil.getAccountDO((String)this.loginName, (String)this.serviceName, (String)domainName);
                            ADAPADAuthenticator.isValidAccount(this.accountDO);
                            Row pwdRow = this.accountDO.getFirstRow("AaaPassword");
                            String pwdFrmDB = (String)pwdRow.get("PASSWORD");
                            String salt = (String)pwdRow.get("SALT");
                            String encPwd = AuthUtil.getEncryptedPassword((String)this.password, (String)salt);
                            result = pwdFrmDB.equals(encPwd);
                            Row loginRow = this.accountDO.getFirstRow("AaaLogin");
                            if (!result) {
                                TDHandler.addAuditEntries(ReportUtil.formMap(TDConstants.LOGIN_AUDIT_COLUMNS, new Object[]{(Long)loginRow.get("LOGIN_ID"), (Long)loginRow.get("USER_ID"), this.loginName, new Long(1L), "unknown", "unknown", 16, "Logon", System.currentTimeMillis(), domainName, rb.getString("adap.ADAPADAuthenticator.Invalid_loginNamepassword"), 1024, 16, new Long(1L), "-", "adap.ADAPUserAuditSeverities.audit_name.login_failed"}));
                                throw new LoginException("adap.ADAPADAuthenticator.Invalid_loginNamepassword");
                            }
                            break block24;
                        }
                        catch (DataAccessException dae) {
                            throw new PAMException(rb.getString("adap.ADAPADAuthenticator.DataAccessException_occured_while_fetching_account"), (Exception)((Object)dae));
                        }
                        catch (LoginException e) {
                            TDHandler.addAuditEntries(ReportUtil.formMap(TDConstants.LOGIN_AUDIT_COLUMNS, new Object[]{-1L, -1L, this.loginName, new Long(1L), "unknown", "unknown", 16, "Logon", System.currentTimeMillis(), domainName, rb.getString(e.getMessage()), 1024, 16, new Long(1L), "-", "adap.ADAPUserAuditSeverities.audit_name.login_failed"}));
                            throw new LoginException(rb.getString(e.getMessage()));
                        }
                    }
                    result = ADHandler.authenticateUser(properties, domainName, this.loginName, this.password, "false");
                    try {
                        if (!result) break block25;
                        ArrayList list = ADAPADAuthenticator.isValidDomainUser(this.loginName, this.serviceName, domainName);
                        if (list.size() > 0) {
                            this.accountDO = AuthDBUtil.getAccountDO((String)this.loginName, (String)this.serviceName, (String)domainName);
                            if (this.accountDO == null || !this.accountDO.containsTable("AaaAccount")) {
                                Hashtable prop = ADAPADAuthenticator.getHighPriorityRole(list);
                                Long roleId = (Long)prop.get("roleId");
                                TechnicianHandler.createUser(domainName, this.loginName, this.password, roleId, (String)prop.get("DELEGATED_DOMAIN"));
                                this.accountDO = AuthDBUtil.getAccountDO((String)this.loginName, (String)this.serviceName, (String)domainName);
                                DataObject dobj = CommonUtil.getPersistence(new boolean[0]).constructDataObject();
                                Row userRow = new Row("AUDTechUserMapping");
                                Row row = this.accountDO.getFirstRow("AaaUser");
                                userRow.set("UNIQUE_ID", (Object)((Long)prop.get("policyId")));
                                userRow.set("USER_ID", (Object)((Long)row.get("USER_ID")));
                                userRow.set("STATUS", (Object)"ACTIVE");
                                dobj.addRow(userRow);
                                dobj = CommonUtil.getPersistence(new boolean[0]).add(dobj);
                            }
                            break block25;
                        }
                        TDHandler.addAuditEntries(ReportUtil.formMap(TDConstants.LOGIN_AUDIT_COLUMNS, new Object[]{-1L, -1L, this.loginName, new Long(1L), "unknown", "unknown", 16, "Logon", System.currentTimeMillis(), domainName, rb.getString("adap.ADAPADAuthenticator.No_such_account_configured_for"), 1024, 16, new Long(1L), "-", "adap.ADAPUserAuditSeverities.audit_name.login_failed"}));
                        throw new LoginException(rb.getString("adap.ADAPADAuthenticator.No_such_account_configured_for"));
                    }
                    catch (DataAccessException dae) {
                        throw new PAMException(rb.getString("adap.ADAPADAuthenticator.DataAccessException_occured_while_fetching_account"), (Exception)((Object)dae));
                    }
                }
                if (result) {
                    logger.log(Level.FINE, "Authentication Result for User {0} is {1}", new Object[]{this.loginName, result});
                } else {
                    TDHandler.addAuditEntries(ReportUtil.formMap(TDConstants.LOGIN_AUDIT_COLUMNS, new Object[]{-1L, -1L, this.loginName, new Long(1L), "unknown", "unknown", 16, "Logon", System.currentTimeMillis(), domainName, rb.getString("adap.ADAPADAuthenticator.Invalid_loginNamepassword"), 1024, 16, new Long(1L), "-", "adap.ADAPUserAuditSeverities.audit_name.login_failed"}));
                    throw new LoginException(rb.getString("adap.ADAPADAuthenticator.Invalid_loginNamepassword"));
                }
            }
            ADAPADAuthenticator.setSessionAttributes(this.accountDO, this.request);
        }
        catch (LoginException loginException) {
            try {
                TDHandler.addAuditEntries(ReportUtil.formMap(TDConstants.LOGIN_AUDIT_COLUMNS, new Object[]{-1L, -1L, this.loginName, new Long(1L), "unknown", "unknown", 16, "Logon", System.currentTimeMillis(), this.domainName, rb.getString("adap.ADAPADAuthenticator.Invalid_loginNamepassword"), 1024, 16, new Long(1L), "-", "adap.ADAPUserAuditSeverities.audit_name.login_failed"}));
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            throw new LoginException(loginException.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public static boolean isValidAccount(DataObject accountDO) throws LoginException {
        try {
            if (accountDO == null) {
                throw new PAMException("adap.ADAPADAuthenticator.Account_DO_fetched_is_null");
            }
            if (!accountDO.containsTable("AaaAccount")) {
                throw new LoginException("adap.ADAPADAuthenticator.No_such_account_configured_for");
            }
            if (!accountDO.containsTable("AaaPassword")) {
                throw new LoginException("adap.ADAPADAuthenticator.No_password_configured_for_this");
            }
            if (!accountDO.containsTable("AaaUserStatus")) {
                throw new LoginException("adap.ADAPADAuthenticator.no_such_user_is_configured");
            }
            Row userStatusRow = accountDO.getRow("AaaUserStatus");
            String userStatus = (String)userStatusRow.get("STATUS");
            if ("DISABLED".equalsIgnoreCase(userStatus)) {
                throw new LoginException("adap.ADAPADAuthenticator.user_is_disabled_in_exchange_reporter_plus");
            }
            Row passwordRow = accountDO.getFirstRow("AaaPassword");
            String algorithm = (String)passwordRow.get("ALGORITHM");
            if (algorithm == null || !algorithm.equals("MD5")) {
                throw new PAMException("adap.ADAPADAuthenticator.Unknown_algorithm_only_MD5_is");
            }
        }
        catch (DataAccessException dae) {
            dae.printStackTrace();
        }
        return true;
    }

    public static void setSessionAttributes(DataObject accountDO, HttpServletRequest request) throws LoginException {
        try {
            HttpSession session = request.getSession();
            Row row = accountDO.getRow("AaaLogin");
            Long loginId = (Long)row.get("LOGIN_ID");
            session.setAttribute("ADAP_SESSION_LOGIN_ID", (Object)loginId);
            ADAPAuthObject authObject = new ADAPAuthObject(loginId);
            session.setAttribute("ADAP_AUTH_OBJ", (Object)authObject);
        }
        catch (Exception e) {
            throw new LoginException(e.getMessage());
        }
    }

    public static ArrayList isValidDomainUser(String loginName, String serviceName, String domainName) throws Exception {
        logger.log(Level.INFO, "Check the user is valid domain account");
        ArrayList idList = new ArrayList();
        DataObject accountDO = AuthDBUtil.getAccountDO((String)loginName, (String)serviceName, (String)domainName);
        Row userStatusRow = null;
        Row accountStatusRow = null;
        if (accountDO != null && !accountDO.isEmpty()) {
            userStatusRow = accountDO.getFirstRow("AaaUserStatus");
            accountStatusRow = accountDO.getFirstRow("AaaAccountStatus");
            String userStatus = (String)userStatusRow.get("STATUS");
            if ("DISABLED".equalsIgnoreCase(userStatus)) {
                throw new LoginException(rb.getString("admp.login.statmsg_user_disabled_in_admp"));
            }
            String accountStatus = (String)accountStatusRow.get("STATUS");
            if ("DEACTIVATED".equals(accountStatus)) {
                throw new LoginException(rb.getString("admp.login.statmsg_user_accnt_disabled_in_admp"));
            }
            if ("LOCKED".equals(accountStatus)) {
                throw new LoginException(rb.getString("admp.login.statmsg_user_accnt_locked_in_admp"));
            }
            idList.add(new Hashtable());
        } else {
            idList = TechnicianHandler.checkAndAddRequesterPrivileges(loginName, domainName, rb);
        }
        return idList;
    }

    private static Hashtable getHighPriorityRole(ArrayList list) throws Exception {
        if (list.size() == 1) {
            return (Hashtable)list.get(0);
        }
        Hashtable highPriorTable = (Hashtable)list.get(0);
        for (int i = 0; i < list.size(); ++i) {
            Hashtable temp = (Hashtable)list.get(i);
            Long roleId = (Long)temp.get("roleId");
            if (roleId != 1L) continue;
            highPriorTable = temp;
        }
        return highPriorTable;
    }
}

