/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.admin.authentication;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.SortColumn;
import com.adventnet.ds.query.Table;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.auditing.server.reports.ReportUtil;
import com.adventnet.sym.adsm.common.server.DomainHandler;
import com.adventnet.sym.adsm.common.server.admin.AdminHandler;
import com.adventnet.sym.adsm.common.server.admin.delegation.TDConstants;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.DBObjectUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;

public class ADAPAuthObject {
    private HashMap<Long, Integer> actionVsAccesses;
    private HashMap<String, ArrayList> userTabs;
    private ArrayList configuredDomainList;
    private String adminForward;
    private String configForward;
    public Hashtable adminDefaultRoute;
    public Hashtable configDefaultRoute;
    private Long defaultReportId;
    private boolean firstLogon = true;
    private HashMap<String, Object> loginUserDetails;

    public ADAPAuthObject(Long loginId) {
        this.init(loginId);
    }

    private void init(Long loginId) {
        this.setUserActions(loginId);
        this.adminForward = this.getFirstTileName(TDConstants.ADMIN_TAB_ID);
        this.configForward = this.getFirstTileName(TDConstants.CONFIG_TAB_ID);
        this.userTabs = this.getAAADetails();
        this.defaultReportId = this.setDefaultReport();
        this.loginUserDetails = this.setLoginUserDetails(loginId);
        this.adminDefaultRoute = this.getDefaultRouteDetails(TDConstants.ADMIN_TAB_ID);
        this.configDefaultRoute = this.getDefaultRouteDetails(TDConstants.CONFIG_TAB_ID);
        this.setConfiguredDomainList(loginId, false);
    }

    public void setFalseToFirstLogon() {
        this.firstLogon = false;
    }

    public boolean getFirstLogon() {
        return this.firstLogon;
    }

    public ArrayList<Long> getUserActins() {
        ArrayList<Long> userActions = new ArrayList<Long>();
        Set<Long> entries = this.actionVsAccesses.keySet();
        for (Long actionId : entries) {
            userActions.add(actionId);
        }
        return userActions;
    }

    public HashMap<String, ArrayList> getAaaDetails() {
        return this.userTabs;
    }

    public HashMap<String, Object> getFirstTabDetails() {
        ArrayList tabList = this.userTabs.get("AVAILABLE_TABS");
        return (HashMap)tabList.get(0);
    }

    public String getConfigTabFirstForward() {
        return this.configForward;
    }

    public String getAdminTabFirstForward() {
        return this.adminForward;
    }

    public Integer getAccessType(Long actionId) {
        return this.actionVsAccesses.get(actionId);
    }

    public void setUserActions(Long loginId) {
        this.actionVsAccesses = new HashMap();
        try {
            Criteria crit = new Criteria(Column.getColumn((String)"ADAPUserRoleMapping", (String)"LOGIN_ID"), (Object)loginId, 0);
            SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)"ADAPUserRoleMapping"));
            Join mapJoin = new Join(Table.getTable((String)"ADAPUserRoleMapping"), Table.getTable((String)"ADAPRoleActionMapping"), new String[]{"ROLE_ID"}, new String[]{"ROLE_ID"}, 2);
            query.addJoin(mapJoin);
            query.addSelectColumn(Column.getColumn((String)"ADAPUserRoleMapping", (String)"*"));
            query.addSelectColumn(Column.getColumn((String)"ADAPRoleActionMapping", (String)"*"));
            query.setCriteria(crit);
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)query);
            Iterator iterator = dataObject.getRows("ADAPRoleActionMapping");
            while (iterator.hasNext()) {
                Row row = (Row)iterator.next();
                this.actionVsAccesses.put((Long)row.get("ACTION_ID"), (Integer)row.get("ACCESS_TYPE"));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public HashMap<String, ArrayList> getAAADetails() {
        HashMap<String, ArrayList> aAAMap = new HashMap<String, ArrayList>();
        aAAMap.put("AVAILABLE_TABS", this.getAvailableTabs());
        return aAAMap;
    }

    public ArrayList<Map<String, Object>> getAvailableTabs() {
        ArrayList<Map<String, Object>> tabList = new ArrayList<Map<String, Object>>();
        ArrayList<Long> userActions = this.getUserActins();
        try {
            boolean isSATabAvailable = false;
            for (int i = 0; i < TDConstants.SERVER_AUDIT_ACTIONS.length; ++i) {
                if (!userActions.contains(TDConstants.SERVER_AUDIT_ACTIONS[i])) continue;
                isSATabAvailable = true;
            }
            boolean isReporTabNeeded = false;
            for (int i = 0; i < TDConstants.REPORT_TAB_ACTIONS.length; ++i) {
                if (!userActions.contains(TDConstants.REPORT_TAB_ACTIONS[i])) continue;
                isReporTabNeeded = true;
            }
            if (!isReporTabNeeded) {
                userActions.remove(TDConstants.REPORT_ACTION_ID);
            }
            boolean isComplianceUrl = false;
            if (userActions.contains(TDConstants.AGGREGATE_REPORTS) && !userActions.contains(TDConstants.HOME_TAB_ID)) {
                userActions.add(TDConstants.HOME_TAB_ID);
                isComplianceUrl = true;
            }
            if (userActions.contains(TDConstants.PROFILE_BASED_REPORTS) && !userActions.contains(TDConstants.REPORT_ACTION_ID)) {
                userActions.add(TDConstants.REPORT_ACTION_ID);
                this.actionVsAccesses.put(TDConstants.REPORT_ACTION_ID, 32);
            }
            if (userActions.contains(TDConstants.PROFILE_BASED_REPORTS) && !userActions.contains(TDConstants.SERVER_AUDIT_TAB_ID)) {
                userActions.add(TDConstants.SERVER_AUDIT_TAB_ID);
                this.actionVsAccesses.put(TDConstants.SERVER_AUDIT_TAB_ID, 32);
            }
            if (userActions.contains(TDConstants.PROFILE_BASED_REPORTS) && !userActions.contains(TDConstants.FILE_AUDIT_TAB_ID)) {
                userActions.add(TDConstants.FILE_AUDIT_TAB_ID);
                this.actionVsAccesses.put(TDConstants.FILE_AUDIT_TAB_ID, 32);
            }
            if (userActions.contains(DBObjectUtil.getUVHValues("ADAPUserRoleActions", "ADAPUserRoleActions:action_id:3157"))) {
                userActions.add(DBObjectUtil.getUVHValues("ADAPUserRoleActions", "ADAPUserRoleActions:action_id:3024"));
                this.actionVsAccesses.put(DBObjectUtil.getUVHValues("ADAPUserRoleActions", "ADAPUserRoleActions:action_id:3024"), this.actionVsAccesses.get(DBObjectUtil.getUVHValues("ADAPUserRoleActions", "ADAPUserRoleActions:action_id:3157")));
            }
            Criteria crit = new Criteria(Column.getColumn((String)"ADAPTotalTabs", (String)"ACTION_ID"), (Object)userActions.toArray(), 8);
            if (isSATabAvailable) {
                crit = crit.or(new Criteria(Column.getColumn((String)"ADAPTotalTabs", (String)"ACTION_ID"), (Object)TDConstants.SERVER_AUDIT_TAB_ID, 0));
            }
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get("ADAPTotalTabs", crit);
            TreeMap hashMap = new TreeMap();
            Iterator it = dataObject.getRows("ADAPTotalTabs");
            while (it.hasNext()) {
                Long tabId;
                Row tabRow = (Row)it.next();
                HashMap<String, Object> tabDetails = new HashMap<String, Object>();
                tabDetails.put("TAB_NAME", tabRow.get("TAB_NAME"));
                tabDetails.put("TAB_DISPLAY_NAME", (String)tabRow.get("TAB_DISPLAY_NAME"));
                tabDetails.put("TAB_URL", tabRow.get("TAB_URL"));
                if (TDConstants.HOME_TAB_ID.longValue() == ((Long)tabRow.get("ACTION_ID")).longValue() && isComplianceUrl) {
                    tabDetails.put("TAB_URL", "ComplianceHome.do?selectedTab=home");
                }
                if (Long.valueOf(tabId = (Long)tabRow.get("TAB_ID")) == Long.valueOf(TDConstants.CONFIG_TAB_ID)) {
                    tabDetails.put("TAB_URL", this.configForward);
                } else if (Long.valueOf(tabId) == Long.valueOf(TDConstants.ADMIN_TAB_ID)) {
                    tabDetails.put("TAB_URL", this.adminForward);
                }
                tabDetails.put("ACTION_ID", (Long)tabRow.get("ACTION_ID"));
                Integer priorityId = (Integer)tabRow.get("PRIORITY_ID");
                hashMap.put(priorityId, tabDetails);
            }
            for (Map.Entry entry : hashMap.entrySet()) {
                tabList.add((Map)entry.getValue());
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return tabList;
    }

    private String getFirstTileName(Long tabId) {
        String forward = null;
        try {
            Criteria crit = new Criteria(Column.getColumn((String)"AUDLeftTreeComponents", (String)"TAB_ID"), (Object)tabId, 0);
            crit = crit.and(new Criteria(Column.getColumn((String)"AUDLeftTreeComponents", (String)"ACTION_ID"), (Object)this.getUserActins().toArray(), 8));
            crit = crit.and(new Criteria(Column.getColumn((String)"AUDLeftTreeComponents", (String)"TILE_URL"), (Object)"", 1));
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get("AUDLeftTreeComponents", crit);
            if (!dataObject.isEmpty()) {
                Row row = dataObject.getFirstRow("AUDLeftTreeComponents");
                forward = AdminHandler.categoryIdReplaceInURL((String)row.get("TILE_URL"));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return forward;
    }

    public Long setDefaultReport() {
        Long reportId = DBObjectUtil.getDefaultReport();
        try {
            Row row;
            Criteria crit = new Criteria(Column.getColumn((String)"AUDReports", (String)"ACTION_ID"), (Object)this.getUserActins().toArray(), 8);
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get("AUDReports", crit);
            if (dataObject.isEmpty()) {
                crit = new Criteria(Column.getColumn((String)"AUDReportCategories", (String)"ACTION_ID"), (Object)this.getUserActins().toArray(), 8);
                crit = crit.and(new Criteria(Column.getColumn((String)"AUDReportCategories", (String)"REPORT_CATEGORY_ID"), (Object)1L, 0));
                dataObject = CommonUtil.getPersistence(new boolean[0]).get("AUDReportCategories", crit);
                if (!dataObject.isEmpty()) {
                    crit = new Criteria(Column.getColumn((String)"AUDReports", (String)"REPORT_CATEGORY_ID"), (Object)1L, 0);
                    dataObject = CommonUtil.getPersistence(new boolean[0]).get("AUDReports", crit);
                }
            }
            if ((row = dataObject.getRow("AUDReports", new Criteria(Column.getColumn((String)"AUDReports", (String)"AUDIT_REPORT_ID"), (Object)reportId, 0))) == null && !dataObject.isEmpty()) {
                row = dataObject.getFirstRow("AUDReports");
            }
            reportId = row != null ? (Long)row.get("AUDIT_REPORT_ID") : reportId;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return reportId;
    }

    public Long getDefaultReport() {
        return this.defaultReportId;
    }

    private Hashtable getDefaultRouteDetails(Long tabId) {
        Hashtable<String, String> forward = new Hashtable<String, String>();
        try {
            SelectQueryImpl sq = new SelectQueryImpl(new Table("AUDLeftTreeComponents"));
            Criteria crit = new Criteria(Column.getColumn((String)"AUDLeftTreeComponents", (String)"TAB_ID"), (Object)tabId, 0);
            crit = crit.and(new Criteria(Column.getColumn((String)"AUDLeftTreeComponents", (String)"ACTION_ID"), (Object)this.getUserActins().toArray(), 8));
            crit = crit.and(new Criteria(Column.getColumn((String)"AUDLeftTreeComponents", (String)"TILE_ROUTE_NAME"), (Object)"", 1));
            crit = tabId == 4L ? crit.and(new Criteria(Column.getColumn((String)"AUDLeftTreeComponents", (String)"TILE_ROUTE_NAME"), (Object)"config", 10)) : crit.and(new Criteria(Column.getColumn((String)"AUDLeftTreeComponents", (String)"TILE_ROUTE_NAME"), (Object)"admin", 10));
            sq.setCriteria(crit);
            ArrayList<Column> colList = new ArrayList<Column>();
            colList.add(Column.getColumn((String)"AUDLeftTreeComponents", (String)"*"));
            sq.addSelectColumns(colList);
            SortColumn sortColumn = new SortColumn("AUDLeftTreeComponents", "TILE_ID", true);
            sq.addSortColumn(sortColumn);
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)sq);
            if (!dataObject.isEmpty()) {
                Row row = dataObject.getFirstRow("AUDLeftTreeComponents");
                String routeName = (String)row.get("TILE_ROUTE_NAME");
                String modelId = AdminHandler.categoryIdReplaceInURL((String)row.get("TILE_MODEL_ID"));
                forward.put("routeName", routeName);
                forward.put("modelId", modelId);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return forward;
    }

    private HashMap<String, Object> setLoginUserDetails(Long loginId) {
        HashMap<String, Object> detailsMap = new HashMap<String, Object>();
        try {
            DataObject dObj = CommonUtil.getPersistence(new boolean[0]).get("ADAPUserRoleMapping", new Criteria(Column.getColumn((String)"ADAPUserRoleMapping", (String)"LOGIN_ID"), (Object)loginId, 0));
            Row row = dObj.getFirstRow("ADAPUserRoleMapping");
            detailsMap = ReportUtil.formMap(new String[]{"ROLE_ID", "DELEGATED_DOMAIN", "COMMON_NAME", "DISPLAY_NAME", "EMAIL_ADDRESS", "IS_AUDIT_ENABLED", "LOCALE_ID"}, new Object[]{row.get("ROLE_ID"), row.get("DELEGATED_DOMAIN"), row.get("COMMON_NAME"), row.get("DISPLAY_NAME"), row.get("EMAIL_ADDRESS"), row.get("IS_AUDIT_ENABLED"), row.get("LOCALE_ID")});
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return detailsMap;
    }

    public HashMap<String, Object> getLoginUserDetails() {
        return this.loginUserDetails;
    }

    public void setConfiguredDomainList(Long loginId, boolean isFullConfigList) {
        ArrayList domainDetailsList = new ArrayList();
        try {
            HashMap<String, Object> loginUserDetails = this.getLoginUserDetails();
            String delegatedDomain = (String)loginUserDetails.get("DELEGATED_DOMAIN");
            if (!isFullConfigList) {
                AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle();
                this.configuredDomainList = delegatedDomain.equals("All Domains") || delegatedDomain.equals(rb.getString("adap.common.text.All_Domains")) || delegatedDomain.equals("adap.common.text.All_Domains") ? DomainHandler.getConfiguredList(loginId, true) : DomainHandler.getConfiguredList(loginId, true, (String)loginUserDetails.get("DELEGATED_DOMAIN"));
            } else {
                this.configuredDomainList = DomainHandler.getFullConfiguredList(loginId, true, delegatedDomain);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public ArrayList getConfiguredDomainList() {
        return this.configuredDomainList;
    }

    public ArrayList<String> getDomainsList() {
        ArrayList<String> domainsList = new ArrayList<String>();
        try {
            for (int size = 0; size < this.configuredDomainList.size(); ++size) {
                Properties prop = (Properties)this.configuredDomainList.get(size);
                domainsList.add((String)prop.get("DOMAIN_NAME"));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return domainsList;
    }

    private void setLocale(Long loginId) {
    }

    public HashMap<Long, Integer> getAccesses() {
        return this.actionVsAccesses;
    }
}

