/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.admin.authentication;

import com.adventnet.authentication.util.AuthDBUtil;
import com.adventnet.persistence.DataObject;
import com.adventnet.sym.adsm.common.server.DomainHandler;
import com.adventnet.sym.adsm.common.server.admin.authentication.ADAPADAuthenticator;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.util.ADSMPersUtil;
import com.manageengine.ads.fw.sso.CustomSSOAuthenticator;
import com.manageengine.ads.fw.sso.cookie.Ticket;
import java.util.Properties;
import java.util.logging.Logger;
import javax.security.auth.login.LoginException;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.json.JSONObject;

public class ADAPCustomSSOAuthenticator
implements CustomSSOAuthenticator {
    private static Logger out = Logger.getLogger("ADSLogger");
    private Ticket ticketObj = null;
    private DataObject accountDO = null;
    private String domainFlatName = null;

    public void init(Ticket ticketObj) {
        try {
            String domainName;
            String string = domainName = !ticketObj.isDomainAuthentication ? "ADAuditPlus Authentication" : ticketObj.domainName;
            if (!ticketObj.isDomainAuthentication) {
                this.accountDO = AuthDBUtil.getAccountDO((String)ticketObj.loginName, (String)ticketObj.serviceName, (String)domainName);
            }
            this.ticketObj = ticketObj;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean isValidAccount() throws LoginException {
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle();
        try {
            if (this.ticketObj.isDomainAuthentication) {
                String domainName = this.ticketObj.domainName;
                JSONObject domainDetails = DomainHandler.getDomainDetails(domainName);
                if (domainDetails == null || domainDetails.length() == 0) {
                    throw new LoginException(rb.getString("adap.login.common.error.invalid_domain"));
                }
                this.domainFlatName = domainDetails.getString("DOMAIN_FLAT_NAME");
                this.accountDO = AuthDBUtil.getAccountDO((String)this.ticketObj.loginName, (String)this.ticketObj.serviceName, (String)this.domainFlatName);
            }
            return ADAPADAuthenticator.isValidAccount(this.accountDO);
        }
        catch (Exception e) {
            if (e.getMessage() == null) {
                throw new LoginException(rb.getString("adap.login.common.error.invalid_domain"));
            }
            throw new LoginException(rb.getString(e.getMessage()));
        }
    }

    public boolean authenticate() {
        try {
            return this.ticketObj.isValidTicket;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public void setSessionAttributes(HttpServletRequest request) {
        try {
            ADAPADAuthenticator.setSessionAttributes(this.accountDO, request);
            ServletContext context = request.getSession().getServletContext();
            String selectedTheme = ADSMPersUtil.getSyMParameter("THEME");
            context.setAttribute("selectedTheme", (Object)selectedTheme);
            HttpSession session = request.getSession();
            session.setAttribute("isLogin", (Object)"true");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public DataObject getDataObject() {
        return this.accountDO;
    }

    public void init(Properties ntlmProperties) {
    }

    public boolean ntlmAuthenticate() throws LoginException {
        return false;
    }
}

