/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.admin.authentication;

import com.adventnet.authentication.Credential;
import com.adventnet.sym.adsm.common.server.DomainHandler;
import com.manageengine.ads.fw.sso.cookie.Ticket;
import com.manageengine.ads.fw.sso.cookie.TicketGenerator;
import com.manageengine.ads.fw.util.CommonUtil;
import java.util.Collection;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import org.json.JSONArray;

public class SSOTicketGenerator
extends TicketGenerator {
    public synchronized Ticket generateTicket(HttpServletRequest request, Credential cred) {
        Long time = System.currentTimeMillis();
        String ticketId = time.toString();
        Ticket ticketObj = new Ticket();
        try {
            String appName = CommonUtil.getProductName();
            String appDN = CommonUtil.getApplicationDomainName();
            ticketObj.userId = cred.getUserId();
            ticketObj.loginId = cred.getLoginId();
            ticketObj.loginName = cred.getLoginName();
            ticketObj.roles = new JSONArray((Collection)cred.getRoles());
            if (cred.getDomainName() != null && !cred.getDomainName().equals(CommonUtil.getApplicationDomainName())) {
                Properties domainDetails = DomainHandler.getUnAuthenticatedDomainDetails(cred.getDomainName(), "DOMAIN_FLAT_NAME");
                ticketObj.domainName = domainDetails.getProperty("DOMAIN_NAME");
            } else {
                ticketObj.domainName = cred.getDomainName();
            }
            ticketObj.localeId = cred.getLocaleId();
            ticketObj.localeLanguage = cred.getUserLocale().getLanguage();
            ticketObj.localeCountry = cred.getUserLocale().getCountry();
            ticketObj.ticket = ticketId;
            ticketObj.applicationName = appName;
            ticketObj.hostName = cred.getHostName();
            ticketObj.ipAddress = request.getRemoteAddr();
            ticketObj.serviceName = cred.getServiceName();
            ticketObj.isValidTicket = true;
            if (ticketObj.domainName.equals("") || ticketObj.domainName.equals(appDN)) {
                ticketObj.isDomainAuthentication = false;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ticketObj;
    }
}

