/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.admin.delegation;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.SortColumn;
import com.adventnet.ds.query.Table;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.admin.delegation.TDUtil;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import org.json.JSONObject;

public class ADAPUserActionsHandler {
    private static Logger logger = Logger.getLogger("QueryLogger");

    public static ArrayList getActionDetails(HttpServletRequest request) {
        ArrayList<Object> actionList = new ArrayList();
        try {
            SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)"ADAPUserRoleActions"));
            ArrayList<SortColumn> list = new ArrayList<SortColumn>();
            list.add(new SortColumn(Column.getColumn((String)"ADAPUserRoleActions", (String)"ACTION_ID"), true));
            list.add(new SortColumn(Column.getColumn((String)"ADAPUserRoleActions", (String)"PRIORITY_ID"), true));
            query.addSortColumns(list);
            query.addSelectColumn(Column.getColumn((String)"ADAPUserRoleActions", (String)"*"));
            DataObject dObj = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)query);
            Criteria crit = new Criteria(Column.getColumn((String)"ADAPUserRoleActions", (String)"PARENT_ID"), (Object)0L, 0);
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
            actionList = ADAPUserActionsHandler.getActionDetails(dObj, crit, rb);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return actionList;
    }

    public static ArrayList<Hashtable> getActionDetails(DataObject dObj, Criteria crit, AdventNetResourceBundle rb) {
        ArrayList<Hashtable> actionDetailsList = new ArrayList<Hashtable>();
        try {
            Iterator it = dObj.getRows("ADAPUserRoleActions", crit);
            while (it.hasNext()) {
                Hashtable<String, Object> actionDetails = new Hashtable<String, Object>();
                Row r = (Row)it.next();
                Long actionId = (Long)r.get("ACTION_ID");
                actionDetails.put("ACTION_NAME", rb.getString((String)r.get("ACTION_NAME")));
                actionDetails.put("ACTION_NAME_KEY", (String)r.get("ACTION_NAME"));
                actionDetails.put("ACTION_ID", actionId);
                Criteria childCrit = new Criteria(Column.getColumn((String)"ADAPUserRoleActions", (String)"PARENT_ID"), (Object)actionId, 0);
                ArrayList<Hashtable> childActionsList = ADAPUserActionsHandler.getActionDetails(dObj, childCrit, rb);
                if (childActionsList.size() > 0) {
                    actionDetails.put("CHILD_LIST", childActionsList);
                }
                actionDetailsList.add(actionDetails);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return actionDetailsList;
    }

    public static JSONObject getRoleDetails(Long roleId) throws Exception {
        DataObject dObj = TDUtil.getRoleDetailsDO(roleId);
        JSONObject roleDetails = new JSONObject();
        Row row = dObj.getFirstRow("ADAPUserRoles");
        roleDetails.put("NAME", (Object)((String)row.get("NAME")));
        roleDetails.put("DESCRIPTION", (Object)((String)row.get("DESCRIPTION")));
        roleDetails.put("selectedActions", (Object)ADAPUserActionsHandler.getRoleActions(dObj));
        return roleDetails;
    }

    public static String getRoleActions(DataObject dObj) throws Exception {
        String selectedActions = "";
        Iterator it = dObj.getRows("ADAPRoleActionMapping");
        while (it.hasNext()) {
            Row row = (Row)it.next();
            selectedActions = selectedActions != "" ? selectedActions + "," + String.valueOf((Long)row.get("ACTION_ID")) + "::" + String.valueOf((Integer)row.get("ACCESS_TYPE")) : String.valueOf((Long)row.get("ACTION_ID")) + "::" + String.valueOf((Integer)row.get("ACCESS_TYPE"));
        }
        return selectedActions;
    }
}

