/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.admin.delegation;

import com.adventnet.authentication.Credential;
import com.adventnet.ds.query.Criteria;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.auditing.server.DNSResolver;
import com.adventnet.sym.adsm.auditing.server.reports.ReportUtil;
import com.adventnet.sym.adsm.common.server.DomainDetailsAPI;
import com.adventnet.sym.adsm.common.server.objects.DirectoryObjectAPI;
import com.adventnet.sym.adsm.common.server.sql.FileWriterObject;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TDHandler
extends Thread {
    private static Logger logger = Logger.getLogger("QueryLogger");
    private static ArrayList<Row> auditDetailsList = new ArrayList();
    private static HashMap<Long, HashMap> loginIdVsDomain = new HashMap();
    private static Hashtable<Long, String> roleDetails = null;
    private static Hashtable<Long, HashMap> userRoleDetails = null;
    private static Hashtable<String, Integer> severityDetails = null;
    private static final DNSResolver DNS_RESOLVER = DNSResolver.getInstance();
    private static volatile TDHandler tdHandler = null;

    private TDHandler() {
        TDHandler.getUserIDvsDomainName();
        TDHandler.getRoleDetails();
        TDHandler.getUserRoleMappingDetails();
        TDHandler.setSeverityDetails();
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static TDHandler getInstance() {
        if (tdHandler != null) return tdHandler;
        Class<TDHandler> clazz = TDHandler.class;
        synchronized (TDHandler.class) {
            if (tdHandler != null) return tdHandler;
            tdHandler = new TDHandler();
            // ** MonitorExit[var0] (shouldn't be in output)
            return tdHandler;
        }
    }

    public static void addAuditEntries(HashMap auditingDetailsMap) {
        try {
            Row auditDetails = new Row("ADAPUserAuditInfo");
            if (auditingDetailsMap.get("CREDENTIAL") != null) {
                Credential credential = (Credential)auditingDetailsMap.remove("CREDENTIAL");
                HashMap loginUserDetails = TDHandler.getLoginDetails(credential.getUserId());
                auditDetails = ReportUtil.formRow(auditDetails, new String[]{"LOGIN_ID", "USER_ID", "LOGIN_NAME", "SESSION_ID", "CLIENT_IP_ADDRESS", "CLIENT_HOST_NAME", "ACCOUNT_ID", "DOMAIN_NAME"}, new Object[]{credential.getLoginId(), credential.getUserId(), credential.getLoginName(), credential.getSessionId(), credential.getHostName(), TDHandler.getHostName(credential.getHostName()), credential.getAccountId(), loginUserDetails.get("LOGIN_DOMAIN_NAME")});
            }
            Set strValue = auditingDetailsMap.keySet();
            for (String keyName : strValue) {
                auditDetails.set(keyName, auditingDetailsMap.get(keyName));
            }
            String addnInfo = (String)auditingDetailsMap.get("ADDITIONAL_INFO");
            auditDetails = ReportUtil.formRow(auditDetails, new String[]{"TIME_GENERATED", "ADDITIONAL_INFO", "SEVERITY"}, new Object[]{System.currentTimeMillis() / 1000L, addnInfo != null ? addnInfo : "-", TDHandler.getSeverity((String)auditDetails.get("SEVERITY"))});
            auditDetailsList.add(auditDetails);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void addToDB() {
        try {
            FileWriterObject.getInstance().dumpRows("ADAPUserAuditInfo", auditDetailsList);
            TDHandler.freeDetailsList();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private static void freeDetailsList() {
        auditDetailsList = new ArrayList();
    }

    private static void getUserIDvsDomainName() {
        try {
            DataObject dObj = CommonUtil.getPersistence(new boolean[0]).get("AaaLogin", (Criteria)null);
            Iterator iterator = dObj.getRows("AaaLogin");
            while (iterator.hasNext()) {
                Row row = (Row)iterator.next();
                HashMap<String, String> loginUserDetails = new HashMap<String, String>();
                loginUserDetails.put("LOGIN_USER_NAME", (String)row.get("NAME"));
                loginUserDetails.put("LOGIN_DOMAIN_NAME", (String)row.get("DOMAINNAME"));
                loginIdVsDomain.put((Long)row.get("USER_ID"), loginUserDetails);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static HashMap getLoginDetails(Long loginId) {
        if (loginIdVsDomain.get(loginId) == null) {
            TDHandler.getUserIDvsDomainName();
        }
        return loginIdVsDomain.get(loginId);
    }

    private static void getRoleDetails() {
        roleDetails = new Hashtable();
        try {
            DataObject dObj = CommonUtil.getPersistence(new boolean[0]).get("ADAPUserRoles", (Criteria)null);
            Iterator iterator = dObj.getRows("ADAPUserRoles");
            while (iterator.hasNext()) {
                Row row = (Row)iterator.next();
                roleDetails.put((Long)row.get("ROLE_ID"), (String)row.get("NAME"));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static String getRoleName(Long roleId) {
        if (roleDetails.get(roleId) == null) {
            TDHandler.getRoleDetails();
        }
        return roleDetails.get(roleId);
    }

    public static String getUserName(Long userId, String objectClass) throws Exception {
        String name = null;
        if (objectClass.equals("user")) {
            Row row = ReportUtil.getFirstRow("AaaUser", "USER_ID", userId, 0);
            name = (String)row.get("FIRST_NAME");
        } else {
            Row row = ReportUtil.getFirstRow("AUDTechnicianTopLevelConfig", "UNIQUE_ID", userId, 0);
            if (row != null) {
                Row objectRow = DirectoryObjectAPI.getInstance().getObjectRow(DomainDetailsAPI.getDomainName((String)row.get("DOMAIN_NAME")), (String)row.get("OBJECT_GUID"), "OBJECT_GUID", objectClass);
                name = (String)objectRow.get("NAME");
            }
        }
        return name;
    }

    public static String getDomainName(Long userId, String objectClass) throws Exception {
        String name = null;
        if (objectClass.equals("user")) {
            Row row = ReportUtil.getFirstRow("AaaLogin", "USER_ID", userId, 0);
            name = (String)row.get("DOMAINNAME");
        } else {
            Row row = ReportUtil.getFirstRow("AUDTechnicianTopLevelConfig", "UNIQUE_ID", userId, 0);
            name = row != null ? (String)row.get("DOMAIN_NAME") : "";
        }
        return name;
    }

    private static String getHostName(String hostIP) {
        String hostName = hostIP;
        if (hostIP.indexOf("0:0:0:1") != -1 || hostIP.equals("127.0.0.1")) {
            hostName = "ADAudit Plus Server";
        } else {
            try {
                ArrayList<String> hostDetails = DNS_RESOLVER.getHostName(hostIP);
                hostName = hostDetails.get(0);
            }
            catch (Exception ex) {
                logger.log(Level.FINE, "Can't resolve the host " + hostIP);
            }
        }
        return hostName;
    }

    public static String getLocalMachineName() {
        String local = "127.0.0.1";
        try {
            InetAddress localMachine = InetAddress.getLocalHost();
            local = localMachine.getHostName();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return local;
    }

    private static void getUserRoleMappingDetails() {
        userRoleDetails = new Hashtable();
        try {
            DataObject dObj = CommonUtil.getPersistence(new boolean[0]).get("ADAPUserRoleMapping", (Criteria)null);
            Iterator iterator = dObj.getRows("ADAPUserRoleMapping");
            while (iterator.hasNext()) {
                Row row = (Row)iterator.next();
                HashMap<String, Object> detailsMap = ReportUtil.formMap(new String[]{"ROLE_ID", "DELEGATED_DOMAIN", "COMMON_NAME", "DISPLAY_NAME", "EMAIL_ADDRESS", "IS_AUDIT_ENABLED", "LOCALE_ID"}, new Object[]{row.get("ROLE_ID"), row.get("DELEGATED_DOMAIN"), row.get("COMMON_NAME"), row.get("DISPLAY_NAME"), row.get("EMAIL_ADDRESS"), row.get("IS_AUDIT_ENABLED"), row.get("LOCALE_ID")});
                userRoleDetails.put((Long)row.get("LOGIN_ID"), detailsMap);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private static void setSeverityDetails() {
        try {
            severityDetails = new Hashtable();
            DataObject dObj = CommonUtil.getPersistence(new boolean[0]).get("ADAPUserAuditSeverities", (Criteria)null);
            Iterator iterator = dObj.getRows("ADAPUserAuditSeverities");
            while (iterator.hasNext()) {
                Row row = (Row)iterator.next();
                severityDetails.put((String)row.get("AUDIT_NAME"), (Integer)row.get("SEVERITY"));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static int getSeverity(String auditName) {
        if (severityDetails == null) {
            TDHandler.setSeverityDetails();
        }
        int severity = severityDetails != null && severityDetails.get(auditName) != null ? severityDetails.get(auditName) : 1;
        return severity;
    }

    @Override
    public void run() {
        try {
            while (Boolean.TRUE.booleanValue()) {
                this.process();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void process() {
        block7: {
            try {
                if (auditDetailsList.size() >= 10) {
                    TDHandler.addToDB();
                    break block7;
                }
                try {
                    Thread.sleep(60000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                if (auditDetailsList.size() > 0) {
                    TDHandler.addToDB();
                } else {
                    logger.log(Level.FINE, "No operation occurred.");
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }
}

