/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.admin.delegation;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.SortColumn;
import com.adventnet.ds.query.Table;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.auditing.server.reports.ReportUtil;
import com.adventnet.sym.adsm.common.server.DomainDetailsAPI;
import com.adventnet.sym.adsm.common.server.admin.TechnicianHandler;
import com.adventnet.sym.adsm.common.server.admin.delegation.TDConstants;
import com.adventnet.sym.adsm.common.server.admin.delegation.TDHandler;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.objects.DirectoryObjectAPI;
import com.adventnet.sym.adsm.common.server.objects.GroupHandler;
import com.adventnet.sym.adsm.common.server.objects.OUHandler;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TDUtil {
    private static Logger logger = Logger.getLogger("QueryLogger");

    public static ArrayList<HashMap> getTDRolesDetails(AdventNetResourceBundle rb, String searchStr) throws Exception {
        ArrayList<HashMap> rolesList = new ArrayList<HashMap>();
        SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)"ADAPUserRoles"));
        Join mapJoin = new Join(Table.getTable((String)"ADAPUserRoles"), Table.getTable((String)"ADAPUserRoleMapping"), new String[]{"ROLE_ID"}, new String[]{"ROLE_ID"}, 1);
        Join loginJoin = new Join(Table.getTable((String)"ADAPUserRoleMapping"), Table.getTable((String)"AaaLogin"), new String[]{"LOGIN_ID"}, new String[]{"LOGIN_ID"}, 1);
        query.addJoin(mapJoin);
        query.addJoin(loginJoin);
        query.addSelectColumn(Column.getColumn((String)"ADAPUserRoles", (String)"*"));
        query.addSelectColumn(Column.getColumn((String)"ADAPUserRoleMapping", (String)"*"));
        query.addSelectColumn(Column.getColumn((String)"AaaLogin", (String)"*"));
        query.addSortColumn(new SortColumn(Column.getColumn((String)"ADAPUserRoles", (String)"NAME"), true));
        DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)query);
        DataObject dObj = CommonUtil.getPersistence(new boolean[0]).get("AUDTechnicianTopLevelConfig", (Criteria)null);
        Iterator iter = dataObject.getRows("ADAPUserRoles");
        while (iter.hasNext()) {
            Row row = (Row)iter.next();
            HashMap<String, Object> roleDetails = new HashMap<String, Object>();
            roleDetails.put("ROLE_ID", row.get("ROLE_ID"));
            String name = rb.getString((String)row.get("NAME"));
            roleDetails.put("NAME", name);
            roleDetails.put("DESCRIPTION", rb.getString((String)row.get("DESCRIPTION")));
            String associateTechnicians = "";
            Iterator iterator = dataObject.getRows("ADAPUserRoleMapping", new Criteria(Column.getColumn((String)"ADAPUserRoleMapping", (String)"ROLE_ID"), row.get("ROLE_ID"), 0));
            while (iterator.hasNext()) {
                Row mapRow = (Row)iterator.next();
                Row loginRow = dataObject.getRow("AaaLogin", new Criteria(Column.getColumn((String)"ADAPUserRoleMapping", (String)"LOGIN_ID"), mapRow.get("LOGIN_ID"), 0));
                associateTechnicians = associateTechnicians + (associateTechnicians != "" ? "," + loginRow.get("NAME") : (String)loginRow.get("NAME"));
            }
            iterator = dObj.getRows("AUDTechnicianTopLevelConfig", new Criteria(Column.getColumn((String)"AUDTechnicianTopLevelConfig", (String)"ROLE_ID"), row.get("ROLE_ID"), 0));
            while (iterator.hasNext()) {
                Row topLevelRow = (Row)iterator.next();
                Row objRow = DirectoryObjectAPI.getInstance().getObjectRow(DomainDetailsAPI.getDomainName((String)topLevelRow.get("DOMAIN_NAME")), (String)topLevelRow.get("OBJECT_GUID"), "OBJECT_GUID", (String)topLevelRow.get("OBJECT_CLASS"));
                associateTechnicians = associateTechnicians + (associateTechnicians != "" ? "," + objRow.get("NAME") : (String)objRow.get("NAME"));
            }
            if (searchStr != null && name.toLowerCase().indexOf(searchStr.toLowerCase()) == -1) continue;
            roleDetails.put("ASSOCIATE_TECHIE", associateTechnicians);
            rolesList.add(roleDetails);
        }
        return rolesList;
    }

    public static String getEventTypeText(int eventType) {
        return TDUtil.getEventTypeText(eventType, ResourceBundleMgr.getInstance().getBundle());
    }

    public static String getEventTypeText(int eventType, AdventNetResourceBundle rb) {
        if (eventType == 8) {
            return rb.getString("adap.common.text.status_msg.success");
        }
        return rb.getString("adap.DefaultCategoryListener.Failure");
    }

    public static String getAccessTypeText(int accessType) throws Exception {
        return TDUtil.getAccessTypeText(accessType, ResourceBundleMgr.getInstance().getBundle());
    }

    public static String getAccessTypeText(int accessType, AdventNetResourceBundle rb) throws Exception {
        String accessTypeText = rb.getString("adap.TDHandler.Full_Access");
        switch (accessType) {
            case 1024: {
                accessTypeText = rb.getString("adap.TDHandler.Full_Access");
                break;
            }
            case 2: {
                accessTypeText = rb.getString("adap.TDHandler.Deny_Access");
                break;
            }
            case 4: {
                accessTypeText = rb.getString("adap.TDHandler.Read_Access");
                break;
            }
            case 8: {
                accessTypeText = rb.getString("adap.TDHandler.Modify_Access");
                break;
            }
            case 16: {
                accessTypeText = rb.getString("adap.TDHandler.Delete_Access");
                break;
            }
            case 512: {
                accessTypeText = rb.getString("adap.TDHandler.Create_Access");
                break;
            }
            default: {
                accessTypeText = rb.getString("adap.TDHandler.Failed");
            }
        }
        return accessTypeText;
    }

    public static String getSeverityText(int severity) throws Exception {
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle();
        String accessTypeText = rb.getString("adap.NotificationAPI.Clear");
        switch (severity) {
            case 1: {
                accessTypeText = rb.getString("adap.NotificationAPI.Attention");
                break;
            }
            case 2: {
                accessTypeText = rb.getString("adap.NotificationAPI.Trouble");
                break;
            }
            case 3: {
                accessTypeText = rb.getString("adap.NotificationAPI.Critical");
                break;
            }
            default: {
                accessTypeText = rb.getString("adap.TDHandler.Failed");
            }
        }
        return accessTypeText;
    }

    public static String deleteRole(Long roleId) throws Exception {
        Criteria criteria = new Criteria(Column.getColumn((String)"ADAPUserRoles", (String)"ROLE_ID"), (Object)roleId, 0);
        CommonUtil.getPersistence(new boolean[0]).delete(criteria);
        return "adap.TDUtil.Delete_Role_Successfully";
    }

    public static String copyRole(Long roleId, String newRoleName, String newRoleDescription) throws Exception {
        DataObject dObj = TDUtil.getRoleDetailsDO(roleId);
        DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).constructDataObject();
        Row row = ReportUtil.formRow("ADAPUserRoles", new String[]{"NAME", "DESCRIPTION", "CREATION_TIME", "MODIFICATION_TIME"}, new Object[]{newRoleName, newRoleDescription, System.currentTimeMillis(), System.currentTimeMillis()});
        dataObject.addRow(row);
        Iterator iterator = dObj.getRows("ADAPRoleActionMapping");
        while (iterator.hasNext()) {
            Row actionRow = (Row)iterator.next();
            dataObject.addRow(ReportUtil.formRow("ADAPRoleActionMapping", new String[]{"ROLE_ID", "ACTION_ID", "ACCESS_TYPE"}, new Object[]{row.get("ROLE_ID"), actionRow.get("ACTION_ID"), actionRow.get("ACCESS_TYPE")}));
        }
        CommonUtil.getPersistence(new boolean[0]).add(dataObject);
        return "adap.TDUtil.Copy_Role_Successfully";
    }

    public static DataObject getRoleDetailsDO(Long roleId) throws Exception {
        Criteria criteria = new Criteria(Column.getColumn((String)"ADAPUserRoles", (String)"ROLE_ID"), (Object)roleId, 0);
        SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)"ADAPUserRoles"));
        Join mapJoin = new Join(Table.getTable((String)"ADAPUserRoles"), Table.getTable((String)"ADAPRoleActionMapping"), new String[]{"ROLE_ID"}, new String[]{"ROLE_ID"}, 2);
        query.addJoin(mapJoin);
        query.addSelectColumn(Column.getColumn((String)"ADAPUserRoles", (String)"*"));
        query.addSelectColumn(Column.getColumn((String)"ADAPRoleActionMapping", (String)"*"));
        query.setCriteria(criteria);
        DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)query);
        return dataObject;
    }

    public static String createRole(String roleName, String description, String actionStr) throws Exception {
        StringTokenizer st = new StringTokenizer(actionStr, ",");
        DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).constructDataObject();
        Row row = ReportUtil.formRow("ADAPUserRoles", new String[]{"NAME", "DESCRIPTION", "CREATION_TIME", "MODIFICATION_TIME"}, new Object[]{roleName, description, System.currentTimeMillis(), System.currentTimeMillis()});
        dataObject.addRow(row);
        while (st.hasMoreTokens()) {
            String action = st.nextToken();
            String[] actionVsAccess = action.split("::");
            try {
                dataObject.addRow(ReportUtil.formRow("ADAPRoleActionMapping", new String[]{"ROLE_ID", "ACTION_ID", "ACCESS_TYPE"}, new Object[]{row.get("ROLE_ID"), Long.parseLong(actionVsAccess[0]), actionVsAccess.length > 1 ? Integer.parseInt(actionVsAccess[1]) : new Integer(32)}));
            }
            catch (Exception ex) {
                logger.log(Level.INFO, "Duplicated added row again ");
            }
        }
        CommonUtil.getPersistence(new boolean[0]).add(dataObject);
        return "adap.TDUtil.Successfully_New_role_Created";
    }

    public static String updateRole(Long roleId, String newRoleName, String newRoleDescription, String selectedActions) throws Exception {
        CommonUtil.getPersistence(new boolean[0]).delete(new Criteria(Column.getColumn((String)"ADAPRoleActionMapping", (String)"ROLE_ID"), (Object)roleId, 0));
        DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get("ADAPUserRoles", new Criteria(Column.getColumn((String)"ADAPUserRoles", (String)"ROLE_ID"), (Object)roleId, 0));
        Row row = dataObject.getFirstRow("ADAPUserRoles");
        row.set("NAME", (Object)newRoleName);
        row.set("DESCRIPTION", (Object)newRoleDescription);
        row.set("MODIFICATION_TIME", (Object)System.currentTimeMillis());
        dataObject.updateRow(row);
        String[] selectedActionsArray = selectedActions.split(",");
        for (int size = 0; size < selectedActionsArray.length; ++size) {
            String action = selectedActionsArray[size];
            String[] actionVsAccess = action.split("::");
            try {
                dataObject.addRow(ReportUtil.formRow("ADAPRoleActionMapping", new String[]{"ROLE_ID", "ACTION_ID", "ACCESS_TYPE"}, new Object[]{roleId, Long.parseLong(actionVsAccess[0]), actionVsAccess.length > 1 ? Integer.parseInt(actionVsAccess[1]) : new Integer(32)}));
                continue;
            }
            catch (Exception ex) {
                logger.log(Level.INFO, "Duplicated added row again ");
            }
        }
        CommonUtil.getPersistence(new boolean[0]).update(dataObject);
        return "adap.TDUtil.Update_Role_Successfully";
    }

    public static void syncWithAD() {
        try {
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle();
            SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)"AUDTechnicianTopLevelConfig"));
            Join mapJoin = new Join(Table.getTable((String)"AUDTechnicianTopLevelConfig"), Table.getTable((String)"AUDTechUserMapping"), new String[]{"UNIQUE_ID"}, new String[]{"UNIQUE_ID"}, 2);
            query.addJoin(mapJoin);
            Join userJoin = new Join(Table.getTable((String)"AUDTechUserMapping"), Table.getTable((String)"AaaUser"), new String[]{"USER_ID"}, new String[]{"USER_ID"}, 2);
            query.addJoin(userJoin);
            query.addSelectColumn(Column.getColumn((String)"AUDTechnicianTopLevelConfig", (String)"*"));
            query.addSelectColumn(Column.getColumn((String)"AUDTechUserMapping", (String)"*"));
            query.addSelectColumn(Column.getColumn((String)"AaaUser", (String)"*"));
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)query);
            Iterator iter = dataObject.getRows("AUDTechnicianTopLevelConfig");
            while (iter.hasNext()) {
                Row row = (Row)iter.next();
                ArrayList objectsList = null;
                String domainName = DomainDetailsAPI.getDomainName((String)row.get("DOMAIN_NAME"));
                String objectName = null;
                if (((String)row.get("OBJECT_CLASS")).equals("group")) {
                    Row row2 = DirectoryObjectAPI.getInstance().getObjectRow(domainName, (String)row.get("OBJECT_GUID"), (String)row.get("OBJECT_CLASS"));
                    objectName = (String)row2.get("NAME");
                    objectsList = GroupHandler.getChildObjects(domainName, "user", (String)row.get("OBJECT_GUID"));
                } else {
                    DataObject dObj = CommonUtil.getPersistence(new boolean[0]).get("ADSMOUDetails", new Criteria(Column.getColumn((String)"ADSMOUDetails", (String)"OBJECT_GUID"), (Object)((String)row.get("OBJECT_GUID")), 0));
                    Row row2 = dObj.getFirstRow("ADSMOUDetails");
                    objectName = (String)row2.get("NAME");
                    objectsList = OUHandler.getChildObjects("user", (String)row2.get("DISTINGUISHED_NAME"));
                }
                if (objectsList.size() > 0) {
                    Iterator iterator = dataObject.getRows("AUDTechUserMapping", new Criteria(Column.getColumn((String)"AUDTechUserMapping", (String)"UNIQUE_ID"), (Object)((Long)row.get("UNIQUE_ID")), 0));
                    while (iterator.hasNext()) {
                        Row mapRow = (Row)iterator.next();
                        Row userRow = dataObject.getRow("AaaUser", new Criteria(Column.getColumn((String)"AaaUser", (String)"USER_ID"), (Object)((Long)mapRow.get("USER_ID")), 0));
                        if (TDUtil.checkIfUserAvailable(objectsList, (String)userRow.get("FIRST_NAME"))) continue;
                        logger.log(Level.INFO, "User '" + (String)userRow.get("FIRST_NAME") + "' already removed/moved from OU/Group ");
                        TechnicianHandler.deleteUser((Long)mapRow.get("USER_ID"), "user");
                        TDHandler.addAuditEntries(ReportUtil.formMap(TDConstants.LOGIN_AUDIT_COLUMNS, new Object[]{new Long(1L), new Long(1L), "admin", new Long(-1L), "127.0.0.1", "ADAudit Plus Server", 8, "Admin", System.currentTimeMillis() / 1000L, "ADAuditPlus Authentication", rb.handleGetObject("adap.TDUtil.audit_entry.tech_deleted", new String[]{(String)userRow.get("FIRST_NAME"), (String)row.get("OBJECT_CLASS"), objectName}), 8, 8, new Long(1L), "-", TDHandler.getSeverity("adap.ADAPUserAuditSeverities.audit_name.tech_deleted")}));
                    }
                    continue;
                }
                logger.log(Level.INFO, "Need to delete This Object");
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private static boolean checkIfUserAvailable(ArrayList objectsList, String loginName) {
        boolean isAvailable = false;
        try {
            for (int size = 0; size < objectsList.size(); ++size) {
                HashMap objectDetails = (HashMap)objectsList.get(size);
                if (!loginName.equalsIgnoreCase((String)objectDetails.get("SAM_ACCOUNT_NAME"))) continue;
                isAvailable = true;
                break;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return isAvailable;
    }
}

