/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.admin.delegation;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.auditing.server.reports.AUDCustomViewAPI;
import com.adventnet.sym.adsm.auditing.server.reports.AuditReportAPI;
import com.adventnet.sym.adsm.auditing.server.reports.ExportUtil;
import com.adventnet.sym.adsm.common.server.admin.delegation.TDConstants;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class TechnicianAuditHandler {
    private static Logger logger = Logger.getLogger("QueryLogger");

    public static ArrayList<HashMap> getAuditRowsList(String searchCriteria, HashMap inputParamsMap, int startIndex, int noOfObjects, int count, Boolean isEmber) throws Exception {
        HashMap<String, Object> tableViewConfig = AUDCustomViewAPI.getInstance().getTableViewConfig(TDConstants.TECH_AUDIT_ID);
        ArrayList rowsList = AuditReportAPI.getInstance().getReportRows(TDConstants.TECH_AUDIT_ID, searchCriteria, inputParamsMap, (String)tableViewConfig.get("SORTCOLUMN"), (String)tableViewConfig.get("SORTORDER"), startIndex, noOfObjects, null, count, isEmber);
        return rowsList;
    }

    public static int getAuditRowsCount(String searchCriteria, HashMap inputParamsMap) throws Exception {
        int count = AuditReportAPI.getInstance().getReportCount(TDConstants.TECH_AUDIT_ID, searchCriteria, inputParamsMap);
        return count;
    }

    public static ArrayList getVisibleColumns() throws Exception {
        return AuditReportAPI.getInstance().getVisibleColumnList(TDConstants.TECH_AUDIT_ID);
    }

    public static String formSearchCriteria(String searchString) throws Exception {
        StringTokenizer st = new StringTokenizer(searchString, ";;;");
        String searchCriteria = null;
        if (!searchString.equals("-")) {
            while (st.hasMoreTokens()) {
                String[] temp = st.nextToken().split("=");
                String value = temp[0] + " like '" + CommonUtil.getSearchString(temp[1]) + "'";
                searchCriteria = searchCriteria != null ? searchCriteria + " AND " + value : value;
            }
        }
        return searchCriteria;
    }

    public static String addActionInCriteria(String searchCriteria, String action) throws Exception {
        String actionStr = "1=1";
        if (action.equals("1")) {
            searchCriteria = searchCriteria != null ? searchCriteria + "AND ACTION_ID = 16" : "ACTION_ID = 16";
        }
        return searchCriteria;
    }

    public static void exportReport(HashMap inputParamsMap, String searchCriteria, String loginName, String reportType, HttpServletRequest request, HttpServletResponse response) throws Exception {
        HashMap<String, String> addionalSQLPropsMap = new HashMap<String, String>();
        HashMap<String, Object> tableViewConfig = AUDCustomViewAPI.getInstance().getTableViewConfig(TDConstants.TECH_AUDIT_ID);
        addionalSQLPropsMap.put("sortColumn", (String)tableViewConfig.get("SORTCOLUMN"));
        addionalSQLPropsMap.put("sortOrder", (String)tableViewConfig.get("SORTORDER"));
        HashMap<String, String> reportMap = new HashMap<String, String>();
        reportMap.put("TITLE", "Audit report for the Technician " + loginName);
        reportMap.put("DESCRIPTION", "Generating Report for the selected Technician");
        reportMap.put("DISPLAY_TYPE", "TABLE");
        ExportUtil.exportReport(TDConstants.TECH_AUDIT_ID, reportMap, (String)inputParamsMap.get("DOMAIN_NAME"), searchCriteria, reportType, inputParamsMap, addionalSQLPropsMap, request, response);
    }

    public static String getUserId(Long userId, String objectClass) throws Exception {
        StringBuilder sb = new StringBuilder();
        if (objectClass.equals("user")) {
            sb.append(Long.toString(userId));
        } else {
            Criteria crit = new Criteria(Column.getColumn((String)"AUDTechUserMapping", (String)"UNIQUE_ID"), (Object)userId, 0);
            DataObject dObj = CommonUtil.getCachedPersistence().get("AUDTechUserMapping", crit);
            if (dObj.isEmpty()) {
                sb.append("-1");
            } else {
                int i = 0;
                Iterator iter = dObj.getRows("AUDTechUserMapping");
                while (iter.hasNext()) {
                    Row row = (Row)iter.next();
                    if (i != 0) {
                        sb.append(",");
                    }
                    sb.append(Long.toString((Long)row.get("USER_ID")));
                    ++i;
                }
            }
        }
        return sb.toString();
    }

    public static HashMap getCustomVisibleList() {
        return AuditReportAPI.getInstance().getCustomVisibleList(TDConstants.TECH_AUDIT_ID);
    }

    public static Boolean resetColumns(Long[] visibleColumns) {
        Boolean status = true;
        try {
            AUDCustomViewAPI.getInstance().updateColumnList(TDConstants.TECH_AUDIT_ID, visibleColumns);
        }
        catch (Exception ex) {
            status = false;
            ex.printStackTrace();
        }
        return status;
    }
}

