/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.authentication;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;

public class ADAPUserAPI {
    private static ADAPUserAPI userAPI = null;
    private static final String TABS_TABLE_NAME = "ADAPTotalTabs";

    public static HashMap getAAADetails(String loginName, Long userId) {
        HashMap<String, ArrayList> aAAMap = new HashMap<String, ArrayList>();
        aAAMap.put("AVAILABLE_TABS", ADAPUserAPI.getAvailableTabs(loginName, userId));
        return aAAMap;
    }

    private static ArrayList getAvailableTabs(String loginName, Long userId) {
        ArrayList<Map> tabList = new ArrayList<Map>();
        try {
            Criteria c = new Criteria(Column.getColumn((String)"AaaLogin", (String)"NAME"), (Object)loginName, 0);
            c = c.and(new Criteria(Column.getColumn((String)"AaaLogin", (String)"USER_ID"), (Object)userId, 0));
            ArrayList<String> tableList = new ArrayList<String>();
            tableList.add("AaaLogin");
            tableList.add("AaaAccount");
            tableList.add("AaaAuthorizedRole");
            tableList.add("AaaRole");
            tableList.add("ADAPRoleTabMapping");
            tableList.add(TABS_TABLE_NAME);
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get(tableList, c);
            TreeMap hashMap = new TreeMap();
            Iterator it = dataObject.getRows(TABS_TABLE_NAME);
            while (it.hasNext()) {
                Row tabRow = (Row)it.next();
                HashMap<String, Object> tabDetails = new HashMap<String, Object>();
                tabDetails.put("TAB_NAME", tabRow.get("TAB_NAME"));
                tabDetails.put("TAB_DISPLAY_NAME", (String)tabRow.get("TAB_DISPLAY_NAME"));
                tabDetails.put("TAB_URL", tabRow.get("TAB_URL"));
                Integer priorityId = (Integer)tabRow.get("PRIORITY_ID");
                hashMap.put(priorityId, tabDetails);
            }
            System.out.println("Tab hashMap in ADAPUserAPI >" + hashMap);
            for (Map.Entry entry : hashMap.entrySet()) {
                tabList.add((Map)entry.getValue());
            }
            System.out.println("Tab List in ADAPUserAPI >" + tabList);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return tabList;
    }
}

