/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.dbsync;

import com.adventnet.sym.adsm.common.server.DomainDetailsAPI;
import com.adventnet.sym.adsm.common.server.DomainHandler;
import com.adventnet.sym.adsm.common.server.InheritedHostHandler;
import com.adventnet.sym.adsm.common.server.MSHandler;
import com.manageengine.ads.fw.dbsync.ExecutorImpl;
import com.manageengine.ads.fw.service.util.ProductUniqueSeqGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.json.JSONArray;
import org.json.JSONObject;

public class ADAPExecutorImpl
extends ExecutorImpl {
    private static Logger out = Logger.getLogger("ADSDBSyncLogger");
    private static final Pattern IPV4_PATTERN = Pattern.compile("^(([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.){3}([01]?\\d\\d?|2[0-4]\\d|25[0-5])$");

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String execute(JSONObject jsonRow) {
        String result = "success";
        try {
            String moduleName = jsonRow.getString("MODULE_NAME");
            int operation = jsonRow.getInt("OPERATION");
            if (moduleName.equalsIgnoreCase("ADSMyFavCategory") || moduleName.equalsIgnoreCase("ADSMyFavReports")) {
                jsonRow = this.constructLoginDetails(jsonRow);
            }
            if (moduleName.equals("DomainConfiguration")) {
                Properties domainProperties = this.getDomainDetails(jsonRow);
                String domainName = domainProperties.getProperty("DomainName");
                String userName = domainProperties.getProperty("UserName");
                String password = domainProperties.getProperty("Password");
                JSONObject domainDetails = DomainHandler.getDomainDetails(domainName);
                if (domainDetails.length() != 0) {
                    String oldUserName;
                    domainName = domainDetails.getString("DOMAIN_NAME");
                    String string = oldUserName = domainDetails.has("USER_NAME") ? domainDetails.getString("USER_NAME") : null;
                    if (userName == null || oldUserName != null && !oldUserName.equals("") && !userName.equalsIgnoreCase(domainDetails.getString("USER_NAME"))) {
                        userName = domainDetails.getString("USER_NAME");
                        password = domainDetails.getString("PASSWORD");
                    }
                }
                if (operation != 1 && operation != 2) return result;
                String authenticationRequired = domainProperties.getProperty("IsAuthRequired");
                String isDefaultDomain = domainProperties.getProperty("IsDefaultDomain");
                String[] dcs = domainProperties.getProperty("DCList").split(",");
                ArrayList<String> dcList = new ArrayList<String>(Arrays.asList(dcs));
                Properties prop = new Properties();
                prop.put("DOMAIN_NAME", domainName);
                if (authenticationRequired != null && authenticationRequired.equalsIgnoreCase("true")) {
                    prop.put("USER_DISTINGUISHED_NAME", userName);
                    prop.put("PASSWORD", password);
                    prop.put("IS_AUTHENTICATION_REQUIRED", authenticationRequired);
                }
                prop.put("DOMAIN_CONTROLLER_LIST", dcList);
                if (isDefaultDomain != null && isDefaultDomain.equalsIgnoreCase("true") && operation != 1) {
                    prop.put("IS_DEFAULT_DOMAIN", "true");
                } else {
                    String defaultDomain = DomainDetailsAPI.getDefaultDomainName();
                    if (defaultDomain.equalsIgnoreCase("") || defaultDomain.equalsIgnoreCase(domainName)) {
                        prop.put("IS_DEFAULT_DOMAIN", "true");
                    } else {
                        prop.put("IS_DEFAULT_DOMAIN", "false");
                    }
                }
                if (operation == 1) {
                    DomainHandler.addDomainDetails(prop, true);
                } else if (authenticationRequired == null && prop.getProperty("IS_DEFAULT_DOMAIN").equalsIgnoreCase("true")) {
                    DomainHandler.setDefaultDomain(domainName, true);
                }
                if (operation != 2) return result;
                Properties dmnDetails = DomainHandler.getConfiguredValuesForModify(domainName);
                dmnDetails.setProperty("IS_AUTHENTICATION_REQUIRED", authenticationRequired);
                if (authenticationRequired.equalsIgnoreCase("true")) {
                    dmnDetails.setProperty("USER_DISTINGUISHED_NAME", userName);
                    dmnDetails.setProperty("PASSWORD", password);
                }
                Properties properties = DomainHandler.getDomainDetails(dmnDetails, true);
                boolean status = DomainHandler.updateCredentials(properties);
                out.log(Level.INFO, "Credential Update status: " + status);
                ArrayList dcExistingList = (ArrayList)dmnDetails.get("DOMAIN_CONTROLLER_LIST");
                out.log(Level.INFO, " dcExistingList " + dcExistingList + " dcList " + dcList);
                Iterator iterator = dcExistingList.iterator();
                while (iterator.hasNext()) {
                    dcList.remove(iterator.next());
                }
                out.log(Level.INFO, " dcExistingList " + dcExistingList + " dcList " + dcList);
                if (dcList.isEmpty()) return result;
                dmnDetails.put("DOMAIN_CONTROLLER_LIST", dcList);
                Properties p = DomainHandler.getDomainDetails(dmnDetails, true);
                DomainHandler.addDomainControllers(p);
                return result;
            } else if (moduleName.equals("HostAddDeleteSync") || moduleName.equals("HostUpdateSync") || moduleName.equals("ADSHostModules")) {
                String domainName = null;
                Properties hostProperties = this.getDomainDetails(jsonRow);
                String hostName = ADAPExecutorImpl.getNameFromFQDN(hostProperties.getProperty("HOST_NAME"));
                hostProperties.setProperty("HOST_NAME", hostName);
                domainName = hostProperties.getProperty("DOMAIN_NAME");
                String sourceStamp = hostProperties.getProperty("PRODUCT_SEQ_NUMBER");
                if (ProductUniqueSeqGenerator.getCurrentSeqNumber().equals(sourceStamp)) {
                    out.log(Level.FINE, "Duplicate Host Information For : " + hostProperties);
                    return result;
                } else {
                    if (domainName != null) {
                        domainName = DomainDetailsAPI.getDomainName(domainName);
                    } else {
                        domainName = MSHandler.getDomainNamefromHost(hostName);
                        out.log(Level.INFO, "Adding ELA added host, by getting ADAP domain from DB, Domain is ----> " + domainName + ", Host is ---> " + hostName);
                    }
                    Integer machineType = MSHandler.getMachineType(hostName, domainName);
                    if (domainName != null && machineType != null) {
                        this.handleHostModule(hostProperties, operation, domainName, machineType, true);
                        return result;
                    } else {
                        out.log(Level.INFO, "Skipping ELA added host, as it belongs to non existing ADAP domain or it not a MemberServer, Host is ---> " + hostName + "  domainName->" + domainName + "  machineType -> " + machineType);
                    }
                }
                return result;
            } else {
                if (!moduleName.equals("MemberServerOrWorkStationAddUpdate") && !moduleName.equals("MemberServerOrWorkStationDelete") && !moduleName.equals("DomainController")) return super.execute(jsonRow);
                out.log(Level.FINE, "Skipping ADAP published Syncing Module " + moduleName);
            }
            return result;
        }
        catch (Exception e) {
            result = e.getMessage() != null ? e.getMessage() : e.toString();
            out.log(Level.INFO, "Unable to Execute Row - Reason : " + result);
        }
        return result;
    }

    private Properties getDomainDetails(JSONObject row) throws Exception {
        Properties properties = new Properties();
        JSONArray columns = row.getJSONArray("COLUMNS");
        for (int i = 0; i < columns.length(); ++i) {
            JSONObject column = columns.getJSONObject(i);
            properties.put(column.getString("NAME"), column.getString("VALUE"));
        }
        return properties;
    }

    private JSONObject constructLoginDetails(JSONObject jsonRow) throws Exception {
        String isProductUser = "false";
        JSONObject json = new JSONObject();
        JSONArray jsonColumns = jsonRow.getJSONArray("COLUMNS");
        for (int i = 0; i < jsonColumns.length(); ++i) {
            JSONObject jsonColumn = jsonColumns.getJSONObject(i);
            json.put(jsonColumn.getString("NAME"), jsonColumn.get("VALUE"));
            if (jsonColumn.getString("NAME").equals("IS_PRODUCT_USER")) {
                isProductUser = jsonColumn.getString("VALUE");
            }
            if (!jsonColumn.getString("NAME").equals("DOMAIN_NAME")) continue;
            json = DomainHandler.getDomainDetails(jsonColumn.getString("VALUE"));
        }
        if (isProductUser.equals("false")) {
            JSONObject jsonDom = new JSONObject();
            jsonDom.put("NAME", (Object)"DOMAIN_FLAT_NAME");
            jsonDom.put("VALUE", (Object)json.getString("DOMAIN_FLAT_NAME"));
            jsonDom.put("ORIGINAL_VALUE", (Object)json.getString("DOMAIN_FLAT_NAME"));
            jsonColumns.put((Object)jsonDom);
            jsonDom = new JSONObject();
            jsonDom.put("NAME", (Object)"DOMAIN_DNS_NAME");
            jsonDom.put("VALUE", (Object)json.getString("DOMAIN_DNS_NAME"));
            jsonDom.put("ORIGINAL_VALUE", (Object)json.getString("DOMAIN_DNS_NAME"));
            jsonColumns.put((Object)jsonDom);
        }
        jsonRow.put("COLUMNS", (Object)jsonColumns);
        return jsonRow;
    }

    private void handleHostModule(Properties hostProperties, int operation, String domainName, Integer machineType, boolean isInherited) throws Exception {
        String hostName = hostProperties.getProperty("HOST_NAME");
        String source_product = hostProperties.getProperty("PRODUCT_SEQ_NUMBER");
        if (operation == 1) {
            out.info("handleHostModule has called for Adding supported device : " + hostProperties + "  DomainName : " + domainName);
            boolean licenseStatus = hostProperties.containsKey("LICENSE_CODE") && hostProperties.getProperty("LICENSE_CODE").equalsIgnoreCase("R");
            InheritedHostHandler.addOrConvertInheritedHost(domainName, hostName, machineType, source_product, licenseStatus, true);
        } else if (operation == 3) {
            out.info("handleHostModule has called for deleting supported device : " + hostProperties + "  DomainName : " + domainName);
            InheritedHostHandler.checkAndDeleteInheritedHost(hostName, domainName, machineType, source_product);
        } else {
            out.info("handleHostModule has called for updating supported device : " + hostProperties + "  DomainName : " + domainName);
            int logCollectionStatus = hostProperties.containsKey("HOST_STATUS") ? Integer.parseInt(hostProperties.getProperty("HOST_STATUS")) : Integer.parseInt(hostProperties.getProperty("LOG_COLLECTION_STATUS"));
            ADAPExecutorImpl.checkAndUpdateInheritedHost(hostName, domainName, source_product, machineType, logCollectionStatus);
        }
    }

    public static void checkAndUpdateInheritedHost(String hostName, String domainName, String source_product, Integer machineType, int logCollectionStatus) throws Exception {
        if (source_product == null) {
            out.info("WARNING : Request processed based on Old Eventlog request  checkAndUpdateInheritedHost");
            ADAPExecutorImpl.updateInheritedHost(hostName, domainName, machineType, logCollectionStatus);
        } else if (InheritedHostHandler.validateInheritedHost(hostName, domainName, source_product)) {
            ADAPExecutorImpl.updateInheritedHost(hostName, domainName, machineType, logCollectionStatus);
        } else {
            out.info("Target Host not found or Source Product Not matching for host : " + hostName + "  source_product : " + source_product);
        }
    }

    public static void updateInheritedHost(String hostName, String domainName, Integer machineType, int logCollectionStatus) throws Exception {
        ArrayList ids = DomainHandler.getComputerId(hostName, domainName);
        if (logCollectionStatus == 0) {
            MSHandler.updateMemberServers(domainName, "Disable", ids, null, machineType, new boolean[0]);
        } else {
            MSHandler.updateMemberServers(domainName, "Enable", ids, null, machineType, new boolean[0]);
        }
    }

    public static String getNameFromFQDN(String name) {
        try {
            if (name != null && name.indexOf(".") > -1 && !ADAPExecutorImpl.isValidInet4Address(name)) {
                name = name.substring(0, name.indexOf("."));
            }
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
        return name;
    }

    public static boolean isValidInet4Address(String inet4Address) {
        return IPV4_PATTERN.matcher(inet4Address).matches();
    }
}

