/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.dbsync;

import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.auditing.server.util.EventSchedulerUtil;
import com.adventnet.sym.adsm.common.server.DomainHandler;
import com.adventnet.sym.adsm.common.server.MSHandler;
import com.adventnet.sym.adsm.common.server.util.LicenseUtil;
import com.manageengine.ads.fw.dbsync.DBSyncModulesContainer;
import com.manageengine.ads.fw.dbsync.PublisherImpl;
import com.manageengine.ads.fw.license.LicenseManager;
import com.manageengine.ads.fw.reports.favourites.MyFavRepHandler;
import com.manageengine.ads.fw.service.util.ProductUniqueSeqGenerator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import org.json.JSONObject;

public class ADAPPublisherImpl
extends PublisherImpl {
    private static Logger out = Logger.getLogger("ADSDBSyncLogger");
    private static Map<String, String> tableModuleMap = DBSyncModulesContainer.getTableModuleMap();

    public void addRow(Row row) throws Exception {
        int operation = row.getOperationIndex();
        String tableName = row.getOriginalTableName();
        String moduleName = tableModuleMap.get(tableName);
        if (!(tableName.equalsIgnoreCase("ADSMDomainConfiguration") || tableName.equalsIgnoreCase("AUDComputerEventRead") || tableName.equalsIgnoreCase("Task_Input") || tableName.equalsIgnoreCase("ADSMDCConfiguration"))) {
            super.addRow(row);
        } else if (tableName.equalsIgnoreCase("AUDComputerEventRead")) {
            if ((Integer)row.get("ISINHERITED") != 1) {
                List columnList = row.getColumns();
                this.createRow(moduleName, operation);
                for (Object columnName : columnList) {
                    JSONObject columnSyncDetails = DBSyncModulesContainer.getColumnSyncDetails((String)tableName, (String)columnName.toString());
                    if (columnSyncDetails == null) continue;
                    JSONObject column = this.constructColumn(row, columnSyncDetails);
                    this.addColumn(column.getString("NAME"), column.getString("VALUE"), column.getString("ORIGINAL_VALUE"));
                }
                this.addAUDComputerEventReadColumns(row);
                this.addRowtoEvent();
            } else {
                out.fine("Inherited Host Cannot be Published " + row);
            }
        } else if (tableName.equalsIgnoreCase("ADSMDCConfiguration")) {
            List columnList = row.getColumns();
            this.createRow(moduleName, operation);
            for (Object columnName : columnList) {
                JSONObject columnSyncDetails = DBSyncModulesContainer.getColumnSyncDetails((String)tableName, (String)columnName.toString());
                if (columnSyncDetails == null) continue;
                JSONObject column = this.constructColumn(row, columnSyncDetails);
                this.addColumn(column.getString("NAME"), column.getString("VALUE"), column.getString("ORIGINAL_VALUE"));
            }
            this.addADSMDCConfigurationColumns(row, operation);
            this.addRowtoEvent();
        } else if (tableName.equalsIgnoreCase("Task_Input")) {
            if (MSHandler.instanceVsGUIDMap.containsKey((Long)row.get("INSTANCE_ID"))) {
                List columnList = row.getColumns();
                this.createRow(moduleName, operation);
                for (Object columnName : columnList) {
                    JSONObject columnSyncDetails = DBSyncModulesContainer.getColumnSyncDetails((String)tableName, (String)columnName.toString());
                    if (columnSyncDetails == null) continue;
                    JSONObject column = this.constructColumn(row, columnSyncDetails);
                    this.addColumn(column.getString("NAME"), column.getString("VALUE"), column.getString("ORIGINAL_VALUE"));
                }
                this.addTaskInputColumns(row);
                this.addRowtoEvent();
            } else {
                out.fine("Unknwon Instance id returned " + row);
            }
        } else if (operation == 3) {
            if (tableName.equalsIgnoreCase("ADSMDomainConfiguration")) {
                this.createRow(moduleName, operation);
                List uniqueColumns = DBSyncModulesContainer.getUniqueTableColumnsForModule((String)moduleName);
                for (String uniqueColumn : uniqueColumns) {
                    JSONObject columnSyncDetails = DBSyncModulesContainer.getColumnSyncDetails((String)tableName, (String)uniqueColumn);
                    if (columnSyncDetails == null) continue;
                    JSONObject column = this.constructColumn(row, columnSyncDetails);
                    this.addColumn(column.getString("NAME"), column.getString("VALUE"), column.getString("ORIGINAL_VALUE"));
                    if (moduleName.equalsIgnoreCase("ADSMyFavCategory") && column.getString("NAME").equals("LOGIN_ID")) {
                        this.getLoginDetails(Long.valueOf(column.getString("VALUE")));
                    }
                    if (!moduleName.equalsIgnoreCase("ADSMyFavReports") || !column.getString("NAME").equals("CATEGORY_ID")) continue;
                    JSONObject json = MyFavRepHandler.getCategoryDetails((Long)Long.valueOf(column.getString("VALUE")));
                    this.constructCategoryDetails(Long.valueOf(column.getString("VALUE")), 0L);
                    this.getLoginDetails(json.getLong("LOGIN_ID"));
                }
                this.addColumn("PRODUCT_SEQ_NUMBER", ProductUniqueSeqGenerator.getCurrentSeqNumber(), null);
                this.addRowtoEvent();
            } else {
                super.addRow(row);
            }
        } else {
            List columnList = row.getColumns();
            this.createRow(moduleName, operation);
            for (Object columnName : columnList) {
                JSONObject columnSyncDetails = DBSyncModulesContainer.getColumnSyncDetails((String)tableName, (String)columnName.toString());
                if (columnSyncDetails == null) continue;
                JSONObject column = this.constructColumn(row, columnSyncDetails);
                this.addColumn(column.getString("NAME"), column.getString("VALUE"), column.getString("ORIGINAL_VALUE"));
            }
            this.addColumn("DCList", ADAPPublisherImpl.getDCList(row.get("DOMAIN_NAME").toString()), null);
            this.addRowtoEvent();
        }
    }

    private void constructCategoryDetails(Long categoryId, Long oldCategoryId) throws Exception {
        String key = "CATEGORY_NAME";
        Long id = oldCategoryId == 0L ? categoryId : oldCategoryId;
        this.addColumn(key, MyFavRepHandler.getCategoryName((Long)categoryId), MyFavRepHandler.getCategoryName((Long)id));
    }

    public void addRow(Row row, List<String> columnList) throws Exception {
        int operation = row.getOperationIndex();
        String tableName = row.getOriginalTableName();
        String moduleName = tableModuleMap.get(tableName);
        if (!(tableName.equalsIgnoreCase("ADSMDomainConfiguration") || tableName.equalsIgnoreCase("AUDComputerEventRead") || tableName.equalsIgnoreCase("ADSMDCConfiguration") || tableName.equalsIgnoreCase("Scheduled_Task"))) {
            super.addRow(row, columnList);
        } else if (tableName.equalsIgnoreCase("AUDComputerEventRead")) {
            List uniqueColumns = DBSyncModulesContainer.getUniqueTableColumnsForModule((String)moduleName);
            columnList.addAll(uniqueColumns);
            this.createRow(moduleName, operation);
            for (String columnName : columnList) {
                JSONObject columnSyncDetails = DBSyncModulesContainer.getColumnSyncDetails((String)tableName, (String)columnName.toString());
                if (columnSyncDetails == null) continue;
                JSONObject column = this.constructColumn(row, columnSyncDetails);
                this.addColumn(column.getString("NAME"), column.getString("VALUE"), column.getString("ORIGINAL_VALUE"));
            }
            this.addAUDComputerEventReadColumns(row);
            this.addRowtoEvent();
        } else if (tableName.equalsIgnoreCase("ADSMDCConfiguration")) {
            List uniqueColumns = DBSyncModulesContainer.getUniqueTableColumnsForModule((String)moduleName);
            columnList.addAll(uniqueColumns);
            this.createRow(moduleName, operation);
            for (String columnName : columnList) {
                JSONObject columnSyncDetails = DBSyncModulesContainer.getColumnSyncDetails((String)tableName, (String)columnName.toString());
                if (columnSyncDetails == null) continue;
                JSONObject column = this.constructColumn(row, columnSyncDetails);
                this.addColumn(column.getString("NAME"), column.getString("VALUE"), column.getString("ORIGINAL_VALUE"));
            }
            this.addADSMDCConfigurationColumns(row, 2);
            this.addRowtoEvent();
        } else if (tableName.equalsIgnoreCase("Scheduled_Task")) {
            List uniqueColumns = DBSyncModulesContainer.getUniqueTableColumnsForModule((String)moduleName);
            columnList.addAll(uniqueColumns);
            this.createRow(moduleName, operation);
            for (String columnName : columnList) {
                JSONObject columnSyncDetails = DBSyncModulesContainer.getColumnSyncDetails((String)tableName, (String)columnName.toString());
                if (columnSyncDetails == null) continue;
                JSONObject column = this.constructColumn(row, columnSyncDetails);
                this.addColumn(column.getString("NAME"), column.getString("VALUE"), column.getString("ORIGINAL_VALUE"));
            }
            this.addScheduledTaskColumns(row);
            this.addRowtoEvent();
        } else {
            List uniqueColumns = DBSyncModulesContainer.getUniqueTableColumnsForModule((String)moduleName);
            for (String uniqueColumn : uniqueColumns) {
                if (columnList.contains(uniqueColumn)) continue;
                columnList.add(uniqueColumn);
            }
            String[] authColumns = new String[]{"IS_AUTHENTICATION_REQUIRED", "USER_DISTINGUISHED_NAME", "PASSWORD"};
            boolean containsAuthChanges = false;
            for (String authColumn : authColumns) {
                if (!columnList.contains(authColumn)) continue;
                containsAuthChanges = true;
                break;
            }
            if (containsAuthChanges) {
                for (String authColumn : authColumns) {
                    if (columnList.contains(authColumn)) continue;
                    columnList.add(authColumn);
                }
            }
            this.createRow(moduleName, operation);
            for (String columnName : columnList) {
                JSONObject columnSyncDetails = DBSyncModulesContainer.getColumnSyncDetails((String)tableName, (String)columnName);
                if (columnSyncDetails == null) continue;
                JSONObject column = this.constructColumn(row, columnSyncDetails);
                this.addColumn(column.getString("NAME"), column.getString("VALUE"), column.getString("ORIGINAL_VALUE"));
            }
            this.addColumn("PRODUCT_SEQ_NUMBER", ProductUniqueSeqGenerator.getCurrentSeqNumber(), null);
            this.addColumn("DCList", ADAPPublisherImpl.getDCList(row.get("DOMAIN_NAME").toString()), null);
            this.addRowtoEvent();
        }
    }

    private JSONObject constructColumn(Row row, JSONObject columnSyncDetails) throws Exception {
        JSONObject result = new JSONObject();
        Object value = null;
        Object originalValue = row.getOriginalValue(columnSyncDetails.getString("COLUMN_NAME"));
        if (columnSyncDetails != null) {
            value = row.get(columnSyncDetails.getString("COLUMN_NAME"));
            String stringValue = value == null ? null : value.toString();
            value = DBSyncModulesContainer.getColumnValue((String)row.getOriginalTableName(), (String)columnSyncDetails.getString("COLUMN_NAME"), (String)stringValue, (JSONObject)columnSyncDetails);
            stringValue = originalValue == null ? null : originalValue.toString();
            originalValue = DBSyncModulesContainer.getColumnValue((String)row.getOriginalTableName(), (String)columnSyncDetails.getString("COLUMN_NAME"), (String)stringValue, (JSONObject)columnSyncDetails);
        }
        result.put("NAME", (Object)columnSyncDetails.getString("MODULE_COLUMN_NAME"));
        if (value != null) {
            result.put("VALUE", (Object)value.toString());
        } else {
            result.put("VALUE", JSONObject.NULL);
        }
        if (originalValue != null) {
            result.put("ORIGINAL_VALUE", (Object)originalValue.toString());
        } else {
            result.put("ORIGINAL_VALUE", JSONObject.NULL);
        }
        return result;
    }

    private static String getDCList(String domainName) {
        String result = null;
        try {
            Properties domainProperties = DomainHandler.getConfiguredValuesForModify(domainName);
            List dcList = (List)domainProperties.get("DOMAIN_CONTROLLER_LIST");
            for (String dc : dcList) {
                if (result == null) {
                    result = dc;
                    continue;
                }
                result = result + "," + dc;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    private void addAUDComputerEventReadColumns(Row row) throws Exception {
        Properties values = DomainHandler.getDNSName((String)row.get("OBJECT_GUID"));
        this.addColumn("NAME", values.getProperty("NAME"), null);
        this.addColumn("DNS_NAME", values.getProperty("DNS_NAME"), null);
        this.addColumn("DOMAIN_NAME", values.getProperty("DOMAIN_NAME"), null);
        this.addColumn("PRODUCT_SEQ_NUMBER", ProductUniqueSeqGenerator.getCurrentSeqNumber(), null);
        this.addColumn("LICENSE_CODE", LicenseManager.getLicenseCode(), null);
        Integer machineType = (Integer)row.get("MACHINE_TYPE");
        this.addColumn("HOST_STATUS", ADAPPublisherImpl.getStatusFromMachinetype(machineType), null);
        if (machineType != null) {
            if (machineType == 16 || machineType == 32) {
                this.addColumn("HOST_TYPE", "201", null);
            } else if (machineType == 8192 || machineType == 4096) {
                this.addColumn("HOST_TYPE", "301", null);
            } else if (machineType == 4 || machineType == 8) {
                this.addColumn("HOST_TYPE", "501", null);
            }
        }
    }

    private void addADSMDCConfigurationColumns(Row row, int operation) throws Exception {
        String dcName = (String)row.get("DOMAIN_CONTROLLER_NAME");
        String domain = (String)row.get("DOMAIN_NAME");
        this.addColumn("NAME", dcName, null);
        this.addColumn("DOMAIN_NAME", domain, null);
        this.addColumn("DNS_NAME", dcName, null);
        this.addColumn("PRODUCT_SEQ_NUMBER", ProductUniqueSeqGenerator.getCurrentSeqNumber(), null);
        this.addColumn("LICENSE_CODE", LicenseManager.getLicenseCode(), null);
        this.addColumn("HOST_TYPE", "101", null);
        Integer host_status = new Integer(1);
        if (operation == 1) {
            try {
                Integer licenseCount = Integer.parseInt(LicenseUtil.getLicenseProperty("DomainController", "NumberOfDomainControllers"));
                int enabledSchedulers = EventSchedulerUtil.getEventSchedulers(3).size();
                host_status = licenseCount > enabledSchedulers ? 3 : 4;
            }
            catch (Exception exp) {
                out.info("Exception while getting host status exp details : " + exp.getMessage());
            }
        }
        this.addColumn("HOST_STATUS", ADAPPublisherImpl.getStatusFromAdminstatus(host_status), null);
        this.addColumn("ADMIN_STATUS", host_status.toString(), null);
    }

    private void addTaskInputColumns(Row row) throws Exception {
        String objectGuid = MSHandler.instanceVsGUIDMap.get((Long)row.get("INSTANCE_ID"));
        MSHandler.instanceVsGUIDMap.remove((Long)row.get("INSTANCE_ID"));
        Properties values = DomainHandler.getDNSName(objectGuid);
        this.addColumn("NAME", values.getProperty("NAME"), null);
        this.addColumn("DNS_NAME", values.getProperty("DNS_NAME"), null);
        this.addColumn("DOMAIN_NAME", values.getProperty("DOMAIN_NAME"), null);
        this.addColumn("PRODUCT_SEQ_NUMBER", ProductUniqueSeqGenerator.getCurrentSeqNumber(), null);
        this.addColumn("LICENSE_CODE", LicenseManager.getLicenseCode(), null);
        this.addColumn("HOST_STATUS", ADAPPublisherImpl.getStatusFromAdminstatus((Integer)row.get("ADMIN_STATUS")), null);
    }

    private void addScheduledTaskColumns(Row row) throws Exception {
        Properties values = DomainHandler.getDNSNameForDC((Long)row.get("SCHEDULE_ID"));
        this.addColumn("NAME", values.getProperty("DOMAIN_CONTROLLER_NAME"), null);
        this.addColumn("DNS_NAME", values.getProperty("DOMAIN_CONTROLLER_NAME"), null);
        this.addColumn("DOMAIN_NAME", values.getProperty("DOMAIN_NAME"), null);
        this.addColumn("PRODUCT_SEQ_NUMBER", ProductUniqueSeqGenerator.getCurrentSeqNumber(), null);
        this.addColumn("LICENSE_CODE", LicenseManager.getLicenseCode(), null);
        this.addColumn("HOST_STATUS", ADAPPublisherImpl.getStatusFromAdminstatus((Integer)row.get("ADMIN_STATUS")), null);
    }

    private static String getStatusFromAdminstatus(Integer admin_Status) {
        String status = "0";
        if (admin_Status != null && admin_Status == 3) {
            status = "1";
        }
        return status;
    }

    private static String getStatusFromMachinetype(Integer machine_Type) {
        String status = "0";
        if (machine_Type != null && (machine_Type == 16 || machine_Type == 4096)) {
            status = "1";
        }
        return status;
    }
}

