/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.export;

import com.adventnet.sym.adsm.auditing.server.delegation.AdvancedGpoHandler;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.csvreader.CsvReader;
import com.csvreader.CsvWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;

public class AuditGPOCsvWriter {
    private static AuditGPOCsvWriter auditGPOCsvWriter = null;
    private static AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle();
    private static final String[] HEADERS = new String[]{"Machine Name", "Policy Target", "Subcategory", "Subcategory GUID", "Inclusion Setting", "Exclusion Setting", "Setting Value"};

    private AuditGPOCsvWriter() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AuditGPOCsvWriter getInstance() {
        if (auditGPOCsvWriter != null) return auditGPOCsvWriter;
        Class<AuditGPOCsvWriter> clazz = AuditGPOCsvWriter.class;
        synchronized (AuditGPOCsvWriter.class) {
            auditGPOCsvWriter = new AuditGPOCsvWriter();
            // ** MonitorExit[var0] (shouldn't be in output)
            return auditGPOCsvWriter;
        }
    }

    public synchronized void writeToCsvFile(Object object) {
        HashMap queueMap = new HashMap();
        Hashtable hashtable = (Hashtable)object;
        Set hashtableSet = hashtable.keySet();
        Iterator iter = hashtableSet.iterator();
        while (iter.hasNext()) {
            String keyName = iter.next().toString();
            queueMap.put(keyName, hashtable.get(keyName));
        }
        String auditCsvFilePath = (String)queueMap.get("auditCsvPath");
        String auditingType = (String)queueMap.get("auditingType");
        String gpoGuid = (String)queueMap.get("auditgpoGuid");
        String domainName = (String)queueMap.get("domainName");
        AuditGPOCsvWriter.writeCsv(auditCsvFilePath, AdvancedGpoHandler.getInstance().getAdvancedAuditPolicies(auditingType, auditCsvFilePath, domainName, gpoGuid));
    }

    public synchronized String readFromCsvFile(Object object) {
        return AuditGPOCsvWriter.readFromCsv((String)object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeCsv(String filePath, String policyString) {
        CsvWriter csvWriter = null;
        try {
            csvWriter = new CsvWriter((Writer)new FileWriter(filePath, false), ',');
            boolean alreadyExists = new File(filePath).exists();
            if (!alreadyExists) {
                for (int i = 0; i < HEADERS.length; ++i) {
                    csvWriter.write(HEADERS[i]);
                }
                csvWriter.endRecord();
            }
            String[] policyStringRow = policyString.split("\n");
            for (int i = 0; i < policyStringRow.length; ++i) {
                String[] s = policyStringRow[i].split(",");
                for (int j = 0; j < s.length; ++j) {
                    csvWriter.write(s[j]);
                }
                csvWriter.endRecord();
            }
            csvWriter.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                csvWriter.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static String readFromCsv(String csvFilename) {
        String policyString = "";
        try {
            Object row = null;
            CsvReader csvReader = new CsvReader((Reader)new FileReader(csvFilename), ',');
            csvReader.readHeaders();
            while (csvReader.readRecord()) {
                for (int i = 0; i < HEADERS.length; ++i) {
                    policyString = policyString + csvReader.get(HEADERS[i]) + (i != 6 ? "," : "");
                }
                policyString = policyString + "\n";
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return policyString;
    }
}

