/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.export;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.SortColumn;
import com.adventnet.ds.query.Table;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.export.JRDesignUtil;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import net.sf.jasperreports.engine.JRBand;
import net.sf.jasperreports.engine.JRBox;
import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRParameter;
import net.sf.jasperreports.engine.base.JRBaseBox;
import net.sf.jasperreports.engine.design.JRDesignBand;
import net.sf.jasperreports.engine.design.JRDesignElement;
import net.sf.jasperreports.engine.design.JRDesignExpression;
import net.sf.jasperreports.engine.design.JRDesignField;
import net.sf.jasperreports.engine.design.JRDesignParameter;
import net.sf.jasperreports.engine.design.JRDesignQuery;
import net.sf.jasperreports.engine.design.JRDesignReportFont;
import net.sf.jasperreports.engine.design.JRDesignStaticText;
import net.sf.jasperreports.engine.design.JRDesignTextField;
import net.sf.jasperreports.engine.design.JasperDesign;

public class AuditSubreport {
    private static AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle();
    private JasperDesign jasperDesign = null;
    private JRDesignBand headerBand = null;
    private JRDesignBand detailBand = null;
    private JRDesignBand titleBand = null;
    private JRDesignReportFont normalFont = null;
    public int columnWidth = 535;
    public int width;
    public int pgWidth = 0;
    public int mainBandWidth = 0;
    private ArrayList<String> columnstrings = null;
    private ArrayList<String> columnDisplayStrings = null;

    public AuditSubreport(int subWidth, String reportType, String query, Long subreportCvID, String columnName, String parameterClass, String headingName) {
        try {
            this.mainBandWidth = subWidth;
            this.jasperDesign = new JasperDesign();
            this.headerBand = new JRDesignBand();
            this.jasperDesign.setColumnHeader((JRBand)this.headerBand);
            this.detailBand = new JRDesignBand();
            this.jasperDesign.setDetail((JRBand)this.detailBand);
            this.titleBand = new JRDesignBand();
            this.detailBand.setHeight(30);
            JRDesignReportFont columnFont = JRDesignUtil.getJRDesignReportFont("Arial_normal", "Verdana", 9, true, false);
            JRDesignStaticText txt = JRDesignUtil.getJRDesignStaticText(0, 0, subWidth, 20, columnFont, new Color(255, 255, 255), new Color(0, 0, 0), (byte)1, (byte)2);
            txt.setMode((byte)1);
            txt.setStretchType((byte)1);
            txt.setPositionType((byte)2);
            txt.setPrintRepeatedValues(true);
            txt.setRemoveLineWhenBlank(false);
            txt.setPrintInFirstWholeBand(false);
            txt.setPrintWhenDetailOverflows(false);
            txt.setPdfFontName("Helvetica-Bold");
            txt.setBold(true);
            Object c1 = null;
            txt.setBackcolor(new Color(239, 239, 231));
            txt.setForecolor(Color.BLACK);
            txt.setText(headingName);
            txt.setLeftPadding(4);
            txt.setRightPadding(4);
            txt.setBorderColor(new Color(155, 166, 109));
            txt.setLeftBorder((byte)5);
            txt.setTopBorder((byte)5);
            txt.setBottomBorder((byte)5);
            txt.setRightBorder((byte)5);
            this.titleBand.addElement((JRDesignElement)txt);
            this.titleBand.setHeight(20);
            this.jasperDesign.setTitle((JRBand)this.titleBand);
            this.normalFont = JRDesignUtil.getJRDesignReportFont("Arial_normal", "Verdana", 9, false, false);
            this.jasperDesign.setName("GPO Settings Subreport");
            this.addNoDataBand("No details found", null, this.jasperDesign, headingName);
            this.jasperDesign.setWhenNoDataType((byte)4);
            this.jasperDesign.setLeftMargin(0);
            this.jasperDesign.setRightMargin(0);
            this.jasperDesign.setBottomMargin(0);
            this.jasperDesign.setTopMargin(0);
            this.setQuery(query);
            this.setColumns(subreportCvID);
            this.addParameter(columnName, parameterClass);
            this.pgWidth = this.addDetails(reportType);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void addNoDataBand(String noDataText, String reportName, JasperDesign jasperDesign, String headingName) throws Exception {
        JRDesignBand titleBand = (JRDesignBand)jasperDesign.getTitle().clone();
        JRElement[] elements1 = titleBand.getElements();
        for (int i = 0; i < elements1.length; ++i) {
            titleBand.removeElement((JRDesignElement)elements1[i]);
        }
        titleBand.setHeight(80);
        if (reportName == null) {
            JRDesignReportFont columnFont = JRDesignUtil.getJRDesignReportFont("Arial_normal", "Verdana", 9, true, false);
            JRDesignStaticText heading = JRDesignUtil.getJRDesignStaticText(0, 0, this.mainBandWidth, 20, columnFont, new Color(255, 255, 255), new Color(0, 0, 0), (byte)1, (byte)2);
            heading.setBackcolor(new Color(239, 239, 231));
            heading.setForecolor(Color.BLACK);
            heading.setBold(true);
            heading.setText(headingName);
            heading.setLeftPadding(4);
            heading.setRightPadding(4);
            heading.setBorderColor(new Color(155, 166, 109));
            heading.setLeftBorder((byte)5);
            heading.setTopBorder((byte)5);
            heading.setBottomBorder((byte)5);
            heading.setRightBorder((byte)5);
            titleBand.addElement((JRDesignElement)heading);
        }
        JRDesignReportFont columnFont = JRDesignUtil.getJRDesignReportFont("Arial_normal", "Verdana", 9, true, false);
        JRDesignStaticText dataText = JRDesignUtil.getJRDesignStaticText(0, 20, this.mainBandWidth, 50, columnFont, new Color(255, 255, 255), new Color(0, 0, 0), (byte)1, (byte)2);
        dataText.setForecolor(Color.BLACK);
        dataText.setBold(true);
        dataText.setText(noDataText);
        dataText.setTextAlignment((byte)2);
        dataText.setBorderColor(new Color(155, 166, 109));
        dataText.setLeftBorder((byte)5);
        dataText.setTopBorder((byte)5);
        dataText.setBottomBorder((byte)5);
        dataText.setRightBorder((byte)5);
        titleBand.addElement((JRDesignElement)dataText);
        jasperDesign.setNoData((JRBand)titleBand);
    }

    public void setColumns(Long cvID) {
        this.columnstrings = new ArrayList();
        this.columnDisplayStrings = new ArrayList();
        try {
            String tableName = "AUDColumnConfiguration";
            Table table = Table.getTable((String)tableName);
            SelectQueryImpl query = new SelectQueryImpl(table);
            Criteria criteria = new Criteria(Column.getColumn((String)tableName, (String)"CV_ID"), (Object)cvID, 0);
            criteria = criteria.and(Column.getColumn((String)tableName, (String)"VISIBLE"), (Object)true, 0);
            query.setCriteria(criteria);
            query.addSelectColumn(Column.getColumn((String)tableName, (String)"COLUMNALIAS"));
            query.addSelectColumn(Column.getColumn((String)tableName, (String)"COLUMN_CONF_ID"));
            query.addSelectColumn(Column.getColumn((String)tableName, (String)"CV_ID"));
            query.addSelectColumn(Column.getColumn((String)tableName, (String)"DISPLAYNAME"));
            query.addSortColumn(new SortColumn(Column.getColumn((String)tableName, (String)"COLUMNINDEX"), true));
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)query);
            Iterator iterator = dataObject.getRows(tableName);
            while (iterator.hasNext()) {
                Row row = (Row)iterator.next();
                this.columnstrings.add((String)row.get("COLUMNALIAS"));
                this.columnDisplayStrings.add(rb.getString((String)row.get("DISPLAYNAME")));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public int addDetails(String reportType) {
        int pageWidth = 0;
        int x = 0;
        Hashtable columnWidths = this.calculateWidth(reportType);
        JRBaseBox columnBox = new JRBaseBox();
        columnBox.setTopBorder((byte)5);
        columnBox.setTopBorderColor(new Color(155, 166, 109));
        columnBox.setBottomBorder((byte)5);
        columnBox.setBottomBorderColor(new Color(155, 166, 109));
        JRBaseBox valueBox = new JRBaseBox();
        valueBox.setTopBorder((byte)5);
        valueBox.setTopBorderColor(new Color(155, 166, 109));
        valueBox.setBottomBorder((byte)5);
        valueBox.setBottomBorderColor(new Color(155, 166, 109));
        try {
            this.headerBand.setHeight(25);
            this.detailBand.setHeight(20);
            JRDesignField field = null;
            for (int i = 0; i < this.columnstrings.size(); ++i) {
                String columnName = this.columnstrings.get(i);
                field = new JRDesignField();
                field.setName(columnName);
                if (columnName.equals("TIME_GENERATED")) {
                    field.setValueClass(Long.class);
                } else {
                    field.setValueClass(String.class);
                }
                this.jasperDesign.addField((JRField)field);
                this.width = (Integer)columnWidths.get(rb.getString(this.columnDisplayStrings.get(i)));
                this.width = this.mainBandWidth / this.columnstrings.size();
                if (i == this.columnstrings.size() - 1 && pageWidth + this.width < this.mainBandWidth) {
                    this.width = this.mainBandWidth - pageWidth;
                }
                pageWidth += this.width;
                JRDesignStaticText headerTxt = JRDesignUtil.getJRDesignStaticText(x, 0, this.width, 25, this.normalFont, new Color(255, 255, 255), new Color(0, 0, 0), (byte)1, (byte)2);
                headerTxt.setMode((byte)1);
                headerTxt.setStretchType((byte)0);
                headerTxt.setPositionType((byte)2);
                headerTxt.setKey(this.columnDisplayStrings.get(i));
                headerTxt.setPrintRepeatedValues(true);
                headerTxt.setBox((JRBox)columnBox);
                headerTxt.setPrintInFirstWholeBand(false);
                headerTxt.setPrintWhenDetailOverflows(false);
                headerTxt.setBackcolor(new Color(239, 239, 231));
                headerTxt.setBorderColor(new Color(155, 166, 109));
                headerTxt.setLeftBorder((byte)5);
                if (i == this.columnstrings.size() - 1) {
                    headerTxt.setRightBorder((byte)5);
                }
                headerTxt.setForecolor(Color.BLACK);
                headerTxt.setText(rb.getString(this.columnDisplayStrings.get(i)));
                headerTxt.setLeftPadding(2);
                headerTxt.setRightPadding(2);
                this.headerBand.addElement((JRDesignElement)headerTxt);
                JRDesignTextField txtField = JRDesignUtil.getJRDesignTextField(x, 0, this.width, 20, this.normalFont, new Color(255, 255, 255), new Color(0, 0, 0), (byte)1, (byte)2);
                JRDesignExpression exp = new JRDesignExpression();
                exp.setValueClass(String.class);
                if (columnName.equals("TIME_GENERATED")) {
                    exp.setText("$F{" + columnName + "}.longValue() == 0L ? \"-\" : com.adventnet.sym.adsm.common.server.util.TimeUtil.formatDate(($F{" + columnName + "}.longValue()*1000L),\"MMM dd,yyyy hh:mm:ss a\")");
                } else {
                    exp.setText("$F{" + columnName + "} == null ? \"-\" : $F{" + columnName + "}");
                }
                txtField.setBox((JRBox)valueBox);
                txtField.setExpression((JRExpression)exp);
                txtField.setLeftBorder((byte)5);
                if (i == this.columnstrings.size() - 1) {
                    txtField.setRightBorder((byte)5);
                }
                txtField.setLeftPadding(2);
                txtField.setRightPadding(2);
                this.detailBand.setSplitAllowed(false);
                txtField.setPrintWhenDetailOverflows(true);
                txtField.setPrintRepeatedValues(true);
                txtField.setPrintInFirstWholeBand(true);
                txtField.setBorderColor(new Color(155, 166, 109));
                this.detailBand.addElement((JRDesignElement)txtField);
                if (reportType.toLowerCase().indexOf("xls") != -1) {
                    x += this.width + 0;
                    continue;
                }
                x += this.width + 0;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return pageWidth;
    }

    public void setQuery(String query) {
        JRDesignQuery designQuery = new JRDesignQuery();
        designQuery.setText(query);
        this.jasperDesign.setQuery(designQuery);
    }

    public void addParameter(String paramterName, String parameterValueClass) throws Exception {
        JRDesignParameter parameter = new JRDesignParameter();
        parameter.setName(paramterName);
        parameter.setValueClassName(parameterValueClass);
        this.jasperDesign.addParameter((JRParameter)parameter);
    }

    public JasperDesign getDesign() {
        return this.jasperDesign;
    }

    public Hashtable calculateWidth(String reportType) {
        Hashtable<String, Integer> columnWidths = new Hashtable<String, Integer>();
        int width = this.columnWidth / this.columnDisplayStrings.size();
        if (width < 60) {
            width = 60;
        }
        String val = null;
        for (String string : this.columnDisplayStrings) {
            int length;
            StringBuffer sb = new StringBuffer();
            sb.append(string);
            val = sb.toString();
            if (val == null) {
                val = "-";
            }
            String str = val.toString();
            int strLength = str.length();
            if (string.length() > strLength) {
                strLength = string.length();
            }
            if ((length = strLength * 4) < width) {
                length = width;
            }
            columnWidths.put(string, length);
        }
        ArrayList<String> lengthyList = new ArrayList<String>();
        int remTotalWidth = 0;
        if (!reportType.toLowerCase().equals("csvde")) {
            for (String string : this.columnDisplayStrings) {
                if (columnWidths.isEmpty()) continue;
                int w = (Integer)columnWidths.get(string);
                if (w > width) {
                    lengthyList.add(string);
                    continue;
                }
                remTotalWidth += width - w;
            }
        }
        int extraWidth = 0;
        if (lengthyList.size() > 0) {
            extraWidth = remTotalWidth / lengthyList.size();
        }
        for (int i = 0; i < lengthyList.size(); ++i) {
            String columnName = (String)lengthyList.get(i);
            int w = (Integer)columnWidths.get(columnName);
            columnWidths.put(columnName, w + extraWidth);
        }
        return columnWidths;
    }
}

