/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.export;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.auditing.server.reports.ExportUtil;
import com.adventnet.sym.adsm.auditing.server.transformers.ColumnTransformer;
import com.adventnet.sym.adsm.auditing.server.transformers.ColumnTransformerAPI;
import com.adventnet.sym.adsm.common.server.export.AuditSubreport;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.sql.ADAPSQLQueryAPI;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import java.awt.Color;
import java.io.File;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;
import net.sf.jasperreports.engine.JRBand;
import net.sf.jasperreports.engine.JRBox;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRDefaultStyleProvider;
import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRFont;
import net.sf.jasperreports.engine.JRSubreportParameter;
import net.sf.jasperreports.engine.JasperCompileManager;
import net.sf.jasperreports.engine.base.JRBaseBox;
import net.sf.jasperreports.engine.design.JRDesignBand;
import net.sf.jasperreports.engine.design.JRDesignElement;
import net.sf.jasperreports.engine.design.JRDesignExpression;
import net.sf.jasperreports.engine.design.JRDesignField;
import net.sf.jasperreports.engine.design.JRDesignFrame;
import net.sf.jasperreports.engine.design.JRDesignReportFont;
import net.sf.jasperreports.engine.design.JRDesignSection;
import net.sf.jasperreports.engine.design.JRDesignStaticText;
import net.sf.jasperreports.engine.design.JRDesignSubreport;
import net.sf.jasperreports.engine.design.JRDesignSubreportParameter;
import net.sf.jasperreports.engine.design.JRDesignTextField;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.type.SplitTypeEnum;
import net.sf.jasperreports.engine.type.StretchTypeEnum;

public class JRDesignUtil {
    public static int pageHeight = 842;
    public static int columnWidth = 535;
    public static int columnSpacing = 0;
    public static int leftMargin = 30;
    public static int rightMargin = 30;
    public static int topMargin = 20;
    public static int bottomMargin = 20;
    public static int x = 0;
    public static int width;
    public static int normalSize;
    public static int groupPad;
    private static String jasperDir;
    public static AdventNetResourceBundle rb;

    public static JRDesignReportFont getJRDesignReportFont(String name, String fontName, int size, boolean bold, boolean isDefault) {
        JRDesignReportFont font = new JRDesignReportFont();
        font.setName(name);
        font.setDefault(isDefault);
        font.setFontName(fontName);
        font.setSize(size);
        font.setBold(bold);
        if (name.equalsIgnoreCase("Arial")) {
            font.setPdfFontName("Helvetica");
        }
        font.setPdfEncoding("Cp1252");
        font.setPdfEmbedded(false);
        return font;
    }

    public static JRDesignTextField getJRDesignTextField(int x, int y, int width, int height, JRDesignReportFont font, Color backColor, Color foreColor, byte hAlign, byte vAlign) {
        return JRDesignUtil.getJRDesignTextField(x, y, width, height, font, backColor, foreColor, hAlign, vAlign, true);
    }

    public static JRDesignStaticText getJRDesignStaticText(int x, int y, int width, int height, JRDesignReportFont font, Color backColor, Color foreColor, byte hAlign, byte vAlign) {
        JRDesignStaticText stxt = new JRDesignStaticText();
        stxt.setX(x);
        stxt.setY(y);
        stxt.setWidth(width);
        stxt.setHeight(height);
        stxt.setMode((byte)1);
        stxt.setPositionType((byte)2);
        if (font != null) {
            stxt.setFont((JRFont)font);
        }
        if (hAlign >= 0) {
            stxt.setTextAlignment(hAlign);
        }
        if (vAlign >= 0) {
            stxt.setVerticalAlignment(vAlign);
        }
        if (backColor != null) {
            stxt.setBackcolor(backColor);
        }
        if (foreColor != null) {
            stxt.setForecolor(foreColor);
        }
        return stxt;
    }

    public static JRDesignTextField getJRDesignTextField(int x, int y, int width, int height, JRDesignReportFont font, Color backColor, Color foreColor, byte hAlign, byte vAlign, boolean isStrech) {
        JRDesignTextField textField = new JRDesignTextField();
        textField.setBlankWhenNull(true);
        textField.setX(x);
        textField.setY(y);
        textField.setWidth(width);
        textField.setHeight(height);
        textField.setMode((byte)1);
        textField.setStretchWithOverflow(true);
        if (isStrech) {
            textField.setStretchType((byte)1);
        }
        textField.setPositionType((byte)2);
        if (font != null) {
            textField.setFont((JRFont)font);
        }
        if (hAlign >= 0) {
            textField.setTextAlignment(hAlign);
        }
        if (vAlign >= 0) {
            textField.setVerticalAlignment(vAlign);
        }
        if (backColor != null) {
            textField.setBackcolor(backColor);
        }
        if (foreColor != null) {
            textField.setForecolor(foreColor);
        }
        return textField;
    }

    public static void fillNoDataBand(JasperDesign jasperDesign, JRDesignBand detailBand, String reportType) {
        try {
            detailBand.setHeight(40);
            JRDesignReportFont columnFont = JRDesignUtil.getJRDesignReportFont(ExportUtil.font1, ExportUtil.font1, normalSize, true, false);
            JRDesignReportFont normalFont = JRDesignUtil.getJRDesignReportFont(ExportUtil.font1, ExportUtil.font1, normalSize, false, false);
            JRDesignReportFont pageFooterFont = JRDesignUtil.getJRDesignReportFont(ExportUtil.font1, ExportUtil.font1, normalSize + 1, true, false);
            JRDesignStaticText txt = JRDesignUtil.getJRDesignStaticText(50, 0, 200, 35, columnFont, new Color(255, 255, 255), new Color(0, 0, 0), (byte)1, (byte)2);
            txt.setMode((byte)1);
            txt.setStretchType((byte)1);
            txt.setPositionType((byte)2);
            txt.setKey("NoData");
            txt.setPrintRepeatedValues(true);
            txt.setRemoveLineWhenBlank(false);
            txt.setPrintInFirstWholeBand(false);
            txt.setPrintWhenDetailOverflows(false);
            JRBaseBox box = new JRBaseBox();
            box.setTopBorder((byte)5);
            box.setTopBorderColor(new Color(155, 166, 109));
            box.setBottomBorder((byte)1);
            box.setBottomBorderColor(new Color(155, 166, 109));
            box.setLeftPadding(1);
            detailBand.setSplitAllowed(false);
            txt.setBox((JRBox)box);
            txt.setBackcolor(new Color(239, 239, 231));
            txt.setForecolor(Color.BLACK);
            txt.setText(rb.getString("adap.JRDesignUtil.No_Data_Found"));
            detailBand.addElement((JRDesignElement)txt);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static int fillBand(Hashtable columnWidths, JasperDesign jasperDesign, JRDesignBand columnHeaderBand, JRDesignBand detailBand, ArrayList attributeList, String reportType, int isSubreport, JRDesignBand colBand, JRDesignBand subReportBand, HashMap inputParamsMap, HashMap addnSQLPropsMap, String searchCriteria) {
        int pageWidth = 0;
        pageHeight = 842;
        columnSpacing = 0;
        leftMargin = 30;
        rightMargin = 30;
        topMargin = 20;
        bottomMargin = 20;
        int x = 0;
        int subX = 0;
        normalSize = 9;
        groupPad = 10;
        try {
            colBand.setHeight(isSubreport * 35);
            if (isSubreport == 0) {
                columnHeaderBand.setHeight(35);
                detailBand.setHeight(30);
            } else {
                columnHeaderBand.setHeight(0);
                detailBand.setHeight(65);
            }
            JRDesignReportFont columnFont = JRDesignUtil.getJRDesignReportFont(ExportUtil.font1, ExportUtil.font1, normalSize, true, false);
            JRDesignReportFont normalFont = JRDesignUtil.getJRDesignReportFont(ExportUtil.font1, ExportUtil.font1, normalSize, false, false);
            JRDesignReportFont pageFooterFont = JRDesignUtil.getJRDesignReportFont(ExportUtil.font1, ExportUtil.font1, normalSize + 1, true, false);
            String dbServerName = CommonUtil.getDBServerName();
            for (int i = 0; i < attributeList.size(); ++i) {
                HashMap columnMap = (HashMap)attributeList.get(i);
                String displayName = rb.getString((String)columnMap.get("DISPLAYNAME"));
                boolean bgColumn = columnMap.get("BGCOLUMN") != null ? ((Boolean)columnMap.get("BGCOLUMN")).booleanValue() : false;
                boolean bl = bgColumn = columnMap.get("SUBREPORT_CV_ID") != null ? false : bgColumn;
                if (bgColumn) continue;
                String columnName = (String)columnMap.get("COLUMNALIAS");
                String dateFormat = (String)columnMap.get("DATE_FORMAT");
                Long columnConfId = (Long)columnMap.get("COLUMN_CONF_ID");
                ColumnTransformer transformer = ColumnTransformerAPI.getInstance().getColumnTransformer(columnConfId);
                String parameterClass = "java.lang.String";
                Long subreportCvID = null;
                if (columnMap.get("SUBREPORT_CV_ID") != null) {
                    subreportCvID = (Long)columnMap.get("SUBREPORT_CV_ID");
                }
                if (columnMap.get("SUBREPORT_PARAM_DATATYPE") != null && !dbServerName.equalsIgnoreCase("postgres")) {
                    parameterClass = "java.lang.Object";
                } else if (columnMap.get("SUBREPORT_PARAM_DATATYPE") != null && dbServerName.equalsIgnoreCase("postgres")) {
                    parameterClass = (String)columnMap.get("SUBREPORT_PARAM_DATATYPE");
                }
                if (dateFormat != null) {
                    parameterClass = "java.lang.Long";
                }
                JRDesignField field = new JRDesignField();
                field.setName(columnName.toString());
                field.setValueClassName(parameterClass);
                jasperDesign.addField((JRField)field);
                JRDesignStaticText txt = null;
                width = (Integer)columnWidths.get(displayName);
                txt = JRDesignUtil.getJRDesignStaticText(x, 0, width, 35, columnFont, new Color(255, 255, 255), new Color(0, 0, 0), (byte)1, (byte)2);
                txt.setMode((byte)1);
                txt.setPositionType((byte)2);
                txt.setKey(displayName.toString());
                txt.setPrintRepeatedValues(true);
                txt.setRemoveLineWhenBlank(false);
                txt.setPrintInFirstWholeBand(false);
                txt.setPrintWhenDetailOverflows(false);
                txt.setPdfFontName("Helvetica-Bold");
                txt.setBold(true);
                Object c1 = null;
                txt.setBackcolor(Color.LIGHT_GRAY);
                txt.setForecolor(Color.BLACK);
                txt.setText(displayName);
                txt.setLeftPadding(4);
                txt.setRightPadding(4);
                txt.setBorderColor(new Color(155, 166, 109));
                if (!reportType.equals("html") || i == 0) {
                    txt.setLeftBorder((byte)5);
                }
                txt.setTopBorder((byte)5);
                txt.setBottomBorder((byte)5);
                txt.setRightBorder((byte)5);
                if (subreportCvID == null) {
                    if (isSubreport == 0) {
                        columnHeaderBand.addElement((JRDesignElement)txt);
                    } else {
                        detailBand.addElement((JRDesignElement)txt);
                    }
                    pageWidth += width;
                }
                if (reportType.toLowerCase().indexOf("xls") != -1 || reportType.toLowerCase().indexOf("csv") != -1) {
                    JRDesignExpression express = new JRDesignExpression();
                    express.setValueClass(Boolean.class);
                    express.setText("$V{PAGE_NUMBER}.intValue() == 1 ? Boolean.TRUE : Boolean.FALSE");
                    if (isSubreport == 0) {
                        columnHeaderBand.setPrintWhenExpression((JRExpression)express);
                    } else {
                        detailBand.setPrintWhenExpression((JRExpression)express);
                    }
                }
                if (subreportCvID == null) {
                    JRDesignTextField txtField = JRDesignUtil.getJRDesignTextField(x, isSubreport * 35, width, 30, normalFont, new Color(255, 255, 255), new Color(0, 0, 0), (byte)1, (byte)2);
                    JRDesignExpression exp = new JRDesignExpression();
                    exp.setValueClass(String.class);
                    if (dateFormat == null) {
                        exp.setText("$F{" + columnName + "} == null ? \"-\" : $F{" + columnName + "}");
                        if (columnName.equals("OBJECT_GUID") && transformer.getClass().getName().endsWith("GPOSettingsTransformer")) {
                            exp.setText("$F{" + columnName + "} == null ? \"-\" : com.adventnet.sym.adsm.auditing.server.gpo.GPODetailsAPI.getInstance().getGPOName($F{" + columnName + "}.toLowerCase())");
                        }
                    } else {
                        exp.setText("$F{" + columnName + "}.longValue() == 0L ? \"-\" : com.adventnet.sym.adsm.common.server.util.TimeUtil.formatDate(($F{" + columnName + "}.longValue()*1000L),\"" + dateFormat + "\")");
                    }
                    if (columnName.equals("ACCESS_TYPE") && "ADAPUserAuditInfo".equals((String)columnMap.get("TABLEALIAS"))) {
                        exp.setText("com.adventnet.sym.adsm.common.server.admin.delegation.TDUtil.getAccessTypeText(Integer.parseInt($F{" + columnName + "}))");
                    } else if (columnName.equals("EVENT_TYPE") && "ADAPUserAuditInfo".equals((String)columnMap.get("TABLEALIAS"))) {
                        exp.setText("com.adventnet.sym.adsm.common.server.admin.delegation.TDUtil.getEventTypeText(Integer.parseInt($F{" + columnName + "}))");
                    } else if (columnName.equals("SEVERITY") && "ADAPUserAuditInfo".equals((String)columnMap.get("TABLEALIAS"))) {
                        exp.setText("com.adventnet.sym.adsm.common.server.admin.delegation.TDUtil.getSeverityText(Integer.parseInt($F{" + columnName + "}))");
                    }
                    txtField.setExpression((JRExpression)exp);
                    txtField.setPadding(4);
                    detailBand.setSplitAllowed(false);
                    txtField.setPrintWhenDetailOverflows(true);
                    txtField.setPrintRepeatedValues(true);
                    txtField.setPrintInFirstWholeBand(true);
                    txtField.setVerticalAlignment((byte)1);
                    if (!reportType.equals("html") || i == 0) {
                        txtField.setLeftBorder((byte)5);
                    }
                    txtField.setTopBorder((byte)5);
                    txtField.setBorderColor(new Color(155, 166, 109));
                    txtField.setRightBorder((byte)5);
                    txtField.setBottomBorder((byte)5);
                    detailBand.addElement((JRDesignElement)txtField);
                } else {
                    subReportBand.setSplitAllowed(true);
                    int pageWidth1 = pageWidth;
                    for (int j = i + 1; j < attributeList.size(); ++j) {
                        HashMap columnMap1 = (HashMap)attributeList.get(j);
                        String displayName1 = (String)columnMap.get("DISPLAYNAME");
                        pageWidth1 += ((Integer)columnWidths.get(displayName)).intValue();
                    }
                    AuditSubreport auditSubreport = new AuditSubreport(pageWidth1, reportType, JRDesignUtil.getSubreportQuery(subreportCvID, inputParamsMap, addnSQLPropsMap, searchCriteria, columnName), subreportCvID, columnName, parameterClass, displayName);
                    int subreportPageWidth = auditSubreport.pgWidth;
                    if (!new File(jasperDir).exists()) {
                        new File(jasperDir).mkdir();
                    }
                    String jasperFileName = jasperDir + File.separator + "AuditSubreport.jasper";
                    JasperDesign subReportDesign = auditSubreport.getDesign();
                    JasperCompileManager.compileReportToFile((JasperDesign)subReportDesign, (String)jasperFileName);
                    JRDesignSubreport subreport = new JRDesignSubreport((JRDefaultStyleProvider)subReportDesign);
                    subreport.setX(subX);
                    subreport.setPositionType((byte)2);
                    subreport.setStretchType((byte)0);
                    JRDesignSubreportParameter subreportParameter = new JRDesignSubreportParameter();
                    subreportParameter.setName(columnName);
                    JRDesignExpression expression = new JRDesignExpression();
                    if (columnName.equalsIgnoreCase("CHANGE_ID")) {
                        expression.setText("com.adventnet.sym.adsm.auditing.server.gpo.GPSettingsHandler.getChangeId($F{" + columnName + "})");
                    } else if (columnName.equalsIgnoreCase("USERNAMETEMP")) {
                        expression.setText("com.adventnet.sym.adsm.auditing.server.transformers.UserLogonActivityTransformer.userNameDisplay($F{" + columnName + "})");
                    } else {
                        expression.setText("$F{" + columnName + "}");
                    }
                    expression.setValueClassName(parameterClass);
                    subreportParameter.setExpression((JRExpression)expression);
                    subreport.addParameter((JRSubreportParameter)subreportParameter);
                    expression = new JRDesignExpression();
                    expression.setValueClass(Connection.class);
                    expression.setText("$P{REPORT_CONNECTION}");
                    subreport.setConnectionExpression((JRExpression)expression);
                    expression = new JRDesignExpression();
                    expression.setValueClass(String.class);
                    expression.setText("\"" + CommonUtil.escapeString(jasperFileName, new String[]{"\\"}) + "\"");
                    subreport.setExpression((JRExpression)expression);
                    subReportBand.addElement((JRDesignElement)subreport);
                    int currWidth = 0;
                    if (txt != null) {
                        currWidth = txt.getWidth();
                    }
                    currWidth = subreportPageWidth + 12;
                    txt.setWidth(currWidth);
                }
                if (subreportCvID != null) continue;
                if (reportType.toLowerCase().indexOf("xls") != -1) {
                    x += width;
                    continue;
                }
                x += width;
            }
            pageWidth = pageWidth < 595 ? 595 : (pageWidth += 120);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return pageWidth;
    }

    public static String getSubreportQuery(Long subreportCvID, HashMap inputParamsMap, HashMap addnSQLPropsMap, String searchCriteria, String columnName) {
        String queryString = "-";
        try {
            if (inputParamsMap.containsKey("isComplianceReport")) {
                String tableName = "AUDSQLQuery";
                Table table = Table.getTable((String)tableName);
                SelectQueryImpl query = new SelectQueryImpl(table);
                Criteria criteria = new Criteria(Column.getColumn((String)tableName, (String)"CV_ID"), (Object)subreportCvID, 0);
                query.setCriteria(criteria);
                query.addSelectColumn(Column.getColumn((String)tableName, (String)"CV_ID"));
                query.addSelectColumn(Column.getColumn((String)tableName, (String)"QUERY_ID"));
                query.addSelectColumn(Column.getColumn((String)tableName, (String)"SQL_STRING"));
                DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)query);
                Row row = dataObject.getRow(tableName);
                queryString = (String)row.get("SQL_STRING");
            } else {
                if (!inputParamsMap.isEmpty() && inputParamsMap.containsKey(columnName)) {
                    inputParamsMap.remove(columnName);
                }
                if ((queryString = ADAPSQLQueryAPI.getInstance().getSQLString(subreportCvID, searchCriteria, inputParamsMap, new HashMap(), 0)).indexOf("${ORDER_BY}") != -1) {
                    queryString = queryString.replace("${ORDER_BY}", "ORDER BY TIME_GENERATED DESC");
                }
                queryString = queryString.replace("'${" + columnName + "}'", "$P{" + columnName + "}");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return queryString;
    }

    public static Hashtable calculateWidth(ArrayList attributeList, ArrayList results, Hashtable multipleValuesSids, String reportType) {
        Hashtable<String, Integer> columnWidths = new Hashtable<String, Integer>();
        int width = columnWidth / attributeList.size();
        if (width < 100) {
            width = 100;
        }
        String val = null;
        for (Object object : attributeList) {
            int length;
            HashMap columnMap = (HashMap)object;
            String displayName = null;
            displayName = rb.getString((String)columnMap.get("DISPLAYNAME"));
            boolean bgColumn = columnMap.get("BGCOLUMN") != null ? ((Boolean)columnMap.get("BGCOLUMN")).booleanValue() : false;
            bgColumn = columnMap.get("SUBREPORT_CV_ID") != null ? false : bgColumn;
            StringBuffer sb = new StringBuffer();
            sb.append(displayName);
            val = sb.toString();
            if (val == null) {
                val = "-";
            }
            String str = val.toString();
            int strLength = str.length();
            if (displayName.length() > strLength) {
                strLength = displayName.length();
            }
            if ((length = strLength * 4 + 10) < width) {
                length = width;
            }
            if (bgColumn) continue;
            columnWidths.put(displayName, length);
        }
        ArrayList<String> lengthyList = new ArrayList<String>();
        int remTotalWidth = 0;
        if (!reportType.toLowerCase().equals("csvde")) {
            for (Object object : attributeList) {
                HashMap columnMap = (HashMap)object;
                boolean bgColumn = columnMap.get("BGCOLUMN") != null ? ((Boolean)columnMap.get("BGCOLUMN")).booleanValue() : false;
                bgColumn = columnMap.get("SUBREPORT_CV_ID") != null ? false : bgColumn;
                String columnName = rb.getString((String)columnMap.get("DISPLAYNAME"));
                if (columnWidths.isEmpty() || bgColumn) continue;
                int w = (Integer)columnWidths.get(columnName);
                if (w > width) {
                    lengthyList.add(columnName);
                    continue;
                }
                remTotalWidth += width - w;
            }
        }
        int extraWidth = 0;
        if (lengthyList.size() > 0) {
            extraWidth = remTotalWidth / lengthyList.size();
        }
        for (int i = 0; i < lengthyList.size(); ++i) {
            String columnName = (String)lengthyList.get(i);
            int w = (Integer)columnWidths.get(columnName);
            columnWidths.put(columnName, w + extraWidth);
        }
        return columnWidths;
    }

    public static JRFont getPDFExporterFont() {
        JRDesignReportFont font = new JRDesignReportFont();
        try {
            ResourceBundleMgr.getInstance();
            Locale locale = ResourceBundleMgr.getServerLocale();
            String language = locale.getLanguage();
            String pdfEncoding = "CP1252";
            String pdfFont = "Helvetica";
            if ("ja".equals(language)) {
                pdfFont = "KozMinPro-Regular";
                pdfEncoding = "UniJIS-UCS2-H";
            } else if ("zh".equals(language)) {
                pdfFont = "STSong-Light";
                pdfEncoding = "UniGB-UCS2-H";
            }
            font.setPdfEncoding(pdfEncoding);
            font.setPdfFontName(pdfFont);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return font;
    }

    public static String getCSVEncoder() {
        return rb.getString("adap.JRDesignUtil.cvsEncoder");
    }

    public static JRDesignReportFont getJRDesignReportFont(String name, JRFont reportPDFFont, int size, boolean bold, boolean isDefault) {
        JRDesignReportFont font = new JRDesignReportFont();
        font.setName(name);
        font.setDefault(isDefault);
        String fontName = reportPDFFont.getPdfFontName();
        String fontEncoding = reportPDFFont.getPdfEncoding();
        font.setFontName(fontName);
        font.setSize(size);
        font.setBold(bold);
        font.setPdfFontName(fontName);
        font.setPdfEncoding(fontEncoding);
        font.setPdfEmbedded(false);
        return font;
    }

    public static void fillBand(Hashtable columnWidths, JasperDesign jasperDesign, JRDesignBand columnHeaderBand, JRDesignBand detailBand, ArrayList attributeList, String reportType, AdventNetResourceBundle rb, ArrayList subReportList) {
        boolean isSplitAllowed = false;
        columnWidth = jasperDesign.getColumnWidth();
        columnSpacing = 0;
        leftMargin = 30;
        rightMargin = 30;
        topMargin = 20;
        bottomMargin = 20;
        normalSize = 9;
        groupPad = 10;
        int x = 0;
        boolean y = false;
        int width = columnWidth / attributeList.size();
        try {
            int i;
            JRDesignBand headerBand = new JRDesignBand();
            JRDesignBand detailBand1 = new JRDesignBand();
            ((JRDesignSection)jasperDesign.getDetailSection()).addBand((JRBand)headerBand);
            ((JRDesignSection)jasperDesign.getDetailSection()).addBand((JRBand)detailBand1);
            headerBand.setHeight(30);
            detailBand1.setHeight(30);
            columnHeaderBand.setHeight(0);
            JRBaseBox frameBox = new JRBaseBox();
            frameBox.setLeftBorder((byte)5);
            frameBox.setLeftBorderColor(new Color(216, 224, 230));
            frameBox.setRightBorder((byte)5);
            frameBox.setRightBorderColor(new Color(216, 224, 230));
            JRDesignFrame frame = new JRDesignFrame();
            frame.setX(0);
            frame.setY(0);
            frame.setWidth(columnWidth);
            frame.setHeight(30);
            frame.setStretchType(StretchTypeEnum.RELATIVE_TO_BAND_HEIGHT);
            frame.setBackcolor(new Color(51, 51, 51));
            frame.setBox((JRBox)frameBox);
            headerBand.addElement((JRDesignElement)frame);
            JRDesignFrame frame1 = new JRDesignFrame();
            frame1.setX(0);
            frame1.setY(0);
            frame1.setWidth(columnWidth);
            frame1.setHeight(30);
            frame1.setStretchType(StretchTypeEnum.RELATIVE_TO_BAND_HEIGHT);
            frame1.setBox((JRBox)frameBox);
            detailBand1.addElement((JRDesignElement)frame1);
            JRDesignReportFont columnFont = null;
            JRDesignReportFont normalFont = null;
            JRDesignReportFont pageFooterFont = null;
            JRFont reportPDFFont = JRDesignUtil.getPDFExporterFont();
            columnFont = JRDesignUtil.getJRDesignReportFont(ExportUtil.font1, ExportUtil.font1, normalSize, true, false);
            normalFont = JRDesignUtil.getJRDesignReportFont(ExportUtil.font1, ExportUtil.font1, normalSize, false, false);
            pageFooterFont = JRDesignUtil.getJRDesignReportFont(ExportUtil.font1, ExportUtil.font1, normalSize + 1, true, false);
            for (i = 0; i < attributeList.size(); ++i) {
                HashMap columnMap = (HashMap)attributeList.get(i);
                Integer columnName = i;
                String displayName = (String)columnMap.get("DISPLAYNAME");
                displayName = rb.getString(displayName);
                String tableName = (String)columnMap.get("TABLE_NAME");
                JRDesignField field = new JRDesignField();
                field.setName(columnName.toString());
                field.setValueClass(String.class);
                jasperDesign.addField((JRField)field);
                JRDesignStaticText txt = JRDesignUtil.getJRDesignStaticText(x, 0, width, 30, columnFont, new Color(255, 255, 255), new Color(0, 0, 0), (byte)1, (byte)2);
                txt.setMode((byte)1);
                txt.setStretchType((byte)1);
                txt.setPositionType((byte)2);
                txt.setKey(columnName.toString());
                txt.setPrintRepeatedValues(true);
                txt.setRemoveLineWhenBlank(false);
                txt.setPrintInFirstWholeBand(false);
                txt.setPrintWhenDetailOverflows(false);
                JRBaseBox box = new JRBaseBox();
                box.setTopBorder((byte)5);
                box.setTopBorderColor(new Color(216, 224, 230));
                box.setBottomBorder((byte)5);
                box.setBottomBorderColor(new Color(216, 224, 230));
                box.setLeftPadding(8);
                txt.setBox((JRBox)box);
                txt.setBackcolor(new Color(107, 119, 126));
                txt.setForecolor(Color.WHITE);
                txt.setText(displayName);
                if (reportType.toLowerCase().indexOf("xls") != -1 || reportType.toLowerCase().indexOf("csv") != -1) {
                    JRDesignExpression express = new JRDesignExpression();
                    express.setValueClass(Boolean.class);
                    express.setText("$V{PAGE_NUMBER}.intValue() == 1 ? Boolean.TRUE : Boolean.FALSE");
                    columnHeaderBand.setPrintWhenExpression((JRExpression)express);
                }
                frame.addElement((JRElement)txt);
                JRDesignTextField txtField = JRDesignUtil.getJRDesignTextField(x, 0, width, 30, normalFont, new Color(255, 255, 255), new Color(0, 0, 0), (byte)1, (byte)2);
                txtField.setBox((JRBox)box);
                detailBand1.setSplitAllowed(true);
                if (reportType.toLowerCase().indexOf("xls") != -1) {
                    txtField.setPrintWhenDetailOverflows(false);
                } else {
                    txtField.setPrintWhenDetailOverflows(true);
                }
                txtField.setPrintRepeatedValues(true);
                txtField.setPrintInFirstWholeBand(true);
                JRDesignExpression exp = new JRDesignExpression();
                exp.setValueClass(String.class);
                exp.setText("$F{" + columnName + "}");
                txtField.setExpression((JRExpression)exp);
                frame1.addElement((JRElement)txtField);
                x += width + 0;
            }
            for (i = 0; i < subReportList.size(); ++i) {
                HashMap map = (HashMap)subReportList.get(i);
                String name = (String)map.get("NAME");
                JRDesignField field = new JRDesignField();
                field.setName(name);
                field.setValueClass(JRDataSource.class);
                jasperDesign.addField((JRField)field);
                JasperDesign subJasperDesign = (JasperDesign)map.get("SUBREPORT_DESIGN");
                JRDesignSubreport jasperReport = new JRDesignSubreport((JRDefaultStyleProvider)subJasperDesign);
                String des = ExportUtil.getJasperPath() + "logonDurationSubReport.jasper";
                JRDesignExpression exp = new JRDesignExpression();
                exp.setValueClass(JRDataSource.class);
                exp.setText("$F{" + name + "}");
                JRDesignExpression exp1 = new JRDesignExpression();
                exp1.setValueClass(String.class);
                des = des.replace("\\", "\\\\");
                exp1.setText("\"" + des + "\"");
                jasperReport.setDataSourceExpression((JRExpression)exp);
                jasperReport.setExpression((JRExpression)exp1);
                JRDesignFrame subFrame = new JRDesignFrame();
                subFrame.setX(0);
                subFrame.setY(0);
                subFrame.setWidth(columnWidth);
                subFrame.setHeight(60);
                subFrame.setStretchType(StretchTypeEnum.RELATIVE_TO_BAND_HEIGHT);
                if (i == subReportList.size() - 1) {
                    frameBox.setBottomBorder((byte)5);
                    frameBox.setBottomBorderColor(new Color(216, 224, 230));
                }
                subFrame.setBox((JRBox)frameBox);
                JRDesignBand subReportBand = new JRDesignBand();
                subReportBand.setHeight(60);
                subReportBand.addElement((JRDesignElement)subFrame);
                subFrame.addElement((JRElement)jasperReport);
                ((JRDesignSection)jasperDesign.getDetailSection()).addBand((JRBand)subReportBand);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void fillBandSubReport(Hashtable columnWidths, JasperDesign jasperDesign, JRDesignBand columnHeaderBand, JRDesignBand detailBand, ArrayList attributeList, String reportType, AdventNetResourceBundle rb, String subReportFile, String heading, boolean flexWidth) {
        boolean isSplitAllowed = false;
        columnWidth = jasperDesign.getColumnWidth();
        columnSpacing = 0;
        leftMargin = 30;
        rightMargin = 30;
        topMargin = 20;
        bottomMargin = 20;
        int x = 0;
        boolean y = false;
        int width = columnWidth / attributeList.size();
        normalSize = 9;
        groupPad = 10;
        try {
            columnHeaderBand.setHeight(30);
            detailBand.setHeight(30);
            detailBand.setSplitType(SplitTypeEnum.PREVENT);
            JRDesignReportFont columnFont = null;
            JRDesignReportFont normalFont = null;
            JRDesignReportFont pageFooterFont = null;
            JRFont reportPDFFont = JRDesignUtil.getPDFExporterFont();
            columnFont = JRDesignUtil.getJRDesignReportFont("Arial_normal", reportPDFFont, normalSize, true, false);
            normalFont = JRDesignUtil.getJRDesignReportFont("Arial_normal", reportPDFFont, normalSize, false, false);
            pageFooterFont = JRDesignUtil.getJRDesignReportFont("pagefooter_reportname", reportPDFFont, normalSize + 1, true, false);
            JRDesignBand titleBand = (JRDesignBand)jasperDesign.getTitle();
            titleBand.setHeight(30);
            JRDesignStaticText headTxt = JRDesignUtil.getJRDesignStaticText(x, 0, width, 30, columnFont, new Color(255, 255, 255), new Color(0, 0, 0), (byte)1, (byte)2);
            headTxt.setMode((byte)1);
            headTxt.setStretchType((byte)1);
            headTxt.setPositionType((byte)2);
            headTxt.setForecolor(Color.BLACK);
            headTxt.setText(heading);
            titleBand.addElement((JRDesignElement)headTxt);
            JRBaseBox box = new JRBaseBox();
            box.setTopBorder((byte)5);
            box.setTopBorderColor(new Color(216, 224, 230));
            box.setLeftBorder((byte)5);
            box.setLeftBorderColor(new Color(216, 224, 230));
            box.setBottomBorder((byte)5);
            box.setBottomBorderColor(new Color(216, 224, 230));
            JRDesignFrame frame = new JRDesignFrame();
            frame.setX(0);
            frame.setY(0);
            if (flexWidth) {
                frame.setWidth(columnWidth - 12);
            } else {
                frame.setWidth(columnWidth);
            }
            frame.setHeight(30);
            frame.setStretchType(StretchTypeEnum.RELATIVE_TO_BAND_HEIGHT);
            frame.setBox((JRBox)box);
            box = new JRBaseBox();
            box.setTopBorder((byte)5);
            box.setTopBorderColor(new Color(216, 224, 230));
            box.setLeftBorder((byte)5);
            box.setLeftBorderColor(new Color(216, 224, 230));
            box.setRightBorder((byte)5);
            box.setRightBorderColor(new Color(216, 224, 230));
            box.setBottomBorder((byte)5);
            box.setBottomBorderColor(new Color(216, 224, 230));
            box.setLeftPadding(5);
            box.setTopPadding(5);
            box.setBottomPadding(5);
            for (int i = 0; i < attributeList.size(); ++i) {
                HashMap columnMap = (HashMap)attributeList.get(i);
                Integer columnName = i;
                String displayName = (String)columnMap.get("DISPLAYNAME");
                displayName = rb.getString(displayName);
                String tableName = (String)columnMap.get("TABLE_NAME");
                if (columnWidths != null && columnWidths.get(displayName) != null) {
                    width = (Integer)columnWidths.get(displayName);
                    width -= 15;
                }
                JRDesignField field = new JRDesignField();
                field.setName(columnName.toString());
                field.setValueClass(String.class);
                jasperDesign.addField((JRField)field);
                JRDesignStaticText txt = JRDesignUtil.getJRDesignStaticText(x, 0, width, 30, columnFont, new Color(255, 255, 255), new Color(0, 0, 0), (byte)1, (byte)2);
                txt.setMode((byte)1);
                txt.setStretchType((byte)1);
                txt.setPositionType((byte)2);
                txt.setKey(columnName.toString());
                txt.setPrintRepeatedValues(true);
                txt.setRemoveLineWhenBlank(false);
                txt.setPrintInFirstWholeBand(false);
                txt.setPrintWhenDetailOverflows(false);
                txt.setBox((JRBox)box);
                txt.setBackcolor(new Color(218, 225, 231));
                txt.setForecolor(Color.BLACK);
                txt.setText(displayName);
                if (reportType.toLowerCase().indexOf("xls") != -1 || reportType.toLowerCase().indexOf("csv") != -1) {
                    JRDesignExpression express = new JRDesignExpression();
                    express.setValueClass(Boolean.class);
                    express.setText("$V{PAGE_NUMBER}.intValue() == 1 ? Boolean.TRUE : Boolean.FALSE");
                    columnHeaderBand.setPrintWhenExpression((JRExpression)express);
                }
                columnHeaderBand.addElement((JRDesignElement)txt);
                JRDesignTextField txtField = JRDesignUtil.getJRDesignTextField(x, 0, width, 30, normalFont, new Color(255, 255, 255), new Color(0, 0, 0), (byte)1, (byte)1);
                if (reportType.toLowerCase().indexOf("xls") != -1) {
                    txtField.setPrintWhenDetailOverflows(false);
                } else {
                    txtField.setPrintWhenDetailOverflows(true);
                }
                txtField.setPrintInFirstWholeBand(true);
                txtField.setMode((byte)2);
                txtField.setPrintRepeatedValues(true);
                txtField.setPrintWhenDetailOverflows(false);
                txtField.setStretchType(StretchTypeEnum.RELATIVE_TO_TALLEST_OBJECT);
                JRDesignExpression exp = new JRDesignExpression();
                exp.setValueClass(String.class);
                exp.setText("$F{" + columnName + "}");
                txtField.setExpression((JRExpression)exp);
                detailBand.addElement((JRDesignElement)txtField);
                txtField.setBox((JRBox)box);
                x += width + 0;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static {
        normalSize = 9;
        groupPad = 10;
        jasperDir = System.getProperty("server.dir") + File.separator + "webapps" + File.separator + "adap" + File.separator + "jasper";
        rb = ResourceBundleMgr.getInstance().getBundle();
    }
}

