/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.export;

import com.adventnet.sym.adsm.common.server.export.JRDesignUtil;
import java.awt.Color;
import java.util.logging.Logger;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.design.JRDesignReportFont;
import net.sf.jasperreports.engine.design.JRDesignStaticText;
import net.sf.jasperreports.engine.design.JRDesignStyle;
import net.sf.jasperreports.engine.design.JRDesignTextField;
import net.sf.jasperreports.engine.type.HorizontalAlignEnum;
import net.sf.jasperreports.engine.type.ModeEnum;
import net.sf.jasperreports.engine.type.PositionTypeEnum;
import net.sf.jasperreports.engine.type.StretchTypeEnum;
import net.sf.jasperreports.engine.type.VerticalAlignEnum;

public class JRUtil {
    private static Logger reportLogger = Logger.getLogger("ReportLogger");
    public static final int COLUMN_WIDTH = 350;
    public static final int PDF_COLUMN_WIDTH = 200;
    public static final int MATRIX_REP_COLUMN_WIDTH = 130;
    public static final String BLANK_REPLACER = "__";
    public static final String REPORT_FONTNAME = "Verdana";
    public static final JRDesignStyle NORMAL_FONT = JRUtil.getJRDesignReportFont("Arial_normal", "Verdana", 11, false, false);
    public static final JRDesignStyle BOLD_FONT = JRUtil.getJRDesignReportFont("Arial_bold", "Verdana", 11, true, false);
    public static final JRDesignStyle TITLE_FONT = JRUtil.getJRDesignReportFont("_font", "Verdana", 15, true, false);
    public static final JRDesignStyle PAGE_HEADER_FONT = JRUtil.getJRDesignReportFont("pageheader_font", "Verdana", 11, true, false);
    public static final JRDesignStyle GROUP_HEADER_FONT = JRUtil.getJRDesignReportFont("grpheader_font", "Verdana", 11, true, false);

    public static JRDesignStaticText formStaticText(String textValue, String textName, int xAxis, int yAxis, int width, int height, int fontSize, String fontName) throws Exception {
        JRDesignStaticText staticText = new JRDesignStaticText();
        staticText.setText(textValue);
        staticText.setKey(textName);
        staticText.setX(xAxis);
        staticText.setY(yAxis);
        staticText.setWidth(width);
        staticText.setHeight(height);
        staticText.setTextAlignment((byte)1);
        staticText.setFontSize(fontSize);
        staticText.setFontName(fontName);
        staticText.setPdfFontName("Helvetica");
        return staticText;
    }

    public static JRDesignStaticText formJRDesignText(int imageXPosition, int textHeight, int textWidth, String graphTitle, JRDesignReportFont columnFont) throws Exception {
        JRDesignStaticText txt = JRDesignUtil.getJRDesignStaticText(imageXPosition, textHeight, textWidth, 30, columnFont, new Color(255, 255, 255), new Color(0, 0, 0), (byte)1, (byte)2);
        txt.setMode((byte)1);
        txt.setStretchType((byte)1);
        txt.setPositionType((byte)2);
        txt.setPrintRepeatedValues(true);
        txt.setRemoveLineWhenBlank(false);
        txt.setPrintInFirstWholeBand(false);
        txt.setPrintWhenDetailOverflows(false);
        txt.setPdfFontName("Helvetica-Bold");
        txt.setBold(true);
        Object c1 = null;
        txt.setBackcolor(new Color(239, 239, 231));
        txt.setForecolor(Color.BLACK);
        txt.setText(graphTitle);
        txt.setLeftPadding(4);
        txt.setRightPadding(4);
        txt.setBorderColor(Color.BLACK);
        txt.setLeftBorder((byte)5);
        txt.setTopBorder((byte)5);
        txt.setBottomBorder((byte)5);
        txt.setRightBorder((byte)5);
        return txt;
    }

    public static JRDesignTextField getJRDesignTextField(int x, int y, int width, int height, JRDesignStyle font, Color backColor, Color foreColor, HorizontalAlignEnum hAlign, VerticalAlignEnum vAlign) {
        JRDesignTextField textField = new JRDesignTextField();
        textField.setBlankWhenNull(true);
        textField.setX(x);
        textField.setY(y);
        textField.setWidth(width);
        textField.setHeight(height);
        textField.setMode(ModeEnum.OPAQUE);
        textField.setStretchWithOverflow(true);
        textField.setStretchType(StretchTypeEnum.RELATIVE_TO_TALLEST_OBJECT);
        textField.setPositionType(PositionTypeEnum.FIX_RELATIVE_TO_TOP);
        if (font != null) {
            textField.setStyle((JRStyle)font);
        }
        textField.setHorizontalAlignment(hAlign);
        textField.setVerticalAlignment(vAlign);
        if (backColor != null) {
            textField.setBackcolor(backColor);
        }
        if (foreColor != null) {
            textField.setForecolor(foreColor);
        }
        return textField;
    }

    public static JRDesignStyle getJRDesignReportFont(String name, String fontName, int size, boolean bold, boolean isDefault) {
        JRDesignStyle font = new JRDesignStyle();
        try {
            font.setName(name);
            font.setDefault(isDefault);
            font.setFontName(fontName);
            font.setFontSize(size);
            font.setBold(bold);
            font.setPdfFontName("Helvetica");
            font.setPdfEncoding("Cp1252");
            font.setPdfEmbedded(false);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return font;
    }
}

