/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.export;

import com.adventnet.sym.adsm.auditing.server.reports.ADAPCsvExporter;
import com.adventnet.sym.adsm.auditing.server.reports.ADAPHtmlExporter;
import com.adventnet.sym.adsm.auditing.server.reports.ADAPPdfExporter;
import com.adventnet.sym.adsm.common.server.export.JRDesignUtil;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.mail.internet.MimeUtility;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.design.JRDesignReportFont;
import net.sf.jasperreports.engine.export.JRCsvExporter;
import net.sf.jasperreports.engine.export.JRCsvExporterParameter;
import net.sf.jasperreports.engine.export.JRGraphics2DExporter;
import net.sf.jasperreports.engine.export.JRGraphics2DExporterParameter;
import net.sf.jasperreports.engine.export.JRHtmlExporter;
import net.sf.jasperreports.engine.export.JRHtmlExporterParameter;
import net.sf.jasperreports.engine.export.JRPdfExporter;
import net.sf.jasperreports.engine.export.JRPdfExporterParameter;
import net.sf.jasperreports.engine.export.JRTextExporterParameter;
import net.sf.jasperreports.engine.export.JRXlsExporter;
import net.sf.jasperreports.engine.export.JRXlsExporterParameter;

public class ReportExporter {
    private static ReportExporter reportExporter;

    private ReportExporter() {
    }

    public static ReportExporter getInstance() {
        if (reportExporter == null) {
            reportExporter = new ReportExporter();
        }
        return reportExporter;
    }

    public void exportAsPdf(ArrayList print, String toolID, Long schedule_id, String dir, boolean isUsedBaseExporter) throws Exception {
        ADAPPdfExporter exporter = new ADAPPdfExporter();
        if (isUsedBaseExporter) {
            exporter = new JRPdfExporter();
            exporter.setParameter(JRExporterParameter.JASPER_PRINT, print.get(0));
        } else {
            exporter.setParameter(JRExporterParameter.JASPER_PRINT_LIST, print);
        }
        JRDesignReportFont font = (JRDesignReportFont)JRDesignUtil.getPDFExporterFont();
        exporter.setParameter(JRPdfExporterParameter.CHARACTER_ENCODING, font.getPdfEncoding());
        FileOutputStream output = new FileOutputStream(new File(dir + File.separator + toolID + ".pdf"));
        exporter.setParameter(JRExporterParameter.OUTPUT_STREAM, output);
        exporter.exportReport();
        output.flush();
        ((OutputStream)output).close();
    }

    public void exportAsHTML(ArrayList print, String toolID, Long schedule_id, String dir, String imagePath, boolean isUsedBaseExporter) throws Exception {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ADAPHtmlExporter exporter = new ADAPHtmlExporter();
        if (isUsedBaseExporter) {
            exporter = new JRHtmlExporter();
            exporter.setParameter(JRExporterParameter.JASPER_PRINT, print.get(0));
        } else {
            exporter.setParameter(JRExporterParameter.JASPER_PRINT_LIST, print);
        }
        exporter.setParameter((JRExporterParameter)JRHtmlExporterParameter.IMAGES_URI, "/cewolf_charts/" + imagePath + "?");
        HashMap imagesMap = new HashMap();
        exporter.setParameter((JRExporterParameter)JRHtmlExporterParameter.IMAGES_MAP, imagesMap);
        exporter.setParameter(JRExporterParameter.OUTPUT_STREAM, bos);
        exporter.setParameter((JRExporterParameter)JRHtmlExporterParameter.IS_WHITE_PAGE_BACKGROUND, Boolean.TRUE);
        exporter.setParameter((JRExporterParameter)JRHtmlExporterParameter.IS_USING_IMAGES_TO_ALIGN, Boolean.FALSE);
        exporter.exportReport();
        byte[] html = bos.toByteArray();
        bos.close();
        FileOutputStream fs = new FileOutputStream(dir + File.separator + toolID + ".html");
        fs.write(html);
        fs.close();
    }

    public void exportAsCSV(ArrayList print, String toolID, Long schedule_id, String dir, boolean isUsedBaseExporter) throws Exception {
        ADAPCsvExporter exporter = new ADAPCsvExporter();
        if (isUsedBaseExporter) {
            exporter = new JRCsvExporter();
            exporter.setParameter(JRExporterParameter.JASPER_PRINT, print.get(0));
        } else {
            exporter.setParameter(JRExporterParameter.JASPER_PRINT_LIST, print);
        }
        exporter.setParameter((JRExporterParameter)JRCsvExporterParameter.FIELD_DELIMITER, ",");
        exporter.setParameter((JRExporterParameter)JRCsvExporterParameter.RECORD_DELIMITER, "\n");
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        exporter.setParameter(JRExporterParameter.OUTPUT_STREAM, baos);
        exporter.setParameter((JRExporterParameter)JRTextExporterParameter.CHARACTER_WIDTH, 200);
        exporter.setParameter((JRExporterParameter)JRTextExporterParameter.CHARACTER_HEIGHT, 50);
        exporter.setParameter(JRExporterParameter.CHARACTER_ENCODING, JRDesignUtil.getCSVEncoder());
        exporter.exportReport();
        FileOutputStream output = new FileOutputStream(new File(dir + File.separator + toolID + ".csv"));
        ((OutputStream)output).write(baos.toByteArray());
        output.flush();
        ((OutputStream)output).close();
    }

    public void exportAsXLS(ArrayList print, String toolID, Long schedule_id, String dir, boolean isUsedBaseExporter) throws Exception {
        JRXlsExporter exporter = new JRXlsExporter();
        if (isUsedBaseExporter) {
            exporter.setParameter(JRExporterParameter.JASPER_PRINT, print.get(0));
            exporter.setParameter(JRXlsExporterParameter.MAXIMUM_ROWS_PER_SHEET, (Object)40000);
        } else {
            exporter.setParameter(JRExporterParameter.JASPER_PRINT_LIST, (Object)print);
        }
        exporter.setParameter(JRExporterParameter.OUTPUT_FILE_NAME, (Object)(dir + File.separator + toolID + ".xls"));
        exporter.setParameter((JRExporterParameter)JRXlsExporterParameter.IS_DETECT_CELL_TYPE, (Object)Boolean.TRUE);
        exporter.setParameter((JRExporterParameter)JRXlsExporterParameter.IS_WHITE_PAGE_BACKGROUND, (Object)Boolean.TRUE);
        exporter.setParameter((JRExporterParameter)JRXlsExporterParameter.IS_REMOVE_EMPTY_SPACE_BETWEEN_ROWS, (Object)Boolean.TRUE);
        exporter.exportReport();
    }

    public void exportAsPdf(ArrayList print, String toolID, HttpServletResponse response, HttpServletRequest request, boolean isUsedBaseExporter) throws Exception {
        ADAPPdfExporter exporter = new ADAPPdfExporter();
        if (isUsedBaseExporter) {
            exporter = new JRPdfExporter();
            exporter.setParameter(JRExporterParameter.JASPER_PRINT, print.get(0));
            JRDesignReportFont font = (JRDesignReportFont)JRDesignUtil.getPDFExporterFont();
            exporter.setParameter(JRPdfExporterParameter.CHARACTER_ENCODING, font.getPdfEncoding());
        } else {
            exporter.setParameter(JRExporterParameter.JASPER_PRINT_LIST, print);
        }
        exporter.setParameter(JRExporterParameter.OUTPUT_FILE_NAME, toolID + ".pdf");
        response.setContentType("application/pdf");
        response.setCharacterEncoding("UTF-8");
        response.setHeader("content-disposition", "attachment; filename=" + this.getExportFileName(request, toolID) + ".pdf");
        ServletOutputStream out = response.getOutputStream();
        exporter.setParameter(JRExporterParameter.OUTPUT_STREAM, out);
        exporter.exportReport();
        out.close();
    }

    public void exportAsJpeg(JasperPrint print, String toolID, HttpServletResponse response, boolean isUsedBaseExporter) throws Exception {
        JRGraphics2DExporter exporter = new JRGraphics2DExporter();
        exporter.setParameter(JRExporterParameter.JASPER_PRINT, (Object)print);
        BufferedImage bufferedImage = new BufferedImage(500, 350, 1);
        exporter.setParameter(JRExporterParameter.OUTPUT_STREAM, (Object)response.getOutputStream());
        exporter.setParameter(JRExporterParameter.OUTPUT_FILE_NAME, (Object)"ChassisImg.jpg");
        exporter.setParameter((JRExporterParameter)JRGraphics2DExporterParameter.GRAPHICS_2D, (Object)bufferedImage.createGraphics());
    }

    public void exportAsHtml(ArrayList print, String toolID, HttpServletResponse response, HttpSession session, String imagePath, boolean isUsedBaseExporter) throws Exception {
        PrintWriter out = response.getWriter();
        ADAPHtmlExporter exporter = new ADAPHtmlExporter();
        if (isUsedBaseExporter) {
            exporter = new JRHtmlExporter();
            exporter.setParameter(JRExporterParameter.JASPER_PRINT, print.get(0));
        } else {
            exporter.setParameter(JRExporterParameter.JASPER_PRINT_LIST, print);
        }
        exporter.setParameter(JRExporterParameter.OUTPUT_WRITER, out);
        exporter.setParameter((JRExporterParameter)JRHtmlExporterParameter.IMAGES_URI, "/cewolf_charts/" + imagePath + "?");
        HashMap imagesMap = (HashMap)session.getAttribute("IMAGE_MAPS");
        if (imagesMap == null) {
            imagesMap = new HashMap();
        }
        session.setAttribute("IMAGES_MAP", imagesMap);
        response.setContentType("text/html");
        exporter.setParameter((JRExporterParameter)JRHtmlExporterParameter.IMAGES_MAP, imagesMap);
        exporter.setParameter((JRExporterParameter)JRHtmlExporterParameter.IS_WHITE_PAGE_BACKGROUND, Boolean.FALSE);
        exporter.setParameter((JRExporterParameter)JRHtmlExporterParameter.IS_USING_IMAGES_TO_ALIGN, Boolean.FALSE);
        exporter.exportReport();
    }

    public void exportAsXls(ArrayList print, String toolID, HttpServletResponse response, HttpServletRequest request, boolean isUsedBaseExporter) throws Exception {
        JRXlsExporter exporter = new JRXlsExporter();
        if (isUsedBaseExporter) {
            exporter = new JRXlsExporter();
            exporter.setParameter(JRExporterParameter.JASPER_PRINT, (Object)((JasperPrint)print.get(0)));
        } else {
            exporter.setParameter(JRExporterParameter.JASPER_PRINT_LIST, (Object)print);
        }
        response.reset();
        response.setCharacterEncoding("UTF-8");
        response.setContentType("application/xls");
        String fileName = this.getExportFileName(request, toolID);
        response.setHeader("content-disposition", "inline; filename=" + fileName + ".xls");
        ServletOutputStream os = response.getOutputStream();
        exporter.setParameter(JRExporterParameter.OUTPUT_STREAM, (Object)os);
        exporter.setParameter((JRExporterParameter)JRXlsExporterParameter.IS_DETECT_CELL_TYPE, (Object)Boolean.TRUE);
        exporter.setParameter((JRExporterParameter)JRXlsExporterParameter.IS_WHITE_PAGE_BACKGROUND, (Object)Boolean.TRUE);
        exporter.setParameter((JRExporterParameter)JRXlsExporterParameter.IS_REMOVE_EMPTY_SPACE_BETWEEN_ROWS, (Object)Boolean.TRUE);
        exporter.setParameter((JRExporterParameter)JRXlsExporterParameter.IS_REMOVE_EMPTY_SPACE_BETWEEN_COLUMNS, (Object)Boolean.TRUE);
        HashMap<String, Object> parametersMap = new HashMap<String, Object>();
        parametersMap.put("response", response);
        parametersMap.put("fileName", fileName);
        exporter.setResponse(parametersMap);
        exporter.exportReport();
        os.close();
    }

    public void exportAsCsv(ArrayList print, String designFileName, HttpServletResponse response, HttpServletRequest request, boolean isUsedBaseExporter) throws Exception {
        ADAPCsvExporter exporter = new ADAPCsvExporter();
        if (isUsedBaseExporter) {
            exporter = new JRCsvExporter();
            exporter.setParameter(JRExporterParameter.JASPER_PRINT, print.get(0));
        } else {
            exporter.setParameter(JRExporterParameter.JASPER_PRINT_LIST, print);
        }
        exporter.setParameter((JRExporterParameter)JRCsvExporterParameter.FIELD_DELIMITER, ",");
        exporter.setParameter((JRExporterParameter)JRCsvExporterParameter.RECORD_DELIMITER, "\n");
        exporter.setParameter(JRExporterParameter.CHARACTER_ENCODING, JRDesignUtil.getCSVEncoder());
        response.reset();
        response.setContentType("application/msexcel-comma");
        response.setHeader("content-disposition", "attachment; filename=" + this.getExportFileName(request, designFileName) + ".csv");
        ServletOutputStream os = response.getOutputStream();
        exporter.setParameter(JRExporterParameter.OUTPUT_STREAM, os);
        exporter.exportReport();
        os.close();
    }

    private JasperPrint getReport(String bpath, String dFile, Map reportParams, JRDataSource jrds) throws Exception {
        String designFileName = dFile;
        String compileFileName = bpath + "jasper" + File.separator + designFileName + ".jasper";
        JasperPrint print = null;
        print = JasperFillManager.fillReport((String)compileFileName, (Map)reportParams, (JRDataSource)jrds);
        return print;
    }

    private String getExportFileName(HttpServletRequest request, String fileName) throws Exception {
        boolean isChrome;
        String user_agent = request.getHeader("user-agent");
        boolean isIE = user_agent.indexOf("MSIE") > -1 || user_agent.indexOf("Trident") > -1;
        boolean bl = isChrome = user_agent.indexOf("Chrome") > -1;
        if (isIE || isChrome) {
            return URLEncoder.encode(fileName, "utf-8");
        }
        return MimeUtility.encodeWord((String)fileName);
    }
}

