/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.export;

import com.adventnet.sym.adsm.auditing.server.reports.ReportUtil;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import java.awt.Color;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import net.sf.jasperreports.crosstabs.design.JRDesignCellContents;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstab;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstabBucket;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstabCell;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstabColumnGroup;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstabDataset;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstabMeasure;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstabParameter;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstabRowGroup;
import net.sf.jasperreports.engine.JRBand;
import net.sf.jasperreports.engine.JRBox;
import net.sf.jasperreports.engine.JRDatasetParameter;
import net.sf.jasperreports.engine.JRDatasetRun;
import net.sf.jasperreports.engine.JRDefaultStyleProvider;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRParameter;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.base.JRBaseBox;
import net.sf.jasperreports.engine.base.JRBaseReport;
import net.sf.jasperreports.engine.design.JRDesignBand;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import net.sf.jasperreports.engine.design.JRDesignDatasetRun;
import net.sf.jasperreports.engine.design.JRDesignElement;
import net.sf.jasperreports.engine.design.JRDesignExpression;
import net.sf.jasperreports.engine.design.JRDesignField;
import net.sf.jasperreports.engine.design.JRDesignImage;
import net.sf.jasperreports.engine.design.JRDesignLine;
import net.sf.jasperreports.engine.design.JRDesignParameter;
import net.sf.jasperreports.engine.design.JRDesignQuery;
import net.sf.jasperreports.engine.design.JRDesignStyle;
import net.sf.jasperreports.engine.design.JRDesignTextField;
import net.sf.jasperreports.engine.design.JasperDesign;

public class SetupMatrixReportPage {
    private static AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle();
    private JRDesignStyle normalStyle = null;
    private JRDesignStyle boldStyle = null;
    private JRDesignStyle italicStyle = null;
    private JRDesignStyle titleBoldStyle = null;
    private JasperDesign jd = new JasperDesign();
    private String logo = "report.gif";
    private int matrix_cell_width = 130;
    private int matrix_cell_height = 30;
    private String default_null_value = "NA";
    private String totali18n = "Total";
    private String noDataMessage = null;
    private String groupDateFormat = "MM-dd-yyyy";
    private String dformat = "MM-dd-yyyy HH:mm";

    public void setGroupDateFormat(String groupDateFormat) {
        if (groupDateFormat != null && !groupDateFormat.trim().equals("")) {
            this.groupDateFormat = groupDateFormat;
        }
    }

    public void setTotali18nMessage(String msg) {
        if (msg != null) {
            this.totali18n = msg;
        }
    }

    public void replaceNullValueAs(String default_null_value) {
        this.default_null_value = default_null_value;
    }

    public void setCellWidth(int matrix_cell_width) {
        this.matrix_cell_width = matrix_cell_width;
    }

    public void setCellHeight(int matrix_cell_height) {
        this.matrix_cell_height = matrix_cell_height;
    }

    private void pageSetup() throws Exception {
        this.jd.setName("ManageEngine ADAudit Plus Pivotal Report View");
        this.jd.setColumnSpacing(0);
        this.jd.setLeftMargin(5);
        this.jd.setRightMargin(5);
        this.jd.setTopMargin(0);
        this.jd.setBottomMargin(0);
        this.jd.setOrientation((byte)2);
    }

    public void setLogo(String logo) {
        this.logo = logo;
    }

    public JasperDesign getJasperDesign(HashMap top, HashMap left, HashMap measureCol, String summaryType, String reportQuery, String locale, boolean isWidget, HashMap inputDataMap) throws Exception {
        this.pageSetup();
        this.addStyle(locale);
        this.addParameter();
        this.addDatasetFields(top, left, measureCol, reportQuery);
        this.addDatasetQuery();
        if (!isWidget) {
            this.addTitle(inputDataMap);
        }
        this.addDetails(top, left, measureCol, summaryType);
        if (!isWidget) {
            this.addNoDataBand();
        }
        this.jd.setWhenNoDataType((byte)4);
        return this.jd;
    }

    private void addNoDataBand() {
        JRDesignBand band = (JRDesignBand)this.jd.getTitle().clone();
        band.setHeight(145);
        JRDesignTextField textField = new JRDesignTextField();
        textField.setX(1);
        textField.setY(121);
        textField.setWidth(100001);
        textField.setHeight(20);
        textField.setHorizontalAlignment((byte)2);
        textField.setStyle((JRStyle)this.boldStyle);
        textField.setForecolor(new Color(0, 0, 0));
        JRDesignExpression expression = new JRDesignExpression();
        expression.setValueClass(String.class);
        if (this.noDataMessage == null) {
            this.noDataMessage = rb.getString("adap.ExportUtil.No_data_available_to_generate");
        }
        expression.setText("\"" + this.noDataMessage + "\"");
        textField.setExpression((JRExpression)expression);
        band.addElement((JRDesignElement)textField);
        JRDesignExpression exp = new JRDesignExpression();
        exp.setValueClass(Boolean.class);
        exp.setText("$V{REPORT_COUNT}.intValue() == 0 ? Boolean.TRUE : Boolean.FALSE");
        band.setPrintWhenExpression((JRExpression)exp);
        this.jd.setNoData((JRBand)band);
    }

    public void addNoDataMessage(String noDataMessage) {
        this.noDataMessage = noDataMessage;
    }

    private void addDatasetFields(HashMap top, HashMap left, HashMap measureCol, String reportQuery) throws Exception {
        JRDesignDataset dsr = new JRDesignDataset(false);
        dsr.setName("subDatasetName");
        JRDesignCrosstabParameter jdctp = new JRDesignCrosstabParameter();
        jdctp.setName("ParamName");
        jdctp.setValueClassName("java.lang.String");
        dsr.addParameter((JRParameter)jdctp);
        jdctp = new JRDesignCrosstabParameter();
        jdctp.setName("fromdate");
        jdctp.setValueClassName("java.lang.Long");
        dsr.addParameter((JRParameter)jdctp);
        jdctp = new JRDesignCrosstabParameter();
        jdctp.setName("todate");
        jdctp.setValueClassName("java.lang.Long");
        dsr.addParameter((JRParameter)jdctp);
        JRDesignQuery jrdq = new JRDesignQuery();
        jrdq.setText(reportQuery);
        dsr.setQuery(jrdq);
        if (top != null && left != null) {
            JRDesignField field = new JRDesignField();
            if ("java.util.Date".equals(left.get("COLUMN_DATA_TYPE")) || "javax.lang.Memory".equals(left.get("COLUMN_DATA_TYPE"))) {
                field.setValueClassName("java.lang.Long");
            } else {
                field.setValueClassName((String)left.get("COLUMN_DATA_TYPE"));
            }
            field.setName((String)left.get("DISPLAY_NAME"));
            dsr.addField((JRField)field);
            field = new JRDesignField();
            if ("java.util.Date".equals(top.get("COLUMN_DATA_TYPE")) || "javax.lang.Memory".equals(top.get("COLUMN_DATA_TYPE"))) {
                field.setValueClassName("java.lang.Long");
            } else {
                field.setValueClassName((String)top.get("COLUMN_DATA_TYPE"));
            }
            field.setName((String)top.get("DISPLAY_NAME"));
            dsr.addField((JRField)field);
            if (!top.get("DISPLAY_NAME").equals(measureCol.get("DISPLAY_NAME")) && !left.get("DISPLAY_NAME").equals(measureCol.get("DISPLAY_NAME"))) {
                field = new JRDesignField();
                if ("java.util.Date".equals(measureCol.get("COLUMN_DATA_TYPE")) || "java.sql.Time".equals(measureCol.get("COLUMN_DATA_TYPE")) || "javax.lang.Memory".equals(measureCol.get("COLUMN_DATA_TYPE"))) {
                    field.setValueClassName("java.lang.Long");
                } else {
                    field.setValueClassName((String)measureCol.get("COLUMN_DATA_TYPE"));
                }
                field.setName((String)measureCol.get("DISPLAY_NAME"));
                dsr.addField((JRField)field);
            }
            this.jd.addDataset(dsr);
        }
    }

    private void addStyle(String locale) throws Exception {
        this.normalStyle = new JRDesignStyle();
        this.boldStyle = new JRDesignStyle();
        this.italicStyle = new JRDesignStyle();
        this.titleBoldStyle = new JRDesignStyle();
        HashMap fontStyle = ReportUtil.getInstance().applyOtherLanguageStyle(locale);
        JRDesignStyle[] style = new JRDesignStyle[]{this.normalStyle, this.boldStyle, this.italicStyle, this.titleBoldStyle};
        String[] styleNames = new String[]{"Arial_Normal", "Arial_Bold", "Arial_Italic", "Arial_Bold_title"};
        int[] fontSize = new int[]{10, 11, 10, 14};
        for (int size = 0; size < style.length; ++size) {
            style[size].setPdfFontName((String)fontStyle.get(ReportUtil.pdf_FontName));
            style[size].setPdfEncoding((String)fontStyle.get(ReportUtil.pdf_FontEncoding));
            style[size].setPdfEmbedded((Boolean)fontStyle.get(ReportUtil.pdf_FontEmbedded));
            style[size].setFontName("Arial");
            style[size].setName(styleNames[size]);
            style[size].setFontSize(fontSize[size]);
        }
        this.normalStyle.setDefault(true);
        this.jd.addStyle((JRStyle)this.normalStyle);
        this.boldStyle.setBold(true);
        this.jd.addStyle((JRStyle)this.boldStyle);
        this.italicStyle.setItalic(true);
        this.jd.addStyle((JRStyle)this.italicStyle);
        this.titleBoldStyle.setBold(true);
        this.jd.addStyle((JRStyle)this.titleBoldStyle);
    }

    private void addParameter() throws Exception {
        String[] parameterNames = new String[]{"Details", "query", "fromdate1", "todate1", "reportName", "domainName", "description", "reportGeneratedAt", "durationText", "reportGenAtText", "annoText", "domainNameText", "duration"};
        Class[] parameterClasses = new Class[]{Map.class, String.class, Long.class, Long.class, String.class, String.class, String.class, String.class, String.class, String.class, String.class, String.class, String.class};
        JRDesignParameter parameter = null;
        for (int size = 0; size < parameterNames.length; ++size) {
            parameter = new JRDesignParameter();
            parameter.setName(parameterNames[size]);
            parameter.setValueClass(parameterClasses[size]);
            this.jd.addParameter((JRParameter)parameter);
        }
    }

    private void addDatasetQuery() throws Exception {
        JRDesignQuery query = new JRDesignQuery();
        query.setText("select 'temp' as time");
        this.jd.setQuery(query);
    }

    public void setDateFormat(String dformat) {
        if (dformat != null && !dformat.trim().equals("")) {
            this.dformat = dformat;
        }
    }

    public void addOrganization(String address, String creator_info) throws Exception {
        if (address == null) {
            address = "";
        }
    }

    private void addTitle(HashMap inputDataMap) throws Exception {
        JRDesignBand band = new JRDesignBand();
        band.setHeight(150);
        JRDesignLine line = new JRDesignLine();
        line.setX(0);
        line.setY(52);
        line.setWidth(100001);
        line.setHeight(1);
        line.setMode((byte)1);
        line.setForecolor(new Color(0, 0, 0));
        band.addElement((JRDesignElement)line);
        JRDesignExpression expression = new JRDesignExpression();
        JRDesignTextField textField = new JRDesignTextField();
        textField.setBlankWhenNull(true);
        textField.setX(10);
        textField.setY(10);
        textField.setWidth(500);
        textField.setHeight(50);
        textField.setHorizontalAlignment((byte)1);
        textField.setStyle((JRStyle)this.titleBoldStyle);
        expression.setValueClass(String.class);
        expression.setText("$P{reportName}");
        textField.setExpression((JRExpression)expression);
        band.addElement((JRDesignElement)textField);
        textField = new JRDesignTextField();
        textField.setBlankWhenNull(true);
        textField.setX(10);
        textField.setY(54);
        textField.setWidth(120);
        textField.setHeight(20);
        textField.setHorizontalAlignment((byte)1);
        textField.setStyle((JRStyle)this.normalStyle);
        textField.setMode((byte)1);
        textField.setForecolor(new Color(41, 89, 148));
        expression = new JRDesignExpression();
        expression.setValueClass(String.class);
        expression.setText("$P{domainNameText}");
        textField.setExpression((JRExpression)expression);
        band.addElement((JRDesignElement)textField);
        textField = new JRDesignTextField();
        textField.setBlankWhenNull(true);
        textField.setX(130);
        textField.setY(54);
        textField.setWidth(120);
        textField.setHeight(20);
        textField.setHorizontalAlignment((byte)1);
        textField.setStyle((JRStyle)this.normalStyle);
        textField.setMode((byte)1);
        textField.setForecolor(new Color(41, 89, 148));
        expression = new JRDesignExpression();
        expression.setValueClass(String.class);
        expression.setText("\":\"");
        textField.setExpression((JRExpression)expression);
        band.addElement((JRDesignElement)textField);
        textField = new JRDesignTextField();
        textField.setBlankWhenNull(true);
        textField.setX(140);
        textField.setY(54);
        textField.setWidth(120);
        textField.setHeight(20);
        textField.setHorizontalAlignment((byte)1);
        textField.setStyle((JRStyle)this.normalStyle);
        textField.setMode((byte)1);
        textField.setForecolor(new Color(41, 89, 148));
        expression = new JRDesignExpression();
        expression.setValueClass(String.class);
        expression.setText("$P{domainName}");
        textField.setExpression((JRExpression)expression);
        band.addElement((JRDesignElement)textField);
        textField = new JRDesignTextField();
        textField.setBlankWhenNull(true);
        textField.setX(10);
        textField.setY(76);
        textField.setWidth(600);
        textField.setHeight(20);
        textField.setMode((byte)1);
        textField.setHorizontalAlignment((byte)1);
        textField.setStyle((JRStyle)this.normalStyle);
        textField.setForecolor(new Color(41, 89, 148));
        expression = new JRDesignExpression();
        expression.setValueClass(String.class);
        expression.setText("$P{annoText}");
        textField.setExpression((JRExpression)expression);
        band.addElement((JRDesignElement)textField);
        textField = new JRDesignTextField();
        textField.setBlankWhenNull(true);
        textField.setX(130);
        textField.setY(76);
        textField.setWidth(120);
        textField.setHeight(20);
        textField.setHorizontalAlignment((byte)1);
        textField.setStyle((JRStyle)this.normalStyle);
        textField.setMode((byte)1);
        textField.setForecolor(new Color(41, 89, 148));
        expression = new JRDesignExpression();
        expression.setValueClass(String.class);
        expression.setText("\":\"");
        textField.setExpression((JRExpression)expression);
        band.addElement((JRDesignElement)textField);
        textField = new JRDesignTextField();
        textField.setBlankWhenNull(true);
        textField.setX(140);
        textField.setY(76);
        textField.setWidth(600);
        textField.setHeight(20);
        textField.setHorizontalAlignment((byte)1);
        textField.setStyle((JRStyle)this.normalStyle);
        textField.setMode((byte)1);
        textField.setForecolor(new Color(41, 89, 148));
        expression = new JRDesignExpression();
        expression.setValueClass(String.class);
        expression.setText("$P{description}");
        textField.setExpression((JRExpression)expression);
        band.addElement((JRDesignElement)textField);
        textField = new JRDesignTextField();
        textField.setBlankWhenNull(true);
        textField.setX(10);
        textField.setY(96);
        textField.setWidth(600);
        textField.setHeight(20);
        textField.setMode((byte)1);
        textField.setHorizontalAlignment((byte)1);
        textField.setStyle((JRStyle)this.normalStyle);
        textField.setForecolor(new Color(41, 89, 148));
        expression = new JRDesignExpression();
        expression.setValueClass(String.class);
        expression.setText("$P{durationText}");
        textField.setExpression((JRExpression)expression);
        band.addElement((JRDesignElement)textField);
        textField = new JRDesignTextField();
        textField.setBlankWhenNull(true);
        textField.setX(130);
        textField.setY(96);
        textField.setWidth(120);
        textField.setHeight(20);
        textField.setHorizontalAlignment((byte)1);
        textField.setStyle((JRStyle)this.normalStyle);
        textField.setMode((byte)1);
        textField.setForecolor(new Color(41, 89, 148));
        expression = new JRDesignExpression();
        expression.setValueClass(String.class);
        expression.setText("\":\"");
        textField.setExpression((JRExpression)expression);
        band.addElement((JRDesignElement)textField);
        textField = new JRDesignTextField();
        textField.setBlankWhenNull(true);
        textField.setX(140);
        textField.setY(96);
        textField.setWidth(600);
        textField.setHeight(20);
        textField.setHorizontalAlignment((byte)1);
        textField.setStyle((JRStyle)this.normalStyle);
        textField.setMode((byte)1);
        textField.setForecolor(new Color(41, 89, 148));
        expression = new JRDesignExpression();
        expression.setValueClass(String.class);
        expression.setText("$P{duration}");
        textField.setExpression((JRExpression)expression);
        band.addElement((JRDesignElement)textField);
        textField = new JRDesignTextField();
        textField.setBlankWhenNull(true);
        textField.setX(10);
        textField.setY(116);
        textField.setWidth(600);
        textField.setHeight(20);
        textField.setMode((byte)1);
        textField.setHorizontalAlignment((byte)1);
        textField.setStyle((JRStyle)this.normalStyle);
        textField.setForecolor(new Color(41, 89, 148));
        expression = new JRDesignExpression();
        expression.setValueClass(String.class);
        expression.setText("$P{reportGenAtText}");
        textField.setExpression((JRExpression)expression);
        band.addElement((JRDesignElement)textField);
        textField = new JRDesignTextField();
        textField.setBlankWhenNull(true);
        textField.setX(130);
        textField.setY(116);
        textField.setWidth(600);
        textField.setHeight(20);
        textField.setHorizontalAlignment((byte)1);
        textField.setStyle((JRStyle)this.normalStyle);
        textField.setMode((byte)1);
        textField.setForecolor(new Color(41, 89, 148));
        expression = new JRDesignExpression();
        expression.setValueClass(String.class);
        expression.setText("\":\"");
        textField.setExpression((JRExpression)expression);
        band.addElement((JRDesignElement)textField);
        textField = new JRDesignTextField();
        textField.setBlankWhenNull(true);
        textField.setX(140);
        textField.setY(116);
        textField.setWidth(120);
        textField.setHeight(20);
        textField.setHorizontalAlignment((byte)1);
        textField.setStyle((JRStyle)this.normalStyle);
        textField.setMode((byte)1);
        textField.setForecolor(new Color(41, 89, 148));
        expression = new JRDesignExpression();
        expression.setValueClass(String.class);
        expression.setText("$P{reportGeneratedAt}");
        textField.setExpression((JRExpression)expression);
        band.addElement((JRDesignElement)textField);
        line = new JRDesignLine();
        line.setX(0);
        line.setY(140);
        line.setWidth(100001);
        line.setHeight(1);
        line.setMode((byte)1);
        line.setForecolor(new Color(0, 0, 0));
        band.addElement((JRDesignElement)line);
        if (this.logo != null && new File(this.logo).isFile()) {
            try {
                JRDesignImage jimage = new JRDesignImage((JRDefaultStyleProvider)new JRBaseReport());
                jimage.setX(1);
                jimage.setY(1);
                jimage.setWidth(160);
                jimage.setHeight(50);
                expression = new JRDesignExpression();
                expression.setValueClass(String.class);
                jimage.setExpression((JRExpression)expression);
                band.addElement((JRDesignElement)jimage);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.jd.setTitle((JRBand)band);
    }

    private void addDetails(HashMap top, HashMap left, HashMap measureCol, String summaryType) throws JRException {
        JRDesignBand band = new JRDesignBand();
        band.setHeight(2);
        JRDesignCrosstab jdct = new JRDesignCrosstab();
        jdct.setX(0);
        jdct.setY(1);
        jdct.setWidth(100000);
        jdct.setMode((byte)1);
        JRDesignCrosstabDataset dst = new JRDesignCrosstabDataset();
        JRDesignDatasetRun jrun = new JRDesignDatasetRun();
        jrun.setDatasetName("subDatasetName");
        JRDesignCrosstabParameter jdctp = new JRDesignCrosstabParameter();
        jdctp.setName("ParamName");
        jdctp.setValueClassName("java.lang.String");
        jrun.addParameter((JRDatasetParameter)jdctp);
        jdctp = new JRDesignCrosstabParameter();
        jdctp.setName("fromdate");
        jdctp.setValueClassName("java.lang.Long");
        JRDesignExpression ex = new JRDesignExpression();
        ex.setValueClass(Long.class);
        ex.setText("$P{fromdate1}");
        jdctp.setExpression((JRExpression)ex);
        jrun.addParameter((JRDatasetParameter)jdctp);
        jdctp = new JRDesignCrosstabParameter();
        jdctp.setName("todate");
        jdctp.setValueClassName("java.lang.Long");
        ex = new JRDesignExpression();
        ex.setValueClass(Long.class);
        ex.setText("$P{todate1}");
        jdctp.setExpression((JRExpression)ex);
        jrun.addParameter((JRDatasetParameter)jdctp);
        JRDesignExpression expression = new JRDesignExpression();
        expression.setValueClass(Map.class);
        expression.setText("$P{Details}");
        jrun.setParametersMapExpression((JRExpression)expression);
        dst.setDatasetRun((JRDatasetRun)jrun);
        jdct.setDataset(dst);
        JRDesignCrosstabRowGroup group = new JRDesignCrosstabRowGroup();
        group.setTotalPosition((byte)2);
        group.setName("leftColumnGroup");
        group.setWidth(this.matrix_cell_width);
        JRDesignCrosstabBucket bucket = new JRDesignCrosstabBucket();
        expression = new JRDesignExpression();
        if ("java.util.Date".equals(left.get("COLUMN_DATA_TYPE"))) {
            expression.setValueClassName("java.util.Date");
            expression.setText("com.adventnet.servicedesk.reports.utils.TimeFormat.getYearMonthDay($F{" + left.get("DISPLAY_NAME") + "})");
        } else {
            expression.setValueClassName((String)left.get("COLUMN_DATA_TYPE"));
            if ("java.lang.String".equals(left.get("COLUMN_DATA_TYPE"))) {
                expression.setText("$F{" + left.get("DISPLAY_NAME") + "} == null ? \"" + this.default_null_value + "\" : $F{" + left.get("DISPLAY_NAME") + "}");
            } else {
                expression.setText("$F{" + left.get("DISPLAY_NAME") + "}");
            }
        }
        bucket.setExpression(expression);
        group.setBucket(bucket);
        JRDesignCellContents cellhd = new JRDesignCellContents();
        cellhd.setMode(Byte.valueOf((byte)1));
        cellhd.setBackcolor(new Color(243, 243, 243));
        JRBaseBox bbox = new JRBaseBox();
        byte b = 1;
        bbox.setLeftBorder(b);
        bbox.setTopBorder(b);
        bbox.setRightBorder(b);
        bbox.setBottomBorder(b);
        bbox.setLeftBorderColor(new Color(74, 117, 164));
        bbox.setTopBorderColor(new Color(74, 117, 164));
        bbox.setRightBorderColor(new Color(74, 117, 164));
        bbox.setBottomBorderColor(new Color(180, 198, 230));
        bbox.setLeftBorderColor(new Color(238, 238, 238));
        bbox.setTopBorderColor(new Color(238, 238, 238));
        bbox.setRightBorderColor(new Color(238, 238, 238));
        bbox.setBottomBorderColor(new Color(238, 238, 238));
        cellhd.setBox((JRBox)bbox);
        JRDesignTextField textField = new JRDesignTextField();
        textField.setBlankWhenNull(true);
        textField.setStretchWithOverflow(true);
        textField.setPositionType((byte)1);
        textField.setPrintWhenDetailOverflows(true);
        textField.setTopPadding(new Integer(2));
        textField.setBottomPadding(new Integer(2));
        textField.setX(1);
        textField.setY(1);
        textField.setWidth(this.matrix_cell_width - 1);
        textField.setHeight(0);
        textField.setHorizontalAlignment((byte)2);
        textField.setStyle((JRStyle)this.normalStyle);
        expression = new JRDesignExpression();
        if ("java.util.Date".equals(left.get("COLUMN_DATA_TYPE"))) {
            expression.setValueClassName("java.util.Date");
            textField.setPattern(this.groupDateFormat);
        } else {
            expression.setValueClassName((String)left.get("COLUMN_DATA_TYPE"));
        }
        expression.setText("$V{leftColumnGroup}");
        textField.setForecolor(new Color(0, 0, 0));
        textField.setExpression((JRExpression)expression);
        cellhd.addElement((JRDesignElement)textField);
        group.setHeader(cellhd);
        JRDesignCellContents cellhdt = new JRDesignCellContents();
        cellhdt.setMode(Byte.valueOf((byte)1));
        cellhdt.setBackcolor(new Color(243, 243, 243));
        bbox = new JRBaseBox();
        b = 1;
        bbox.setLeftBorder(b);
        bbox.setTopBorder(b);
        bbox.setRightBorder(b);
        bbox.setBottomBorder(b);
        bbox.setLeftBorderColor(new Color(74, 117, 164));
        bbox.setTopBorderColor(new Color(74, 117, 164));
        bbox.setRightBorderColor(new Color(74, 117, 164));
        bbox.setBottomBorderColor(new Color(74, 117, 164));
        bbox.setLeftBorderColor(new Color(238, 238, 238));
        bbox.setTopBorderColor(new Color(238, 238, 238));
        bbox.setRightBorderColor(new Color(238, 238, 238));
        bbox.setBottomBorderColor(new Color(238, 238, 238));
        cellhdt.setBox((JRBox)bbox);
        textField = new JRDesignTextField();
        textField.setStretchWithOverflow(true);
        textField.setPositionType((byte)1);
        textField.setPrintWhenDetailOverflows(true);
        textField.setTopPadding(new Integer(2));
        textField.setBottomPadding(new Integer(2));
        textField.setBlankWhenNull(true);
        textField.setX(1);
        textField.setY(1);
        textField.setWidth(this.matrix_cell_width - 1);
        textField.setHeight(0);
        textField.setStyle((JRStyle)this.boldStyle);
        textField.setMode((byte)1);
        textField.setHorizontalAlignment((byte)2);
        textField.setBackcolor(new Color(243, 243, 243));
        textField.setForecolor(new Color(0, 0, 0));
        expression = new JRDesignExpression();
        expression.setValueClassName("java.lang.String");
        if ("Sum".equals(summaryType)) {
            expression.setText("\"" + this.totali18n + " \"");
        } else {
            expression.setText("\"" + summaryType + " \"");
        }
        textField.setExpression((JRExpression)expression);
        cellhdt.addElement((JRDesignElement)textField);
        group.setTotalHeader(cellhdt);
        jdct.addRowGroup(group);
        JRDesignCrosstabColumnGroup cgroup = new JRDesignCrosstabColumnGroup();
        cgroup.setTotalPosition((byte)2);
        cgroup.setName("topColumnGroup");
        cgroup.setHeight(2);
        bucket = new JRDesignCrosstabBucket();
        expression = new JRDesignExpression();
        if ("java.util.Date".equals(top.get("COLUMN_DATA_TYPE"))) {
            expression.setValueClassName("java.util.Date");
            expression.setText("com.adventnet.servicedesk.reports.utils.TimeFormat.getYearMonthDay($F{" + top.get("DISPLAY_NAME") + "})");
        } else {
            expression.setValueClassName((String)top.get("COLUMN_DATA_TYPE"));
            if ("java.lang.String".equals(top.get("COLUMN_DATA_TYPE"))) {
                expression.setText("$F{" + top.get("DISPLAY_NAME") + "} == null ? \"" + this.default_null_value + "\" : $F{" + top.get("DISPLAY_NAME") + "}");
            } else {
                expression.setText("$F{" + top.get("DISPLAY_NAME") + "}");
            }
        }
        bucket.setExpression(expression);
        cgroup.setBucket(bucket);
        cellhd = new JRDesignCellContents();
        cellhd.setMode(Byte.valueOf((byte)1));
        cellhd.setBackcolor(new Color(243, 243, 243));
        bbox = new JRBaseBox();
        b = 1;
        bbox.setLeftBorder(b);
        bbox.setTopBorder(b);
        bbox.setRightBorder(b);
        bbox.setBottomBorder(b);
        bbox.setLeftBorderColor(new Color(238, 238, 238));
        bbox.setTopBorderColor(new Color(238, 238, 238));
        bbox.setRightBorderColor(new Color(238, 238, 238));
        bbox.setBottomBorderColor(new Color(238, 238, 238));
        cellhd.setBox((JRBox)bbox);
        textField = new JRDesignTextField();
        textField.setStretchWithOverflow(true);
        textField.setPositionType((byte)1);
        textField.setPrintWhenDetailOverflows(true);
        textField.setTopPadding(new Integer(2));
        textField.setBottomPadding(new Integer(2));
        textField.setBlankWhenNull(true);
        textField.setX(1);
        textField.setY(1);
        textField.setWidth(this.matrix_cell_width - 1);
        textField.setHeight(0);
        textField.setStyle((JRStyle)this.boldStyle);
        textField.setMode((byte)1);
        textField.setBackcolor(new Color(243, 243, 243));
        textField.setHorizontalAlignment((byte)2);
        textField.setForecolor(new Color(0, 0, 0));
        expression = new JRDesignExpression();
        expression.setValueClassName("java.lang.String");
        if ("Sum".equals(summaryType)) {
            expression.setText("\"" + this.totali18n + " \"");
        } else {
            expression.setText("\"" + summaryType + " \"");
        }
        textField.setExpression((JRExpression)expression);
        cellhd.addElement((JRDesignElement)textField);
        cgroup.setTotalHeader(cellhd);
        cellhd = new JRDesignCellContents();
        cellhd.setMode(Byte.valueOf((byte)1));
        cellhd.setBackcolor(new Color(243, 243, 243));
        bbox = new JRBaseBox();
        b = 1;
        bbox.setLeftBorder(b);
        bbox.setTopBorder(b);
        bbox.setRightBorder(b);
        bbox.setBottomBorder(b);
        bbox.setLeftBorderColor(new Color(238, 238, 238));
        bbox.setTopBorderColor(new Color(238, 238, 238));
        bbox.setRightBorderColor(new Color(238, 238, 238));
        bbox.setBottomBorderColor(new Color(238, 238, 238));
        bbox.setLeftBorderColor(new Color(74, 117, 164));
        bbox.setTopBorderColor(new Color(74, 117, 164));
        bbox.setRightBorderColor(new Color(0, 0, 0));
        bbox.setBottomBorderColor(new Color(74, 117, 164));
        cellhd.setBox((JRBox)bbox);
        textField = new JRDesignTextField();
        textField.setBlankWhenNull(true);
        textField.setStretchWithOverflow(true);
        textField.setPositionType((byte)1);
        textField.setPrintWhenDetailOverflows(true);
        textField.setTopPadding(new Integer(2));
        textField.setBottomPadding(new Integer(2));
        textField.setX(1);
        textField.setY(1);
        textField.setWidth(this.matrix_cell_width - 1);
        textField.setHeight(0);
        textField.setHorizontalAlignment((byte)2);
        textField.setStyle((JRStyle)this.normalStyle);
        expression = new JRDesignExpression();
        if ("java.util.Date".equals(top.get("COLUMN_DATA_TYPE"))) {
            expression.setValueClassName("java.util.Date");
            textField.setPattern(this.groupDateFormat);
        } else {
            expression.setValueClassName((String)top.get("COLUMN_DATA_TYPE"));
        }
        expression.setText("$V{topColumnGroup}");
        textField.setForecolor(new Color(0, 0, 0));
        textField.setExpression((JRExpression)expression);
        cellhd.addElement((JRDesignElement)textField);
        cgroup.setHeader(cellhd);
        jdct.addColumnGroup(cgroup);
        JRDesignCrosstabMeasure mes = new JRDesignCrosstabMeasure();
        mes.setName("summary_column");
        if ("java.sql.Time".equals(measureCol.get("COLUMN_DATA_TYPE"))) {
            mes.setValueClassName("java.lang.Long");
        } else if ("javax.lang.Memory".equals(measureCol.get("COLUMN_DATA_TYPE"))) {
            mes.setValueClassName("java.lang.Long");
        } else if ("java.lang.String".equals(measureCol.get("COLUMN_DATA_TYPE")) || "java.util.Date".equals(measureCol.get("COLUMN_DATA_TYPE"))) {
            mes.setValueClassName("java.lang.Long");
            summaryType = "Count";
        } else {
            mes.setValueClassName((String)measureCol.get("COLUMN_DATA_TYPE"));
        }
        if ("Sum".equals(summaryType)) {
            mes.setCalculation((byte)2);
        } else if ("Avg".equals(summaryType)) {
            mes.setCalculation((byte)3);
        } else if ("Min".equals(summaryType)) {
            mes.setCalculation((byte)4);
        } else if ("Max".equals(summaryType)) {
            mes.setCalculation((byte)5);
        } else {
            mes.setCalculation((byte)2);
        }
        expression = new JRDesignExpression();
        if ("java.sql.Time".equals(measureCol.get("COLUMN_DATA_TYPE")) || "java.util.Date".equals(measureCol.get("COLUMN_DATA_TYPE"))) {
            expression.setValueClassName("java.lang.Long");
            expression.setText("new Long(Math.round($F{" + measureCol.get("DISPLAY_NAME") + "}.longValue()/1000l) * 1000l)");
        } else if ("javax.lang.Memory".equals(measureCol.get("COLUMN_DATA_TYPE"))) {
            expression.setValueClassName("java.lang.Long");
            expression.setText("$F{" + measureCol.get("DISPLAY_NAME") + "}" + " == null ? new Long(0) : $F{" + measureCol.get("DISPLAY_NAME") + "}");
        } else {
            expression.setValueClassName((String)measureCol.get("COLUMN_DATA_TYPE"));
            if ("java.lang.Integer".equals(measureCol.get("COLUMN_DATA_TYPE"))) {
                expression.setText("$F{" + measureCol.get("DISPLAY_NAME") + "} == null ? new Integer(0) : $F{" + measureCol.get("DISPLAY_NAME") + "}");
            } else if ("java.lang.Long".equals((String)measureCol.get("COLUMN_DATA_TYPE"))) {
                expression.setText("$F{" + measureCol.get("DISPLAY_NAME") + "} == null ? new Long(0) : $F{" + measureCol.get("DISPLAY_NAME") + "}");
            } else if ("java.lang.Double".equals((String)measureCol.get("COLUMN_DATA_TYPE"))) {
                expression.setText("$F{" + measureCol.get("DISPLAY_NAME") + "} == null ? new Double(0.0) : com.adventnet.servicedesk.reports.utils.DoubleFormat.formatD($F{" + measureCol.get("DISPLAY_NAME") + "},2,2)");
            } else {
                expression.setText("$F{" + measureCol.get("DISPLAY_NAME") + "}");
            }
        }
        mes.setValueExpression((JRExpression)expression);
        jdct.addMeasure(mes);
        JRDesignCrosstabCell cell = new JRDesignCrosstabCell();
        cell.setWidth(Integer.valueOf(this.matrix_cell_width));
        cell.setHeight(Integer.valueOf(2));
        JRDesignCellContents cellcont = new JRDesignCellContents();
        cellcont.setMode(Byte.valueOf((byte)1));
        cellcont.setBackcolor(new Color(255, 255, 255));
        bbox = new JRBaseBox();
        bbox.setBottomBorder(b);
        bbox.setLeftBorder(b);
        bbox.setTopBorder(b);
        bbox.setRightBorder(b);
        bbox.setLeftBorderColor(new Color(123, 129, 123));
        bbox.setTopBorderColor(new Color(123, 129, 123));
        bbox.setRightBorderColor(new Color(74, 117, 164));
        bbox.setBottomBorderColor(new Color(74, 117, 164));
        cellcont.setBox((JRBox)bbox);
        textField = new JRDesignTextField();
        textField.setBlankWhenNull(true);
        textField.setStretchWithOverflow(true);
        textField.setPositionType((byte)1);
        textField.setPrintWhenDetailOverflows(true);
        textField.setTopPadding(new Integer(2));
        textField.setBottomPadding(new Integer(2));
        textField.setStretchType((byte)2);
        textField.setX(1);
        textField.setY(1);
        textField.setWidth(this.matrix_cell_width - 1);
        textField.setHeight(0);
        textField.setHorizontalAlignment((byte)2);
        textField.setStyle((JRStyle)this.normalStyle);
        expression = new JRDesignExpression();
        if ("java.sql.Time".equals(measureCol.get("COLUMN_DATA_TYPE")) && !"Count".equals(summaryType)) {
            expression.setValueClassName("java.lang.String");
            expression.setText("com.adventnet.servicedesk.reports.utils.TimeFormat.format(new Long(Math.round($V{summary_column}.longValue()/1000L) * 1000L))");
        } else if ("java.sql.Time".equals(measureCol.get("COLUMN_DATA_TYPE")) || "java.lang.String".equals(measureCol.get("COLUMN_DATA_TYPE")) || "java.util.Date".equals(measureCol.get("COLUMN_DATA_TYPE"))) {
            expression.setValueClass(Long.class);
            expression.setText("$V{summary_column}");
        } else if ("javax.lang.Memory".equals(measureCol.get("COLUMN_DATA_TYPE"))) {
            expression.setValueClass(String.class);
            expression.setText("$V{summary_column} == null ? new Long(0) + \" b\": com.adventnet.servicedesk.reports.utils.ReportUtil.convert($V{summary_column}.longValue())");
        } else if ("java.lang.Double".equals(measureCol.get("COLUMN_DATA_TYPE"))) {
            expression.setValueClassName((String)measureCol.get("COLUMN_DATA_TYPE"));
            expression.setText("com.adventnet.servicedesk.reports.utils.DoubleFormat.formatD($V{summary_column},2,2)");
        } else {
            expression.setValueClassName((String)measureCol.get("COLUMN_DATA_TYPE"));
            expression.setText("$V{summary_column}");
        }
        textField.setExpression((JRExpression)expression);
        cellcont.addElement((JRDesignElement)textField);
        cell.setContents(cellcont);
        jdct.addCell(cell);
        band.addElement((JRDesignElement)jdct);
        this.jd.setDetail((JRBand)band);
    }
}

