/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.i18n;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.JsMessage;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import java.util.HashMap;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class ResourceBundleMgr {
    private static volatile ResourceBundleMgr instance = null;
    private HashMap rbLocaleMap = new HashMap();
    private HashMap jsLocaleMap = new HashMap();
    private static Locale serverLocale = null;

    private ResourceBundleMgr() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ResourceBundleMgr getInstance() {
        if (instance != null) return instance;
        Class<ResourceBundleMgr> clazz = ResourceBundleMgr.class;
        synchronized (ResourceBundleMgr.class) {
            if (instance != null) return instance;
            instance = new ResourceBundleMgr();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public AdventNetResourceBundle getBundle() {
        return this.getBundle(serverLocale);
    }

    public AdventNetResourceBundle getBundle(Locale locale) {
        AdventNetResourceBundle rb = null;
        try {
            rb = (AdventNetResourceBundle)this.rbLocaleMap.get(locale);
            if (rb == null) {
                rb = new AdventNetResourceBundle(locale);
                this.rbLocaleMap.put(locale, rb);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return rb;
    }

    public AdventNetResourceBundle getBundle(HttpServletRequest request) {
        Locale locale = null;
        try {
            HttpSession session = request.getSession();
            locale = session.getAttribute("USER_LOCALE") != null ? (Locale)session.getAttribute("USER_LOCALE") : this.getClientLocale(1L, request);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.getBundle(locale);
    }

    public void setUserLocale(Long loginId, Long localeId, HttpServletRequest request) {
        try {
            Criteria crit = new Criteria(Column.getColumn((String)"User_Locale", (String)"LOGIN_ID"), (Object)loginId, 0);
            DataObject dObj = CommonUtil.getPersistence(new boolean[0]).get("User_Locale", crit);
            if (!dObj.isEmpty()) {
                dObj.deleteRows("User_Locale", crit);
            }
            Row r = new Row("User_Locale");
            r.set("LOGIN_ID", (Object)loginId);
            r.set("LOCALE_ID", (Object)localeId);
            dObj.addRow(r);
            CommonUtil.getPersistence(new boolean[0]).update(dObj);
            Locale locale = ResourceBundleMgr.getLocale(localeId);
            request.getSession().setAttribute("USER_LOCALE", (Object)locale);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getJsMessage(Locale locale) {
        String jsMessage = "";
        try {
            JsMessage jsBundleObj = (JsMessage)this.jsLocaleMap.get(locale);
            if (jsBundleObj == null) {
                jsBundleObj = new JsMessage(locale);
                this.jsLocaleMap.put(locale, jsBundleObj);
            }
            jsMessage = jsBundleObj.getString();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return jsMessage;
    }

    public String getJsMessage2(Locale locale) {
        String jsMessage = "";
        try {
            JsMessage jsBundleObj = (JsMessage)this.jsLocaleMap.get(locale);
            jsBundleObj = null;
            if (jsBundleObj == null) {
                jsBundleObj = new JsMessage(locale);
                this.jsLocaleMap.put(locale, jsBundleObj);
            }
            jsMessage = jsBundleObj.getString2();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return jsMessage;
    }

    public void updateLocaleDetails(Long localeId, String language, String country) {
        try {
            Criteria crit = new Criteria(Column.getColumn((String)"LocaleDetails", (String)"LOCALE_ID"), (Object)localeId, 0);
            DataObject dObj = CommonUtil.getPersistence(new boolean[0]).get("LocaleDetails", crit);
            if (!dObj.isEmpty()) {
                Row r = dObj.getFirstRow("LocaleDetails");
                r.set("LOCALE_LANGUAGE", (Object)language);
                r.set("LOCALE_COUNTRY", (Object)country);
                dObj.updateRow(r);
                CommonUtil.getPersistence(new boolean[0]).update(dObj);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Locale getServerLocale() {
        Locale locale = null;
        Long localeId = ResourceBundleMgr.getUserLocaleId(1L);
        locale = localeId == 0L || localeId == -1L ? Locale.getDefault() : ResourceBundleMgr.getLocale(localeId);
        return locale;
    }

    public Locale getClientLocale(HttpServletRequest request) {
        HttpSession session = request.getSession();
        Locale locale = (Locale)session.getAttribute("USER_LOCALE");
        if (locale == null) {
            Long loginId = (Long)request.getSession().getAttribute("ADAP_SESSION_LOGIN_ID");
            return this.getClientLocale(loginId, request);
        }
        return locale;
    }

    public Locale getClientLocale(Long loginId, HttpServletRequest request) {
        Locale locale = null;
        try {
            Long localeId = this.getClientLocaleId(loginId);
            locale = localeId == 0L || localeId == -1L ? request.getLocale() : ResourceBundleMgr.getLocale(localeId);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return locale;
    }

    public static Long getUserLocaleId(Long loginId) {
        Long localeId = -1L;
        try {
            Criteria crit = new Criteria(Column.getColumn((String)"User_Locale", (String)"LOGIN_ID"), (Object)loginId, 0);
            DataObject dObj = CommonUtil.getPersistence(new boolean[0]).get("User_Locale", crit);
            if (!dObj.isEmpty()) {
                Row r = dObj.getFirstRow("User_Locale");
                localeId = (Long)r.get("LOCALE_ID");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return localeId;
    }

    public static Locale getLocale(Long localeId) {
        Locale locale = new Locale("en", "US");
        try {
            Criteria crit = new Criteria(Column.getColumn((String)"LocaleDetails", (String)"LOCALE_ID"), (Object)localeId, 0);
            DataObject dObj = CommonUtil.getPersistence(new boolean[0]).get("LocaleDetails", crit);
            if (!dObj.isEmpty()) {
                Row r = dObj.getFirstRow("LocaleDetails");
                String language = (String)r.get("LOCALE_LANGUAGE");
                String country = (String)r.get("LOCALE_COUNTRY");
                locale = country != null && !country.equals("") ? new Locale(language, country) : new Locale(language);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return locale;
    }

    public Long getClientLocaleId(Long loginId) {
        Long localeId = ResourceBundleMgr.getUserLocaleId(loginId);
        if (localeId == -1L && (loginId == null || loginId != 1L)) {
            localeId = ResourceBundleMgr.getUserLocaleId(1L);
        }
        return localeId;
    }

    static {
        serverLocale = ResourceBundleMgr.getServerLocale();
    }
}

