/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.mail;

import com.adventnet.sym.adsm.common.server.util.MailServerUtil;
import java.io.File;
import java.io.IOException;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimeUtility;

public class SendMailAPI
extends Thread {
    private String fileName = null;
    private static Logger logger = Logger.getLogger("MailLogger");
    private HashMap mailServerProperties = null;
    private Vector sendMailQue = new Vector();
    private static volatile SendMailAPI handle;
    private static boolean debugFlag;
    public static boolean MAIL_HOST_ERROR;
    private Hashtable invalidHash = new Hashtable();
    private long recycleTime = 120000L;
    private boolean shutdownSignal = false;
    private boolean isShutdowned = false;
    private Object recycleThread = new Object();
    private static boolean isContentTypePlain;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SendMailAPI getInstance() {
        if (handle != null) return handle;
        Class<SendMailAPI> clazz = SendMailAPI.class;
        synchronized (SendMailAPI.class) {
            if (handle != null) return handle;
            handle = new SendMailAPI();
            handle.start();
            // ** MonitorExit[var0] (shouldn't be in output)
            return handle;
        }
    }

    public boolean getIsContentTypePlain() {
        return isContentTypePlain;
    }

    private SendMailAPI() {
        this.setMailServerSettings();
    }

    public SendMailAPI(Properties prop) {
        try {
            this.setmailServerDetails(prop);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void setMailServerSettings() {
        try {
            Properties prop = MailServerUtil.getMailServerSettings();
            this.setmailServerDetails(prop);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setmailServerDetails(Properties prop) throws Exception {
        this.mailServerProperties = new HashMap();
        this.mailServerProperties.put("MAIL_SERVER", (String)prop.get("MAIL_SERVER"));
        this.mailServerProperties.put("SMTP_PORT", new Long(prop.get("SMTP_PORT").toString()));
        this.mailServerProperties.put("FROM_ADDRESS", (String)prop.get("FROM_ADDRESS"));
        this.mailServerProperties.put("IS_AUTHENTICATION_REQUIRED", prop.get("IS_AUTHENTICATION_REQUIRED"));
        this.mailServerProperties.put("USER_NAME", (String)prop.get("USER_NAME"));
        this.mailServerProperties.put("PASSWORD", (String)prop.get("PASSWORD"));
        this.mailServerProperties.put("PLAIN_TEXT_MAIL", prop.get("PLAIN_TEXT_MAIL"));
        this.mailServerProperties.put("USE_SECURE_CONN", prop.get("USE_SECURE_CONN"));
        isContentTypePlain = Boolean.valueOf(this.mailServerProperties.get("PLAIN_TEXT_MAIL").toString());
    }

    public void updateMailServerSettings() {
        try {
            if (this.mailServerProperties != null) {
                this.setMailServerSettings();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSendMailInQue(Vector inQ) {
        try {
            Vector vector = inQ;
            synchronized (vector) {
                this.sendMailQue.addAll(inQ);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block8: while (true) {
            try {
                Object object;
                while (MAIL_HOST_ERROR) {
                    if (!this.updateMailServerStatus()) continue;
                    object = this.recycleThread;
                    synchronized (object) {
                        this.recycleThread.wait(this.recycleTime);
                        continue block8;
                    }
                }
                this.processMailRequests();
                object = this.recycleThread;
                synchronized (object) {
                    this.recycleThread.wait(this.recycleTime);
                    continue;
                }
            }
            catch (Throwable th) {
                th.printStackTrace();
                continue;
            }
            break;
        }
    }

    private boolean updateMailServerStatus() {
        try {
            String mailServer = (String)this.mailServerProperties.get("MAIL_SERVER");
            Socket soc = new Socket(mailServer, (int)Integer.valueOf(this.mailServerProperties.get("SMTP_PORT").toString()));
            soc.close();
            MAIL_HOST_ERROR = false;
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
        return MAIL_HOST_ERROR;
    }

    public boolean isValidHost() {
        return !MAIL_HOST_ERROR;
    }

    public void clearHostError() {
        MAIL_HOST_ERROR = false;
    }

    public void clearInvalidMailId(String userName) {
        if (this.invalidHash.get(userName) != null) {
            this.invalidHash.remove(userName);
        }
    }

    private boolean isCycled(HashMap map) {
        String time = (String)map.get("lastCycleTime");
        if (time == null) {
            return false;
        }
        return System.currentTimeMillis() - Long.valueOf(time) <= this.recycleTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processMailRequests() {
        Vector sendMailQueCopy = null;
        Vector vector = this.sendMailQue;
        synchronized (vector) {
            sendMailQueCopy = this.sendMailQue;
            this.sendMailQue = new Vector();
        }
        if (sendMailQueCopy.size() > 0) {
            for (Object object : sendMailQueCopy) {
                HashMap map = (HashMap)object;
                try {
                    this.sendMail(map);
                    Thread.sleep(100L);
                }
                catch (Exception mex) {
                    logger.log(Level.SEVERE, "Exception " + mex.getMessage() + " occured while mailing " + map);
                    mex.printStackTrace();
                    this.handleSendFailedException(mex, map);
                }
                if (!this.shutdownSignal) continue;
                break;
            }
        }
    }

    public boolean sendMail(HashMap mailDetails) throws Exception {
        String usetls;
        String mailServer = (String)this.mailServerProperties.get("MAIL_SERVER");
        Properties properties = System.getProperties();
        properties.put("mail.smtp.host", mailServer);
        properties.put("mail.smtp.sendpartial", "true");
        if (Boolean.valueOf(this.mailServerProperties.get("IS_AUTHENTICATION_REQUIRED").toString()).booleanValue()) {
            properties.put("mail.smtp.auth", "true");
        } else {
            properties.put("mail.smtp.auth", "false");
        }
        if (this.mailServerProperties.get("SMTP_PORT") != null) {
            properties.put("mail.smtp.port", this.mailServerProperties.get("SMTP_PORT").toString());
        }
        if (!(usetls = (String)this.mailServerProperties.get("USE_SECURE_CONN")).equalsIgnoreCase("none")) {
            if (usetls.equalsIgnoreCase("tls")) {
                properties.put("mail.smtp.starttls.enable", "true");
                properties.put("mail.smtp.starttls.required", "true");
                properties.remove("mail.smtp.socketFactory.port");
                properties.remove("mail.smtp.socketFactory.class");
                properties.remove("mail.smtp.socketFactory.fallback");
            } else {
                properties.put("mail.smtp.socketFactory.port", this.mailServerProperties.get("SMTP_PORT").toString());
                properties.put("mail.smtp.socketFactory.class", "javax.net.ssl.SSLSocketFactory");
                properties.put("mail.smtp.socketFactory.fallback", "false");
                properties.remove("mail.smtp.starttls.enable");
                properties.remove("mail.smtp.starttls.required");
            }
        } else {
            properties.remove("mail.debug");
            properties.remove("mail.smtp.starttls.required");
            properties.remove("mail.smtp.starttls.enable");
            properties.remove("mail.smtp.socketFactory.port");
            properties.remove("mail.smtp.socketFactory.class");
            properties.remove("mail.smtp.socketFactory.fallback");
        }
        Session session = Session.getInstance((Properties)properties);
        if (Boolean.valueOf(this.mailServerProperties.get("IS_AUTHENTICATION_REQUIRED").toString()).booleanValue()) {
            String userName = (String)this.mailServerProperties.get("USER_NAME");
            String password = (String)this.mailServerProperties.get("PASSWORD");
            SMTPAuthenticator auth = new SMTPAuthenticator(userName, password);
            session = Session.getInstance((Properties)properties, (Authenticator)auth);
        }
        session.setDebug(debugFlag);
        this.sendMail(mailDetails, session);
        return true;
    }

    public boolean sendMail(HashMap mailDetails, ArrayList emptyFileList) throws Exception {
        String usetls;
        String mailServer = (String)this.mailServerProperties.get("MAIL_SERVER");
        Properties properties = System.getProperties();
        properties.put("mail.smtp.host", mailServer);
        properties.put("mail.smtp.sendpartial", "true");
        if (Boolean.valueOf(this.mailServerProperties.get("IS_AUTHENTICATION_REQUIRED").toString()).booleanValue()) {
            properties.put("mail.smtp.auth", "true");
        } else {
            properties.put("mail.smtp.auth", "false");
        }
        if (this.mailServerProperties.get("SMTP_PORT") != null) {
            properties.put("mail.smtp.port", this.mailServerProperties.get("SMTP_PORT").toString());
        }
        if (!(usetls = (String)this.mailServerProperties.get("USE_SECURE_CONN")).equalsIgnoreCase("none")) {
            if (usetls.equalsIgnoreCase("tls")) {
                properties.put("mail.smtp.starttls.enable", "true");
                properties.put("mail.smtp.starttls.required", "true");
                properties.remove("mail.smtp.socketFactory.port");
                properties.remove("mail.smtp.socketFactory.class");
                properties.remove("mail.smtp.socketFactory.fallback");
            } else {
                properties.put("mail.smtp.socketFactory.port", this.mailServerProperties.get("SMTP_PORT").toString());
                properties.put("mail.smtp.socketFactory.class", "javax.net.ssl.SSLSocketFactory");
                properties.put("mail.smtp.socketFactory.fallback", "false");
                properties.remove("mail.smtp.starttls.enable");
                properties.remove("mail.smtp.starttls.required");
            }
        } else {
            properties.remove("mail.debug");
            properties.remove("mail.smtp.starttls.required");
            properties.remove("mail.smtp.starttls.enable");
            properties.remove("mail.smtp.socketFactory.port");
            properties.remove("mail.smtp.socketFactory.class");
            properties.remove("mail.smtp.socketFactory.fallback");
        }
        Session session = Session.getInstance((Properties)properties);
        if (Boolean.valueOf(this.mailServerProperties.get("IS_AUTHENTICATION_REQUIRED").toString()).booleanValue()) {
            String userName = (String)this.mailServerProperties.get("USER_NAME");
            String password = (String)this.mailServerProperties.get("PASSWORD");
            SMTPAuthenticator auth = new SMTPAuthenticator(userName, password);
            session = Session.getInstance((Properties)properties, (Authenticator)auth);
        }
        session.setDebug(debugFlag);
        this.sendMail(mailDetails, session, emptyFileList);
        return true;
    }

    public void sendMail(HashMap mailDetails, Session session) throws Exception {
        MimeMessage mess = new MimeMessage(session);
        this.setEmailAddress(mailDetails, mess);
        String message = (String)mailDetails.get("message");
        mess.setSubject((String)mailDetails.get("subject"), "UTF-8");
        Boolean isGPOAlert = (Boolean)mailDetails.get("isGPOAlert");
        if (isGPOAlert == null) {
            isGPOAlert = false;
        }
        if (mailDetails.get("isSummary") != null) {
            isContentTypePlain = false;
        }
        if (mailDetails.get("contentType") == null && isContentTypePlain && !isGPOAlert.booleanValue() || "text".equalsIgnoreCase((String)mailDetails.get("contentType"))) {
            mess.setContent((Object)message, "text/plain;charset=utf-8");
        } else {
            mess.setContent((Object)message, "text/html;charset=utf-8");
        }
        this.setAttachment(mailDetails, mess, message);
        Transport.send((Message)mess);
    }

    public void sendMail(HashMap mailDetails, Session session, ArrayList emptyFileList) throws Exception {
        MimeMessage mess = new MimeMessage(session);
        this.setEmailAddress(mailDetails, mess);
        String message = (String)mailDetails.get("message");
        mess.setSubject((String)mailDetails.get("subject"), "UTF-8");
        Boolean isGPOAlert = (Boolean)mailDetails.get("isGPOAlert");
        if (isGPOAlert == null) {
            isGPOAlert = false;
        }
        if (mailDetails.get("contentType") == null && isContentTypePlain && !isGPOAlert.booleanValue() || "text".equalsIgnoreCase((String)mailDetails.get("contentType"))) {
            mess.setContent((Object)message, "text/plain;charset=utf-8");
        } else {
            mess.setContent((Object)message, "text/html;charset=utf-8");
        }
        this.setAttachment(mailDetails, mess, message, emptyFileList);
        Transport.send((Message)mess);
    }

    public void setEmailAddress(HashMap mailDetails, MimeMessage mess) throws Exception {
        int i;
        String from = (String)this.mailServerProperties.get("FROM_ADDRESS");
        if (from != null && !from.equals("")) {
            mess.setFrom((Address)new InternetAddress(from));
        }
        if (mailDetails.get("toAddress") != null) {
            String[] to = (String[])mailDetails.get("toAddress");
            InternetAddress[] toInternetAddress = new InternetAddress[to.length];
            for (i = 0; i < to.length; ++i) {
                if (to[i] == null || to[i].length() <= 0) continue;
                toInternetAddress[i] = new InternetAddress(to[i].trim());
            }
            mess.setRecipients(Message.RecipientType.TO, (Address[])toInternetAddress);
        }
        mess.setSentDate(new Date());
        if (mailDetails.get("ccAddress") != null) {
            String[] cc = (String[])mailDetails.get("ccAddress");
            InternetAddress[] ccInternetAddress = new InternetAddress[cc.length];
            for (i = 0; i < cc.length; ++i) {
                ccInternetAddress[i] = new InternetAddress(cc[i].trim());
            }
            mess.setRecipients(Message.RecipientType.CC, (Address[])ccInternetAddress);
        }
    }

    public void setAttachment(HashMap mailDetails, MimeMessage mess, String message) throws Exception {
        MimeBodyPart messageBodyPart = new MimeBodyPart();
        messageBodyPart.setText(message, "UTF-8");
        MimeMultipart multipart = new MimeMultipart();
        multipart.addBodyPart((BodyPart)messageBodyPart);
        String attachment = (String)mailDetails.get("attachment");
        if (attachment != null) {
            ArrayList list = (ArrayList)mailDetails.get("filesList");
            File fFile = new File(attachment);
            if (fFile.exists()) {
                logger.log(Level.INFO, "files are existing");
                File[] fList = fFile.listFiles();
                for (int i = 0; i < fList.length; ++i) {
                    for (int l = 0; l < list.size(); ++l) {
                        if (!fList[i].getName().contains((CharSequence)list.get(l))) continue;
                        logger.log(Level.INFO, "filename is " + fList[i]);
                        messageBodyPart = new MimeBodyPart();
                        FileDataSource dataSource = new FileDataSource(fList[i]);
                        messageBodyPart.setDataHandler(new DataHandler((DataSource)dataSource));
                        this.fileName = MimeUtility.encodeText((String)fList[i].getName(), (String)"UTF-8", (String)"B");
                        messageBodyPart.setFileName(this.fileName);
                        multipart.addBodyPart((BodyPart)messageBodyPart);
                    }
                }
            }
            mess.setContent((Multipart)multipart);
        }
    }

    public void setAttachment(HashMap mailDetails, MimeMessage mess, String message, ArrayList emptyFileList) throws Exception {
        MimeBodyPart messageBodyPart = new MimeBodyPart();
        messageBodyPart.setText(message, "UTF-8");
        MimeMultipart multipart = new MimeMultipart();
        multipart.addBodyPart((BodyPart)messageBodyPart);
        String attachment = (String)mailDetails.get("attachment");
        emptyFileList.remove(emptyFileList.size() - 1);
        if (attachment != null) {
            ArrayList list = (ArrayList)mailDetails.get("filesList");
            File fFile = new File(attachment);
            if (fFile.exists()) {
                logger.log(Level.INFO, "files are existing");
                File[] fList = fFile.listFiles();
                String temp = null;
                for (int i = 0; i < fList.length; ++i) {
                    for (int l = 0; l < list.size(); ++l) {
                        if (!fList[i].getName().contains((CharSequence)list.get(l))) continue;
                        boolean mailsendflag = false;
                        temp = fList[i].getName().replaceAll("_", " ");
                        for (int j = 1; j < emptyFileList.size(); ++j) {
                            if (temp.indexOf((String)emptyFileList.get(j)) == -1) continue;
                            mailsendflag = true;
                        }
                        if (mailsendflag && !list.contains(fList[i].getName())) continue;
                        logger.log(Level.INFO, "filename is " + fList[i]);
                        messageBodyPart = new MimeBodyPart();
                        FileDataSource dataSource = new FileDataSource(fList[i]);
                        messageBodyPart.setDataHandler(new DataHandler((DataSource)dataSource));
                        this.fileName = MimeUtility.encodeText((String)fList[i].getName(), (String)"UTF-8", (String)"B");
                        messageBodyPart.setFileName(this.fileName);
                        multipart.addBodyPart((BodyPart)messageBodyPart);
                    }
                }
            }
            mess.setContent((Multipart)multipart);
        }
    }

    private void handleSendFailedException(Exception mex, HashMap map) {
        Exception ex = mex;
        boolean resend = false;
        do {
            if (ex instanceof MessagingException) {
                if ((ex = ((MessagingException)((Object)ex)).getNextException()) == null) continue;
                logger.log(Level.INFO, ex.getMessage());
                continue;
            }
            if (ex instanceof IOException) {
                logger.log(Level.INFO, "Network Failure or Mail Server Down " + ex.getMessage());
                ex.printStackTrace();
                MAIL_HOST_ERROR = true;
                ex = null;
                continue;
            }
            logger.log(Level.INFO, "The exception is :" + ex.getMessage());
            ex.printStackTrace();
            ex = null;
        } while (ex != null);
    }

    private HashMap removeInValidAddress(HashMap mailDetails, Address[] invalid) {
        if (mailDetails.get("toAddress") != null) {
            mailDetails.put("toAddress", this.getRemovedAddress((String[])mailDetails.get("toAddress"), invalid));
        }
        if (mailDetails.get("ccAddress") != null) {
            mailDetails.put("ccAddress", this.getRemovedAddress((String[])mailDetails.get("toAddress"), invalid));
        }
        return mailDetails;
    }

    private String[] getRemovedAddress(String[] address, Address[] invalid) {
        String[] ret = new String[address.length];
        int count = 0;
        for (int i = 0; i < address.length; ++i) {
            for (int j = 0; j < invalid.length; ++j) {
                if (address[i].equalsIgnoreCase(invalid[j].toString())) continue;
                ret[count++] = address[i];
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopSending() {
        if (this.isShutdowned) {
            return;
        }
        this.shutdownSignal = true;
        Object object = this.recycleThread;
        synchronized (object) {
            this.recycleThread.notify();
        }
        while (!this.isShutdowned) {
            try {
                Thread.sleep(500L);
            }
            catch (Exception exp) {
                exp.printStackTrace();
            }
        }
    }

    static {
        debugFlag = false;
        MAIL_HOST_ERROR = false;
        isContentTypePlain = false;
    }

    private static class SMTPAuthenticator
    extends Authenticator {
        private String userName = null;
        private String password = null;

        public SMTPAuthenticator(String userName, String password) {
            this.userName = userName;
            this.password = password;
        }

        public PasswordAuthentication getPasswordAuthentication() {
            if (this.userName != null && this.password != null) {
                return new PasswordAuthentication(this.userName, this.password);
            }
            return null;
        }
    }
}

