/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.model;

import com.adventnet.sym.adsm.common.server.model.TreeObject;
import com.adventnet.sym.adsm.common.server.util.CommonIconUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;
import java.util.TreeSet;

public class DirectoryObject
implements TreeObject {
    Properties prop = new Properties();
    String key = null;
    String parentKey = null;
    boolean leaf = false;
    boolean isContainer = false;
    Properties childObjects = null;
    String adsPath = null;
    String guid = null;
    String relativeName = null;
    String name = null;
    String objectClass = null;

    public void setProperties(Properties p) {
        this.prop = p;
    }

    public Properties getProperties() {
        return this.prop;
    }

    public void setChildObjects(Properties p) {
        this.childObjects = p;
    }

    public Properties getChildObjects() {
        return this.childObjects;
    }

    @Override
    public ArrayList getChildObjectList() {
        ArrayList<Object> list = new ArrayList<Object>();
        if (this.childObjects != null) {
            TreeSet<Object> set = new TreeSet<Object>(this.childObjects.keySet());
            Iterator<Object> it = set.iterator();
            while (it.hasNext()) {
                list.add(this.childObjects.get(it.next()));
            }
        }
        return list;
    }

    public void setIsContainer(boolean bool) {
        this.isContainer = bool;
    }

    public boolean isContainer() {
        return this.isContainer;
    }

    public void setIsLeaf(boolean bool) {
        this.leaf = bool;
    }

    @Override
    public boolean isLeaf() {
        return this.leaf;
    }

    public void setParentKey(String str) {
        this.parentKey = str;
    }

    public String getParentKey() {
        return this.parentKey;
    }

    public void setKey(String str) {
        this.key = str;
    }

    public String getKey() {
        return this.key;
    }

    public void setGuid(String str) {
        this.guid = str;
    }

    public String getGuid() {
        return this.guid;
    }

    public void setName(String str) {
        this.name = str;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setRelativeName(String str) {
        this.relativeName = str;
    }

    @Override
    public String getID() {
        return this.relativeName;
    }

    @Override
    public String getTarget() {
        return this.guid;
    }

    public void setObjectClass(String str) {
        this.objectClass = str;
    }

    public String getObjectClass() {
        return this.objectClass;
    }

    @Override
    public String getActionLink() {
        String str = this.htmlEscape(this.relativeName);
        str = this.scriptEscape(str);
        String str1 = this.htmlEscape(this.name);
        str1 = this.scriptEscape(str1);
        String actionLink = "'guid=" + this.guid + "&objectClass=" + this.objectClass + "&nodeClicked=" + str + "&objectName=" + str1 + "', '" + this.leaf + "'";
        return actionLink;
    }

    @Override
    public String getImageIcon() {
        return CommonIconUtil.getTreeIcon(this.objectClass);
    }

    public String toString() {
        return new String("Name=" + this.name + ":Leaf=" + this.leaf + ":RelativeName=" + this.relativeName + ":Class=" + this.objectClass + ":ChildObjects=" + this.getChildObjects());
    }

    public String scriptEscape(String str) {
        if (str == null) {
            return null;
        }
        String[] chars = new String[]{"\\", "\"", "'"};
        String ret = str;
        for (String s : chars) {
            if (!ret.contains(s)) continue;
            ret = s.equalsIgnoreCase("\\") ? ret.replaceAll("\\\\", "\\\\\\\\") : ret.replaceAll(s, "\\\\" + s);
        }
        return ret;
    }

    public String htmlEscape(String str) {
        if (str == null) {
            return null;
        }
        String[] chars = new String[]{"&", ">", "<", "\""};
        String[] vals = new String[]{"&amp;", "&gt;", "&lt;", "&quot;"};
        for (int i = 0; i < chars.length; ++i) {
            String s = chars[i];
            if (str == null || !str.contains(s)) continue;
            str = str.replaceAll(s, vals[i]);
        }
        return str;
    }
}

