/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.model;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import java.util.ArrayList;
import java.util.Hashtable;

public class ObjectClass {
    private static AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle();
    private ArrayList tables = null;
    private String objectClass = null;
    private Integer startRange = null;
    private Integer endRange = null;
    private String baseTable = null;
    private String resultTable = null;
    private String displayText = null;
    private String objectSelectURL = null;
    private Integer reportId = null;

    public String getDisplayText() {
        return this.displayText;
    }

    public String getObjectClass() {
        return this.objectClass;
    }

    public String getObjectSelectURL() {
        return this.objectSelectURL;
    }

    public ObjectClass(String objClass, DataObject obj) {
        try {
            this.objectClass = objClass;
            this.tables = new ArrayList();
            Row r = obj.getRow("ADMPObjects", new Criteria(Column.getColumn((String)"ADMPObjects", (String)"OBJECT_CLASS"), (Object)objClass, 0));
            this.baseTable = (String)r.get("BASE_TABLE_NAME");
            this.resultTable = (String)r.get("RESULT_TABLE_NAME");
            this.startRange = (Integer)r.get("START_ATTRIB_ID");
            this.endRange = (Integer)r.get("END_ATTRIB_ID");
            this.displayText = rb.getString((String)r.get("DISPLAY_TEXT"));
            this.objectSelectURL = (String)r.get("OBJECT_SELECT_URL");
            this.reportId = (Integer)r.get("REPORT_ID");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public ArrayList getTables() {
        ArrayList list = new ArrayList();
        for (int i = 0; i < this.tables.size(); ++i) {
            Hashtable props = (Hashtable)this.tables.get(i);
            list.add(props.get("TABLE_NAME"));
        }
        return list;
    }

    public ArrayList getTableDetails() {
        return this.tables;
    }

    public Integer getStartRange() {
        return this.startRange;
    }

    public Integer getEndRange() {
        return this.endRange;
    }

    public String getBaseTable() {
        return this.baseTable;
    }

    public String getResultTable() {
        return this.resultTable;
    }

    public Integer getReportId() {
        return this.reportId;
    }
}

