/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.mysql.tools;

import com.adventnet.mfw.ConsoleOut;
import com.adventnet.sym.adsm.auditing.server.util.MetaTableHandler;
import com.adventnet.sym.adsm.common.server.mysql.tools.ChangeDBServer;
import com.adventnet.sym.adsm.common.server.mysql.tools.ConnectionUtil;
import com.adventnet.sym.adsm.common.server.postgres.PSQLBackupHandler;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.EncryptionAPI;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Statement;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.text.StringCharacterIterator;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class BackUpDB
extends JFrame {
    private Connection conn = null;
    private String separator = File.separator;
    private String backupDir = null;
    private String backupFileName = null;
    private BufferedWriter logout = null;
    private List tableNames = null;
    private String dbserver = null;
    private boolean isMySQL = true;
    private String dbname = "unknown";
    private boolean dbbackupstatus = true;
    private boolean dbhealthstatus = true;
    private boolean isADAP = false;
    private String[] otherDataTables;
    private String[] tmpTables = new String[0];
    private static int attempt = 1;
    private Hashtable scharTable = null;
    private Pattern timePattern = null;
    private List mssqlKeys = null;
    private HashMap mssqlAlias = null;
    private HashMap anomalyTimeCrit = null;
    private List insertQueryTables = null;
    private HashMap afToRbbMap = null;
    private EncryptionAPI enc = null;
    private long patchTime = 0L;
    String osname;
    private HashMap tableColNameMap = new HashMap();
    Pattern tableNamePattern = null;
    private List<String> metaTableList = null;
    private Integer inputDays = 0;
    private JPanel backUpPanel;
    private JLabel dbTypeLabel;
    private JTextArea dbSizeDesc;
    private JRadioButton onlyConfig;
    private JTextArea onlyConfigDesc;
    private JRadioButton configAndData;
    private JTextArea configAndDataDesc;
    private JLabel selDaysLabel;
    private JTextField selDays;
    private JRadioButton entireData;
    private JTextArea entireDataDesc;
    private JButton startButton;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BackUpDB() {
        this.osname = System.getProperty("os.name", "Windows");
        this.afToRbbMap = new HashMap();
        this.timePattern = Pattern.compile("(\\d+)\\s+(\\S+)");
        this.tableNamePattern = Pattern.compile("^[0-9]+[_]+[a-zA-Z]+");
        this.mssqlAlias = new HashMap();
        this.mssqlAlias.put("file", "FileName");
        this.backUpPanel = new JPanel(new GridLayout(7, 3, 0, 0));
        this.enc = EncryptionAPI.getEncryptionObj();
        this.scharTable = new Hashtable();
        this.insertQueryTables = new ArrayList();
        ResultSet rs = null;
        Statement stmt = null;
        try {
            String query = "SELECT TableDetails.TABLE_NAME, ColumnDetails.COLUMN_NAME from TableDetails inner join ColumnDetails on TableDetails.TABLE_ID=ColumnDetails.TABLE_ID and ColumnDetails.DATA_TYPE='SCHAR'";
            this.conn = this.getConnection();
            stmt = this.conn.createStatement();
            rs = stmt.executeQuery(query);
            while (rs.next()) {
                String col;
                String table = rs.getString("TABLE_NAME");
                String prevValue = this.scharTable.put(table, col = rs.getString("COLUMN_NAME"));
                if (prevValue != null) {
                    this.scharTable.put(table, col + "$" + prevValue);
                }
                if (this.insertQueryTables.contains(table)) continue;
                this.insertQueryTables.add(table);
            }
            this.insertQueryTables.add("AUDAccessMask");
            this.insertQueryTables.add("AUDReportCategories");
            this.insertQueryTables.add("AUDColumnConfiguration");
            this.insertQueryTables.add("AUDComputerEventRead");
            this.insertQueryTables.add("AUDHomeGraphs");
            this.insertQueryTables.add("AUDGraphOptions");
            this.insertQueryTables.add("AUDMetaTable");
            this.insertQueryTables.add("AUDBackUpMetaTable");
            this.insertQueryTables.add("AUDReportUICategories");
            this.insertQueryTables.add("AUDSQLQueryColumnPattern");
            this.insertQueryTables.add("ADSProducts");
            this.insertQueryTables.add("ADSQuickLinks");
            this.insertQueryTables.add("AUDScheduler");
            this.insertQueryTables.add("AUDFileMonitorShares");
            this.insertQueryTables.add("ADSMShareGeneralDetails");
            this.insertQueryTables.add("AUDShareSaclDetails");
            this.insertQueryTables.add("AUDServerFolderSyncStatus");
            this.insertQueryTables.add("AUDArchiveConfig");
            this.insertQueryTables.add("AUDBackUpMetaTable");
            this.insertQueryTables.add("AUDFIMFolderConf");
            this.insertQueryTables.add("AudPrinterDetails");
            this.insertQueryTables.add("ADSMPrinterGeneralDetails");
            this.insertQueryTables.add("AUDPrinterAlertCriteria");
            this.insertQueryTables.add("AUDSchedulerInputMap");
            this.insertQueryTables.add("AUDRule");
            this.insertQueryTables.add("AudSecPolicyPath");
            this.tableColNameMap.put("AUDRULE_VALUE", "VALUE");
            this.tableColNameMap.put("AUDELEMENTATTR_ATTRVALUE", "ATTRVALUE");
            this.tableColNameMap.put("AUDCATEGORIES_CATEGORY_DESCRIPTION", "CATEGORY_DESCRIPTION");
            this.tableColNameMap.put("AUDGRAPHOPTIONS_CRITERIA", "CRITERIA");
            this.tableColNameMap.put("AUDCOMPLIANCEREPORTMAPPING_SECTION", "SECTION");
            this.tableColNameMap.put("AUDGRAPHOPTIONS_XCOLUMN", "XCOLUMN");
            this.tableColNameMap.put("AUDGRAPHOPTIONS_YCOLUMN", "YCOLUMN");
            this.tableColNameMap.put("AUDSCHEDULER_TO_MAIL_ADDRESS", "TO_MAIL_ADDRESS");
            this.tableColNameMap.put("AUDMONITOR_MONITOR_DESCRIPTION", "MONITOR_DESCRIPTION");
            this.tableColNameMap.put("AUDSQLQUERY_COUNT_SQL_STRING", "COUNT_SQL_STRING");
            this.tableColNameMap.put("AUDUNIONQUERY_UNION_COUNT_QUERY", "UNION_COUNT_QUERY");
            this.tableColNameMap.put("AUDALERT_ALERT_MESSAGE", "ALERT_MESSAGE");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public Hashtable getSCharTable() {
        return this.scharTable;
    }

    public void process(String argument) throws Exception {
        this.initBackup();
        this.initComponents();
    }

    public void process() throws Exception {
        try {
            this.startBackup();
            this.endBackup();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            this.deleteAllTempFiles();
            System.out.println("\n");
            ConsoleOut.println((String)"\n");
            ConnectionUtil.shutDownDB();
            System.out.println("\nBackup process is completed successfully.\n\nBackup data file is " + this.backupDir + File.separator + this.backupFileName);
            ConsoleOut.println((String)("\nBackup process is completed successfully.\n\nBackup data file is " + this.backupDir + File.separator + this.backupFileName));
            if (this.conn != null && !this.conn.isClosed()) {
                this.conn.close();
            }
            if (this.logout != null) {
                this.logout.flush();
                this.logout.close();
            }
            System.exit(0);
        }
    }

    public boolean getDBHealthStatus() {
        return this.dbhealthstatus;
    }

    private List getAllTables() throws Exception {
        return ConnectionUtil.getTableList();
    }

    protected void initBackup() throws Exception {
        try {
            System.out.println("Starting....");
            File file = new File(System.getProperty("jboss.home.dir") + File.separator + "logs" + File.separator + "BackUp.log");
            this.logout = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF8"));
            this.backupDir = this.getBackupDir();
            if (!new File(this.backupDir).isDirectory()) {
                new File(this.backupDir).mkdirs();
            }
            String build_number = BackUpDB.getBuildNumber();
            this.tableNames = this.getAllTables();
            List tableNamesList = this.getAllTables();
            for (Object object : tableNamesList) {
                Matcher m = this.tableNamePattern.matcher((String)object);
                if (!m.find()) continue;
                this.tableNames.remove((String)object);
                this.logout.write("\nRemove File Shares Tables " + object + "\n");
            }
            this.createBuildInfoXml(build_number);
            this.backupFileName = this.getBackupFileName(build_number);
            this.logout.write("\t\t\t\t ADAudit Plus [" + build_number + "] backup log\n");
            this.logout.write("\t\t\t*************************************************************\n");
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void preBackUp() {
        System.out.println("\n\nPreparing to take backup of the database........\n\n");
        ConsoleOut.println((String)"\n\nPreparing to take backup of the database........\n");
        ArrayList unWantedTables = new ArrayList();
        Statement stmt = null;
        ResultSet rs = null;
        try {
            for (int i = 0; i < this.insertQueryTables.size(); ++i) {
                this.tableNames.remove(this.insertQueryTables.get(i));
            }
            this.logout.write("\nUnWantedTables ::::::: " + unWantedTables);
            this.logout.write("\nTables to be backed up using OUTFILE ::::::: " + this.tableNames);
            this.logout.write("\nTables to be backed up using INSERT query syntax ::::::: ");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception ee) {
                ee.printStackTrace();
            }
        }
    }

    protected void startBackup() throws Exception {
        this.logout.write("Backup process started....\n ");
        this.logout.write("Going to take backup of the database\n");
        if (this.dbbackupstatus) {
            int i;
            String confFileDir = System.getProperty("server.home") + "/conf/";
            Object[] configDataObj = this.configAndData.getSelectedObjects();
            if (configDataObj != null) {
                this.inputDays = Integer.parseInt(this.selDays.getText());
                this.metaTableList = MetaTableHandler.getMetaTableList(this.inputDays);
                System.out.println("BEFORE TABLE LENGTH :" + this.tableNames.size());
                for (String metaTable : this.metaTableList) {
                    this.tableNames.remove(metaTable.toLowerCase());
                    System.out.println("DELETED METATBLE : " + metaTable);
                }
            }
            System.out.println("\n\nPlease wait! Database backup is in Progress..........");
            ConsoleOut.println((String)"\n\nPlease wait! Database backup is in Progress..........");
            System.out.println("0-----------------------50------------------------100(%)");
            ConsoleOut.println((String)"0-----------------------50------------------------100(%)");
            int len = this.tableNames.size();
            int divider = len / 50;
            for (i = 0; i < len; ++i) {
                if (i % divider == 0) {
                    System.out.print("=");
                    ConsoleOut.print((String)"=");
                }
                try {
                    this.logout.write("\n" + this.tableNames.get(i));
                    this.dumpAllTable(this.tableNames.get(i).toString());
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (e.getMessage() != null && e.getMessage().indexOf("adap.table_") >= 0) continue;
                    throw e;
                }
            }
            len = this.insertQueryTables.size();
            for (i = 0; i < len; ++i) {
                try {
                    this.logout.write(this.insertQueryTables.get(i) + "\n");
                    this.dumpScharTable(this.insertQueryTables.get(i).toString());
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (e.getMessage() != null && e.getMessage().indexOf("adap.table_") >= 0) continue;
                    throw e;
                }
            }
        }
        System.out.println("");
        ConsoleOut.println((String)"");
    }

    protected void endBackup() throws Exception {
        this.logout.write("Compressing backup file\n");
        String rootdir = System.getProperty("jboss.home.dir");
        ZipOutputStream zipout = new ZipOutputStream(new FileOutputStream(this.backupDir + this.separator + this.backupFileName));
        this.addToZip(zipout, this.backupDir + this.separator + "backup_info.xml");
        if (this.dbbackupstatus) {
            int len = this.tableNames.size();
            for (int i = 0; i < len; ++i) {
                this.addToZip(zipout, this.backupDir + this.separator + this.tableNames.get(i).toString() + ".sql");
            }
        }
        zipout.close();
    }

    private Connection getConnection() throws Exception {
        String sep = File.separator;
        String dsfile = System.getProperty("jboss.home.dir") + sep + "conf" + sep + "database_params.conf";
        if (this.dbserver == null) {
            if (new File(dsfile).isFile()) {
                this.dbserver = BackUpDB.getActiveDBServer();
                this.isMySQL = "mysql".equals(this.dbserver);
                return ConnectionUtil.getConnection(this.dbserver);
            }
            throw new Exception("Data Source file not found : " + dsfile);
        }
        return ConnectionUtil.getConnection(this.dbserver);
    }

    private void deleteAllTempFiles() throws Exception {
        new File(this.backupDir + this.separator + "backup_info.xml").delete();
        if (this.tableNames != null) {
            int len = this.tableNames.size();
            for (int i = 0; i < len; ++i) {
                new File(this.backupDir + this.separator + this.tableNames.get(i).toString() + ".sql").delete();
            }
        }
    }

    private void addToZip(ZipOutputStream zipout, String file) throws Exception {
        ZipEntry ent = new ZipEntry(new File(file).getName());
        zipout.putNextEntry(ent);
        try (FileInputStream fileReader = new FileInputStream(new File(file));){
            int len;
            byte[] data = new byte[1024];
            int j = 0;
            while ((len = fileReader.read(data)) >= 0) {
                zipout.write(data, 0, len);
                zipout.flush();
                ++j;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HashMap getMetaData(String table_name) {
        LinkedHashMap hash = new LinkedHashMap();
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = this.conn.prepareStatement("SELECT TABLE_ID FROM TableDetails where TABLE_NAME = '" + table_name + "'");
            rs = stmt.executeQuery();
            if (rs.next()) {
                stmt = this.conn.prepareStatement("SELECT COLUMN_NAME, MAX_SIZE, DATA_TYPE FROM ColumnDetails where TABLE_ID = '" + rs.getString(1) + "'");
                rs = stmt.executeQuery();
                while (rs.next()) {
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    map.put("MAX_SIZE", rs.getObject(2));
                    map.put("DATA_TYPE", rs.getObject(3));
                    hash.put(rs.getString(1), map);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        return hash;
    }

    private void dumpScharTable(String table) throws Exception {
        this.logout.write("\nExtracting info from table in dumpTable " + table);
        if (attempt >= 3) {
            throw new Exception("Unable to get the data from [" + table + "] table");
        }
        HashMap metadata = this.getMetaData(table);
        ArrayList<String> scharColList = null;
        String query = "";
        Object[] configDataObj = this.configAndData.getSelectedObjects();
        Long timePeriod = this.inputDays.longValue() * 86400L;
        Long fromTime = System.currentTimeMillis() / 1000L - timePeriod;
        query = configDataObj != null && table.equalsIgnoreCase("AUDMetaTable") ? "SELECT * FROM " + table + " where END_TIME >= '" + fromTime + "' or END_TIME = '0'" : (configDataObj != null && table.equalsIgnoreCase("AUDBackUpMetaTable") ? "SELECT * FROM " + table + " where END_TIME >= '" + fromTime + "'  and IS_REGENERATE_DATA = 1" : "SELECT * FROM " + table);
        if (this.scharTable.containsKey(table)) {
            String temp = (String)this.scharTable.get(table);
            scharColList = new ArrayList<String>();
            String[] scharCol = temp.split("$");
            String selectCol = PSQLBackupHandler.getSelectedColumn(metadata, this.dbserver);
            for (int i = 0; i < scharCol.length; ++i) {
                String replacement = "concat( \"encryptbykey(key_guid('ZOHO_SYMM_KEY'), N'\", AES_DECRYPT(" + scharCol[i] + ",'MLite'),\"')\" ) as " + scharCol[i];
                if (this.dbserver.equalsIgnoreCase("postgres")) {
                    replacement = PSQLBackupHandler.getDecryptString(scharCol[i]);
                }
                selectCol = selectCol.replace(scharCol[i], replacement);
                scharColList.add(scharCol[i]);
            }
            query = "SELECT " + selectCol + " FROM " + table;
        } else {
            String selectCol = PSQLBackupHandler.getSelectedColumn(metadata, this.dbserver);
            query = CommonUtil.constructString(new String[]{"SELECT ", selectCol, " FROM ", table}, null);
        }
        PreparedStatement stmt2 = null;
        stmt2 = this.conn.prepareStatement(query);
        ResultSet rs = null;
        try {
            rs = stmt2.executeQuery();
        }
        catch (Exception ex) {
            ++attempt;
            System.out.println("ERROR = *" + ex.getMessage() + "*");
            this.conn = this.getConnection();
            this.dumpScharTable(table);
            this.dbhealthstatus = false;
            return;
        }
        FileOutputStream fout = new FileOutputStream(new File(this.backupDir + this.separator + table + ".sql"));
        BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)fout, "UTF8"));
        ResultSetMetaData metaData = rs.getMetaData();
        int colCount = metaData.getColumnCount();
        int max_col_size = 0;
        try {
            int i;
            if (!rs.isBeforeFirst()) {
                return;
            }
            StringBuffer buffer = new StringBuffer();
            buffer.append("INSERT INTO " + table + " (");
            if (!metaData.isAutoIncrement(1)) {
                buffer.append(metaData.getColumnName(1));
            }
            for (i = 1; i < colCount; ++i) {
                if (metaData.isAutoIncrement(i)) {
                    buffer.append(metaData.getColumnName(i + 1));
                    continue;
                }
                buffer.append("," + metaData.getColumnLabel(i + 1));
            }
            buffer.append(") VALUES\n");
            out.write(buffer.toString());
            buffer = new StringBuffer();
            while (rs.next()) {
                buffer.append("(");
                for (i = 0; i < colCount; ++i) {
                    if (metaData.isAutoIncrement(i + 1)) continue;
                    if (i > 0 && !metaData.isAutoIncrement(i)) {
                        buffer.append(", ");
                    }
                    Object value = null;
                    if ("timestamp".equalsIgnoreCase(metaData.getColumnTypeName(i + 1))) {
                        try {
                            value = rs.getObject(i + 1);
                        }
                        catch (Exception e) {
                            value = "1970-01-01 00:00:00";
                            this.logout.write("\n" + e.getMessage());
                        }
                    } else {
                        value = rs.getObject(i + 1);
                    }
                    if (value == null) {
                        if ("timestamp".equalsIgnoreCase(metaData.getColumnTypeName(i + 1)) || "datetime".equalsIgnoreCase(metaData.getColumnTypeName(i + 1))) {
                            if (this.isMySQL) {
                                buffer.append("'1970-01-01 00:00:00'");
                                continue;
                            }
                            buffer.append("-1");
                            continue;
                        }
                        buffer.append("NULL");
                        continue;
                    }
                    String colData = null;
                    if (value instanceof Clob) {
                        Clob clob = (Clob)value;
                        BufferedReader read = (BufferedReader)clob.getCharacterStream();
                        String tmp = read.readLine();
                        while (tmp != null) {
                            colData = colData == null ? tmp : colData + tmp;
                            tmp = read.readLine();
                        }
                        if (colData == null) {
                            colData = "NULL";
                        }
                    } else {
                        colData = value.toString();
                    }
                    if (BackUpDB.isTextColumn(metaData.getColumnTypeName(i + 1))) {
                        String temp;
                        String colName = metaData.getColumnLabel(i + 1);
                        if ((colName = colName.toUpperCase()).equals("PASSWORD") && (temp = colData).contains("encryptbykey(key_guid('ZOHO_SYMM_KEY'), N'")) {
                            temp = temp.replace("encryptbykey(key_guid('ZOHO_SYMM_KEY'), N'", "");
                            temp = temp.substring(0, temp.length() - 2);
                            String temp2 = temp.replaceAll("'", "''");
                            String string = colData = temp.indexOf("'") != -1 ? colData.replaceAll(temp, temp2) : colData;
                        }
                        if (scharColList == null || !scharColList.contains(colName)) {
                            colData = BackUpDB.format(colData);
                        }
                        try {
                            HashMap map = (HashMap)metadata.get(colName);
                            max_col_size = Integer.parseInt((String)map.get("MAX_SIZE"));
                        }
                        catch (Exception e) {
                            max_col_size = 0;
                        }
                        if (max_col_size > 0 && max_col_size < 4000 && colData.length() > max_col_size) {
                            colData = colData.substring(0, --max_col_size);
                            while (colData.endsWith("\\") || colData.endsWith("'") || colData.endsWith("''")) {
                                colData = colData.substring(0, --max_col_size);
                            }
                        }
                        if (scharColList == null || !scharColList.contains(colName)) {
                            buffer.append("N'" + colData + "'");
                            continue;
                        }
                        buffer.append(colData);
                        continue;
                    }
                    if ("bit".equalsIgnoreCase(metaData.getColumnTypeName(i + 1)) || "tinyint".equalsIgnoreCase(metaData.getColumnTypeName(i + 1))) {
                        if ("false".equals(colData)) {
                            buffer.append("0");
                            continue;
                        }
                        buffer.append("1");
                        continue;
                    }
                    buffer.append(colData);
                }
                buffer.append(");\n");
                if (this.scharTable.containsKey(table)) {
                    String encStr = this.enc.encryptLog(buffer.toString());
                    out.write(encStr + "|");
                } else {
                    out.write(buffer.toString());
                }
                buffer = new StringBuffer();
            }
            out.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            stmt2.close();
            try {
                if (rs != null) {
                    rs.close();
                }
                fout.close();
                out.close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        attempt = 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpAllTable(String table) throws Exception {
        this.logout.write("\nExtracting info from table in faDumpTable " + table);
        if (attempt >= 3) {
            throw new Exception("Unable to get the data from [" + table + "] table");
        }
        PreparedStatement dstmt = null;
        if (this.dbserver.equalsIgnoreCase("mysql")) {
            dstmt = this.conn.prepareStatement("desc " + table);
        } else if (this.dbserver.equalsIgnoreCase("mssql")) {
            dstmt = this.conn.prepareStatement("sp_columns " + table);
        } else if (this.dbserver.equalsIgnoreCase("postgres")) {
            dstmt = this.conn.prepareStatement(PSQLBackupHandler.getColumnString(table));
        }
        String query = null;
        try (ResultSet rs = null;){
            rs = dstmt.executeQuery();
            String filename = this.backupDir + this.separator + table + ".sql";
            filename = filename.replace("\\", "\\\\");
            if (this.dbserver.equalsIgnoreCase("mysql")) {
                while (rs.next()) {
                    String colName = rs.getString(1);
                    if (this.tableColNameMap.get(table.toUpperCase() + "_" + colName.toUpperCase()) != null && ((String)this.tableColNameMap.get(table.toUpperCase() + "_" + colName.toUpperCase())).equalsIgnoreCase(colName)) {
                        query = query + ", IF(" + colName + "='',' '," + colName + ")";
                        continue;
                    }
                    if (query != null) {
                        colName = rs.getBoolean(3) ? ", IFNULL(" + colName + ",'')" : ", " + colName;
                    } else {
                        query = "Select ";
                        colName = rs.getBoolean(3) ? "IFNULL(" + colName + ",'')" : colName;
                    }
                    query = query + colName;
                }
                query = query + " FROM " + table + " INTO OUTFILE \"" + filename + "\" FIELDS ESCAPED BY '' TERMINATED BY '|**|' LINES TERMINATED BY '|**|**|\r\n'";
                this.logout.write("\nQUERY IS " + query);
            } else if (this.dbserver.equalsIgnoreCase("postgres")) {
                query = PSQLBackupHandler.constructQuery(rs, this.tableColNameMap, filename, table);
                this.logout.write("\nQUERY IS " + query);
            }
        }
        PreparedStatement stmt = null;
        try {
            if (this.dbserver.equalsIgnoreCase("mysql")) {
                stmt = this.conn.prepareStatement(query);
                stmt.executeQuery();
            } else if (this.dbserver.equalsIgnoreCase("postgres")) {
                stmt = this.conn.prepareStatement(query);
                int count = stmt.executeUpdate();
            }
        }
        catch (Exception ex) {
            ++attempt;
            System.out.println("ERROR = *" + ex.getMessage() + "*");
            this.conn = this.getConnection();
            this.dumpAllTable(table);
            this.dbhealthstatus = false;
            return;
        }
    }

    private static boolean isTextColumn(String columnType) {
        boolean flag = false;
        if ("varchar".equalsIgnoreCase(columnType) || "nvarchar".equalsIgnoreCase(columnType)) {
            flag = true;
        } else if ("char".equalsIgnoreCase(columnType) || "nchar".equalsIgnoreCase(columnType)) {
            flag = true;
        } else if ("text".equalsIgnoreCase(columnType) || "ntext".equalsIgnoreCase(columnType)) {
            flag = true;
        } else if ("datetime".equalsIgnoreCase(columnType) || "timestamp".equalsIgnoreCase(columnType)) {
            flag = true;
        } else if ("citext".equalsIgnoreCase(columnType)) {
            flag = true;
        }
        return flag;
    }

    private static boolean isNTextColumn(String columnType) {
        boolean flag = false;
        if ("text".equalsIgnoreCase(columnType) || "ntext".equalsIgnoreCase(columnType)) {
            flag = true;
        }
        return flag;
    }

    public void handleMssqlKeys(StringBuffer query) {
        for (int i = 0; i < this.mssqlKeys.size(); ++i) {
            String key = (String)this.mssqlKeys.get(i);
            int ind = query.indexOf(key + " ");
            while (ind != -1) {
                query.replace(ind, ind + key.length(), "[" + this.mssqlKeys.get(i) + "]");
                ind = query.indexOf(this.mssqlKeys.get(i) + " ", ind + key.length() + 2);
            }
        }
    }

    private String[] splitByAs(String selClause) {
        StringBuffer str = new StringBuffer(selClause);
        int start = 0;
        int mid = str.indexOf(" as ", 0);
        int end = str.indexOf(",", mid);
        while (end != -1 && mid != -1) {
            mid = (str = str.insert(end + 1, "$")).indexOf(" as ", start = end + 2);
            if (mid == -1) continue;
            end = str.indexOf(",", mid);
        }
        return str.toString().split(",\\$");
    }

    private String handleLocateFn(String ele) {
        ele = ele.replaceAll("LOCATE\\(", "PATINDEX(");
        StringBuffer buf = new StringBuffer(ele);
        int start = buf.indexOf("PATINDEX(", 0);
        while (start != -1) {
            buf = buf.insert(start += 9, "'%'+");
            start = buf.indexOf(",", start);
            buf = buf.insert(start, "+'%'");
            start = buf.indexOf("PATINDEX(", start);
        }
        return buf.toString();
    }

    private boolean isAggrFunc(String ele) {
        return ele.startsWith("count(") || ele.startsWith("max(") || ele.startsWith("min(") || ele.startsWith("sum(");
    }

    private String getAnomalyCrit(String timeUnit, String interval) {
        String tTimeCriteria = null;
        if (timeUnit.equals("1 Hour")) {
            String startTime;
            String endTime;
            long period = this.getTimeLong(interval) / 1000L;
            if (this.isMySQL) {
                endTime = "DATEADD(MINUTE, -" + period / 60L + " , GETDATE())";
                startTime = "DATEADD(MINUTE, -" + (period + 3600L) / 60L + " , GETDATE())";
            } else {
                endTime = "DATE_SUB(NOW(), INTERVAL " + period + " SECOND)";
                startTime = "DATE_SUB(NOW(), INTERVAL " + period + 3600 + " SECOND)";
            }
            tTimeCriteria = "( HOUR BETWEEN " + startTime + " AND " + endTime + " )";
        } else if (timeUnit.equals("2 Hours")) {
            long period = this.getTimeLong(interval) / 1000L;
            if (period <= 1800L) {
                String startTime;
                String endTime;
                if (this.isMySQL) {
                    endTime = "DATEADD(MINUTE, -" + period / 60L + " , GETDATE())";
                    startTime = "DATEADD( MINUTE, -" + (period + 7200L) / 60L + " , GETDATE())";
                } else {
                    endTime = "DATE_SUB(NOW(), INTERVAL " + period + " SECOND)";
                    startTime = "DATE_SUB(NOW(), INTERVAL " + period + 7200 + " SECOND)";
                }
                tTimeCriteria = "( HOUR BETWEEN " + startTime + " AND " + endTime + " )";
            } else {
                tTimeCriteria = this.isMySQL ? "(HOUR BETWEEN DATEADD(HOUR, -2, GETDATE()) AND GETDATE())" : "(HOUR BETWEEN DATE_SUB(NOW(), INTERVAL 2 HOUR) AND NOW())";
            }
        } else if (timeUnit.equals("6 Hours")) {
            long period = this.getTimeLong(interval) / 1000L;
            if (period <= 1800L) {
                String startTime;
                String endTime;
                if (this.isMySQL) {
                    endTime = "DATEADD(MINUTE, - " + period / 60L + " , GETDATE())";
                    startTime = "DATEADD(MINUTE, -" + (period + 21600L) / 60L + " , GETDATE())";
                } else {
                    endTime = "DATE_SUB(NOW(), INTERVAL " + period + " SECOND)";
                    startTime = "DATE_SUB(NOW(), INTERVAL " + period + 21600 + " SECOND)";
                }
                tTimeCriteria = "( HOUR BETWEEN " + startTime + " AND " + endTime + " )";
            } else {
                tTimeCriteria = this.isMySQL ? "(HOUR BETWEEN DATEADD(HOUR, -6, HOUR) AND GETDATE())" : "(HOUR BETWEEN DATE_SUB(NOW(), INTERVAL 6 HOUR) AND NOW())";
            }
        } else if (timeUnit.equals("12 Hours")) {
            tTimeCriteria = this.isMySQL ? "(HOUR BETWEEN DATEADD(HOUR, -12, GETDATE()) AND GETDATE())" : "(HOUR BETWEEN DATE_SUB(NOW(), INTERVAL 12 HOUR) AND NOW())";
        } else if (timeUnit.equals("1 Day")) {
            tTimeCriteria = this.isMySQL ? "(HOUR BETWEEN DATEADD(DAY, -1 , GETDATE()) AND GETDATE())" : "(HOUR BETWEEN DATE_SUB(NOW(), INTERVAL 1 DAY) AND NOW())";
        } else if (timeUnit.equals("7 Days")) {
            tTimeCriteria = this.isMySQL ? "(HOUR BETWEEN DATEADD(DAY, -7, GETDATE()) AND GETDATE())" : "(HOUR BETWEEN DATE_SUB(NOW(), INTERVAL 7 DAY) AND NOW())";
        } else if (timeUnit.equals("14 Days")) {
            tTimeCriteria = this.isMySQL ? "(HOUR BETWEEN DATEADD(DAY, -14, GETDATE()) AND GETDATE())" : "(HOUR BETWEEN DATE_SUB(NOW(), INTERVAL 14 DAY) AND NOW())";
        } else if (timeUnit.equals("30 Days")) {
            tTimeCriteria = this.isMySQL ? "(HOUR BETWEEN DATEADD(DAY, -30, GETDATE()) AND GETDATE())" : "(HOUR BETWEEN DATE_SUB(NOW(), INTERVAL 30 DAY) AND NOW())";
        }
        return tTimeCriteria;
    }

    private long getTimeLong(String unit) {
        Matcher m = this.timePattern.matcher(unit);
        long result = 0L;
        if (m.matches()) {
            int number = Integer.parseInt(m.group(1));
            String string = m.group(2);
            if (string.indexOf("Min") > -1) {
                result = (long)(number * 60) * 1000L;
            } else if (string.indexOf("Hour") > -1) {
                result = (long)(number * 3600) * 1000L;
            } else if (string.indexOf("Day") > -1) {
                result = (long)(number * 86400) * 1000L;
            }
        }
        return result;
    }

    private static String format(String colData) {
        StringBuffer buffer = new StringBuffer();
        StringCharacterIterator iterator = new StringCharacterIterator(colData);
        char character = iterator.current();
        while (character != '\uffff') {
            if (character == '\'') {
                buffer.append("''");
            } else if (character == '\r') {
                buffer.append("\\r");
            } else if (character == '\n') {
                buffer.append("\\n");
            } else {
                buffer.append(character);
            }
            character = iterator.next();
        }
        return buffer.toString();
    }

    private void createBuildInfoXml(String build_number) throws Exception {
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
        Document document = docBuilder.newDocument();
        Element root = document.createElement("backup-info");
        document.appendChild(root);
        Element backup_date = document.createElement("backup-date");
        backup_date.appendChild(document.createTextNode(new Date().toString()));
        root.appendChild(backup_date);
        this.dbname = ConnectionUtil.getDataBase();
        Element db = document.createElement("database");
        db.appendChild(document.createTextNode(this.dbname));
        root.appendChild(db);
        Element srcDB = document.createElement("source-dbtype");
        db.appendChild(document.createTextNode(this.dbserver));
        root.appendChild(srcDB);
        Element build_num = document.createElement("build-number");
        build_num.appendChild(document.createTextNode(build_number));
        root.appendChild(build_num);
        Element number_of_table = document.createElement("number-of-table");
        number_of_table.appendChild(document.createTextNode(this.tableNames.size() + ""));
        root.appendChild(number_of_table);
        String build_info = this.backupDir + this.separator + "backup_info.xml";
        System.out.println("[ creating backup_info.xml ] : " + new File(build_info).createNewFile());
        DOMSource xmlSource = new DOMSource(document);
        StreamResult result = new StreamResult(new FileOutputStream(build_info));
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.setOutputProperty("indent", "yes");
        transformer.transform(xmlSource, result);
    }

    public String getBackupFileName(String build_number) throws Exception {
        if (this.backupFileName == null) {
            String date = new SimpleDateFormat("MM_dd_yyyy_HH_mm").format(new Date());
            return "backup_" + this.dbname + "_" + build_number + "_database_" + date + ".data";
        }
        return this.backupFileName;
    }

    private String getBackupDir() throws Exception {
        String backupDir = System.getProperty("backupDir").trim();
        if ("\\backup".equals(backupDir) || "/backup".equals(backupDir)) {
            backupDir = System.getProperty("jboss.home.dir") + File.separator + "backup";
        }
        if (!new File(backupDir).exists()) {
            this.logout.write("\nbackupDir " + backupDir + " does not exists. Going to create directory");
            new File(backupDir).mkdirs();
            this.logout.write("\nbackupDir " + backupDir + " created");
        }
        return backupDir;
    }

    public ZipOutputStream zipDirectory(String dir, ZipOutputStream zos) throws Exception {
        File d = new File(dir);
        if (!d.exists()) {
            System.out.println("Exiting $^$%^&$%^&$%^");
            return zos;
        }
        if (!d.isDirectory()) {
            throw new IllegalArgumentException("Compress: not a directory:  " + dir);
        }
        String[] entries = d.list();
        byte[] buffer = new byte[4096];
        int len = entries.length;
        for (int i = 0; i < len; ++i) {
            File f = new File(d, entries[i]);
            System.out.println("File added to zip " + f);
            if (f.isDirectory()) {
                this.zipDirectory(f.getPath(), zos);
                continue;
            }
            try (FileInputStream in = new FileInputStream(f);){
                int bytes_read;
                String absolutePath = f.getPath();
                int startIndx = absolutePath.indexOf("fileAttachments");
                if (startIndx == -1) {
                    startIndx = absolutePath.indexOf("custom");
                }
                if (startIndx == -1) {
                    startIndx = absolutePath.indexOf("inlineimages");
                }
                String subStr = absolutePath.substring(startIndx);
                ZipEntry entry = new ZipEntry(subStr);
                zos.putNextEntry(entry);
                while ((bytes_read = in.read(buffer)) != -1) {
                    zos.write(buffer, 0, bytes_read);
                }
                continue;
            }
        }
        return zos;
    }

    public static String getActiveDBServer() throws Exception {
        return ChangeDBServer.getActiveDB();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getBuildNumber() throws Exception {
        String buildFile = System.getProperty("jboss.home.dir") + File.separator + "conf" + File.separator + "product.conf";
        FileInputStream fi = null;
        Properties buildProp = new Properties();
        try {
            fi = new FileInputStream(new File(buildFile));
            buildProp.load(fi);
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            e.printStackTrace();
        }
        finally {
            try {
                if (fi != null) {
                    fi.close();
                }
            }
            catch (Exception ee) {
                ee.printStackTrace();
            }
        }
        String buildNumber = (String)buildProp.get("product.build_number");
        return buildNumber.trim();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getDBSize() {
        String sizeGB = "-1";
        BufferedReader buff = null;
        String strSizeBytes = null;
        Statement stmt = null;
        DecimalFormat twoDigit = new DecimalFormat("0.00");
        long sizeBytes = 0L;
        ResultSet rs = null;
        ResultSet rs1 = null;
        try {
            stmt = this.conn.createStatement();
            if ("mysql".equals(this.dbserver)) {
                rs = stmt.executeQuery("show variables like 'datadir'");
                String path = "";
                if (rs.next()) {
                    path = (String)rs.getObject("Value");
                }
                String temp = null;
                Process pro = null;
                Runtime rt = Runtime.getRuntime();
                boolean flag = false;
                this.logout.write("\nData dir path ::::: " + path);
                String[] dirPaths = new String[]{path + "\\adap", path + "\\ibdata1"};
                long totalBytes = 0L;
                if (this.osname.startsWith("Win")) {
                    for (int i = 0; i < 2; ++i) {
                        pro = rt.exec("cmd /c DIR /A-D  \"" + dirPaths[i] + "\"");
                        buff = new BufferedReader(new InputStreamReader(pro.getInputStream()));
                        temp = buff.readLine();
                        while (temp.indexOf(" bytes") == -1) {
                            strSizeBytes = temp = buff.readLine();
                        }
                        if (strSizeBytes == null) {
                            pro = rt.exec("cmd /c DIR " + dirPaths[i] + " | FIND \"bytes\"");
                            buff = new BufferedReader(new InputStreamReader(pro.getInputStream()));
                            strSizeBytes = buff.readLine();
                        }
                        strSizeBytes = strSizeBytes.trim();
                        Pattern p = Pattern.compile("\\s*\\d*\\D*([0-9,]*).*");
                        Matcher m = p.matcher(strSizeBytes);
                        boolean b = m.matches();
                        strSizeBytes = m.group(1);
                        strSizeBytes = strSizeBytes.replaceAll(",", "");
                        strSizeBytes = strSizeBytes.replace('.', ' ');
                        strSizeBytes = strSizeBytes.replaceAll(" ", "");
                        totalBytes = Long.parseLong(strSizeBytes);
                        sizeBytes += totalBytes;
                    }
                } else if (this.osname.startsWith("Lin")) {
                    pro = rt.exec("/usr/bin/du -cbs " + dirPaths[0] + " " + dirPaths[1]);
                    buff = new BufferedReader(new InputStreamReader(pro.getInputStream()));
                    temp = buff.readLine();
                    strSizeBytes = "";
                    while (temp != null) {
                        strSizeBytes = temp;
                        temp = buff.readLine();
                    }
                    String[] values = strSizeBytes.split("\\s+");
                    if (values.length > 0) {
                        sizeBytes = Long.parseLong(values[0]);
                    }
                }
            } else if ("mssql".equals(this.dbserver)) {
                rs1 = stmt.executeQuery("exec sp_helpfile");
                if (rs1.next()) {
                    strSizeBytes = (String)rs1.getObject("size");
                }
                Pattern p = Pattern.compile("(\\d+) KB");
                Matcher m = p.matcher(strSizeBytes);
                boolean b = m.matches();
                strSizeBytes = m.group(1);
                sizeBytes = Long.parseLong(strSizeBytes);
                sizeBytes *= 1024L;
            } else if (this.dbserver.equalsIgnoreCase("postgres")) {
                sizeBytes = PSQLBackupHandler.getDBSize(rs1, stmt);
            }
            sizeGB = twoDigit.format((double)sizeBytes / 1.073741824E9);
            this.logout.write("\nDatabase size(GB) ::::::::: " + sizeGB);
        }
        catch (Exception e) {
            e.printStackTrace();
            sizeGB = "-1";
            System.out.println("Error while calculating Free disk Space, read line : " + strSizeBytes);
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (buff != null) {
                    buff.close();
                }
                if (rs != null) {
                    rs.close();
                }
                if (rs1 != null) {
                    rs1.close();
                }
            }
            catch (Exception e) {
                buff = null;
            }
        }
        return sizeGB;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getDWS() throws Exception {
        String dws = "32";
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = this.conn.createStatement();
            rs = stmt.executeQuery("select TIMESTAMP from DataManagementTiming where TIMER_NAME='SYS_DATA_WINDOW'");
            if (rs.next()) {
                dws = rs.getString("TIMESTAMP");
            }
        }
        catch (Exception e) {
            System.out.println("Error while getting data window size : " + e);
            e.printStackTrace();
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (stmt != null) {
                stmt.close();
            }
        }
        return dws;
    }

    private String getEstimatedTime(String dbSize) {
        String estimatedTime = "few minutes";
        try {
            if (dbSize.indexOf("0.") != -1) {
                long timeInMin = Math.round(Double.parseDouble(dbSize) * 120.0);
                estimatedTime = timeInMin + " Mins";
            } else {
                long timeInHr = Math.round(Double.parseDouble(dbSize)) * 2L;
                estimatedTime = timeInHr + " Hrs";
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return estimatedTime;
    }

    public List getInsertQueryTables() {
        return this.insertQueryTables;
    }

    private void initComponents() throws Exception {
        this.dbTypeLabel = new JLabel();
        this.dbSizeDesc = new JTextArea(3, 6);
        this.onlyConfig = new JRadioButton();
        this.onlyConfigDesc = new JTextArea();
        this.configAndData = new JRadioButton();
        this.configAndDataDesc = new JTextArea();
        this.selDaysLabel = new JLabel();
        this.selDays = new JTextField(4);
        this.entireData = new JRadioButton();
        this.entireDataDesc = new JTextArea();
        this.startButton = new JButton();
        this.setTitle("Backup Database");
        this.backUpPanel.setBorder(BorderFactory.createTitledBorder("Backup Database Setup Wizard"));
        this.dbTypeLabel.setLocation((int)this.dbTypeLabel.getLocation().getX(), (int)this.dbTypeLabel.getLocation().getY() + 60);
        this.dbTypeLabel.setText("Data retrieved from " + this.getDBUIName());
        this.backUpPanel.add(this.dbTypeLabel);
        this.dbTypeLabel.setBounds(30, 40, 300, 20);
        String dbSize = this.getDBSize();
        String estimatedTime = this.getEstimatedTime(dbSize);
        this.dbSizeDesc.setPreferredSize(new Dimension(100, 100));
        this.dbSizeDesc.setText("The size of the " + this.getDBUIName() + " database to be backedup is approximately " + dbSize + " GB. This will take approximately " + estimatedTime + " to backup the whole database.");
        this.dbSizeDesc.setLineWrap(true);
        this.dbSizeDesc.setEditable(false);
        this.dbSizeDesc.setDisabledTextColor(Color.BLUE);
        this.backUpPanel.add(this.dbSizeDesc);
        this.dbSizeDesc.setBounds(30, 80, 335, 65);
        this.entireData.setLocation((int)this.entireData.getLocation().getX(), (int)this.entireData.getLocation().getY() + 60);
        this.entireData.setText("Backup whole database");
        this.backUpPanel.add(this.entireData);
        this.entireData.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BackUpDB.this.onlyConfig.setSelected(false);
                BackUpDB.this.configAndData.setSelected(false);
                BackUpDB.this.entireData.setSelected(true);
                BackUpDB.this.selDaysLabel.setVisible(false);
                BackUpDB.this.selDays.setVisible(false);
            }
        });
        this.entireDataDesc.setLocation((int)this.entireDataDesc.getLocation().getX(), (int)this.entireDataDesc.getLocation().getY() + 60);
        if (this.isADAP) {
            this.entireDataDesc.setText("Backup the configuration & setting (i.e) Hosts/Applications added, Report/Alert Profiles created etc. and all the data.\nEstimated time approximately " + estimatedTime);
        } else {
            this.entireDataDesc.setText("Backup all the data.\nEstimated time approximately " + estimatedTime);
        }
        this.entireDataDesc.setLineWrap(true);
        this.entireDataDesc.setEditable(false);
        this.entireDataDesc.setDisabledTextColor(Color.BLACK);
        this.backUpPanel.add(this.entireDataDesc);
        this.entireData.setSelected(true);
        this.configAndData.setLocation((int)this.configAndData.getLocation().getX(), (int)this.configAndData.getLocation().getY() + 60);
        this.configAndData.setText("Backup Configurations & Selected days data");
        this.backUpPanel.add(this.configAndData);
        this.configAndData.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BackUpDB.this.onlyConfig.setSelected(false);
                BackUpDB.this.configAndData.setSelected(true);
                BackUpDB.this.entireData.setSelected(false);
                BackUpDB.this.selDaysLabel.setVisible(true);
                BackUpDB.this.selDays.setVisible(true);
            }
        });
        this.configAndDataDesc.setLocation((int)this.configAndDataDesc.getLocation().getX(), (int)this.configAndDataDesc.getLocation().getY() + 60);
        this.configAndDataDesc.setText("Backup the configurations and data for the entered number of days");
        this.configAndDataDesc.setLineWrap(true);
        this.configAndDataDesc.setEditable(false);
        this.configAndDataDesc.setDisabledTextColor(Color.BLACK);
        this.backUpPanel.add(this.configAndDataDesc);
        this.selDaysLabel.setLocation((int)this.selDaysLabel.getLocation().getX(), (int)this.selDaysLabel.getLocation().getY() + 60);
        this.selDaysLabel.setText("Please enter no. of days : ");
        this.add(this.selDaysLabel);
        this.selDaysLabel.setBounds(20, 425, 200, 20);
        this.selDaysLabel.setVisible(false);
        this.selDays.setLocation((int)this.selDays.getLocation().getX(), (int)this.selDays.getLocation().getY() + 60);
        this.add(this.selDays);
        this.selDays.setBounds(170, 425, 40, 20);
        this.selDays.setVisible(false);
        this.startButton.setLocation((int)this.startButton.getLocation().getX(), (int)this.startButton.getLocation().getY() + 60);
        this.startButton.setText("Start backup >>");
        this.add(this.startButton);
        this.startButton.setBounds(30, 450, 130, 20);
        this.startButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                if (BackUpDB.this.configAndData.isSelected()) {
                    String errMsg = "Please enter a valid number of days";
                    try {
                        int days = Integer.parseInt(BackUpDB.this.selDays.getText());
                        if (days < 1) {
                            errMsg = "Please enter a positive number of days";
                            throw new NumberFormatException();
                        }
                    }
                    catch (NumberFormatException e) {
                        JOptionPane.showMessageDialog(null, errMsg, "Alert", 2);
                        return;
                    }
                }
                BackUpDB.this.preBackUp();
                BackUpDB.this.dispose();
                try {
                    BackUpDB.this.process();
                }
                catch (Exception e) {
                    System.out.println(e);
                }
            }
        });
        this.add(this.backUpPanel);
        this.pack();
    }

    private String getDBUIName() throws Exception {
        String dbName = "PostgreSQL Server";
        if (this.dbserver.equalsIgnoreCase("mysql")) {
            dbName = "MySQL Server";
        } else if (this.dbserver.equalsIgnoreCase("mssql")) {
            dbName = "SQL Server";
        }
        return dbName;
    }

    public static void main(String[] args) throws Exception {
        BackUpDB obj = new BackUpDB();
        try {
            obj.process("init");
            obj.setLocation(300, 150);
            obj.setSize(550, 520);
            obj.setVisible(true);
            obj.setDefaultCloseOperation(3);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

