/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.mysql.tools;

import com.adventnet.sym.adsm.common.server.mysql.tools.ChangeDBServerGUI;
import com.zoho.framework.utils.crypto.EnDecryptImpl;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.Statement;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ChangeDBServer {
    private String separator = File.separator;
    private PrintWriter log = null;

    public static void main(String[] args) throws Exception {
        ChangeDBServerGUI.main(args);
    }

    public static String createDB(String stype, String server, String port, String dbName, boolean isWinAuthType, String domain, String user, String pword, String instanceName) throws Exception {
        String conUrl = ChangeDBServer.getConnectionURL(stype, server, port, isWinAuthType, domain, instanceName);
        return ChangeDBServer.executeQuery(conUrl, user, pword, "create database " + dbName, isWinAuthType);
    }

    public static String getActiveDB() throws Exception {
        String stype = "mssql";
        String driverName = ChangeDBServer.getPropertyValue("drivername");
        if (driverName.equals("org.gjt.mm.mysql.Driver")) {
            stype = "mysql";
        } else if (driverName.equals("org.postgresql.Driver")) {
            stype = "postgres";
        }
        return stype;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getPropertyValue(String key) throws Exception {
        FileInputStream fis = null;
        String dbfile = System.getProperty("server.home") + File.separator + "conf" + File.separator + "database_params.conf";
        if (!new File(dbfile).isFile()) {
            throw new Exception("datasource file not found [" + dbfile + "]");
        }
        Properties pro = new Properties();
        try {
            fis = new FileInputStream(new File(dbfile));
            pro.load(fis);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (fis != null) {
                fis.close();
            }
        }
        return pro.getProperty(key);
    }

    public static boolean isWinAuthType() throws Exception {
        String userName = ChangeDBServer.getPropertyValue("username");
        return userName == null;
    }

    public static HashMap getDBDetails(String selectedServer) throws Exception {
        LinkedHashMap<String, String> hash = new LinkedHashMap<String, String>();
        String activeDB = ChangeDBServer.getActiveDB();
        String connectionURL = ChangeDBServer.getPropertyValue("url");
        String userName = ChangeDBServer.getPropertyValue("username");
        String dbName = "";
        String dbServer = "localhost";
        String port = "";
        String instanceName = "";
        if ("mysql".equals(activeDB) && selectedServer.equals("mysql") || "postgres".equals(activeDB) && selectedServer.equals("postgres")) {
            dbServer = connectionURL.substring(connectionURL.indexOf("://") + 3, connectionURL.lastIndexOf(":"));
            port = connectionURL.substring(connectionURL.indexOf(dbServer) + dbServer.length() + 1, connectionURL.lastIndexOf("/"));
            dbName = connectionURL.substring(connectionURL.indexOf(port) + port.length() + 1, connectionURL.indexOf("?"));
        } else if ("mssql".equals(activeDB) && selectedServer.equals("mssql")) {
            dbServer = connectionURL.substring(connectionURL.indexOf("://") + 3, connectionURL.indexOf(";"));
            if (connectionURL.contains("instance")) {
                instanceName = connectionURL.substring(connectionURL.indexOf("instance=") + 9, connectionURL.indexOf(";DatabaseName"));
            } else if (dbServer.indexOf(":") != -1) {
                port = dbServer.substring(dbServer.indexOf(":") + 1, dbServer.length());
                dbServer = dbServer.substring(0, dbServer.indexOf(":"));
            }
            if (connectionURL.indexOf("Domain=") != -1) {
                dbName = connectionURL.substring(connectionURL.indexOf("DatabaseName=") + 13, connectionURL.indexOf(";Domain="));
                String domainName = connectionURL.substring(connectionURL.indexOf("Domain") + 7, connectionURL.length());
                hash.put("DOMAINNAME", domainName);
            } else {
                dbName = connectionURL.substring(connectionURL.indexOf("DatabaseName=") + 13, connectionURL.length());
            }
            String password = ChangeDBServer.getPropertyValue("password");
            if (password != null) {
                EnDecryptImpl enDecrypt = new EnDecryptImpl();
                hash.put("PASSWORD", enDecrypt.decrypt(password));
            }
            hash.put("DATABASE", dbName);
        }
        hash.put("HOST", dbServer);
        hash.put("PORT", port);
        hash.put("DATABASE", dbName);
        hash.put("USERNAME", userName);
        hash.put("INSTANCENAME", instanceName);
        return hash;
    }

    public static String getConnectionURL(String stype, String server, String port, boolean isWinAuthType, String domain, String instanceName) throws Exception {
        String dbUrl = "";
        if ("mssql".equals(stype)) {
            if (instanceName != null && !instanceName.equals("")) {
                dbUrl = "jdbc:jtds:sqlserver://" + server + ";instance=" + instanceName;
            } else if (port != null && !port.equals("")) {
                dbUrl = "jdbc:jtds:sqlserver://" + server + ":" + port;
            }
            Class.forName("net.sourceforge.jtds.jdbc.Driver");
        } else if ("mysql".equals(stype)) {
            dbUrl = "jdbc:mysql://" + server + ":" + port + "/";
            Class.forName("org.gjt.mm.mysql.Driver");
        } else if ("postgres".equals(stype)) {
            dbUrl = "jdbc:postgresql://" + server + ":" + port + "/";
            Class.forName("org.postgresql.Driver");
        }
        return dbUrl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String executeQuery(String conUrl, String user, String pword, String query, Boolean isWinAuthType) throws Exception {
        String message = "Successfully Executed !!!";
        Object dbUrl = null;
        Connection conn = null;
        Statement stmt = null;
        try {
            conn = isWinAuthType != false ? DriverManager.getConnection(conUrl) : DriverManager.getConnection(conUrl, user, pword);
            stmt = conn.createStatement();
            stmt.executeUpdate(query);
        }
        catch (Exception e) {
            message = e.getMessage();
        }
        finally {
            try {
                if (conn != null && !conn.isClosed()) {
                    conn.close();
                }
            }
            catch (Exception conE) {
                conE.printStackTrace();
            }
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception stE) {
                stE.printStackTrace();
            }
        }
        return message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String isDBServerRunning(String stype, String server, String port, boolean isWinAuthType, String domain, String user, String pword, String instanceName) throws Exception {
        String isRunning = "yes";
        String dbUrl = null;
        if ("mssql".equals(stype)) {
            if (instanceName != null && !instanceName.equals("")) {
                dbUrl = "jdbc:jtds:sqlserver://" + server + ";instance=" + instanceName;
            } else if (port != null && !port.equals("")) {
                dbUrl = "jdbc:jtds:sqlserver://" + server + ":" + port;
            }
            Class.forName("net.sourceforge.jtds.jdbc.Driver");
        } else if ("mysql".equals(stype)) {
            dbUrl = "jdbc:mysql://" + server + ":" + port + "/";
            Class.forName("org.gjt.mm.mysql.Driver");
        } else if ("postgres".equals(stype)) {
            dbUrl = "jdbc:postgresql://" + server + ":" + port;
            System.out.println(dbUrl);
            Class.forName("org.postgresql.Driver");
        }
        Connection conn = null;
        try {
            conn = isWinAuthType ? DriverManager.getConnection(dbUrl) : DriverManager.getConnection(dbUrl, user, pword);
        }
        catch (Exception e) {
            isRunning = e.getMessage().indexOf("refused") > 0 ? ("mssql".equals(stype) ? "Connection refused  exception is thrown by SQL server when it is unable to connect to the server. \nThere may be a number of reasons why this could happen:\n\n1)  The server name is misspelled or the port number is incorrect. \n2)  SQL Server is not configured to use TCP/IP. Enable TCP/IP from SQL Server's Network Utility app. \n3)  There is a firewall blocking port 1433 on the server. To check whether TCP/IP is enabled and \nthe port is not blocked you can use \"telnet <server_host> <portnumber>\"\n" : "Please verify the following\n\n1)  Please check the MySQL (or) PostgreSQL server is running.\n2)  Whether the server name is misspelled or the port number is incorrect.\n3)  If the MySQL (or) PostgreSQL server is running in a remote computer check for firewall blocking the port number configured.\n4)  If none of the above mentioned matches please contact 'support@adauditplus.com'") : (e.getMessage().toLowerCase().indexOf("access denied") > 0 ? "Access denied :-( please check the User name and password" : (e.getMessage().toLowerCase().indexOf("port out of range") > 0 ? "Out of range :-( Invalid port number" : (e.getMessage().toLowerCase().indexOf("unknownhost") > 0 ? "Unknown Host " + server + " : Please check the server name you have entered" : e.getMessage())));
        }
        finally {
            if (conn != null && !conn.isClosed()) {
                conn.close();
            }
        }
        return isRunning;
    }

    public void updateDBConfigFile(String server, String host, String port, String dbName, boolean isWinAuthType, String domain, String user, String pwd, String serverdir, String instanceName) throws Exception {
        Properties updatedDBConfig = new Properties();
        String connectionUrl = null;
        String driverName = null;
        String userName = user;
        String passWord = pwd;
        String dbAdapter = null;
        String sqlGenerator = null;
        String portNumber = port;
        String dbParmasFile = System.getProperty("SERVER_HOME") + File.separator + "conf" + File.separator + "database_params.conf";
        String dbPersistenceConfFile = System.getProperty("SERVER_HOME") + File.separator + "conf" + File.separator + "Persistence" + File.separator + "persistence-configurations.xml";
        if ("mysql".equals(server)) {
            connectionUrl = "jdbc:mysql://" + host + ":" + portNumber + "/" + dbName + "?useUnicode=true&characterEncoding=UTF-8&jdbcCompliantTruncation=false";
            driverName = "org.gjt.mm.mysql.Driver";
            dbAdapter = "com.adventnet.db.adapter.mysql.MysqlDBAdapter";
            sqlGenerator = "com.adventnet.db.adapter.mysql.MysqlSQLGenerator";
            if (pwd != null && !pwd.equals("")) {
                updatedDBConfig.setProperty("password", passWord);
            }
            updatedDBConfig.setProperty("username", userName);
            updatedDBConfig.setProperty("exceptionsorterclassname", "com.adventnet.db.adapter.mysql.MysqlExceptionSorter");
        } else if ("mssql".equals(server)) {
            connectionUrl = "jdbc:jtds:sqlserver://" + host;
            if (!instanceName.equalsIgnoreCase("")) {
                connectionUrl = connectionUrl + ";instance=" + instanceName;
            } else if (port != null && !port.equalsIgnoreCase("")) {
                connectionUrl = connectionUrl + ":" + port;
            }
            connectionUrl = connectionUrl + ";DatabaseName=" + dbName;
            driverName = "net.sourceforge.jtds.jdbc.Driver";
            dbAdapter = "com.adventnet.db.adapter.mssql.MssqlDBAdapter";
            sqlGenerator = "com.adventnet.db.adapter.mssql.MssqlSQLGenerator";
            if (!isWinAuthType) {
                EnDecryptImpl enDecrypt = new EnDecryptImpl();
                updatedDBConfig.setProperty("password", enDecrypt.encrypt(passWord));
                updatedDBConfig.setProperty("username", userName);
            }
            updatedDBConfig.setProperty("exceptionsorterclassname", "com.adventnet.db.adapter.mssql.MssqlExceptionSorter");
        } else if ("postgres".equals(server)) {
            connectionUrl = "jdbc:postgresql://" + host + ":" + portNumber + "/" + dbName;
            driverName = "org.postgresql.Driver";
            dbAdapter = "com.adventnet.db.adapter.postgres.PostgresDBAdapter";
            sqlGenerator = "com.adventnet.db.adapter.postgres.PostgresSQLGenerator";
            if (pwd != null && !pwd.equals("")) {
                updatedDBConfig.setProperty("password", passWord);
            }
            updatedDBConfig.setProperty("username", userName);
            updatedDBConfig.setProperty("exceptionsorterclassname", "com.adventnet.db.adapter.postgres.PostgresExceptionSorter");
        }
        this.updateXMLFile(server, dbPersistenceConfFile);
        updatedDBConfig.setProperty("minsize", "1");
        updatedDBConfig.setProperty("maxsize", "20");
        updatedDBConfig.setProperty("transaction_isolation", "TRANSACTION_READ_COMMITTED");
        updatedDBConfig.setProperty("url", connectionUrl);
        updatedDBConfig.setProperty("drivername", driverName);
        updatedDBConfig.setProperty("dbadapter", dbAdapter);
        updatedDBConfig.setProperty("sqlgenerator", sqlGenerator);
        FileOutputStream out = new FileOutputStream(dbParmasFile);
        Enumeration<Object> e = updatedDBConfig.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String configLine = key + " = " + updatedDBConfig.getProperty(key) + "\n";
            byte[] buf = configLine.getBytes();
            ((OutputStream)out).write(buf);
        }
        ((OutputStream)out).close();
    }

    private void updateXMLFile(String newDBServer, String serverdir) throws Exception {
        String value = "true";
        if ("mssql".equals(newDBServer)) {
            value = "false";
        }
        String separator = File.separator;
        String xml_path = serverdir;
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
        Document doc = docBuilder.parse(new FileInputStream(xml_path));
        NodeList attributes = doc.getElementsByTagName("configuration");
        for (int i = 0; i < attributes.getLength(); ++i) {
            Element ele = (Element)attributes.item(i);
            String attributeName = ele.getAttribute("name");
            if ("DBName".equals(attributeName)) {
                ele.setAttribute("value", newDBServer);
            }
            if ("StartDBServer".equals(attributeName)) {
                ele.setAttribute("value", value);
            }
            if (!"DSAdapter".equals(attributeName)) continue;
            ele.setAttribute("value", newDBServer);
        }
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        transformer.setOutputProperty("indent", "yes");
        StreamResult result = new StreamResult(new File(xml_path));
        DOMSource source = new DOMSource(doc);
        transformer.transform(source, result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String checkBCPFiles() {
        String bcpError = "BCP OK";
        String binDir = System.getProperty("SERVER_HOME") + File.separator + "bin" + File.separator;
        File bcpexe = new File(binDir + "bcp.exe");
        File bcprll = new File(binDir + "bcp.rll");
        if (!bcpexe.exists() || !bcprll.exists()) {
            bcpError = "Please copy bcp.exe & bcp.rll from your SQL server to ADAudit Plus <installation folder>\\bin. If not, certain features would not work properly";
        } else {
            BufferedReader in = null;
            try {
                Process p = Runtime.getRuntime().exec("cmd /c bcp.exe -?");
                in = new BufferedReader(new InputStreamReader(p.getInputStream()));
                String bcpOut = in.readLine();
                if (bcpOut == null) {
                    bcpError = "You are trying to configure SQL Server 2005 or above version,\n to support the same please download and install the SQL Native Client.\n Cick on OK for further information";
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (Exception ee) {
                        ee.printStackTrace();
                    }
                }
            }
        }
        return bcpError;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String executeBCPQuery(String serverName, boolean isWinAuthType, String userName, String pwd, String query, String instanceName) {
        String output = "";
        String commandToExecute = "cmd /c bcp.exe \"" + query + "\" queryout query.out -S " + serverName + "\\" + instanceName + " -c";
        commandToExecute = commandToExecute + (isWinAuthType ? " -T" : " -U " + userName + " -P \"" + pwd + "\"");
        BufferedReader in = null;
        try {
            Process p = Runtime.getRuntime().exec(commandToExecute);
            in = new BufferedReader(new InputStreamReader(p.getInputStream()));
            String line = "";
            while ((line = in.readLine()) != null) {
                output = output + line;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception ee) {
                    ee.printStackTrace();
                }
            }
        }
        return output;
    }

    public static String checkBCPQuery(String serverName, boolean isWinAuthType, String userName, String pwd, String instanceName) {
        String queryOut = ChangeDBServer.executeBCPQuery(serverName, isWinAuthType, userName, pwd, "select * from INFORMATION_SCHEMA.Tables", instanceName);
        return queryOut.indexOf("Named Pipes") != -1 ? "Please enable the option Using both TCP/IP and named pipes in Remote Connections.\n For more information click on OK" : "BCP OK";
    }

    public static String getLicenseType() {
        String productType = "Standard Edition";
        String userType = "Evaluation";
        String licenseType = new String();
        try {
            String separator = File.separator;
            String license_path = System.getProperty("server.home") + separator + "lib" + separator + "AdventNetLicense.xml";
            DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
            Document doc = docBuilder.parse(new FileInputStream(license_path));
            licenseType = ((Element)doc.getElementsByTagName("UserInfo").item(0)).getAttribute("LicenseType");
            if (licenseType.equals("Registered")) {
                licenseType = licenseType + "-" + ((Element)doc.getElementsByTagName("Product").item(0)).getAttribute("Type");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return licenseType;
    }

    public static HashMap getInbuildDBDetails() throws Exception {
        String activeDBName = ChangeDBServer.getActiveDB();
        return ChangeDBServer.getInbuildDBDetails(activeDBName);
    }

    public static HashMap getInbuildDBDetails(String dbServer) throws Exception {
        HashMap<String, Object> dbDetMap = new HashMap<String, Object>();
        if (dbServer.equalsIgnoreCase("mssql")) {
            dbServer = ChangeDBServer.getDBName();
        }
        if (dbServer.equals("mysql")) {
            dbDetMap.put("DB_SERVER_TYPE", "MySQL Server");
            dbDetMap.put("USERNAME", "root");
        } else {
            dbDetMap.put("DB_SERVER_TYPE", "PostgreSQL Server");
            dbDetMap.put("USERNAME", "postgres");
        }
        dbDetMap.put("DB_SERVER_NAME", dbServer);
        dbDetMap.put("DB_NAME", "adap");
        dbDetMap.put("HOST_NAME", "localhost");
        dbDetMap.put("PORT", new Long(33307L));
        System.out.println(dbDetMap);
        return dbDetMap;
    }

    private static String getDBName() {
        String dbName = "postgres";
        String dbHome = System.getProperty("server.home") + File.separator + "mysql";
        File file = new File(dbHome);
        if (file.exists()) {
            dbName = "mysql";
        }
        return dbName;
    }
}

