/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.mysql.tools;

import com.adventnet.sym.adsm.common.server.mysql.tools.ChangeDBServer;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.PortUnreachableException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class ChangeDBServerGUI
extends JFrame {
    private PrintWriter log = null;
    private String alertTitle = "ADAudit Plus - Change DataBase";
    private HashMap dbDetMap = null;
    private JComboBox serverType;
    private JComboBox sqlinstance;
    private JLabel sqlinstancelabel;
    private JLabel serverTypeLabel;
    private JLabel addressLabel;
    private JLabel authtypelabel;
    private JLabel dblabel;
    private JLabel domainlabel;
    private JLabel portlabel;
    private JLabel userLabel;
    private JLabel pwdlabel;
    private JPasswordField password;
    private JTextField serverAddress;
    private JTextField database;
    private JRadioButton winauthtype;
    private JRadioButton sqlauthtype;
    private JTextField domainName;
    private JTextField userName;
    private JTextField port;
    private JButton cancelButton;
    private JButton testButton;
    private JButton saveButton;
    private JPanel jPanel1 = new JPanel();

    public ChangeDBServerGUI() throws Exception {
        this.log = new PrintWriter(new FileOutputStream("changedbserver.log"), true);
        this.dbDetMap = ChangeDBServer.getInbuildDBDetails();
        this.initComponents();
    }

    private void initComponents() {
        this.serverTypeLabel = new JLabel();
        this.serverType = new JComboBox();
        this.sqlinstance = new JComboBox();
        this.sqlinstancelabel = new JLabel();
        this.addressLabel = new JLabel();
        this.serverAddress = new JTextField();
        this.port = new JTextField();
        this.authtypelabel = new JLabel();
        this.dblabel = new JLabel();
        this.domainlabel = new JLabel();
        this.portlabel = new JLabel();
        this.winauthtype = new JRadioButton();
        this.sqlauthtype = new JRadioButton();
        this.database = new JTextField();
        this.domainName = new JTextField();
        this.userLabel = new JLabel();
        this.userName = new JTextField();
        this.pwdlabel = new JLabel();
        this.password = new JPasswordField();
        this.cancelButton = new JButton();
        this.testButton = new JButton();
        this.saveButton = new JButton();
        this.setDefaultCloseOperation(3);
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("Database Setup Wizard"));
        this.serverTypeLabel.setText("Server Type");
        this.add(this.serverTypeLabel);
        this.serverTypeLabel.setBounds(40, 70, 100, 20);
        ArrayList<Object> serverTypeList = new ArrayList<Object>();
        serverTypeList.add(this.dbDetMap.get("DB_SERVER_TYPE"));
        serverTypeList.add("MSSQL Server");
        int size = serverTypeList.size();
        String[] serverTypeArr = new String[size];
        for (int i = 0; i < size; ++i) {
            serverTypeArr[i] = (String)serverTypeList.get(i);
        }
        this.serverType.setModel(new DefaultComboBoxModel<String>(serverTypeArr));
        this.add(this.serverType);
        this.serverType.setBounds(180, 70, 180, 24);
        this.serverType.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                String stype = ChangeDBServerGUI.this.serverType.getSelectedItem().toString();
                try {
                    ChangeDBServerGUI.this.serverAddress.setText("");
                    ChangeDBServerGUI.this.port.setText("");
                    ChangeDBServerGUI.this.database.setText("");
                    ChangeDBServerGUI.this.userName.setText("");
                    ChangeDBServerGUI.this.password.setText("");
                    if ("MSSQL Server".equals(stype)) {
                        String alertMsg = ChangeDBServer.checkBCPFiles();
                        if (!"BCP OK".equals(alertMsg)) {
                            ChangeDBServerGUI.this.log.println(alertMsg);
                            JOptionPane.showMessageDialog(null, alertMsg, ChangeDBServerGUI.this.alertTitle, 2);
                            if (alertMsg.indexOf("SQL Native Client") != -1) {
                                Runtime.getRuntime().exec("rundll32 url.dll,FileProtocolHandler http://www.manageengine.com/products/active-directory-audit/help/getting-started/migrating-mysql-to-mssql.html#Configuring_MS_SQLServer");
                                System.exit(0);
                            }
                            System.exit(0);
                        } else {
                            ChangeDBServerGUI.this.callMSSQLUI();
                        }
                    } else if (stype.equalsIgnoreCase("Mysql Server") || stype.equalsIgnoreCase("PostgreSQL Server")) {
                        ChangeDBServerGUI.this.callMYSQLUI();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        Object hash = null;
        String stype = "mssql";
        try {
            stype = ChangeDBServer.getActiveDB();
            if ("mysql".equals(stype)) {
                stype = "MySQL Server";
                this.sqlinstance.setVisible(false);
                this.sqlinstancelabel.setVisible(false);
            } else if ("mssql".equals(stype)) {
                stype = "MSSQL Server";
                this.sqlinstance.setVisible(true);
                this.sqlinstancelabel.setVisible(true);
            } else if (stype.equals("postgres")) {
                stype = "PostgreSQL Server";
                this.sqlinstance.setVisible(false);
                this.sqlinstancelabel.setVisible(false);
            }
            this.serverType.setSelectedItem(stype);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.addressLabel.setText("Host Name");
        this.add(this.addressLabel);
        this.addressLabel.setBounds(40, 120, 110, 15);
        if (this.serverAddress.getText().equals("")) {
            this.serverAddress.setText("localhost");
        }
        this.add(this.serverAddress);
        this.serverAddress.setBounds(180, 120, 180, 19);
        this.serverAddress.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                String stype = ChangeDBServerGUI.this.serverType.getSelectedItem().toString();
                if ("MSSQL Server".equals(stype)) {
                    ChangeDBServerGUI.this.sqlinstance.setModel(new DefaultComboBoxModel<Object>(ChangeDBServerGUI.this.getNamedInstance(ChangeDBServerGUI.this.serverAddress.getText())));
                    if (ChangeDBServerGUI.this.sqlinstance.getSelectedItem() != null) {
                        String instance_details = ChangeDBServerGUI.this.sqlinstance.getSelectedItem().toString();
                        String[] values = instance_details.split(";");
                        ChangeDBServerGUI.this.serverAddress.setText(values[0]);
                        if (values.length > 2) {
                            ChangeDBServerGUI.this.port.setText(values[2]);
                        }
                    }
                }
            }
        });
        this.add(this.portlabel);
        this.portlabel.setText("Port");
        this.portlabel.setBounds(40, 150, 110, 15);
        this.add(this.port);
        this.port.setBounds(180, 150, 180, 19);
        this.add(this.sqlinstancelabel);
        this.sqlinstancelabel.setText("Select MSSQL Server Instances");
        this.sqlinstancelabel.setBounds(40, 180, 420, 24);
        this.add(this.sqlinstance);
        this.sqlinstance.setBounds(40, 210, 320, 24);
        if ("MSSQL Server".equals(stype) && this.serverAddress.getText() != null) {
            this.sqlinstance.setModel(new DefaultComboBoxModel<Object>(this.getNamedInstance(this.serverAddress.getText())));
        }
        this.sqlinstance.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                String instance_details = ChangeDBServerGUI.this.sqlinstance.getSelectedItem().toString();
                String[] values = instance_details.split(";");
                ChangeDBServerGUI.this.serverAddress.setText(values[0]);
                if (values.length > 2) {
                    ChangeDBServerGUI.this.port.setText(values[2]);
                }
            }
        });
        int inc = 0;
        if ("MSSQL Server".equals(stype)) {
            inc = 60;
        }
        this.dblabel.setText("Database Name");
        this.add(this.dblabel);
        this.dblabel.setBounds(40, 180 + inc, 110, 15);
        this.database.setEditable(true);
        this.database.setText("");
        this.add(this.database);
        this.database.setBounds(180, 180 + inc, 180, 19);
        this.authtypelabel.setText("Connect Using");
        this.add(this.authtypelabel);
        this.authtypelabel.setBounds(40, 210 + inc, 110, 15);
        this.winauthtype.setText("Windows Authentication");
        this.add(this.winauthtype);
        this.winauthtype.setBounds(30, 240 + inc, 180, 25);
        this.sqlauthtype.setText("SQL Server Authentication");
        this.add(this.sqlauthtype);
        this.sqlauthtype.setBounds(200, 240 + inc, 200, 25);
        this.domainlabel.setText("Domain Name");
        this.domainlabel.setBounds(40, 270 + inc, 110, 15);
        this.add(this.domainlabel);
        this.domainName.setText("");
        this.domainName.setBounds(180, 270 + inc, 180, 19);
        this.add(this.domainName);
        if ("MSSQL Server".equals(stype)) {
            inc = 150;
            this.port.setVisible(false);
            this.portlabel.setVisible(false);
        }
        this.winauthtype.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ChangeDBServerGUI.this.sqlauthtype.setSelected(false);
                ChangeDBServerGUI.this.domainlabel.setVisible(false);
                ChangeDBServerGUI.this.domainName.setVisible(false);
                ChangeDBServerGUI.this.userLabel.setVisible(false);
                ChangeDBServerGUI.this.userName.setVisible(false);
                ChangeDBServerGUI.this.pwdlabel.setVisible(false);
                ChangeDBServerGUI.this.password.setVisible(false);
                ChangeDBServerGUI.this.userName.setText("");
                ChangeDBServerGUI.this.password.setText("");
            }
        });
        this.sqlauthtype.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ChangeDBServerGUI.this.winauthtype.setSelected(false);
                ChangeDBServerGUI.this.domainlabel.setVisible(false);
                ChangeDBServerGUI.this.domainName.setVisible(false);
                ChangeDBServerGUI.this.userLabel.setVisible(true);
                ChangeDBServerGUI.this.userName.setVisible(true);
                ChangeDBServerGUI.this.pwdlabel.setVisible(true);
                ChangeDBServerGUI.this.password.setVisible(true);
                if (ChangeDBServerGUI.this.userName.getText().equals("")) {
                    ChangeDBServerGUI.this.userName.setText("sa");
                    ChangeDBServerGUI.this.password.setText("");
                }
            }
        });
        this.userLabel.setText("User Name");
        this.add(this.userLabel);
        this.userLabel.setBounds(40, 210 + inc, 110, 15);
        this.add(this.userName);
        this.userName.setBounds(180, 210 + inc, 180, 19);
        this.pwdlabel.setText("Password");
        this.add(this.pwdlabel);
        this.pwdlabel.setBounds(40, 240 + inc, 110, 15);
        this.add(this.password);
        this.password.setText("");
        this.password.setBounds(180, 240 + inc, 180, 19);
        this.cancelButton.setText("Cancel");
        this.add(this.cancelButton);
        this.cancelButton.setBounds(190, 270 + inc, 80, 25);
        this.cancelButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                System.exit(0);
            }
        });
        this.testButton.setText("Test Connection");
        this.add(this.testButton);
        this.testButton.setBounds(280, 270 + inc, 80, 25);
        this.testButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                int mouse = evt.getButton();
                ChangeDBServerGUI.this.doCheckDBOperation();
            }
        });
        this.saveButton.setText("Save");
        this.add(this.saveButton);
        this.saveButton.setBounds(100, 270 + inc, 80, 25);
        this.saveButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                ChangeDBServerGUI.this.doSaveDBOperation();
            }
        });
        this.jPanel1.setBounds(0, 0, 360, 300);
        this.add(this.jPanel1);
        this.setTitle("ADAudit Plus - DB Configuration");
        String meImg = System.getProperty("SERVER_HOME") + File.separator + "images" + File.separator + "adsspFavicon.jpg";
        Image im = Toolkit.getDefaultToolkit().getImage(meImg);
        this.setIconImage(im);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isNamedInstance(String serverName, boolean isWinAuthType, String instanceName, String userName, String password) {
        boolean isNamedInstance = false;
        String dbUrl = null;
        Connection conn = null;
        Statement stmt = null;
        ResultSet resultSet = null;
        try {
            dbUrl = "jdbc:jtds:sqlserver://" + serverName + ";instance=" + instanceName;
            Class.forName("net.sourceforge.jtds.jdbc.Driver");
            String instanceQuery = "SELECT @@SERVERNAME AS INSTANCE";
            conn = isWinAuthType ? DriverManager.getConnection(dbUrl) : DriverManager.getConnection(dbUrl, userName, password);
            stmt = conn.createStatement();
            resultSet = stmt.executeQuery(instanceQuery);
            String name = "";
            if (resultSet.next()) {
                name = resultSet.getString(1);
            }
            if (!serverName.equalsIgnoreCase(name)) {
                isNamedInstance = true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (Exception se) {
                se.printStackTrace();
            }
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception se) {
                se.printStackTrace();
            }
            try {
                if (conn != null && !conn.isClosed()) {
                    conn.close();
                }
            }
            catch (Exception conE) {
                conE.printStackTrace();
            }
        }
        return isNamedInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doSaveDBOperation() {
        boolean validation = true;
        String stype = this.serverType.getSelectedItem().toString();
        String sname = this.serverAddress.getText();
        String sport = this.port.getText();
        String db = this.database.getText();
        String domain = this.domainName.getText();
        String uname = this.userName.getText();
        String pwd = this.password.getText();
        String serverType = "MSSQL Server".equals(stype) ? "mssql" : (String)this.dbDetMap.get("DB_SERVER_NAME");
        boolean isWinAuthType = this.isWindowsAuthentication(stype);
        String instanceName = "";
        if (serverType.equalsIgnoreCase("mssql")) {
            String instanceDetails = this.sqlinstance.getSelectedItem().toString();
            instanceName = ChangeDBServerGUI.getInstanceName(instanceDetails);
        }
        String err = null;
        if (sname.trim().equals("")) {
            err = "Please enter the valid server address !!!";
            validation = false;
        } else if (sport.trim().equals("") && !isWinAuthType && !serverType.equals("mssql")) {
            err = "Please enter the valid server port !!!";
            validation = false;
        } else if (db.trim().equals("")) {
            err = "Please enter the valid database !!!";
            validation = false;
        } else {
            try {
                if (!isWinAuthType && !serverType.equals("mssql")) {
                    Integer.parseInt(sport);
                }
            }
            catch (Exception e) {
                err = "Please enter the valid server port !!!";
                validation = false;
            }
        }
        if (!validation) {
            JOptionPane.showMessageDialog(null, err, this.alertTitle, 0);
        } else {
            try {
                ChangeDBServer cdb = new ChangeDBServer();
                String running = ChangeDBServer.isDBServerRunning(serverType, sname, sport, isWinAuthType, domain, uname, pwd, instanceName);
                if ("yes".equals(running)) {
                    if ("MSSQL Server".equalsIgnoreCase(stype)) {
                        this.alertTitle = ChangeDBServer.createDB("mssql", sname, sport, db, isWinAuthType, domain, uname, pwd, instanceName);
                        if (this.alertTitle.indexOf("Database") != -1 && this.alertTitle.indexOf("already exist") != -1) {
                            Object[] options = new Object[]{"OK", "Cancel"};
                            JOptionPane.showMessageDialog(null, "Already a database exist, Please give different name", "Alert", -1);
                            return;
                        }
                        if (this.alertTitle.indexOf("Successfully Executed") != -1) {
                            if (!this.isNamedInstance(sname, isWinAuthType, instanceName, uname, pwd)) {
                                instanceName = "";
                            }
                            cdb.updateDBConfigFile("mssql", sname, sport, db, isWinAuthType, domain, uname, pwd, null, instanceName);
                            JOptionPane.showMessageDialog(null, "MSSQL Server configured Successfully", "Alert", -1);
                            System.exit(0);
                        } else {
                            JOptionPane.showMessageDialog(null, this.alertTitle, "Alert", -1);
                        }
                    } else if ("MySQL Server".equalsIgnoreCase(stype)) {
                        this.alertTitle = ChangeDBServer.createDB("mysql", sname, sport, db, false, "", uname, pwd, null);
                        cdb.updateDBConfigFile("mysql", sname, sport, db, false, "", uname, pwd, null, null);
                        JOptionPane.showMessageDialog(null, "MY SQL server configured successfully.", "Alert", -1);
                    } else if ("PostgreSQL Server".equalsIgnoreCase(stype)) {
                        this.alertTitle = ChangeDBServer.createDB("postgres", sname, sport, db, false, "", uname, pwd, null);
                        cdb.updateDBConfigFile("postgres", sname, sport, db, false, "", uname, pwd, null, null);
                        JOptionPane.showMessageDialog(null, "PostgreSQL Server configured successfully.", "Alert", -1);
                    }
                } else {
                    JOptionPane.showMessageDialog(null, running, "Alert", -1);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                this.log.println(ex.getMessage());
            }
            finally {
                if (this.log != null) {
                    this.log.close();
                }
            }
        }
    }

    private void doCheckDBOperation() {
        String stype = this.serverType.getSelectedItem().toString();
        String sname = this.serverAddress.getText();
        String sport = this.port.getText();
        String db = this.database.getText();
        String domain = this.domainName.getText();
        String uname = this.userName.getText();
        String pwd = this.password.getText();
        String serverType = "MSSQL Server".equals(stype) ? "mssql" : (String)this.dbDetMap.get("DB_SERVER_NAME");
        boolean isWinAuthType = this.isWindowsAuthentication(stype);
        boolean validation = true;
        String err = null;
        String instanceName = null;
        if (serverType.equalsIgnoreCase("mssql")) {
            String instanceDetails = this.sqlinstance.getSelectedItem().toString();
            instanceName = ChangeDBServerGUI.getInstanceName(instanceDetails);
        }
        if (sname.trim().equals("") && !isWinAuthType) {
            err = "Please enter the valid server address !!!";
            validation = false;
        } else if (sport.trim().equals("") && !isWinAuthType && !serverType.equals("mssql")) {
            err = "Please enter the valid server port !!!";
            validation = false;
        } else if (db.trim().equals("")) {
            err = "Please enter the valid database !!!";
            validation = false;
        } else if (uname.trim().equals("") && !isWinAuthType) {
            err = "Please enter the user name !!!";
            validation = false;
        } else {
            try {
                if (!isWinAuthType && !serverType.equals("mssql")) {
                    Integer.parseInt(sport);
                }
            }
            catch (Exception e) {
                err = "Please enter the valid server port !!!";
                validation = false;
            }
        }
        if (!validation) {
            JOptionPane.showMessageDialog(null, err, this.alertTitle, 0);
        } else {
            String running = "no";
            try {
                running = ChangeDBServer.isDBServerRunning(serverType, sname, sport, isWinAuthType, domain, uname, pwd, instanceName);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if ("yes".equals(running)) {
                if ("MSSQL Server".equals(stype)) {
                    this.sqlServerValidation(sname, uname, pwd, isWinAuthType, instanceName);
                }
                JOptionPane.showMessageDialog(null, "Connection Established Successfully.", "Alert", -1);
            } else {
                JOptionPane.showMessageDialog(null, running, "Alert", -1);
            }
        }
    }

    private void sqlServerValidation(String sname, String uname, String pwd, boolean isWinAuthType, String instanceName) {
        String bcpMsg = ChangeDBServer.checkBCPQuery(sname, isWinAuthType, uname, pwd, instanceName);
        if (!"BCP OK".equals(bcpMsg)) {
            JOptionPane.showMessageDialog(null, bcpMsg, this.alertTitle, 2);
            try {
                Runtime.getRuntime().exec("rundll32 url.dll,FileProtocolHandler http://www.manageengine.com/products/active-directory-audit/help/getting-started/migrating-mysql-to-mssql.html");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private Object[] getNamedInstance(String hostName) {
        byte[] bytBuffer = new byte[1024];
        try {
            DatagramSocket ds = new DatagramSocket();
            ds.setSoTimeout(6000);
            InetAddress iadd = InetAddress.getByName(hostName);
            ds.connect(iadd, 1434);
            byte[] msg = new byte[]{2};
            DatagramPacket dp = new DatagramPacket(msg, msg.length);
            ds.send(dp);
            DatagramPacket dpr = new DatagramPacket(bytBuffer, bytBuffer.length);
            ds.receive(dpr);
        }
        catch (PortUnreachableException ure) {
            String msg = "Unable to fetch the SQL server instances\n\nRoot Causes:\n";
            msg = msg + "1) SQL server is not installed in " + hostName + "\n";
            msg = msg + "2) There is a firewall blocking port 1434 on the server\n";
            msg = msg + "3) If you are using MSSQL Server 2005, Please start the 'SQL Server Browser' from the Services\n";
            JOptionPane.showMessageDialog(null, msg, this.alertTitle, -1);
        }
        catch (UnknownHostException uhe) {
            JOptionPane.showMessageDialog(null, "Unknown host : " + hostName, this.alertTitle, -1);
        }
        catch (SocketTimeoutException ste) {
            JOptionPane.showMessageDialog(null, "Socket Time out while fetching the database instances from host : " + hostName, this.alertTitle, -1);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String instances = new String(bytBuffer);
        String[] instance = instances.split(";;");
        int len = instance.length;
        Vector<String> v = new Vector<String>();
        for (int i = 0; i < len; ++i) {
            if (instance[i].trim().equals("")) continue;
            String[] temp = instance[i].split(";");
            int l = temp.length;
            String val = "";
            for (int j = 0; j < l; j += 2) {
                if (temp[j].indexOf("ServerName") >= 0) {
                    val = val + temp[j + 1].trim();
                    continue;
                }
                if (temp[j].indexOf("InstanceName") >= 0) {
                    val = val + ";" + temp[j + 1].trim();
                    continue;
                }
                if (temp[j].indexOf("tcp") < 0) continue;
                val = val + ";" + temp[j + 1].trim();
            }
            v.add(val);
        }
        return v.toArray();
    }

    private boolean isWindowsAuthentication(String stype) {
        Object[] authType;
        boolean isWinAuthType = false;
        if ("MSSQL Server".equals(stype) && (authType = this.winauthtype.getSelectedObjects()) != null) {
            isWinAuthType = true;
        }
        return isWinAuthType;
    }

    public static String getInstanceName(String instanceDetails) {
        String instanceName = "";
        try {
            String[] instanceDetailsArray;
            if (instanceDetails != null && (instanceDetailsArray = instanceDetails.split("\\;")).length > 1) {
                instanceName = instanceDetailsArray[1];
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return instanceName;
    }

    public static void main(String[] args) throws Exception {
        ChangeDBServerGUI obj = new ChangeDBServerGUI();
        obj.setLocation(300, 200);
        obj.setSize(420, 500);
        obj.setVisible(true);
    }

    public void callMYSQLUI() throws Exception {
        this.sqlinstance.setVisible(false);
        this.sqlinstancelabel.setVisible(false);
        this.authtypelabel.setVisible(false);
        this.winauthtype.setVisible(false);
        this.sqlauthtype.setVisible(false);
        this.domainlabel.setVisible(false);
        this.domainName.setVisible(false);
        this.database.setLocation((int)this.database.getLocation().getX(), (int)this.database.getLocation().getY() - 60);
        this.dblabel.setLocation((int)this.dblabel.getLocation().getX(), (int)this.dblabel.getLocation().getY() - 60);
        this.userLabel.setLocation((int)this.userLabel.getLocation().getX(), (int)this.userLabel.getLocation().getY() - 60);
        this.userName.setLocation((int)this.userName.getLocation().getX(), (int)this.userName.getLocation().getY() - 60);
        this.pwdlabel.setLocation((int)this.pwdlabel.getLocation().getX(), (int)this.pwdlabel.getLocation().getY() - 60);
        this.password.setLocation((int)this.password.getLocation().getX(), (int)this.password.getLocation().getY() - 60);
        this.saveButton.setLocation((int)this.saveButton.getLocation().getX(), (int)this.saveButton.getLocation().getY() - 60);
        this.cancelButton.setLocation((int)this.cancelButton.getLocation().getX(), (int)this.cancelButton.getLocation().getY() - 60);
        this.testButton.setLocation((int)this.testButton.getLocation().getX(), (int)this.testButton.getLocation().getY() - 60);
        this.serverType.setSelectedItem("MySQL Server");
        this.dblabel.setBounds(40, 180, 110, 15);
        this.database.setBounds(180, 180, 180, 19);
        this.userLabel.setBounds(40, 210, 110, 15);
        this.userName.setBounds(180, 210, 180, 19);
        this.pwdlabel.setBounds(40, 240, 110, 15);
        this.password.setBounds(180, 240, 180, 19);
        this.cancelButton.setBounds(190, 270, 80, 25);
        this.testButton.setBounds(280, 270, 80, 25);
        this.saveButton.setBounds(100, 270, 80, 25);
        this.serverAddress.setText((String)this.dbDetMap.get("HOST_NAME"));
        String portNo = ((Long)this.dbDetMap.get("PORT")).toString();
        this.port.setText(portNo);
        this.userLabel.setVisible(true);
        this.pwdlabel.setVisible(true);
        this.userName.setVisible(true);
        this.password.setVisible(true);
        this.database.setText((String)this.dbDetMap.get("DB_NAME"));
        this.userName.setText((String)this.dbDetMap.get("USERNAME"));
        this.password.setText("");
        this.portlabel.setVisible(true);
        this.port.setVisible(true);
        String stype = ChangeDBServer.getActiveDB();
        if (stype.equals("mssql")) {
            this.database.setText("");
            this.userName.setText((String)this.dbDetMap.get("USENAME"));
            this.password.setText("");
        }
    }

    public void callMSSQLUI() throws Exception {
        HashMap hash = null;
        this.sqlinstance.setVisible(true);
        this.sqlinstancelabel.setVisible(true);
        this.authtypelabel.setVisible(true);
        this.winauthtype.setVisible(true);
        this.sqlauthtype.setVisible(true);
        this.authtypelabel.setLocation((int)this.authtypelabel.getLocation().getX(), (int)this.authtypelabel.getLocation().getY() + 60);
        this.winauthtype.setLocation((int)this.winauthtype.getLocation().getX(), (int)this.winauthtype.getLocation().getY() + 60);
        this.sqlauthtype.setLocation((int)this.sqlauthtype.getLocation().getX(), (int)this.sqlauthtype.getLocation().getY() + 60);
        this.dblabel.setLocation((int)this.dblabel.getLocation().getX(), (int)this.dblabel.getLocation().getY() + 60);
        this.database.setLocation((int)this.database.getLocation().getX(), (int)this.database.getLocation().getY() + 60);
        this.domainlabel.setLocation((int)this.domainlabel.getLocation().getX(), (int)this.domainlabel.getLocation().getY() + 60);
        this.domainName.setLocation((int)this.domainName.getLocation().getX(), (int)this.domainName.getLocation().getY() + 60);
        this.userLabel.setLocation((int)this.userLabel.getLocation().getX(), (int)this.userLabel.getLocation().getY() + 60);
        this.userName.setLocation((int)this.userName.getLocation().getX(), (int)this.userName.getLocation().getY() + 60);
        this.pwdlabel.setLocation((int)this.pwdlabel.getLocation().getX(), (int)this.pwdlabel.getLocation().getY() + 60);
        this.password.setLocation((int)this.password.getLocation().getX(), (int)this.password.getLocation().getY() + 60);
        this.saveButton.setLocation((int)this.saveButton.getLocation().getX(), (int)this.saveButton.getLocation().getY() + 60);
        this.cancelButton.setLocation((int)this.cancelButton.getLocation().getX(), (int)this.cancelButton.getLocation().getY() + 60);
        this.testButton.setLocation((int)this.testButton.getLocation().getX(), (int)this.testButton.getLocation().getY() + 60);
        this.dblabel.setBounds(40, 240, 110, 15);
        this.database.setBounds(180, 240, 180, 19);
        this.authtypelabel.setBounds(40, 270, 110, 15);
        this.winauthtype.setBounds(35, 300, 170, 15);
        this.sqlauthtype.setBounds(200, 300, 190, 15);
        this.domainlabel.setBounds(40, 330, 110, 15);
        this.domainName.setBounds(180, 330, 180, 19);
        this.userLabel.setBounds(40, 360, 110, 15);
        this.userName.setBounds(180, 360, 180, 19);
        this.pwdlabel.setBounds(40, 390, 110, 15);
        this.password.setBounds(180, 390, 180, 19);
        this.cancelButton.setBounds(190, 420, 80, 25);
        this.testButton.setBounds(280, 420, 80, 25);
        this.saveButton.setBounds(100, 420, 80, 25);
        hash = ChangeDBServer.getDBDetails("mssql");
        if (!ChangeDBServer.isWinAuthType()) {
            this.winauthtype.setSelected(false);
            this.sqlauthtype.setSelected(true);
            this.domainlabel.setVisible(false);
            this.domainName.setVisible(false);
            this.userLabel.setVisible(true);
            this.userName.setVisible(true);
            this.pwdlabel.setVisible(true);
            this.password.setVisible(true);
            String stype = ChangeDBServer.getActiveDB();
            this.userName.setText((String)hash.get("USERNAME"));
            if (stype.equals("mysql") || stype.equals("postgres")) {
                this.userName.setText("sa");
                this.password.setText("");
            }
        } else {
            this.sqlauthtype.setSelected(false);
            this.winauthtype.setSelected(true);
            this.domainlabel.setVisible(false);
            this.domainName.setVisible(false);
            this.domainName.setText((String)hash.get("DOMAINNAME"));
            this.userLabel.setVisible(false);
            this.userName.setVisible(false);
            this.userName.setText("");
            this.pwdlabel.setVisible(false);
            this.password.setVisible(false);
            this.password.setText("");
        }
        this.serverAddress.setText((String)hash.get("HOST"));
        this.port.setText((String)hash.get("PORT"));
        this.database.setText((String)hash.get("DATABASE"));
        this.password.setText("");
        this.port.setVisible(false);
        this.portlabel.setVisible(false);
    }
}

