/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.mysql.tools;

import com.adventnet.db.adapter.DBAdapter;
import com.adventnet.sym.adsm.common.server.mysql.tools.ChangeDBServer;
import com.zoho.framework.utils.crypto.EnDecryptImpl;
import java.io.File;
import java.io.FileReader;
import java.sql.Connection;
import java.sql.DriverManager;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class ConnectionUtil {
    public static String driver = "";
    public static String connectionURL = "";
    public static String username = "";
    public static String password = "";
    public static String characterEncoding = "";
    public static String seperator = File.separator;
    public static Connection conn;
    public static boolean stopDBServer;
    public static DBAdapter dbAdapter;
    public static String[] removeTables;

    public static Connection getConnection(String dbserver) throws Exception {
        if (conn != null && !conn.isClosed()) {
            return conn;
        }
        ConnectionUtil.parseDSFile(dbserver);
        ConnectionUtil.getDBAdapter(dbserver);
        try {
            Class.forName(driver);
            conn = DriverManager.getConnection(connectionURL, username, password);
            System.out.println("Database started");
        }
        catch (Exception e) {
            System.out.println("Database not started. Starting .........");
            dbAdapter.setUpDB(connectionURL, username, password);
            Thread.sleep(1000L);
            Class.forName(driver);
            conn = DriverManager.getConnection(connectionURL, username, password);
            stopDBServer = true;
        }
        return conn;
    }

    public static void parseDSFile(String dbserver) throws Exception {
        connectionURL = ChangeDBServer.getPropertyValue("url");
        driver = ChangeDBServer.getPropertyValue("drivername");
        username = ChangeDBServer.getPropertyValue("username");
        password = ChangeDBServer.getPropertyValue("password");
        if (password != null) {
            EnDecryptImpl enDecrypt = new EnDecryptImpl();
            password = enDecrypt.decrypt(password);
        }
        characterEncoding = ChangeDBServer.getPropertyValue("connection-property");
    }

    public static String getCharacterEncoding() {
        return characterEncoding;
    }

    public static String getUserName() {
        return username;
    }

    public static String getPassword() {
        return password;
    }

    public static String getConnectionURL() {
        return connectionURL;
    }

    public static String getConnectionURL(Map connectionProps) throws Exception {
        String connectionURL = (String)connectionProps.get("ConnectionURL");
        String connectionProp = (String)connectionProps.get("ConnectionProperties");
        System.out.println("Database connectionProp : " + connectionProp);
        if (connectionProp != null) {
            int encode = connectionProp.indexOf("characterEncoding");
            int unicode = connectionProp.indexOf("useUnicode");
            if (encode != -1 || unicode != -1) {
                StringTokenizer token = new StringTokenizer(connectionProp, "\n");
                StringBuffer strBuf = new StringBuffer();
                boolean firstToken = true;
                while (token.hasMoreTokens()) {
                    strBuf.append(token.nextToken());
                    if (!firstToken) continue;
                    strBuf.append("&");
                    firstToken = false;
                }
                connectionProp = strBuf.toString();
                connectionURL = connectionURL + "?" + connectionProp;
            }
        }
        return connectionURL;
    }

    public static String getDBName() throws Exception {
        String dbName = dbAdapter.getDefaultDB(conn);
        int containsConnProps = dbName.indexOf("?");
        if (containsConnProps > -1) {
            dbName = dbName.substring(0, containsConnProps);
        }
        return dbName;
    }

    public static String getDataBase() throws Exception {
        return dbAdapter.getDBName(conn);
    }

    public static DBAdapter getDBAdapter(String dbserver) throws Exception {
        String dbAdapterClassName = "com.adventnet.db.adapter.mysql.MysqlDBAdapter";
        if ("mssql".equals(dbserver)) {
            dbAdapterClassName = "com.adventnet.db.adapter.mssql.MssqlDBAdapter";
        } else if ("postgres".equals(dbserver)) {
            dbAdapterClassName = "com.adventnet.db.adapter.postgres.PostgresDBAdapter";
        }
        dbAdapter = (DBAdapter)Thread.currentThread().getContextClassLoader().loadClass(dbAdapterClassName).newInstance();
        return dbAdapter;
    }

    public static void shutDownDB() throws Exception {
        System.out.println("stopping DB Server .......");
        if (stopDBServer) {
            dbAdapter.shutDownDB(connectionURL, username, password);
        }
    }

    public static List getTableList() throws Exception {
        List tableList = dbAdapter.getTables(conn, ConnectionUtil.getDBName());
        tableList = ConnectionUtil.getTableList(tableList);
        return tableList;
    }

    public static List getTableList(Connection con) throws Exception {
        List tableList = dbAdapter.getTables(con, ConnectionUtil.getDBName());
        tableList = ConnectionUtil.getTableList(tableList);
        return tableList;
    }

    public static List getTableList(List tableList) throws Exception {
        if (null != tableList && !tableList.isEmpty()) {
            for (String tableName : removeTables) {
                if (!tableList.contains(tableName)) continue;
                tableList.remove(tableName);
            }
        }
        return tableList;
    }

    public static String getConstraint(String dbConFile, String constraintName) {
        String resultString = null;
        File dbFile = new File(dbConFile);
        try {
            Node localNode;
            DocumentBuilderFactory documentbuilderfactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentbuilder = documentbuilderfactory.newDocumentBuilder();
            Document doc = documentbuilder.parse(new InputSource(new FileReader(dbFile)));
            NodeList nodes = doc.getElementsByTagName("datasources");
            int dslength = nodes.getLength();
            if (dslength != 0 && (localNode = nodes.item(0)).getNodeType() == 1) {
                Element localElement = (Element)localNode;
                NodeList urlList = localElement.getElementsByTagName(constraintName);
                Element urlElement = (Element)urlList.item(0);
                NodeList textUrlList = urlElement.getChildNodes();
                Node n1 = textUrlList.item(0);
                resultString = n1.getNodeValue().trim();
            }
        }
        catch (Exception ee) {
            ee.printStackTrace();
        }
        return resultString;
    }

    static {
        stopDBServer = false;
        removeTables = new String[]{"trace_xe_action_map", "trace_xe_event_map"};
    }
}

