/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.mysql.tools;

import com.adventnet.db.adapter.SQLGenerator;
import com.adventnet.db.api.RelationalAPI;
import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.Query;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.SortColumn;
import com.adventnet.ds.query.Table;
import com.adventnet.mfw.ConsoleOut;
import com.adventnet.persistence.DataAccess;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.PersistenceInitializer;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.auditing.server.compliance.TemplateTableHandler;
import com.adventnet.sym.adsm.auditing.server.monitor.AuditMonitorAPI;
import com.adventnet.sym.adsm.auditing.server.util.MoveRecreateTableHandler;
import com.adventnet.sym.adsm.common.server.mysql.tools.BackUpDB;
import com.adventnet.sym.adsm.common.server.mysql.tools.ChangeDBServer;
import com.adventnet.sym.adsm.common.server.mysql.tools.ConnectionUtil;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.EncryptionAPI;
import com.adventnet.tools.update.installer.JarExtractor;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.StringCharacterIterator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

public class RestoreBackup {
    private static BufferedWriter logout = null;
    private static boolean dataRestoreState = false;
    private static String errString = "";
    private static int errorCode = -1;
    private static String dbType = "";
    private Connection con = null;
    private static String symmKeyName = "ZOHO_SYMM_KEY";
    private static String certificateName = "ZOHO_CERT";
    private boolean isEventLog = false;
    private String separator = File.separator;
    private String back_dir = "";
    private Pattern archiveTablesPattern = null;
    private Pattern importArchivePattern = null;
    private Pattern baseTablePattern = null;
    private HashMap dbparams = new HashMap();
    private String dbserver = null;
    private String dbname = null;
    private String dbuser = null;
    private String dbpass = null;
    private String instanceName = null;
    private String dbPort = null;
    private boolean isWinAuthType = false;
    private List insertQueryTables;
    private List insertQueryTablesLowerCase;
    private Hashtable scharTable;
    private Hashtable scharTableLowerCase;
    private EncryptionAPI dec = null;
    private BackUpDB backupDB = null;
    private HashMap inbuildDBMap = null;
    private Hashtable build_info = null;
    public static String[] sqlQueryColumn = new String[]{"sql_string", "count_sql_string", "groupbyused", "group_by", "union_used"};
    public static String[] unionQueryColumn = new String[]{"union_query", "union_count_query"};
    public static String[] viewConfigColumn = new String[]{"sortcolumn"};
    public static String[] graphOptionColumn = new String[]{"xcolumn", "ycolumn", "criteria", "group_by", "limit_value", "sort_order"};
    private static String cvTableName = "AUDCVConfig";
    private static String viewConfigTable = "AUDTableViewConfig";
    private static String graphTableName = "AUDGraphOptions";
    private static String sqlQueryTable = "AUDSQLQuery";
    private static String unionQueryTable = "AUDUnionQuery";
    private static String[] indexes = new String[]{"TIME_GENERATED_AUDAcntCrtn", "RECORD_NUMBER_AUDAcntCrtn", "ACCOUNT_SID_AUDAcntCrtn", "CALLER_USER_SID_AUDAcntCrtn", "TIME_GENERATED_AUDCompMgmt", "RECORD_NUMBER_AUDCompuMgmt", "ACCOUNT_SID_AUDCompuMgmt", "CALLER_USER_SID_AUDCompMgmt", "TIME_GENERATED_AUDPolicyCng", "RECORD_NUMBER_AUDPolicyCng", "CALLER_USER_SID_AUDPolicyCng", "TIME_GENERATED_AUDFileAudit", "RECORD_NUMBER_AUDFileAudit", "ACCESS_TYPE_AUDFileAudit", "SOURCE_AUDFileAudit", "USERNAME_AUDFileAudit", "TIME_GENERATED_AUDCompInfo", "RECORD_NUMBER_AUDCompInfo", "TIME_GENERATED_AUDNPSAuditInf", "TIME_GENERATED_AUD_FIM", "RECORD_NUMBER_AUD_FIM", "ACCESS_TYPE_AUD_FIM", "SOURCE_AUD_FIM", "USERNAME_AUD_FIM", "TIME_GENERATED_AUDAcCrtn_0", "RECORD_NUMBER_AUDAcCrtn_0", "ACCOUNT_SID_AUDAcCrtn_0", "CALLER_USER_SID_AUDAcCrtn_0", "TIME_GENERATED_AUDCompMgmt_0", "RECORD_NUMBER_AUDCompuMgmt_0", "ACCOUNT_SID_AUDCompuMgmt_0", "CALLER_USER_SID_AUDCompMgmt_0", "TIME_GENERATED_AUDPocyCng_0", "RECORD_NUMBER_AUDPoliCng_0", "CALLER_USER_SID_AUDPoliCng_0", "TIME_GENERATED_AUDFileAudit_0", "RECORD_NUMBER_AUDFileAudit_0", "ACCESS_TYPE_AUDFileAudit_0", "SOURCE_AUDFileAudit_0", "USERNAME_AUDFileAudit_0", "TIME_GENERATED_AUDCmInfo_0", "RECORD_NUMBER_AUDCmInfo_0", "TIME_GENERATED_AUDNPSAudInf_0", "RECORD_NUMBER_AUDNPSAudInfo_0", "TIME_GENERATED_AUD_FIM_0", "RECORD_NUMBER_AUD_FIM_0", "ACCESS_TYPE_AUD_FIM_0", "SOURCE_AUD_FIM_0", "USERNAME_AUD_FIM_0"};

    public RestoreBackup() {
        try {
            dbType = RestoreBackup.getActiveDBServer();
            this.con = ConnectionUtil.getConnection(dbType);
            logout = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(System.getProperty("server.home") + File.separator + "logs" + File.separator + "RestoreBackup.log"), "UTF8"));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public RestoreBackup(String filename) {
        try {
            dbType = RestoreBackup.getActiveDBServer();
            if (this.con == null) {
                this.con = ConnectionUtil.getConnection(dbType);
            }
            this.inbuildDBMap = ChangeDBServer.getInbuildDBDetails(dbType);
            this.dec = EncryptionAPI.getDecryptionObj();
            this.backupDB = new BackUpDB();
            this.insertQueryTables = this.backupDB.getInsertQueryTables();
            this.insertQueryTablesLowerCase = new ArrayList();
            for (int i = 0; i < this.insertQueryTables.size(); ++i) {
                this.insertQueryTablesLowerCase.add(this.insertQueryTables.get(i).toString().toLowerCase());
            }
            this.scharTable = this.backupDB.getSCharTable();
            this.scharTableLowerCase = new Hashtable();
            if (this.scharTable != null && !this.scharTable.isEmpty()) {
                Set keys = this.scharTable.keySet();
                for (String key : keys) {
                    String val = (String)this.scharTable.get(key);
                    this.scharTableLowerCase.put(key.toLowerCase(), val);
                }
            }
            this.back_dir = new File(filename).getParent();
            dbType = RestoreBackup.getActiveDBServer();
            this.archiveTablesPattern = Pattern.compile("[aA][uU][dD][a-zA-Z]+[_]+[0-9]+");
            this.importArchivePattern = Pattern.compile("[aA][uU][dD][a-zA-Z]+[_]+[0]+[_]+[0-9]+");
            this.baseTablePattern = Pattern.compile("[_][0-9]+");
            this.isWinAuthType = ChangeDBServer.isWinAuthType();
            if ("mssql".equals(dbType)) {
                this.setDBParams();
            }
            logout = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(System.getProperty("jboss.home.dir") + File.separator + "logs" + File.separator + "RestoreBackup.log"), "UTF8"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) throws Exception {
        if (RestoreBackup.getActiveDBServer().equalsIgnoreCase("mysql") || RestoreBackup.getActiveDBServer().equalsIgnoreCase("postgres")) {
            ConsoleOut.println((String)"\n Please change the database to mssql ......");
            System.exit(1);
        }
        if (args.length == 1 && new File(args[0]).isFile()) {
            RestoreBackup rbkp = new RestoreBackup(args[0]);
            rbkp.deCompressData(args[0]);
            if (rbkp.isBuildCompatible()) {
                String confFileDir = System.getProperty("server.home") + "/conf/";
                try {
                    PersistenceInitializer.initializeDB((String)confFileDir);
                }
                catch (Exception ex) {
                    ConsoleOut.println((String)ex.getMessage());
                }
                PersistenceInitializer.initializeMickey((boolean)true);
                rbkp.restoreDatabase(args[0]);
                dataRestoreState = true;
            } else {
                ConnectionUtil.shutDownDB();
                System.exit(1);
            }
        } else {
            System.out.println("File not found : " + (args.length == 1 ? args[0] : ""));
        }
    }

    private void setDBParams() throws Exception {
        this.dbparams = ChangeDBServer.getDBDetails("mssql");
        if (this.dbparams != null) {
            this.dbserver = (String)this.dbparams.get("HOST");
            this.dbname = (String)this.dbparams.get("DATABASE");
            this.dbuser = (String)this.dbparams.get("USERNAME");
            this.dbpass = (String)this.dbparams.get("PASSWORD");
            this.instanceName = (String)this.dbparams.get("INSTANCENAME");
            this.dbPort = (String)this.dbparams.get("PORT");
            if (this.dbpass == null) {
                this.dbpass = "";
            }
        }
    }

    private boolean isBuildCompatible() throws Exception {
        try {
            this.build_info = this.getBuildInfo(this.back_dir + this.separator + "backup_info.xml");
            String backUpBuild = this.build_info.get("build_number").toString().trim();
            String installBuild = BackUpDB.getBuildNumber();
            if (backUpBuild.equals(installBuild)) {
                return true;
            }
            this.deleteDir(new File(this.back_dir));
            ConsoleOut.println((String)("\nBackup build " + backUpBuild + "is not compatible with existing build " + installBuild + "\n"));
            System.out.println("Backup build " + backUpBuild + " is not compatible with installation build " + installBuild);
            logout.write("\nBackup build " + backUpBuild + "is not compatible with existing build " + installBuild + "\n");
        }
        catch (Exception e) {
            logout.write("\nException while checking build compatibility " + e.getMessage());
            e.printStackTrace();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restoreDatabase(String backup_file) throws Exception {
        try {
            ConsoleOut.println((String)" Dropping all template instances ");
            TemplateTableHandler.deleteAllTables();
            ConsoleOut.println((String)" Working before getting connection ");
            List tables = RelationalAPI.getInstance().getDBAdapter().getTables(this.con, null);
            ConsoleOut.println((String)("db type : " + dbType));
            System.out.println("\n\nPlease wait ! Deleting table data in Progress..");
            System.out.println("0-----------------------50------------------------100(%)");
            ConsoleOut.println((String)"0-----------------------50------------------------100(%)");
            this.fkCheck(false);
            Thread.sleep(4000L);
            this.deleteTableData(tables);
            System.out.println("\n\nPlease wait ! Restoring in Progress...................");
            ConsoleOut.println((String)"\n\nPlease wait ! Restoring in Progress...................");
            this.restoreTableData(tables, false);
            ConsoleOut.println((String)" Creating all template instances ");
            TemplateTableHandler.createCrunchTemplateInstances();
            ConsoleOut.println((String)" Copying all template instances ");
            this.restoreTableData(tables, true);
            RestoreBackup.updateTableData();
            RestoreBackup.updateDefaultTaskInput();
            Thread.sleep(4000L);
            this.fkCheck(true);
            System.out.println("\n deleting temp files.....");
            ConsoleOut.println((String)"\n deleting temp files.....");
            this.deleteDir(new File(this.back_dir));
            errString = "Data restored successfully";
            errorCode = 0;
            dataRestoreState = false;
        }
        catch (Exception e) {
            e.printStackTrace();
            dataRestoreState = false;
            System.out.println("Unable to restore database : " + e.getMessage());
            ConsoleOut.println((String)("Unable to restore database : " + e.getMessage()));
            logout.write("\n" + e.getMessage() + "\n");
            if (logout != null) {
                logout.close();
            }
            System.exit(1);
        }
        finally {
            ConnectionUtil.shutDownDB();
            if (logout != null) {
                logout.close();
            }
            if (this.con != null) {
                this.con.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dropADAPTables() {
        String str = null;
        Statement stmt = null;
        boolean flag = false;
        String tableName = "";
        try {
            List adapTableList = this.getADAPTableList();
            this.con.setAutoCommit(false);
            stmt = this.con.createStatement();
            int size = adapTableList.size();
            for (int k = 0; k < size; ++k) {
                str = "drop table " + adapTableList.get(k);
                try {
                    stmt.executeUpdate(str);
                    logout.write(str + " \n");
                    continue;
                }
                catch (SQLException e) {
                    logout.write(e.getMessage() + " : " + str + "\n");
                    flag = true;
                }
            }
            this.con.commit();
            if (flag) {
                System.out.println("Error occured while droping  adap table");
                ConsoleOut.println((String)"Error occured while droping  adap table");
                System.out.println(" data please see the error log");
                ConsoleOut.println((String)" data please see the error log");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List getADAPTableList() {
        ArrayList<String> tableList = new ArrayList<String>();
        Connection connection = null;
        Statement stmt = null;
        ResultSet rs = null;
        boolean isNewConn = false;
        try {
            if (connection == null) {
                connection = RelationalAPI.getInstance().getConnection();
                isNewConn = true;
            }
            stmt = connection.createStatement();
            SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)"TableDetails"));
            Join join = new Join("TableDetails", "SB_Applications", new String[]{"APPL_ID"}, new String[]{"APPL_ID"}, 2);
            Criteria crit = new Criteria(Column.getColumn((String)"SB_Applications", (String)"APPL_NAME"), (Object)"adap", 0, true);
            query.addJoin(join);
            query.setCriteria(crit);
            query.addSortColumn(new SortColumn(new Column("TableDetails", "TABLE_ORDER"), false));
            query.addSelectColumn(Column.getColumn((String)"TableDetails", (String)"*"));
            String sqlString = ((SQLGenerator)Class.forName("com.adventnet.db.adapter.mssql.MssqlSQLGenerator").newInstance()).getSQLForSelect((Query)query);
            rs = stmt.executeQuery(sqlString);
            while (rs.next()) {
                tableList.add(rs.getString(3));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
                if (isNewConn && connection != null) {
                    connection.close();
                }
            }
            catch (Exception exc) {
                exc.printStackTrace();
            }
        }
        return tableList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createTables() {
        Statement stmt = null;
        try {
            String query;
            String file = this.back_dir + File.separator + "createTableSyntax.sql";
            BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
            int i = 0;
            stmt = this.con.createStatement();
            this.con.setAutoCommit(false);
            while ((query = in.readLine()) != null) {
                ++i;
                boolean createTable = stmt.execute(query);
                this.con.commit();
                logout.write(query + ": return val :" + createTable + " \n");
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    private boolean isTablePresent(ArrayList<String> list, String tableName) {
        for (String str : list) {
            if (!tableName.equalsIgnoreCase(str)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restoreTableData(List tables, boolean isTemplateTableMigrate) throws Exception {
        String tmp = System.getProperty("sdp.restore.error.ignoretables");
        Vector<String> error_tables = null;
        if (tmp != null) {
            System.out.println("Error Tables : " + tmp);
            ConsoleOut.println((String)("Error Tables : " + tmp));
            String[] tables_tmp = tmp.split(",");
            int size = tables_tmp.length;
            error_tables = new Vector<String>(size);
            for (int i = 0; i < size; ++i) {
                if (tables_tmp[i].trim().equals("")) continue;
                error_tables.add(tables_tmp[i]);
            }
        }
        Statement stmt = null;
        FileOutputStream fos = null;
        try {
            this.con.setAutoCommit(false);
            stmt = this.con.createStatement();
            fos = !isTemplateTableMigrate ? new FileOutputStream(System.getProperty("jboss.home.dir") + File.separator + "logs" + File.separator + "dbDump.log", false) : new FileOutputStream(System.getProperty("jboss.home.dir") + File.separator + "logs" + File.separator + "dbDump_compliance.log", false);
            System.out.println("0-----------------------50------------------------100(%)");
            ConsoleOut.println((String)"0-----------------------50------------------------100(%)");
            int size = tables.size();
            int div = size / 50;
            File[] files = new File(this.back_dir).listFiles();
            ArrayList templateInstanceList = TemplateTableHandler.getTemplateInstanceList();
            for (int i = 0; i < files.length; ++i) {
                String fileName = files[i].getName();
                if (fileName.endsWith("_mysqlformat.sql")) continue;
                String file = this.back_dir + File.separator + fileName;
                if (!new File(file).exists()) {
                    logout.write("\nFile not found : " + fileName);
                    continue;
                }
                if (!fileName.endsWith(".sql")) continue;
                String tableName = fileName.substring(0, fileName.lastIndexOf("."));
                if ((!isTemplateTableMigrate || !this.isTablePresent(templateInstanceList, tableName)) && isTemplateTableMigrate) continue;
                if (this.insertQueryTablesLowerCase.contains(tableName.toUpperCase()) || this.insertQueryTablesLowerCase.contains(tableName.toLowerCase())) {
                    String query;
                    Statement stmtSym;
                    long size_bytes;
                    boolean encrypted;
                    String line;
                    String header;
                    BufferedReader in;
                    block60: {
                        logout.write("\nDumping file " + fileName + " into table " + tableName + " using insert query syntax");
                        in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
                        header = in.readLine();
                        line = "";
                        encrypted = this.scharTableLowerCase.containsKey(tableName);
                        long buffer_size = 10240L;
                        if (header == null) {
                            in.close();
                            if ((i + 1) % div != 0) continue;
                            System.out.print("=");
                            continue;
                        }
                        line = this.readLine(in, encrypted);
                        size_bytes = line.length();
                        stmtSym = null;
                        try {
                            if ("mssql".equals(dbType)) {
                                stmtSym = this.con.createStatement();
                                query = "OPEN SYMMETRIC KEY " + symmKeyName + " DECRYPTION BY CERTIFICATE " + certificateName;
                                stmtSym.execute(query);
                            }
                            if (error_tables == null || !error_tables.contains(tableName)) {
                                if ("mssql".equals(dbType)) {
                                    while (line != null) {
                                        line = RestoreBackup.replaceUnwantedChar(line);
                                        stmt.addBatch(header + line);
                                        if (size_bytes > buffer_size) {
                                            stmt.executeBatch();
                                            this.con.commit();
                                            size_bytes = 0L;
                                        }
                                        if ((line = this.readLine(in, encrypted)) == null) continue;
                                        size_bytes += (long)line.length();
                                    }
                                } else {
                                    while (line != null) {
                                        line = RestoreBackup.replaceUnwantedChar(line);
                                        stmt.addBatch(header + line.replaceAll(", N'", ", '"));
                                        if (size_bytes > buffer_size) {
                                            stmt.executeBatch();
                                            this.con.commit();
                                            size_bytes = 0L;
                                        }
                                        if ((line = this.readLine(in, encrypted)) == null) continue;
                                        size_bytes += (long)line.length();
                                    }
                                }
                                break block60;
                            }
                            if ("mssql".equals(dbType)) {
                                while (line != null) {
                                    line = RestoreBackup.replaceUnwantedChar(line);
                                    try {
                                        stmt.executeUpdate(header + line);
                                    }
                                    catch (Exception e) {
                                        System.out.println("Error ignored = " + e.getMessage());
                                    }
                                    line = this.readLine(in, encrypted);
                                }
                            } else {
                                while (line != null) {
                                    line = RestoreBackup.replaceUnwantedChar(line);
                                    try {
                                        stmt.executeUpdate(header + line.replaceAll(", N'", ", '"));
                                    }
                                    catch (Exception e) {
                                        System.out.println("Error ignored = " + e.getMessage());
                                    }
                                    line = this.readLine(in, encrypted);
                                }
                            }
                            this.con.commit();
                        }
                        catch (Exception ex) {
                            logout.write("\nException while executing the query QUERY = " + header + line + ex);
                        }
                        finally {
                            if (stmtSym != null) {
                                stmtSym.close();
                            }
                        }
                    }
                    if (!(error_tables != null && error_tables.contains(tableName) || size_bytes <= 0L)) {
                        try {
                            stmt.executeBatch();
                            this.con.commit();
                        }
                        catch (Exception ex) {
                            logout.write("\nException while executing the query QUERY = " + header + line + ex);
                        }
                    }
                    if (encrypted && "mssql".equals(dbType)) {
                        stmtSym = null;
                        try {
                            stmtSym = this.con.createStatement();
                            query = "CLOSE SYMMETRIC KEY " + symmKeyName;
                            stmtSym.execute(query);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        finally {
                            if (stmtSym != null) {
                                stmtSym.close();
                            }
                        }
                    }
                    in.close();
                    if ((i + 1) % div != 0) continue;
                    System.out.print("=");
                    continue;
                }
                try {
                    logout.write("\nDumping file " + fileName + " into table " + tableName + " using bcp.exe");
                    if (tableName.indexOf("_") != -1) {
                        Matcher m = this.archiveTablesPattern.matcher(tableName);
                        Matcher importMacher = this.importArchivePattern.matcher(tableName);
                        if (m.matches() || importMacher.matches()) {
                            String[] splitTableArray = this.baseTablePattern.split(tableName);
                            String baseTableName = "";
                            if (splitTableArray[0] != null) {
                                baseTableName = splitTableArray[0];
                            }
                            stmt.executeUpdate(this.constructQuery(tableName, baseTableName));
                            logout.write("\nCreated splitted table " + tableName);
                        }
                    }
                    if (tableName.startsWith("ip_") || tableName.startsWith("iptable_") || tableName.equalsIgnoreCase("AUDShareAccessInfoTables") || tableName.equalsIgnoreCase("AUDADUserServices")) continue;
                    this.con.commit();
                    String command = null;
                    String dbHome = System.getProperty("db.home");
                    String delimiter = "|**|";
                    String lineTerminator = "|**|**|";
                    if (((String)this.inbuildDBMap.get("DB_SERVER_NAME")).equals("postgres")) {
                        delimiter = "\\t";
                        lineTerminator = "";
                    }
                    command = "cmd /c bcp.exe " + this.dbname + ".dbo." + tableName + " in \"" + this.back_dir + "\\" + fileName + "\" -S " + this.dbserver;
                    if (this.instanceName != null && !this.instanceName.equals("")) {
                        command = command + "\\" + this.instanceName;
                    } else if (this.dbPort != null && !this.dbPort.equals("")) {
                        command = command + "," + this.dbPort;
                    }
                    command = !this.isWinAuthType ? command + " -U " + this.dbuser + " -P \"" + this.dbpass + "\"" : command + " -T ";
                    command = command + " -t \"" + delimiter + "\" -r \"" + lineTerminator + "\\n\" -e ..\\logs\\datainerr.txt -c -E -q";
                    fos.write(("Dumping to table " + tableName + "\n" + command + "\n").getBytes());
                    this.executeCommand(command, fos);
                }
                catch (Exception e) {
                    logout.write("\nError while dumping table " + tableName + ". I skip this and proceed further");
                    e.printStackTrace();
                }
                if ((i + 1) % div != 0) continue;
                ConsoleOut.print((String)"=");
            }
        }
        catch (Exception e) {
            logout.write("\n" + e);
            e.printStackTrace();
        }
        finally {
            if (stmt != null) {
                stmt.close();
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (Exception ee) {
                    ee.printStackTrace();
                }
            }
        }
    }

    private String readLine(BufferedReader in, boolean enc) throws IOException {
        String line = null;
        if (enc) {
            line = EncryptionAPI.readEncryptedLine(in);
            if (line != null) {
                line = this.dec.decryptLog(line);
            }
        } else {
            line = in.readLine();
        }
        return line;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeCommand(String command, FileOutputStream fos) throws Exception {
        BufferedReader in = null;
        try {
            int c;
            Process p = Runtime.getRuntime().exec(command);
            in = new BufferedReader(new InputStreamReader(p.getInputStream()));
            while ((c = in.read()) != -1) {
                fos.write(c);
            }
        }
        catch (Exception ex) {
            logout.write("\nError while executing query to import sql file into database");
            ex.printStackTrace();
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception ee) {
                    ee.printStackTrace();
                }
            }
        }
    }

    public String constructQuery(String splitTable, String baseTable) throws Exception {
        Statement stmt1 = null;
        Statement stmt2 = null;
        ResultSet rs1 = null;
        ResultSet rs2 = null;
        String finalQuery = "";
        if ("mysql".equals(dbType)) {
            finalQuery = "create table if not exists " + splitTable + " like " + baseTable;
        } else if ("mssql".equals(dbType)) {
            StringBuffer resultQuery = new StringBuffer("");
            try {
                stmt1 = this.con.createStatement();
                rs1 = stmt1.executeQuery("exec sp_columns " + baseTable);
                resultQuery.append("if not exists (select * from sysobjects where name='" + splitTable + "' and xtype='U') BEGIN CREATE TABLE " + splitTable + " ( ");
                while (rs1.next()) {
                    String tempStr;
                    int tempInt;
                    String columnName = "";
                    String columnType = "";
                    String columnSize = "";
                    String defaultValue = "";
                    String nullable = "";
                    columnName = (String)rs1.getObject(4) + " ";
                    columnType = (String)rs1.getObject(6) + " ";
                    String lowerColumnType = columnType.toLowerCase();
                    if (lowerColumnType.indexOf("int") == -1 && lowerColumnType.indexOf("datetime") == -1 && lowerColumnType.indexOf("ntext") == -1 && lowerColumnType.indexOf("text") == -1) {
                        columnSize = "(" + (Integer)rs1.getObject(7) + ") ";
                    }
                    if ((tempInt = ((Integer)rs1.getObject(11)).intValue()) == 0) {
                        nullable = "NOT NULL";
                    }
                    if ((tempStr = (String)rs1.getObject(13)) != null) {
                        defaultValue = "DEFAULT " + tempStr + " ";
                    }
                    resultQuery.append(columnName + columnType + columnSize + defaultValue + nullable + ", ");
                }
                resultQuery.append(" ); ");
                stmt1.close();
                rs1.close();
                stmt2 = this.con.createStatement();
                rs2 = stmt2.executeQuery("exec sp_helpindex " + baseTable);
                while (rs2.next()) {
                    String indexName = "";
                    String indexValue = "";
                    indexName = (String)rs2.getObject(1);
                    indexValue = (String)rs2.getObject(3);
                    if (indexName.indexOf("PK") != -1) {
                        resultQuery.insert(resultQuery.indexOf(" );"), "PRIMARY KEY (" + indexValue + ")");
                        continue;
                    }
                    resultQuery.append("CREATE INDEX " + indexName + " ON " + splitTable + " ( " + indexValue + " );");
                }
                resultQuery.append(" END");
                stmt2.close();
                rs2.close();
            }
            catch (Exception e) {
                logout.write("\nException Executing the constructed SQL  ::  \n" + resultQuery);
                throw e;
            }
            finally {
                try {
                    if (stmt1 != null) {
                        stmt1.close();
                    }
                    if (stmt2 != null) {
                        stmt2.close();
                    }
                    if (rs1 != null) {
                        rs1.close();
                    }
                    if (rs2 != null) {
                        rs2.close();
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            logout.write("\n" + resultQuery + "\n");
            finalQuery = resultQuery.toString();
        } else if (dbType.equalsIgnoreCase("postgres") && (finalQuery = MoveRecreateTableHandler.getInstance().getPSQLCreateTableSyntax(baseTable, dbType)) != null) {
            finalQuery = finalQuery.replaceAll(baseTable, splitTable);
            Long currentTime = System.currentTimeMillis();
            for (int i = 0; i < indexes.length; ++i) {
                if (finalQuery.indexOf(indexes[i]) == -1) continue;
                finalQuery = finalQuery.replaceAll(indexes[i], indexes[i] + "_" + currentTime);
            }
        }
        return finalQuery;
    }

    private String replaceCRTF(String data) throws Exception {
        try {
            data = data.replaceAll("\\\\t", "\t");
            data = data.replaceAll("\\\\r", "\r");
            data = data.replaceAll("\\\\n", "\n");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return data;
    }

    private void deleteDir(File file) throws Exception {
        File[] files = file.listFiles();
        for (int i = 0; i < files.length; ++i) {
            if (files[i].getName().indexOf(".sql") > 0) {
                files[i].delete();
                continue;
            }
            if (!files[i].getName().equals("backup_info.xml")) continue;
            files[i].delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fkCheck(boolean enable) throws Exception {
        logout.write("\nFK Check " + enable + "\n");
        try (Statement stmt = null;){
            stmt = this.con.createStatement();
            if ("mysql".equals(dbType)) {
                if (enable) {
                    stmt.execute("set SESSION FOREIGN_KEY_CHECKS = 1");
                } else {
                    stmt.execute("set SESSION FOREIGN_KEY_CHECKS = 0");
                }
            } else if ("mssql".equals(dbType)) {
                String keyword = enable ? " CHECK" : " NOCHECK";
                stmt.executeUpdate("exec sp_MSforeachtable 'ALTER TABLE ? " + keyword + " CONSTRAINT ALL'");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteTableData(List deleteTablesList) throws Exception {
        String str = null;
        boolean flag = false;
        try (Statement stmt = null;){
            this.con.setAutoCommit(false);
            stmt = this.con.createStatement();
            int size = deleteTablesList.size();
            int divider = size / 50;
            for (int i = size - 1; i >= 0; --i) {
                if (i % divider == 0) {
                    ConsoleOut.print((String)"=");
                }
                str = "delete from " + deleteTablesList.get(i);
                logout.write("Deleting table " + deleteTablesList.get(i) + " \n");
                try {
                    stmt.executeUpdate(str);
                    continue;
                }
                catch (SQLException e) {
                    logout.write(e.getMessage() + " : " + str + "\n");
                    flag = true;
                }
            }
            this.con.commit();
            if (flag) {
                System.out.println("Error occured while deletion of all table");
                ConsoleOut.println((String)"Error occured while deletion of all table");
                System.out.println(" data please see the error log");
                ConsoleOut.println((String)" data please see the error log");
            }
        }
    }

    private Hashtable getBuildInfo(String backup_info) throws Exception {
        Hashtable<String, String> hash = new Hashtable<String, String>(4);
        if (!new File(backup_info).isFile()) {
            throw new Exception("backup-info.xml not found : " + backup_info);
        }
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
        Document doc = docBuilder.parse(backup_info);
        NodeList nodelist = doc.getElementsByTagName("backup-date");
        System.out.println("");
        ConsoleOut.println((String)"*************************************************************");
        ConsoleOut.println((String)("\t Backup data  : " + nodelist.item(0).getFirstChild().getNodeValue()));
        hash.put("backup_date", nodelist.item(0).getFirstChild().getNodeValue());
        nodelist = doc.getElementsByTagName("database");
        ConsoleOut.println((String)("\t Database name : " + nodelist.item(0).getFirstChild().getNodeValue()));
        hash.put("database", nodelist.item(0).getFirstChild().getNodeValue());
        nodelist = doc.getElementsByTagName("number-of-table");
        ConsoleOut.println((String)("\t Total Tables  : " + nodelist.item(0).getFirstChild().getNodeValue()));
        hash.put("no_of_tables", nodelist.item(0).getFirstChild().getNodeValue());
        nodelist = doc.getElementsByTagName("build-number");
        ConsoleOut.println((String)("\t Build Number  : " + nodelist.item(0).getFirstChild().getNodeValue()));
        hash.put("build_number", nodelist.item(0).getFirstChild().getNodeValue());
        ConsoleOut.println((String)"*************************************************************");
        ConsoleOut.println((String)"");
        return hash;
    }

    private static String getActiveDBServer() throws Exception {
        return ChangeDBServer.getActiveDB();
    }

    private static String replaceUnwantedChar(String data) {
        StringBuffer buffer = new StringBuffer();
        try {
            StringCharacterIterator iterator = new StringCharacterIterator(data);
            char character = iterator.current();
            while (character != '\uffff') {
                if (character != '\u0000') {
                    buffer.append(character);
                }
                character = iterator.next();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        buffer.append("\n");
        return buffer.toString();
    }

    private void deCompressData(String filename) throws Exception {
        logout.write("\nExtracting backup file");
        File backupFile = new File(filename);
        ConsoleOut.println((String)"Please wait extracting backup file");
        new File(this.back_dir).mkdir();
        JarExtractor.extract((File)backupFile, (File)new File(this.back_dir));
    }

    public static boolean isDataRestored() {
        return dataRestoreState;
    }

    public static String getErrorString() {
        return errString;
    }

    public static int getErrorCode() {
        return errorCode;
    }

    public static void setErrorCode(int ec, String es) {
        errorCode = ec;
        errString = es;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HashMap getMetaData(String table_name) {
        LinkedHashMap<String, String> hash = new LinkedHashMap<String, String>();
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = this.con.prepareStatement("SELECT TABLE_ID FROM TableDetails where TABLE_NAME = '" + table_name + "'");
            rs = stmt.executeQuery();
            if (rs.next()) {
                stmt = this.con.prepareStatement("SELECT COLUMN_NAME, MAX_SIZE FROM ColumnDetails where TABLE_ID = '" + rs.getString(1) + "'");
                rs = stmt.executeQuery();
                while (rs.next()) {
                    hash.put(rs.getString(1), rs.getString(2));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        return hash;
    }

    public static void updateTableData() {
        try {
            String confFileDir = System.getProperty("server.home") + "/conf/";
            RestoreBackup.updateMonitorSqlQuery();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void updateMonitorSqlQuery() {
        try {
            DataObject dataObject = RestoreBackup.getDataObject(sqlQueryTable);
            DataObject joinDataObject = RestoreBackup.getDataObject(graphTableName);
            DataObject sqlQueryDataObject = CommonUtil.getPersistence(new boolean[0]).get(sqlQueryTable, (Criteria)null);
            DataObject graphOptionDataObject = CommonUtil.getPersistence(new boolean[0]).get(graphTableName, (Criteria)null);
            DataObject unionQueryDataObject = CommonUtil.getPersistence(new boolean[0]).get(unionQueryTable, (Criteria)null);
            Iterator iterator = dataObject.getRows("AUDMonitorReportMap");
            boolean z = false;
            while (iterator.hasNext()) {
                Row monitorReportRow = (Row)iterator.next();
                Long monitorId = (Long)monitorReportRow.get("MONITOR_ID");
                Long reportId = (Long)monitorReportRow.get("AUDIT_REPORT_ID");
                Criteria crit = new Criteria(Column.getColumn((String)"AUDReportCVMapping", (String)"AUDIT_REPORT_ID"), (Object)reportId, 0);
                Row cvMapRow = dataObject.getRow("AUDReportCVMapping", crit);
                if (cvMapRow == null) continue;
                Long cvId = (Long)cvMapRow.get("CV_ID");
                crit = new Criteria(Column.getColumn((String)sqlQueryTable, (String)"CV_ID"), (Object)cvId, 0);
                Row sqlRow = sqlQueryDataObject.getRow(sqlQueryTable, crit);
                if (sqlRow == null) continue;
                boolean add = false;
                Long queryId = (Long)sqlRow.get("QUERY_ID");
                sqlRow.set("SQL_STRING", (Object)AuditMonitorAPI.getInstance().getMonitorReportSQLString(monitorId, 0L));
                sqlRow.set("COUNT_SQL_STRING", (Object)AuditMonitorAPI.getInstance().getMonitorReportCountSQLString(monitorId));
                sqlRow.set("UNION_USED", (Object)true);
                Criteria unionQueryCrit = new Criteria(Column.getColumn((String)unionQueryTable, (String)"QUERY_ID"), (Object)queryId, 0);
                Row unionQueryRow = unionQueryDataObject.getRow(unionQueryTable, unionQueryCrit);
                if (unionQueryRow == null) {
                    unionQueryRow = new Row(unionQueryTable);
                    unionQueryRow.set("QUERY_ID", (Object)queryId);
                    add = true;
                }
                unionQueryRow.set("QUERY_ID", sqlRow.get("QUERY_ID"));
                unionQueryRow.set("UNION_QUERY", (Object)AuditMonitorAPI.getInstance().getMonitorReportUnionSQLString(monitorId));
                unionQueryRow.set("UNION_COUNT_QUERY", (Object)AuditMonitorAPI.getInstance().getMonitorUnionCountSQLString(monitorId));
                if (add) {
                    unionQueryDataObject.addRow(unionQueryRow);
                } else {
                    unionQueryDataObject.updateRow(unionQueryRow);
                }
                sqlQueryDataObject.updateRow(sqlRow);
            }
            Iterator reportCvIt = joinDataObject.getRows("AUDReportCVMapping");
            while (reportCvIt.hasNext()) {
                Row repcvMapRow = (Row)reportCvIt.next();
                if (repcvMapRow == null) continue;
                Long cvID = (Long)repcvMapRow.get("CV_ID");
                Criteria graphCrit = new Criteria(Column.getColumn((String)graphTableName, (String)"CV_ID"), (Object)cvID, 0);
                Row graphRow = graphOptionDataObject.getRow(graphTableName, graphCrit);
                String xColumn = (String)graphRow.get("XCOLUMN");
                String groupBy = (String)graphRow.get("GROUP_BY");
                graphRow.set("XCOLUMN", (Object)RestoreBackup.getMSSqlFormateString(xColumn));
                graphRow.set("GROUP_BY", (Object)RestoreBackup.getMSSqlFormateString(groupBy));
                graphRow.set("YCOLUMN", (Object)"adapcount");
                graphOptionDataObject.updateRow(graphRow);
            }
            CommonUtil.getPersistence(new boolean[0]).update(sqlQueryDataObject);
            CommonUtil.getPersistence(new boolean[0]).update(unionQueryDataObject);
            CommonUtil.getPersistence(new boolean[0]).update(graphOptionDataObject);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static DataObject getDataObject(String tableName) {
        DataObject dataObject = null;
        try {
            String monitorReportMapTable = "AUDMonitorReportMap";
            String reportCvMappingTable = "AUDReportCVMapping";
            Table table = Table.getTable((String)monitorReportMapTable);
            SelectQueryImpl query = new SelectQueryImpl(table);
            Join monitorcvMapJoin = new Join(monitorReportMapTable, reportCvMappingTable, new String[]{"AUDIT_REPORT_ID"}, new String[]{"AUDIT_REPORT_ID"}, 2);
            Join cvSqlJoin = new Join(reportCvMappingTable, sqlQueryTable, new String[]{"CV_ID"}, new String[]{"CV_ID"}, 2);
            Join cvGraphJoin = new Join(reportCvMappingTable, graphTableName, new String[]{"CV_ID"}, new String[]{"CV_ID"}, 2);
            query.addJoin(monitorcvMapJoin);
            query.addSelectColumn(Column.getColumn((String)reportCvMappingTable, (String)"*"));
            if (tableName.equalsIgnoreCase("AUDSQLQuery")) {
                query.addJoin(cvSqlJoin);
                query.addSelectColumn(Column.getColumn((String)monitorReportMapTable, (String)"*"));
                query.addSelectColumn(Column.getColumn((String)sqlQueryTable, (String)"*"));
            } else {
                query.addJoin(cvGraphJoin);
                query.addSelectColumn(Column.getColumn((String)graphTableName, (String)"*"));
            }
            dataObject = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)query);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return dataObject;
    }

    public static String getMSSqlFormateString(String mySqlString) {
        String msSqlString = null;
        try {
            msSqlString = mySqlString.contains("DATE_FORMAT") && mySqlString.contains("%d %b %y") || mySqlString.contains("DD Mon YY") && mySqlString.contains("TO_TIMESTAMP") ? "${PATTERNREPLACE:XCOLUMN_DAY_BASED}" : (mySqlString.contains("DAYOFYEAR") || mySqlString.contains("DAYOFYEAR(FROM_UNIXTIME(TIME_GENERATED))") ? "${PATTERNREPLACE:GROUP_BY_DAY_BASED}" : (mySqlString.contains("HOUR") || mySqlString.contains("HOUR(FROM_UNIXTIME(TIME_GENERATED))") || mySqlString.contains("HH24") && mySqlString.contains("TO_TIMESTAMP") ? "${PATTERNREPLACE:XCOLUMN_HOUR_BASED}" : mySqlString));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return msSqlString;
    }

    private static void updateDefaultTaskInput() {
        try {
            Criteria crit = new Criteria(Column.getColumn((String)"Default_Task_Input", (String)"VARIABLE_NAME"), (Object)"framework.online.backup", 0);
            DataObject dObj = DataAccess.get((String)"Default_Task_Input", (Criteria)crit);
            Row row = dObj.getFirstRow("Default_Task_Input");
            row.set("VARIABLE_VALUE", (Object)"");
            dObj.updateRow(row);
            DataAccess.update((DataObject)dObj);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

