/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.mysql.tools;

import com.adventnet.mfw.ConsoleOut;
import com.adventnet.sym.adsm.common.server.mysql.tools.BackUpDB;
import com.adventnet.sym.adsm.common.server.mysql.tools.RestoreBackup;
import com.adventnet.sym.adsm.common.server.mysql.tools.ShutdownThread;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.Observable;
import java.util.Observer;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class RestoreDialog
extends JDialog
implements Observer {
    private static boolean bkUpStat = false;
    private String progressStr;
    private Thread restoreThread;
    private Thread progressbarThread;
    private Thread refreshThread;
    private static RestoreDialog jDialog;
    private JTextField backupFileText;
    private JButton browseButton;
    private JButton cancelButton;
    private JLabel headerLabel;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel4;
    private JLabel noteLabel;
    private JButton okButton;
    private JLabel statusLabel;
    private JLabel successLabel;
    private JProgressBar restoreProgressBar;
    private String fileName;

    public RestoreDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
    }

    private void initComponents() {
        boolean isEventLog;
        this.jPanel1 = new JPanel();
        this.headerLabel = new JLabel();
        this.noteLabel = new JLabel();
        this.jPanel2 = new JPanel();
        this.backupFileText = new JTextField();
        this.browseButton = new JButton();
        this.jPanel4 = new JPanel();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        this.setDefaultCloseOperation(0);
        this.setTitle("Restore Database");
        this.setBackground(new Color(231, 231, 231));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                RestoreDialog.this.closeDialog(evt);
            }
        });
        this.jPanel1.setLayout(new BorderLayout());
        this.headerLabel.setHorizontalAlignment(2);
        boolean bl = isEventLog = "/event".equals(System.getProperty("Context", "/event"));
        if (!isEventLog) {
            String dbType = "mssql";
            try {
                dbType = BackUpDB.getActiveDBServer();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            dbType = "mssql".equals(dbType) ? "SQL Server" : "Mysql Server";
            this.headerLabel.setText("<html> Data will be restored into " + dbType + " <br><br>Please choose the data to be restored</html>");
        } else {
            this.headerLabel.setText("<html><br>Please choose the data to be restored</html>");
        }
        this.jPanel1.add((Component)new JLabel("  "), "West");
        this.jPanel1.add((Component)this.headerLabel, "Center");
        this.noteLabel.setFont(new Font("Dialog", 0, 10));
        this.noteLabel.setText("   Note : The existing data will be rewritten with the backup data");
        this.jPanel1.add((Component)this.noteLabel, "South");
        this.getContentPane().add(this.jPanel1);
        this.jPanel2.setLayout(new GridBagLayout());
        this.backupFileText.setHorizontalAlignment(2);
        this.backupFileText.setMinimumSize(new Dimension(44, 19));
        this.backupFileText.setPreferredSize(new Dimension(250, 19));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 11;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 44, 0, 17);
        this.jPanel2.add((Component)this.backupFileText, gridBagConstraints);
        this.browseButton.setText("Browse");
        this.browseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RestoreDialog.this.browseButtonActionPerformed(evt);
            }
        });
        this.jPanel2.add((Component)this.browseButton, new GridBagConstraints());
        this.getContentPane().add(this.jPanel2);
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RestoreDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.jPanel4.add(this.okButton);
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RestoreDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.jPanel4.add(this.cancelButton);
        this.getContentPane().add(this.jPanel4);
        this.pack();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        System.exit(0);
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        ConsoleOut.println((String)("File name is :  " + this.backupFileText.getText()));
        this.fileName = this.backupFileText.getText();
        if (this.fileName == null || this.fileName != null && this.fileName.trim().equals("")) {
            System.out.println("fileName is empty");
            JOptionPane.showMessageDialog(null, "You have not chosen the data file to be restored.\nPlease choose the file to be restored.");
            return;
        }
        Runtime.getRuntime().addShutdownHook(new ShutdownThread(this));
        this.headerLabel.setHorizontalAlignment(2);
        this.headerLabel.setText("<html><br>&nbsp;&nbsp;Restore data in progress . . .</html>");
        this.jPanel2.removeAll();
        this.restoreProgressBar = new JProgressBar();
        this.statusLabel = new JLabel();
        this.jPanel2.setLayout(new BorderLayout());
        this.restoreProgressBar.setIndeterminate(true);
        this.jPanel2.add((Component)this.restoreProgressBar, "Center");
        this.jPanel2.add((Component)this.statusLabel, "South");
        this.okButton.setEnabled(false);
        this.cancelButton.setEnabled(false);
        Runnable dload = new Runnable(){

            @Override
            public void run() {
                try {
                    RestoreBackup.main(new String[]{RestoreDialog.this.fileName});
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
        this.restoreThread = new Thread(dload);
        this.restoreThread.start();
        Runnable progress = new Runnable(){

            @Override
            public void run() {
                try {
                    if (!RestoreDialog.this.isDataRestoring()) {
                        RestoreDialog.this.restoreProgressBar.show();
                    }
                }
                catch (Exception e) {
                    System.out.println("Exception while showing ProgressBar :");
                    e.printStackTrace();
                }
            }
        };
        Runnable refresh = new Runnable(){

            @Override
            public void run() {
                try {
                    long n1 = 0L;
                    boolean n2 = false;
                    while (RestoreBackup.getErrorCode() == -1) {
                        try {
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    RestoreDialog.this.restoreProgressBar.setIndeterminate(true);
                                }
                            });
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                    }
                    RestoreDialog.this.remove(RestoreDialog.this.jPanel1);
                    RestoreDialog.this.jPanel2.removeAll();
                    RestoreDialog.this.successLabel = new JLabel();
                    RestoreDialog.this.successLabel.setText(RestoreBackup.getErrorString());
                    RestoreDialog.this.jPanel2.add((Component)RestoreDialog.this.successLabel, "Center");
                    RestoreDialog.this.cancelButton.setText("Close");
                    RestoreDialog.this.cancelButton.setEnabled(true);
                }
                catch (Exception exp2) {
                    exp2.printStackTrace();
                    JOptionPane.showMessageDialog(null, "Exception while updating the progressBar", "Error", 0);
                }
            }
        };
        this.progressbarThread = new Thread(progress);
        this.progressbarThread.start();
        this.refreshThread = new Thread(refresh);
        this.refreshThread.start();
        this.repaint();
    }

    private void browseButtonActionPerformed(ActionEvent evt) {
        JFileChooser chooser = new JFileChooser();
        chooser.setCurrentDirectory(new File(System.getProperty("jboss.home.dir")));
        int returnVal = chooser.showOpenDialog(this);
        if (returnVal == 0) {
            ConsoleOut.println((String)("You chose to open this file: " + chooser.getSelectedFile()));
            this.backupFileText.setText(chooser.getSelectedFile().toString());
        }
    }

    private void closeDialog(WindowEvent evt) {
        if (RestoreBackup.isDataRestored() && RestoreBackup.getErrorCode() == -1) {
            JOptionPane.showMessageDialog(null, "Closing the window will cause the data to be in an inconsistent state.\nHence cannot close the window.", "Close", 1);
        } else {
            this.setVisible(false);
            this.dispose();
            System.exit(0);
        }
    }

    public static void main(String[] args) throws Exception {
        ConsoleOut.println((String)"*********************************************************************************");
        ConsoleOut.println((String)"\t\t\t Restore DB Setup Wizard");
        ConsoleOut.println((String)"*********************************************************************************");
        ConsoleOut.println((String)"");
        ConsoleOut.println((String)"Execute Restore DB Utility from command prompt");
        ConsoleOut.println((String)"");
        ConsoleOut.println((String)"\tFor Windows users : ");
        ConsoleOut.println((String)"\t\ttools>restoreData -c [backup file]");
        ConsoleOut.println((String)"");
        ConsoleOut.println((String)"");
        ConsoleOut.println((String)"*********************************************************************************");
        if (args.length == 2 && ("--console".equals(args[0].trim()) || "-c".equals(args[0].trim()))) {
            System.out.println("FYI [SEVERE]: Please don't kill this utility until the operation is completed");
            RestoreBackup.main(new String[]{args[1]});
        } else {
            jDialog = new RestoreDialog((Frame)new JFrame(), true);
            jDialog.setSize(450, 200);
            jDialog.setLocation(200, 200);
            jDialog.show();
        }
    }

    public String getFileName() {
        return this.fileName;
    }

    public boolean isDataRestoring() {
        bkUpStat = RestoreBackup.isDataRestored();
        return bkUpStat;
    }

    public static Object getObject() {
        return jDialog;
    }

    public String getStatusBar() {
        return this.progressStr;
    }

    @Override
    public void update(Observable o, Object arg) {
        this.progressStr = (String)arg;
        this.statusLabel.setText(this.progressStr);
    }
}

