/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.ntfs;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.DomainDetailsAPI;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.objects.DirectoryObjectAPI;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;

public class ExcludeFilesHandler {
    private static final AdventNetResourceBundle RB = ResourceBundleMgr.getInstance().getBundle();
    private static final Logger EVENTLOGGER = Logger.getLogger("EventLogger");
    private static ExcludeFilesHandler filesHandler = null;
    private static ArrayList<String> ignorableFileList = null;
    private static ArrayList<Pattern> excludeFilePattern = null;
    private static ArrayList<String> excludeFileTypeList = null;
    private static ArrayList<String> excludeProcessList = null;
    private static ArrayList<String> keyName = null;
    private static ArrayList<String> keyValue = null;
    private static ArrayList<String> domainList = null;
    private static ArrayList<String> excludeUserList = null;
    private static HashMap domainUserList;
    private static HashMap userInfo;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ExcludeFilesHandler getInstance() {
        if (filesHandler != null) return filesHandler;
        Class<ExcludeFilesHandler> clazz = ExcludeFilesHandler.class;
        synchronized (ExcludeFilesHandler.class) {
            if (filesHandler != null) return filesHandler;
            filesHandler = new ExcludeFilesHandler();
            // ** MonitorExit[var0] (shouldn't be in output)
            return filesHandler;
        }
    }

    private ExcludeFilesHandler() {
        this.setIgnorableFileTypes();
        this.setExcludeList();
        this.setFileKeys();
    }

    private void setFileKeys() {
        keyName = new ArrayList();
        keyValue = new ArrayList();
        try {
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get("AUDFileFilterKeys", (Row)null);
            Iterator iterator = dataObject.getRows("AUDFileFilterKeys");
            while (iterator.hasNext()) {
                Row row = (Row)iterator.next();
                String name = (String)row.get("KEY_NAME");
                String rbvalue = (String)row.get("KEY_VALUE");
                String localeValue = "";
                StringTokenizer stringTokenizer = new StringTokenizer(rbvalue, ",");
                while (stringTokenizer.hasMoreTokens()) {
                    String value = stringTokenizer.nextToken().trim();
                    value = RB.getString(value);
                    localeValue = localeValue + "[" + value + "]";
                }
                keyName.add(name);
                keyValue.add(localeValue);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static ArrayList<String> getIgnorableFileList() {
        return ignorableFileList;
    }

    public static ArrayList<String> getExcludeFileTypeList() {
        return excludeFileTypeList;
    }

    public static ArrayList<String> getExcludeProcessList() {
        return excludeProcessList;
    }

    public static ArrayList<Pattern> getExcludeFilePattern() {
        return excludeFilePattern;
    }

    public static ArrayList<String> getKeyList() {
        return keyName;
    }

    public static ArrayList<String> getDomainList() {
        return domainList;
    }

    public static HashMap getDomainUserList() {
        return domainUserList;
    }

    public static HashMap getUserInfo() {
        return userInfo;
    }

    public static ArrayList<String> getExcludeUserList() {
        return excludeUserList;
    }

    private void setIgnorableFileTypes() {
        ignorableFileList = new ArrayList();
        excludeFilePattern = new ArrayList();
        try {
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get("AUDIgnorableFileFilter", (Row)null);
            Iterator iterator = dataObject.getRows("AUDIgnorableFileFilter");
            while (iterator.hasNext()) {
                Row row = (Row)iterator.next();
                String filePattern = (String)row.get("PATTERN");
                ignorableFileList.add(filePattern);
                String fileRegexPattern = filePattern.toLowerCase().replaceAll("\\*", ".\\*");
                fileRegexPattern = fileRegexPattern.replaceAll("\\\\", "\\\\\\\\");
                fileRegexPattern = fileRegexPattern.replaceAll("\\$", "\\\\\\$");
                excludeFilePattern.add(Pattern.compile(fileRegexPattern));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setExcludeList() {
        excludeFileTypeList = new ArrayList();
        excludeProcessList = new ArrayList();
        excludeUserList = new ArrayList();
        try {
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get("AUDExcludeFileFilter", (Row)null);
            Iterator iterator = dataObject.getRows("AUDExcludeFileFilter");
            while (iterator.hasNext()) {
                Row row = (Row)iterator.next();
                String excludeType = (String)row.get("EXCLUDE_TYPE");
                String value = (String)row.get("EXCLUDE_VALUE");
                if (excludeType.equalsIgnoreCase("File Type")) {
                    excludeFileTypeList.add(value);
                    continue;
                }
                if (excludeType.equalsIgnoreCase("Process Name")) {
                    excludeProcessList.add(value);
                    continue;
                }
                excludeUserList.add(value);
            }
            for (int i = 0; i < ignorableFileList.size(); ++i) {
                excludeFileTypeList.add(ignorableFileList.get(i));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void saveIgnorableFileTypes(ArrayList<String> ignorableFileList) {
        try {
            if (this.deleteIgnorableFileTypes()) {
                DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).constructDataObject();
                for (String string : ignorableFileList) {
                    Row row = new Row("AUDIgnorableFileFilter");
                    row.set("PATTERN", (Object)string);
                    dataObject.addRow(row);
                }
                CommonUtil.getPersistence(new boolean[0]).add(dataObject);
            }
            this.setIgnorableFileTypes();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private boolean deleteIgnorableFileTypes() {
        boolean flag = false;
        try {
            CommonUtil.getPersistenceLite().delete(new Criteria(Column.getColumn((String)"AUDIgnorableFileFilter", (String)"FILE_FILTER_ID"), null, 1));
            flag = true;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return flag;
    }

    public boolean isPatternMatches(String absoluteName) {
        boolean isPatternMatched = false;
        String fileAbsoluteName = absoluteName.toLowerCase();
        for (Pattern pattern : excludeFilePattern) {
            if (!pattern.matcher(fileAbsoluteName).matches()) continue;
            return true;
        }
        return isPatternMatched;
    }

    public void saveExcludeList(String excludeType, String excludeList) {
        ArrayList<String> ignorableList = new ArrayList<String>();
        ArrayList<String> ignorableListJava = new ArrayList<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(excludeList, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String fileType = stringTokenizer.nextToken().trim();
            if (excludeType.equals(keyName.get(0)) && !fileType.startsWith("*.")) {
                ignorableListJava.add(fileType);
                continue;
            }
            ignorableList.add(fileType);
        }
        if (excludeType.equals(keyName.get(0))) {
            this.saveIgnorableFileTypes(ignorableListJava);
        }
        try {
            if (this.deleteExcludeList(excludeType)) {
                DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).constructDataObject();
                for (String string : ignorableList) {
                    Row row = new Row("AUDExcludeFileFilter");
                    row.set("EXCLUDE_VALUE", (Object)string);
                    row.set("EXCLUDE_TYPE", (Object)excludeType);
                    dataObject.addRow(row);
                }
                CommonUtil.getPersistence(new boolean[0]).add(dataObject);
            }
            this.setExcludeList();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private boolean deleteExcludeList(String excludeType) {
        boolean flag = false;
        try {
            CommonUtil.getPersistenceLite().delete(new Criteria(Column.getColumn((String)"AUDExcludeFileFilter", (String)"EXCLUDE_TYPE"), (Object)excludeType, 0));
            flag = true;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return flag;
    }

    /*
     * Unable to fully structure code
     */
    public String[] getNativeFilterString(String domainName) {
        keyLength = ExcludeFilesHandler.keyName.size() + 1;
        filter = new String[keyLength];
        try {
            filter[0] = "";
            for (i = 0; i < keyLength - 1; ++i) {
                filter[0] = filter[0] + ExcludeFilesHandler.keyValue.get(i);
            }
            eventTypes = new Integer[]{2, 6, 8};
            col = Column.getColumn((String)"AUDEventID", (String)"EVENT_TYPE");
            criteria = new Criteria(col, (Object)eventTypes, 8);
            filterDO = CommonUtil.getPersistence(new boolean[0]).get("AUDEventID", criteria);
            iterator = filterDO.getRows("AUDEventID");
            while (iterator.hasNext()) {
                row = (Row)iterator.next();
                value = "[" + row.get("EVENT_NUMBER").toString() + "]";
                filter[0] = filter[0] + value;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
lbl21:
        // 4 sources

        try {
            for (i = 0; i < keyLength - 1; ++i) {
                block13: {
                    filter[i + 1] = ExcludeFilesHandler.keyValue.get(i);
                    if (i != 2) break block13;
                    col = Column.getColumn((String)"AUDExcludeFileFilter", (String)"EXCLUDE_TYPE");
                    criteria = new Criteria(col, (Object)ExcludeFilesHandler.keyName.get(i), 0);
                    criteria = criteria.and(Column.getColumn((String)"AUDExcludeFileFilter", (String)"DOMAIN_NAME"), (Object)domainName, 0);
                    filterDO = CommonUtil.getPersistence(new boolean[0]).get("AUDExcludeFileFilter", criteria);
                    iterator = filterDO.getRows("AUDExcludeFileFilter");
                    while (iterator.hasNext()) {
                        row = (Row)iterator.next();
                        guid = (String)row.get("EXCLUDE_VALUE");
                        row = DirectoryObjectAPI.getInstance().getObjectRow(domainName, guid, "user");
                        if (row == null) {
                            try {
                                cri = new Criteria(Column.getColumn((String)"AUDExcludeFileFilter", (String)"EXCLUDE_VALUE"), (Object)guid, 0);
                                cri = cri.and(new Criteria(Column.getColumn((String)"AUDExcludeFileFilter", (String)"DOMAIN_NAME"), (Object)domainName, 0));
                                CommonUtil.getPersistenceLite().delete(cri);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                            continue;
                        }
                        value = (String)row.get("LOGON_NAME");
                        if (!value.equals("-")) {
                            filter[i + 1] = filter[i + 1] + "[" + value + "]";
                        }
                        if ((value = (String)row.get("SAM_ACCOUNT_NAME")).equals("-")) continue;
                        filter[i + 1] = filter[i + 1] + "[" + value + "]";
                        value = (String)row.get("DOMAIN_NAME") + "\\" + (String)row.get("SAM_ACCOUNT_NAME");
                        filter[i + 1] = filter[i + 1] + "[" + value + "]";
                    }
                    ** GOTO lbl21
                }
                col = Column.getColumn((String)"AUDExcludeFileFilter", (String)"EXCLUDE_TYPE");
                criteria = new Criteria(col, (Object)ExcludeFilesHandler.keyName.get(i), 0);
                filterDO = CommonUtil.getPersistence(new boolean[0]).get("AUDExcludeFileFilter", criteria);
                iterator = filterDO.getRows("AUDExcludeFileFilter");
                while (iterator.hasNext()) {
                    row = (Row)iterator.next();
                    value = "[" + (String)row.get("EXCLUDE_VALUE") + "]";
                    filter[i + 1] = filter[i + 1] + value;
                }
                ** GOTO lbl21
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return filter;
    }

    public static void setUserList() {
        domainUserList = new HashMap();
        userInfo = new HashMap();
        domainList = new ArrayList();
        try {
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get("ADSMDomainConfiguration", (Row)null);
            Iterator iterator = dataObject.getRows("ADSMDomainConfiguration");
            while (iterator.hasNext()) {
                Row row = (Row)iterator.next();
                String name = (String)row.get("DOMAIN_NAME");
                domainList.add(name);
            }
            for (int i = 0; i < domainList.size(); ++i) {
                String defaultNamingContext = DomainDetailsAPI.getDefaultNamingContext(domainList.get(i));
                String searchStr = null;
                ArrayList rowsList = DirectoryObjectAPI.getInstance().getObjects(defaultNamingContext, "user", searchStr, -1, 0, 1L, 0L);
                ArrayList<String> guidList = new ArrayList<String>();
                for (Object object : rowsList) {
                    HashMap userDetails = (HashMap)object;
                    String name = (String)userDetails.get("NAME");
                    String guid = (String)userDetails.get("OBJECT_GUID");
                    guidList.add(guid);
                    userInfo.put(guid, name);
                }
                domainUserList.put(domainList.get(i), guidList);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void saveExcludeUserList(String excludeType, String excludeList, String domainName) {
        if (!excludeList.equals("undefined")) {
            ArrayList<String> ignorableList = new ArrayList<String>();
            StringTokenizer stringTokenizer = new StringTokenizer(excludeList, ",");
            while (stringTokenizer.hasMoreTokens()) {
                String fileType = stringTokenizer.nextToken().trim();
                ignorableList.add(fileType);
            }
            try {
                if (this.deleteExcludeUserList(domainName)) {
                    DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).constructDataObject();
                    for (String string : ignorableList) {
                        Row row = new Row("AUDExcludeFileFilter");
                        row.set("EXCLUDE_VALUE", (Object)string);
                        row.set("EXCLUDE_TYPE", (Object)excludeType);
                        row.set("DOMAIN_NAME", (Object)domainName);
                        dataObject.addRow(row);
                    }
                    CommonUtil.getPersistence(new boolean[0]).add(dataObject);
                }
                this.setExcludeList();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            this.deleteExcludeUserList(domainName);
            this.setExcludeList();
        }
    }

    private boolean deleteExcludeUserList(String domainName) {
        boolean flag = false;
        try {
            CommonUtil.getPersistenceLite().delete(new Criteria(Column.getColumn((String)"AUDExcludeFileFilter", (String)"DOMAIN_NAME"), (Object)domainName, 0));
            flag = true;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return flag;
    }

    public HashMap getFileExcludeMap(String domainName) {
        HashMap excludeMap = new HashMap();
        HashMap excludeOperators = new HashMap();
        HashMap resultMap = new HashMap();
        int eventIdSize = 0;
        int keyLength = keyName.size();
        ArrayList<String> ruleList = new ArrayList<String>();
        ArrayList<Integer> opList = new ArrayList<Integer>();
        ArrayList<Long> idList = new ArrayList<Long>();
        String EX_FILE_FILTER = "AUDExcludeFileFilter";
        try {
            int i;
            Integer[] eventTypes = new Integer[]{2, 6, 8};
            Column col = Column.getColumn((String)"AUDEventID", (String)"EVENT_TYPE");
            Criteria criteria = new Criteria(col, (Object)eventTypes, 8);
            DataObject filterDO = CommonUtil.getPersistence(new boolean[0]).get("AUDEventID", criteria);
            eventIdSize = filterDO.size("AUDEventID");
            Iterator iterator = filterDO.getRows("AUDEventID");
            for (i = 0; i < eventIdSize; ++i) {
                Row row = (Row)iterator.next();
                idList.add((Long)row.get("EVENT_NUMBER"));
            }
            for (i = 0; i < keyLength; ++i) {
                Row row;
                Iterator rowIterator;
                String key = keyValue.get(i);
                if (i == 2) {
                    Column col1 = Column.getColumn((String)"AUDExcludeFileFilter", (String)"EXCLUDE_TYPE");
                    Criteria criteria1 = new Criteria(col1, (Object)keyName.get(i), 0);
                    criteria1 = criteria1.and(Column.getColumn((String)"AUDExcludeFileFilter", (String)"DOMAIN_NAME"), (Object)domainName, 0);
                    DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get("AUDExcludeFileFilter", criteria1);
                    rowIterator = dataObject.getRows("AUDExcludeFileFilter");
                    while (rowIterator.hasNext()) {
                        row = (Row)rowIterator.next();
                        String guid = (String)row.get("EXCLUDE_VALUE");
                        row = DirectoryObjectAPI.getInstance().getObjectRow(domainName, guid, "user");
                        if (row == null) {
                            try {
                                Criteria cri = new Criteria(Column.getColumn((String)"AUDExcludeFileFilter", (String)"EXCLUDE_VALUE"), (Object)guid, 0);
                                cri = cri.and(new Criteria(Column.getColumn((String)"AUDExcludeFileFilter", (String)"DOMAIN_NAME"), (Object)domainName, 0));
                                CommonUtil.getPersistenceLite().delete(cri);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                            continue;
                        }
                        String value = (String)row.get("LOGON_NAME");
                        if (!value.equals("-")) {
                            ruleList.add(key + value);
                            opList.add(1);
                        }
                        if ((value = (String)row.get("SAM_ACCOUNT_NAME")).equals("-")) continue;
                        ruleList.add(key + value);
                        opList.add(1);
                        value = (String)row.get("DOMAIN_NAME") + "\\" + (String)row.get("SAM_ACCOUNT_NAME");
                        ruleList.add(key + value);
                        opList.add(1);
                    }
                    continue;
                }
                Column col2 = Column.getColumn((String)"AUDExcludeFileFilter", (String)"EXCLUDE_TYPE");
                Criteria criteria2 = new Criteria(col2, (Object)keyName.get(i), 0);
                DataObject excludeDO = CommonUtil.getPersistence(new boolean[0]).get("AUDExcludeFileFilter", criteria2);
                rowIterator = excludeDO.getRows("AUDExcludeFileFilter");
                while (rowIterator.hasNext()) {
                    row = (Row)rowIterator.next();
                    String value = (String)row.get("EXCLUDE_VALUE");
                    if (i == 0) {
                        value = value.substring(1);
                    }
                    ruleList.add(key + value);
                    opList.add(8);
                }
            }
            int columnLength = ruleList.size() + 1;
            for (int i2 = 0; i2 < eventIdSize; ++i2) {
                Integer key = ((Long)idList.get(i2)).intValue();
                excludeMap.put(key, ruleList);
                excludeOperators.put(key, opList);
            }
            resultMap.put("excludeMap", excludeMap);
            resultMap.put("excludeOperators", excludeOperators);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return resultMap;
    }

    public HashMap getGeneralExcludeMap(String domainName, int machineType, Integer[] machineTypes) {
        HashMap<Integer, ArrayList<String>> excludeMap = new HashMap<Integer, ArrayList<String>>();
        HashMap<Integer, ArrayList<Integer>> excludeOperators = new HashMap<Integer, ArrayList<Integer>>();
        HashMap<String, HashMap<Integer, ArrayList<Object>>> resultMap = new HashMap<String, HashMap<Integer, ArrayList<Object>>>();
        try {
            Criteria criteria = new Criteria(Column.getColumn((String)"AUDExcludeRules", (String)"MACHINE_TYPE"), (Object)machineTypes, 8);
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get("AUDExcludeRules", criteria);
            int size = dataObject.size("AUDExcludeRules");
            Iterator iterator = dataObject.getRows("AUDExcludeRules");
            for (int i = 0; i < size; ++i) {
                Row row = (Row)iterator.next();
                Integer eventNumber = (Integer)row.get("EVENT_NUMBER");
                String key = (String)row.get("VARIABLE_NAME");
                String value = (String)row.get("VALUE");
                Integer operator = (Integer)row.get("OPERATOR");
                String rule = "[" + RB.getString(key) + "]" + value;
                if ((machineType & 0x20000) == 131072 && eventNumber == 560 && key.equals("adap.AUDRuleVariables.variable_name.Object_Type")) continue;
                ArrayList<String> ruleList = (ArrayList<String>)excludeMap.get(eventNumber);
                if (ruleList == null) {
                    ruleList = new ArrayList<String>();
                }
                ruleList.add(rule);
                ArrayList<Integer> opList = (ArrayList<Integer>)excludeOperators.get(eventNumber);
                if (opList == null) {
                    opList = new ArrayList<Integer>();
                }
                opList.add(operator);
                excludeMap.put(eventNumber, ruleList);
                excludeOperators.put(eventNumber, opList);
            }
            resultMap.put("excludeMap", excludeMap);
            resultMap.put("excludeOperators", excludeOperators);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return resultMap;
    }

    public HashMap constructExcludeString(String domainName, int machineType) {
        HashMap fileExcludeMap = null;
        HashMap generalExcludeMap = null;
        boolean merge = Boolean.TRUE;
        Integer[] machineTypes = new Integer[]{1, 4, 16, 5, 17, 20, 21};
        if (machineType == 1) {
            machineTypes = new Integer[]{1, 17, 21};
            merge = Boolean.FALSE;
        } else if ((machineType & 1) == 1 && ((machineType & 4) == 4 || (machineType & 0x40) == 64)) {
            machineTypes = new Integer[]{4, 20, 21};
        } else if ((machineType & 0x10) == 16 && (machineType & 4) != 4 && (machineType & 0x40) != 64) {
            merge = Boolean.FALSE;
            machineTypes = new Integer[]{16, 17, 20, 21};
        } else if ((machineType & 0x10) == 16 && ((machineType & 4) == 4 || (machineType & 0x40) == 64)) {
            machineTypes = new Integer[]{4, 16, 17, 20, 21};
        } else if ((machineType & 0x10) != 16 && ((machineType & 4) == 4 || (machineType & 0x40) == 64)) {
            machineTypes = new Integer[]{4, 20, 21};
        } else if ((machineType & 0x100) == 256 || (machineType & 0x20000) == 131072) {
            machineTypes = new Integer[]{4, 20, 21};
        } else if ((machineType & 0x80000) == 524288) {
            machineTypes = new Integer[]{22};
        }
        EVENTLOGGER.log(Level.INFO, "Machine Type -> " + machineType + "\tMerge->" + merge);
        generalExcludeMap = this.getGeneralExcludeMap(domainName, machineType, machineTypes);
        HashMap excludeMap = (HashMap)generalExcludeMap.get("excludeMap");
        HashMap excludeOperators = (HashMap)generalExcludeMap.get("excludeOperators");
        if (merge) {
            fileExcludeMap = this.getFileExcludeMap(domainName);
            HashMap fExcludeMap = (HashMap)fileExcludeMap.get("excludeMap");
            HashMap fEcludeOperators = (HashMap)fileExcludeMap.get("excludeOperators");
            for (Integer key : fExcludeMap.keySet()) {
                if (excludeMap.get(key) == null) {
                    excludeMap.put(key, fExcludeMap.get(key));
                    excludeOperators.put(key, fEcludeOperators.get(key));
                    continue;
                }
                ArrayList ruleList = (ArrayList)excludeMap.get(key);
                ArrayList opList = (ArrayList)excludeOperators.get(key);
                ruleList.addAll((Collection)fExcludeMap.get(key));
                opList.addAll((Collection)fEcludeOperators.get(key));
                excludeMap.put(key, ruleList);
                excludeOperators.put(key, opList);
            }
        }
        int rowcount = excludeMap.size();
        String[][] excludeRules = new String[rowcount][];
        int[][] operatorList = new int[rowcount][];
        Iterator exMapIterator = excludeMap.entrySet().iterator();
        for (int i = 0; i < rowcount; ++i) {
            Map.Entry exMapEntry = exMapIterator.next();
            Integer eventNumber = (Integer)exMapEntry.getKey();
            ArrayList rules = (ArrayList)exMapEntry.getValue();
            ArrayList operators = (ArrayList)excludeOperators.get(eventNumber);
            int columnLen = rules.size() + 1;
            excludeRules[i] = new String[columnLen];
            operatorList[i] = new int[columnLen];
            operatorList[i][0] = eventNumber;
            excludeRules[i][0] = String.valueOf(columnLen);
            for (int j = 1; j < columnLen; ++j) {
                operatorList[i][j] = (Integer)operators.get(j - 1);
                excludeRules[i][j] = (String)rules.get(j - 1);
            }
        }
        generalExcludeMap.put("excludeMap", excludeRules);
        generalExcludeMap.put("excludeOperators", operatorList);
        return generalExcludeMap;
    }
}

