/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.ntfs;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.Range;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.SortColumn;
import com.adventnet.ds.query.Table;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.auditing.server.fileaudit.FileServerHandler;
import com.adventnet.sym.adsm.common.server.ADHandler;
import com.adventnet.sym.adsm.common.server.ntfs.ShareHandler;
import com.adventnet.sym.adsm.common.server.sql.QueryUtil;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.EscapeUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FileSystemAPI {
    private static FileSystemAPI api = null;
    private static Logger logger = Logger.getLogger("ReportLogger");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static FileSystemAPI getInstance() {
        if (api != null) return api;
        Class<FileSystemAPI> clazz = FileSystemAPI.class;
        synchronized (FileSystemAPI.class) {
            if (api != null) return api;
            api = new FileSystemAPI();
            // ** MonitorExit[var0] (shouldn't be in output)
            return api;
        }
    }

    private FileSystemAPI() {
    }

    public ArrayList getConfiguredFileServers(String domainName, String searchPattern, int startIndex, int numOfObjects) {
        ArrayList<Row> serverList = new ArrayList<Row>();
        try {
            DataObject dataObject;
            String tableName = "ADSMComputerGeneralDetails";
            Criteria criteria = new Criteria(Column.getColumn((String)tableName, (String)"DOMAIN_NAME"), (Object)domainName, 0);
            criteria = criteria.and(new Criteria(Column.getColumn((String)tableName, (String)"OPERATING_SYSTEM"), (Object)"Server", 12));
            if (searchPattern != null) {
                criteria = criteria.and(new Criteria(Column.getColumn((String)tableName, (String)"NAME"), (Object)searchPattern, 12));
            }
            if ((dataObject = CommonUtil.getPersistence(new boolean[0]).get(tableName, criteria)).isEmpty()) {
                // empty if block
            }
            Iterator iterator = dataObject.getRows(tableName);
            while (iterator.hasNext()) {
                Row serverRow = (Row)iterator.next();
                serverList.add(serverRow);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return serverList;
    }

    public ArrayList<Row> getSharesForServer(String domainName, String computerName, String refresh) {
        ArrayList<Row> shareList = new ArrayList<Row>();
        try {
            Criteria criteria = new Criteria(Column.getColumn((String)"ADSMShareGeneralDetails", (String)"HOST_COMPUTER"), (Object)computerName, 0);
            criteria.and(new Criteria(Column.getColumn((String)"ADSMShareGeneralDetails", (String)"DOMAIN_NAME"), (Object)domainName, 0));
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get("ADSMShareGeneralDetails", criteria);
            if (dataObject.isEmpty() || refresh.equals("true")) {
                Properties shareProperties = ADHandler.getSharesForServer(domainName, computerName);
                dataObject = ShareHandler.updateSharesForServer(domainName, shareProperties, computerName);
            }
            Iterator iterator = dataObject.getRows("ADSMShareGeneralDetails");
            while (iterator.hasNext()) {
                Row shareRow = (Row)iterator.next();
                shareList.add(shareRow);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return shareList;
    }

    public Hashtable<String, Object> getSharesForServer(HashMap params, HashMap shareMap, String searchString, Integer count) {
        Hashtable<String, Object> result = new Hashtable<String, Object>();
        ArrayList<Row> shareList = new ArrayList<Row>();
        String message = null;
        String shareAction = "";
        try {
            ArrayList<String> conShareList;
            boolean isSearch = false;
            SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)"ADSMShareGeneralDetails"));
            Column column = Column.getColumn((String)"ADSMShareGeneralDetails", (String)"*");
            query.addSelectColumn(column);
            Criteria criteria = new Criteria(Column.getColumn((String)"ADSMShareGeneralDetails", (String)"HOST_COMPUTER"), (Object)((String)shareMap.get("HOST_NAME")), 0);
            Criteria criteria3 = new Criteria(Column.getColumn((String)"ADSMShareGeneralDetails", (String)"DOMAIN_NAME"), (Object)((String)shareMap.get("DOMAIN_NAME")), 0);
            criteria = criteria.and(criteria3);
            if (searchString != null && !"".equalsIgnoreCase(searchString)) {
                Criteria criteria1 = new Criteria(Column.getColumn((String)"ADSMShareGeneralDetails", (String)"SHARE_NAME"), (Object)searchString, 12, false);
                criteria = criteria.and(criteria1);
                isSearch = true;
            }
            logger.log(Level.INFO, "SHARE_ACTION is:" + (String)shareMap.get("SHARE_ACTION"));
            if (((String)shareMap.get("SHARE_ACTION")).equalsIgnoreCase("ADD") && !(conShareList = FileServerHandler.getConfiguredShares((String)shareMap.get("HOST_NAME"), (String)shareMap.get("DOMAIN_NAME"))).isEmpty() && ((String)shareMap.get("SHARE_ACTION")).equalsIgnoreCase("ADD")) {
                Criteria criteria2 = new Criteria(Column.getColumn((String)"ADSMShareGeneralDetails", (String)"LOCATION"), (Object)conShareList.toArray(new String[conShareList.size()]), 9, false);
                criteria = criteria.and(criteria2);
                shareAction = "ADD";
            }
            query.setCriteria(criteria);
            if (params != null && !params.isEmpty()) {
                Integer fromIndex = (Integer)params.get("FROM_INDEX");
                Integer range = (Integer)params.get("RANGE");
                Integer innerTopVal = fromIndex - 1 + range;
                if (count > 0 && count < innerTopVal) {
                    range = count % range;
                }
                Range rangeObj = new Range(fromIndex.intValue(), range.intValue());
                query.setRange(rangeObj);
            }
            query.addSortColumn(new SortColumn(Column.getColumn((String)"ADSMShareGeneralDetails", (String)"SHARE_NAME"), true));
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)query);
            try {
                if (!isSearch && (dataObject.isEmpty() && !shareAction.equals("ADD") || ((String)shareMap.get("REFRESH")).equals("true"))) {
                    String domainName = (String)shareMap.get("DOMAIN_NAME");
                    Properties shareProperties = ADHandler.getSharesForServer(domainName, (String)shareMap.get("HOST_NAME"));
                    dataObject = ShareHandler.updateSharesForServer(domainName, shareProperties, (String)shareMap.get("HOST_NAME"));
                    dataObject = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)query);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                message = ex.getMessage();
            }
            Iterator iterator = dataObject.getRows("ADSMShareGeneralDetails");
            while (iterator.hasNext()) {
                Row shareRow = (Row)iterator.next();
                shareList.add(shareRow);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            message = e.getMessage();
        }
        if (message != null) {
            result.put("message", message);
        }
        result.put("Shares", shareList);
        return result;
    }

    public Hashtable<String, Object> getSharesForServerEmber(HashMap params, HashMap shareMap, String searchString, Integer count) {
        Hashtable<String, Object> result = new Hashtable<String, Object>();
        ArrayList shareList = new ArrayList();
        String message = null;
        String shareAction = "";
        String columnName = "LOCATION";
        String canonicalName = "LOCAL_PATH";
        String objectGuid = columnName;
        try {
            ArrayList<String> conShareList;
            boolean isSearch = false;
            SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)"ADSMShareGeneralDetails"));
            Column column = Column.getColumn((String)"ADSMShareGeneralDetails", (String)"*");
            query.addSelectColumn(column);
            Criteria criteria = new Criteria(Column.getColumn((String)"ADSMShareGeneralDetails", (String)"HOST_COMPUTER"), (Object)((String)shareMap.get("HOST_NAME")), 0);
            Criteria criteria3 = new Criteria(Column.getColumn((String)"ADSMShareGeneralDetails", (String)"DOMAIN_NAME"), (Object)((String)shareMap.get("DOMAIN_NAME")), 0);
            criteria = criteria.and(criteria3);
            if (searchString != null && !"".equalsIgnoreCase(searchString)) {
                Criteria criteria1 = new Criteria(Column.getColumn((String)"ADSMShareGeneralDetails", (String)"SHARE_NAME"), (Object)searchString, 12, false);
                criteria = criteria.and(criteria1);
                isSearch = true;
            }
            logger.log(Level.INFO, "SHARE_ACTION is:" + (String)shareMap.get("SHARE_ACTION"));
            if (((String)shareMap.get("SHARE_ACTION")).equalsIgnoreCase("addshare") && !(conShareList = FileServerHandler.getConfiguredShares((String)shareMap.get("HOST_NAME"), (String)shareMap.get("DOMAIN_NAME"))).isEmpty() && ((String)shareMap.get("SHARE_ACTION")).equalsIgnoreCase("addshare")) {
                Criteria criteria2 = new Criteria(Column.getColumn((String)"ADSMShareGeneralDetails", (String)"LOCATION"), (Object)conShareList.toArray(new String[conShareList.size()]), 9, false);
                criteria = criteria.and(criteria2);
                shareAction = "addshare";
            }
            query.setCriteria(criteria);
            if (params != null && !params.isEmpty()) {
                Integer fromIndex = (Integer)params.get("FROM_INDEX");
                Integer range = (Integer)params.get("RANGE");
                Integer innerTopVal = fromIndex - 1 + range;
                if (count > 0 && count < innerTopVal) {
                    range = count % range;
                }
                Range rangeObj = new Range(fromIndex.intValue(), range.intValue());
                query.setRange(rangeObj);
            }
            query.addSortColumn(new SortColumn(Column.getColumn((String)"ADSMShareGeneralDetails", (String)"SHARE_NAME"), true));
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)query);
            try {
                if (!isSearch && (dataObject.isEmpty() && !shareAction.equals("addshare") || ((String)shareMap.get("REFRESH")).equals("true"))) {
                    String domainName = (String)shareMap.get("DOMAIN_NAME");
                    Properties shareProperties = ADHandler.getSharesForServer(domainName, (String)shareMap.get("HOST_NAME"));
                    dataObject = ShareHandler.updateSharesForServer(domainName, shareProperties, (String)shareMap.get("HOST_NAME"));
                    dataObject = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)query);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                message = ex.getMessage();
            }
            Iterator iterator = dataObject.getRows("ADSMShareGeneralDetails");
            while (iterator.hasNext()) {
                Row shareRow = (Row)iterator.next();
                HashMap<String, String> valueMap = new HashMap<String, String>();
                valueMap.put("LOCATION", (String)shareRow.get(columnName));
                valueMap.put("LOCAL_PATH", (String)shareRow.get(canonicalName));
                valueMap.put("OBJECT_GUID", (String)shareRow.get(objectGuid));
                shareList.add(valueMap);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            message = e.getMessage();
        }
        if (message != null) {
            result.put("message", message);
        }
        result.put("fileShares", shareList);
        return result;
    }

    public Iterator getShareRows(String domainName, ArrayList selectedSharesList, String objClassName, String machineName) throws Exception {
        Iterator iterator = null;
        try {
            DataObject dataObj;
            System.out.println("***************Inside getShareRows of FileSystemAPI*****************");
            String[] shareNames = new String[selectedSharesList.size()];
            String dbName = CommonUtil.getDBServerName();
            for (int k = 0; k < selectedSharesList.size(); ++k) {
                String selectedShareName = (String)selectedSharesList.get(k);
                logger.log(Level.INFO, "selectedShareName in FileSystemAPI " + selectedShareName);
                if (dbName.equalsIgnoreCase("mssql")) {
                    selectedShareName = EscapeUtil.escSplCharsAsMSSQL(selectedShareName);
                }
                shareNames[k] = selectedShareName;
            }
            String tableName = "ADSMShareGeneralDetails";
            Criteria crit = new Criteria(Column.getColumn((String)tableName, (String)"HOST_COMPUTER"), (Object)machineName, 0);
            crit = crit.and(new Criteria(Column.getColumn((String)tableName, (String)"DOMAIN_NAME"), (Object)domainName, 0));
            if (!shareNames[0].equals("allObjects")) {
                crit = crit.and(new Criteria(Column.getColumn((String)tableName, (String)"SHARE_NAME"), (Object)shareNames, 8));
            }
            if (!(dataObj = CommonUtil.getPersistence(new boolean[0]).get(tableName, crit)).isEmpty()) {
                iterator = dataObj.getRows(tableName);
            }
            System.out.println("***************Leaving getShareRows of FileSystemAPI*****************");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return iterator;
    }

    public static int getSharesCount(String hostName) {
        String query = "SELECT COUNT(*) FROM ADSMShareGeneralDetails WHERE HOST_COMPUTER='" + hostName + "'";
        int count = QueryUtil.getRowsCount(query);
        return count;
    }

    public static int getSharesCount(HashMap params, String searchPattern) throws Exception {
        System.out.println("***************Inside getSharesCount*****************");
        if (FileSystemAPI.getSharesCount((String)params.get("HOST_NAME")) == 0) {
            String domainName = (String)params.get("DOMAIN_NAME");
            Properties shareProperties = ADHandler.getSharesForServer(domainName, (String)params.get("HOST_NAME"));
            ShareHandler.updateSharesForServer(domainName, shareProperties, (String)params.get("HOST_NAME"));
        }
        String query = "SELECT COUNT(*) FROM ADSMShareGeneralDetails WHERE HOST_COMPUTER=${hostName} AND SHARE_NAME LIKE '${SCRITERIA}'";
        int count = 0;
        try {
            query = searchPattern != null ? query.replace("${SCRITERIA}", searchPattern) : query.replace("AND SHARE_NAME LIKE '${SCRITERIA}'", "");
            query = query.replace("${hostName}", "'" + (String)params.get("HOST_NAME") + "'");
            System.out.println("Query is" + query);
            count = QueryUtil.getRowsCount(query);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        System.out.println("***************Leaving getSharesCount*****************");
        return count;
    }

    public static DataObject getShareDO(Object[] shareIds, String columnName) {
        DataObject dataObject = null;
        try {
            Criteria criteria = new Criteria(Column.getColumn((String)"ADSMShareGeneralDetails", (String)columnName), (Object)shareIds, 8);
            dataObject = CommonUtil.getPersistence(new boolean[0]).get("ADSMShareGeneralDetails", criteria);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return dataObject;
    }
}

