/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.ntfs;

import com.adventnet.sym.adsm.auditing.server.fileaudit.cluster.ClusterHandler;
import com.adventnet.sym.adsm.common.server.ntfs.FilesAndFolderListener;
import com.adventnet.sym.adsm.common.server.ntfs.NTFSTableUtil;
import com.adventnet.sym.adsm.common.server.objects.ObjectUpdateHandler;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.EscapeUtil;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FileUpdateTask
extends Thread {
    public static final Logger REPORT_LOGGER = Logger.getLogger("ReportLogger");
    private static volatile int workingThreadCount = 0;
    private static int maxThreadCount = 5;
    protected Properties shareProperties = null;
    private String domainName = null;
    private String serverName = null;
    private String tableName = null;
    private boolean isClusterCap = false;
    private ArrayList clusterNodes = null;

    public static synchronized void setWorkingThreadCount(int count) {
        workingThreadCount += count;
    }

    public FileUpdateTask(String domainName, String serverName, Properties shareProperties, boolean isSeperateThread, boolean clusterCap) {
        this.domainName = domainName;
        this.serverName = serverName;
        this.tableName = NTFSTableUtil.getTableName(null, serverName, domainName, "newType");
        this.shareProperties = shareProperties;
        this.isClusterCap = clusterCap;
        if (this.isClusterCap) {
            this.clusterNodes = ClusterHandler.getConfiguredClusterNodes(domainName, serverName);
        }
        if (isSeperateThread) {
            this.start();
        }
    }

    @Override
    public void run() {
        try {
            this.updateFiles();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateFiles() throws Exception {
        REPORT_LOGGER.log(Level.INFO, "Getting Files and Folders for Server [{0}] started.", new Object[]{this.serverName});
        REPORT_LOGGER.log(Level.INFO, "Creating table for Server [{0}].", new Object[]{this.serverName});
        REPORT_LOGGER.log(Level.INFO, "Share List for Server [{0}] started.", new Object[]{this.serverName});
        if (this.shareProperties != null && !this.shareProperties.isEmpty()) {
            Enumeration<Object> shares = this.shareProperties.keys();
            while (shares.hasMoreElements()) {
                String sharePath = (String)shares.nextElement();
                String shareLocalPath = this.shareProperties.getProperty(sharePath);
                if (CommonUtil.getDBServerName().equalsIgnoreCase("mssql")) {
                    sharePath = EscapeUtil.escSplCharsAsMSSQL(sharePath);
                }
                REPORT_LOGGER.log(Level.INFO, "Started getting Shares for [{0}]. The local path is [{1}].", new Object[]{sharePath, shareLocalPath});
                Properties properties = new Properties();
                properties.setProperty("sharePath", sharePath);
                properties.setProperty("shareLocalPath", shareLocalPath);
                properties.setProperty("tableName", this.tableName);
                properties.setProperty("serverName", this.serverName);
                properties.setProperty("domainName", this.domainName);
                properties.put("isClusterCap", (Object)this.isClusterCap);
                if (this.isClusterCap) {
                    properties.put("clusterNodes", this.clusterNodes);
                }
                FilesAndFolderListener listener = new FilesAndFolderListener(properties, this);
                FileUpdateTask fileUpdateTask = this;
                synchronized (fileUpdateTask) {
                    while (true) {
                        if (workingThreadCount < maxThreadCount) break;
                        Thread.sleep(300L);
                    }
                    FileUpdateTask.setWorkingThreadCount(1);
                }
                new ShareFileReadThread(this.domainName, sharePath, shareLocalPath, listener, "ShareFileReadThread").start();
            }
        }
    }

    static class ShareFileReadThread
    extends Thread {
        String domainName;
        String sharePath;
        String shareLocalPath;
        FilesAndFolderListener listener;
        FileUpdateTask fileUpdateTask;

        public ShareFileReadThread(String domainName, String sharePath, String shareLocalPath, FilesAndFolderListener listener, String threadName) {
            super(threadName);
            this.domainName = domainName;
            this.sharePath = sharePath;
            this.shareLocalPath = shareLocalPath;
            this.listener = listener;
            this.fileUpdateTask = this.fileUpdateTask;
        }

        @Override
        public void run() {
            ObjectUpdateHandler.runReport(this.domainName, this.listener, 810);
            REPORT_LOGGER.log(Level.INFO, "Is Listener Completed : " + this.listener.isListenerCompleted());
            while (!this.listener.isListenerCompleted()) {
                try {
                    REPORT_LOGGER.log(Level.INFO, "Waiting for Files and Folder Listener to complete ...");
                    Thread.sleep(1000L);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            REPORT_LOGGER.log(Level.INFO, "Finished getting Shares for [{0}]. The local path is [{1}].", new Object[]{this.sharePath, this.shareLocalPath});
            FileUpdateTask.setWorkingThreadCount(-1);
        }
    }
}

