/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.ntfs;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.auditing.server.util.EventDataUtil;
import com.adventnet.sym.adsm.common.server.ADHandler;
import com.adventnet.sym.adsm.common.server.model.NativeListener;
import com.adventnet.sym.adsm.common.server.ntfs.FileUpdateTask;
import com.adventnet.sym.adsm.common.server.ntfs.ProcessCreatedFiles;
import com.adventnet.sym.adsm.common.server.objects.ObjectListener;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.TimeUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FilesAndFolderListener
extends ObjectListener {
    private String sharePath = null;
    private String shareLocalPath = null;
    private String tableName = null;
    private long updateCount = 0L;
    private long lastFileCreatedTime = 0L;
    private long recentEventTime = 0L;
    private long maxFileTime = 0L;
    private String serverName = null;
    private static Logger reportLogger = Logger.getLogger("ReportLogger");
    private String domainName = null;
    private boolean isClusterCap = false;
    private ArrayList clusterNodes = null;

    public FilesAndFolderListener(Properties shareProperites, FileUpdateTask fileUpdateTask) {
        this.sharePath = shareProperites.getProperty("sharePath");
        this.shareLocalPath = shareProperites.getProperty("shareLocalPath");
        this.tableName = shareProperites.getProperty("tableName");
        this.serverName = shareProperites.getProperty("serverName");
        this.domainName = shareProperites.getProperty("domainName");
        this.isClusterCap = (Boolean)shareProperites.get("isClusterCap");
        long[] updateTimes = this.getUpdateCount(this.sharePath);
        this.updateCount = updateTimes[0];
        this.lastFileCreatedTime = updateTimes[1];
        try {
            if (this.isClusterCap) {
                this.clusterNodes = (ArrayList)shareProperites.get("clusterNodes");
                if (this.clusterNodes != null) {
                    for (int i = 0; i < this.clusterNodes.size(); ++i) {
                        long recentEventTimeNode;
                        Properties nodeProps = (Properties)this.clusterNodes.get(i);
                        String nodeName = (String)nodeProps.get("COMPUTER_NAME");
                        HashMap serverMap = EventDataUtil.getComputerProperties(this.domainName, nodeName);
                        if (serverMap == null || (recentEventTimeNode = ((Long)serverMap.get("RECENT_EVENT_TIME")).longValue()) <= this.recentEventTime) continue;
                        this.recentEventTime = recentEventTimeNode;
                    }
                }
            } else {
                HashMap serverMap = EventDataUtil.getComputerProperties(this.domainName, this.serverName);
                this.recentEventTime = (Long)serverMap.get("RECENT_EVENT_TIME");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        reportLogger.log(Level.INFO, "Started Getting Files for  server [{0}], share [{1}]: ", new Object[]{this.serverName, this.sharePath});
        reportLogger.log(Level.INFO, "FFL updateCount : " + this.updateCount);
        reportLogger.log(Level.INFO, "FFL recentEventTime : " + this.recentEventTime);
        reportLogger.log(Level.INFO, "FFL lastFileCreatedTime : " + this.lastFileCreatedTime);
    }

    @Override
    protected void checkAttributeList(ArrayList attributeList) {
    }

    @Override
    public void addRow(Properties prop) {
        try {
            String isFinished = (String)((ArrayList)prop.get("isCompleted")).get(0);
            if (isFinished.equalsIgnoreCase("false")) {
                long creationTime = Long.parseLong((String)((ArrayList)prop.get("Creation Time")).get(0));
                if (TimeUtil.getUnixTimeFromFileTime(creationTime) <= this.recentEventTime) {
                    prop.setProperty("serverName", this.serverName);
                    prop.setProperty("domainName", this.domainName);
                    prop.put("isClusterCap", (Object)this.isClusterCap);
                    if (this.isClusterCap) {
                        prop.put("clusterNodes", this.clusterNodes);
                    }
                    ProcessCreatedFiles.getInstance().addToQueue(prop);
                    if (creationTime > this.maxFileTime) {
                        this.maxFileTime = creationTime;
                    }
                }
            } else if (isFinished.equalsIgnoreCase("true")) {
                long maxFileTimeFirst = Long.parseLong((String)((ArrayList)prop.get("MaxFileTime")).get(0));
                long totalFilesCount = (Long)((ArrayList)prop.get("TotalFilesCount")).get(0);
                reportLogger.log(Level.INFO, "sharePath:" + this.sharePath);
                reportLogger.log(Level.INFO, "maxFiletime:" + this.maxFileTime);
                reportLogger.log(Level.INFO, "totalFilesCount:" + totalFilesCount);
                reportLogger.log(Level.INFO, "maxFileTimeFirst:" + maxFileTimeFirst);
                if (this.updateCount == 0L) {
                    this.maxFileTime = maxFileTimeFirst;
                } else if (this.maxFileTime == 0L && totalFilesCount > 0L) {
                    this.maxFileTime = TimeUtil.millisToFiletime(this.recentEventTime);
                }
                if (this.maxFileTime > 0L) {
                    this.updateRecentFileTime(this.sharePath, this.maxFileTime);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void updateRecentFileTime(String uncPath, long maxFiletime) {
        try {
            reportLogger.log(Level.INFO, "Updating Latest File Time" + maxFiletime);
            Criteria criteria = new Criteria(Column.getColumn((String)"AUDServerFolderSyncStatus", (String)"SHARE_NAME"), (Object)uncPath, 0);
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get("AUDServerFolderSyncStatus", criteria);
            Row row = dataObject.getRow("AUDServerFolderSyncStatus");
            long updateCount = (Long)row.get("UPDATE_COUNT");
            long existingMaxFileTime = (Long)row.get("LATEST_CREATED_FILE_TIME");
            if (maxFiletime > existingMaxFileTime) {
                row.set("LATEST_CREATED_FILE_TIME", (Object)maxFiletime);
                row.set("UPDATE_COUNT", (Object)(updateCount + 1L));
                dataObject.updateRow(row);
            }
            CommonUtil.getPersistence(new boolean[0]).update(dataObject);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public long[] getUpdateCount(String sharePath) {
        long updateCount = 0L;
        long lastFileCreatedTime = 0L;
        try {
            Criteria criteria = new Criteria(Column.getColumn((String)"AUDServerFolderSyncStatus", (String)"SHARE_NAME"), (Object)sharePath, 0);
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get("AUDServerFolderSyncStatus", criteria);
            if (!dataObject.isEmpty()) {
                Row row = dataObject.getRow("AUDServerFolderSyncStatus");
                updateCount = (Long)row.get("UPDATE_COUNT");
                lastFileCreatedTime = (Long)row.get("LATEST_CREATED_FILE_TIME");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        long[] updateTimes = new long[]{updateCount, lastFileCreatedTime};
        return updateTimes;
    }

    @Override
    protected void doAction(String domainName, Long loginId, String distinguishedName, ArrayList attributeList, NativeListener listener) throws Exception {
        attributeList.remove("objectSID");
        attributeList.remove("objectGUID");
        ADHandler.getFilesAndFolders(domainName, this.sharePath, this.shareLocalPath, this.lastFileCreatedTime, this.updateCount, loginId, attributeList, this);
    }
}

