/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.ntfs;

import com.adventnet.db.api.RelationalAPI;
import com.adventnet.db.persistence.metadata.ColumnDefinition;
import com.adventnet.db.persistence.metadata.PrimaryKeyDefinition;
import com.adventnet.db.persistence.metadata.TableDefinition;
import com.adventnet.db.persistence.metadata.UniqueValueGeneration;
import com.adventnet.db.persistence.metadata.util.MetaDataUtil;
import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.objects.ComputerHandler;
import com.adventnet.sym.adsm.common.server.sql.QueryUtil;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class NTFSTableUtil {
    private static Logger logger = Logger.getLogger("ReportLogger");
    public static String[] folderDetailscolumnNames = new String[]{"FILE_ID", "LOCATION", "LOCAL_PATH", "NAME", "TYPE", "CREATION_TIME", "LAST_ACCESS_TIME", "LAST_WRITE_TIME", "SIZE"};
    public static String[] folderDetailsNativeProp = new String[]{"uvhGenerator", "Location", "Local Path", "Name", "Type", "Creation Time", "Last Access Time", "Last Write Time", "Size"};
    private static String[] columnDescription = new String[]{"Surrogate unique key for each file server object", "Location for each folder", "Absolute Path of Folder or File", "Folder Name", "Type eg. File or Folder", "Creation time", "Last accessed time", "Modified time", "Size in bytes"};
    private static String[] columnDataType = new String[]{"BIGINT", "CHAR", "CHAR", "CHAR", "CHAR", "BIGINT", "BIGINT", "BIGINT", "BIGINT"};
    private static int[] columnDataMaxLength = new int[]{0, 1000, 1000, 255, 100, 0, 0, 0, 0};
    private static Object[] columnDefaultValues = new Object[]{null, null, null, "-", "-", 0, 0, 0, 0};

    public static void createServerTable(String serverTable) throws Exception {
        try {
            TableDefinition tableDef = MetaDataUtil.getTableDefinitionByName((String)serverTable);
            if (tableDef == null) {
                tableDef = new TableDefinition();
                tableDef.setTableName(serverTable);
                ColumnDefinition coldef = null;
                for (int i = 0; i < folderDetailscolumnNames.length; ++i) {
                    coldef = new ColumnDefinition();
                    coldef.setColumnName(folderDetailscolumnNames[i]);
                    coldef.setDescription(columnDescription[i]);
                    coldef.setDataType(columnDataType[i]);
                    if (columnDataMaxLength[i] > 0) {
                        coldef.setMaxLength(columnDataMaxLength[i]);
                    }
                    coldef.setNullable(false);
                    if (columnDefaultValues[i] != null) {
                        coldef.setDefaultValue(columnDefaultValues[i]);
                    }
                    if (i == 0) {
                        coldef.setUnique(false);
                        UniqueValueGeneration generator = new UniqueValueGeneration();
                        generator.setGeneratorName(serverTable + ".FILE_ID");
                        coldef.setUniqueValueGeneration(generator);
                    }
                    tableDef.addColumnDefinition(coldef);
                }
                PrimaryKeyDefinition pkDef = new PrimaryKeyDefinition();
                pkDef.setName(serverTable + "_PK");
                pkDef.addColumnName("FILE_ID");
                pkDef.setTableName(serverTable);
                tableDef.setPrimaryKey(pkDef);
                CommonUtil.getPersistence(new boolean[0]).createTable("adap", tableDef);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            String message = e.getMessage();
            System.out.println("Exception message :  " + message);
            throw new Exception(e);
        }
    }

    public static void dropTable(String computerName, String domainName) {
        String tableName = NTFSTableUtil.getTableName(null, computerName, domainName, "newType");
        try {
            logger.log(Level.INFO, "Dropping table " + tableName);
            CommonUtil.getPersistence(new boolean[0]).dropTable(tableName);
            logger.log(Level.INFO, "Successfully dropped table " + tableName);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String getTableName(String sid, String serverName, String domainName, String formatType) {
        String serverTable = null;
        try {
            if (sid == null || sid.length() == 0) {
                serverTable = serverName + "_" + domainName;
                if (serverTable.length() > 55) {
                    serverTable = serverTable.substring(0, 55);
                }
                serverTable = serverTable + "_SERVER";
                serverTable = CommonUtil.escapedTableName(serverTable);
                Row row = ComputerHandler.getComputerRow(domainName, serverName);
                if (row != null) {
                    sid = (String)row.get("SID_STRING");
                }
            }
            if (sid != null) {
                int index = sid.lastIndexOf("-");
                String rid = sid.substring(++index, sid.length());
                if (formatType != null && formatType.equalsIgnoreCase("oldType")) {
                    serverTable = rid + "_" + domainName + "_SERVER";
                    serverTable = CommonUtil.escapedTableName(serverTable);
                } else {
                    serverTable = domainName + "_" + rid + "_SERVER";
                    serverTable = CommonUtil.escapedTableName(serverTable);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return serverTable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void truncateServerTable(String serverTable) {
        RelationalAPI relAPI = null;
        Connection connection = null;
        Statement statement = null;
        try {
            logger.log(Level.INFO, "Truncating table " + serverTable);
            String truncateTableQuery = "TRUNCATE TABLE " + serverTable;
            relAPI = RelationalAPI.getInstance();
            connection = relAPI.getConnection();
            statement = connection.createStatement();
            int count = statement.executeUpdate(truncateTableQuery);
            logger.log(Level.INFO, "Successfully Truncate the  table " + serverTable + " with count --> " + count);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException se) {}
        }
    }

    public static void renameFileServerTable() {
        try {
            ArrayList tableNameList = NTFSTableUtil.getTableNameList();
            if (tableNameList != null) {
                ArrayList critTableNameList = new ArrayList();
                for (Object object : tableNameList) {
                    HashMap critTableNameMap = (HashMap)object;
                    critTableNameList.add(critTableNameMap.get("OldName"));
                }
                Criteria crit = new Criteria(Column.getColumn((String)"TableDetails", (String)"TABLE_NAME"), (Object)critTableNameList.toArray(), 8);
                DataObject tableDetailsDataObject = CommonUtil.getPersistence(new boolean[0]).get("TableDetails", crit);
                for (Object object : tableNameList) {
                    HashMap tableNameMap = (HashMap)object;
                    String oldTableName = (String)tableNameMap.get("OldName");
                    String newTableName = (String)tableNameMap.get("NewName");
                    NTFSTableUtil.renameTable(oldTableName, newTableName);
                    Criteria criteria = new Criteria(Column.getColumn((String)"TableDetails", (String)"TABLE_NAME"), (Object)oldTableName, 0);
                    Row row = tableDetailsDataObject.getRow("TableDetails", criteria);
                    if (row == null) continue;
                    row.set("TableDetails", (Object)newTableName);
                    row.set("DISPLAY_NAME", (Object)newTableName);
                    tableDetailsDataObject.updateRow(row);
                }
                CommonUtil.getPersistence(new boolean[0]).update(tableDetailsDataObject);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void renameTable(String oldTableName, String newTableName) {
        Connection connection = null;
        Statement statement = null;
        try {
            connection = RelationalAPI.getInstance().getConnection();
            statement = connection.createStatement();
            String alterTableQuery = "ALTER TABLE " + oldTableName + " RENAME " + newTableName;
            QueryUtil.executeUpdate("Renaming Table", statement, alterTableQuery);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException se) {
                se.printStackTrace();
            }
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException se) {
                se.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList getTableNameList() {
        ArrayList serverNameList = null;
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            connection = RelationalAPI.getInstance().getConnection();
            statement = connection.createStatement();
            String query = "SELECT ADSMComputerGeneralDetails.DOMAIN_NAME, ADSMComputerGeneralDetails.NAME, ADSMComputerGeneralDetails.OBJECT_GUID, ADSMComputerGeneralDetails.SID_STRING FROM AUDComputerEventRead JOIN ADSMComputerGeneralDetails ON AUDComputerEventRead.OBJECT_GUID = ADSMComputerGeneralDetails.OBJECT_GUID WHERE (AUDComputerEventRead.MACHINE_TYPE&4=4 OR AUDComputerEventRead.MACHINE_TYPE&8=8)";
            resultSet = QueryUtil.executeQuery("Getting Configured Servers", statement, query);
            if (resultSet != null) {
                serverNameList = new ArrayList();
                while (resultSet.next()) {
                    HashMap<String, String> tableNameMap = new HashMap<String, String>();
                    String sid = resultSet.getString("SID_STRING");
                    String name = resultSet.getString("NAME");
                    String domainName = resultSet.getString("DOMAIN_NAME");
                    String oldTableName = NTFSTableUtil.getTableName(sid, name, domainName, "oldType");
                    String newTableName = NTFSTableUtil.getTableName(sid, name, domainName, "newType");
                    tableNameMap.put("OldName", oldTableName);
                    tableNameMap.put("NewName", newTableName);
                    serverNameList.add(tableNameMap);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (SQLException se) {
                se.printStackTrace();
            }
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException se) {
                se.printStackTrace();
            }
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException se) {
                se.printStackTrace();
            }
        }
        return serverNameList;
    }
}

