/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.ntfs;

import com.adventnet.db.api.RelationalAPI;
import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.auditing.server.config.ServerConfigAPI;
import com.adventnet.sym.adsm.auditing.server.printAudit.PrintServerEnabled;
import com.adventnet.sym.adsm.auditing.server.printAudit.PrinterListenerThread;
import com.adventnet.sym.adsm.common.server.MSHandler;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.sql.ADAPSQLQueryUtil;
import com.adventnet.sym.adsm.common.server.sql.QueryUtil;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Logger;

public class PrintHandler {
    private static String[] printShareProps = new String[]{"PrinterName", "domainName", "PortName", "hComputer", "SharedName"};
    private static String[] sharePropColumns = new String[]{"PRINTER_NAME", "DOMAIN_NAME", "PORT_NAME", "HOST_COMPUTER", "IS_SHARED"};
    private static String[] sharePropDataType = new String[]{"String", "String", "String", "String", "Boolean"};
    public static final String SHARE_TABLE_NAME = "ADSMPrinterGeneralDetails";
    public static final String PRINTER_TABLE_NAME = "AudPrinterDetails";
    public static HashMap printServerStatusMap = new HashMap();
    private static AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle();
    public static HashMap<String, ArrayList<String>> printerNameList = new HashMap();
    private static Logger logger = Logger.getLogger(PrintHandler.class.getName());

    public static DataObject updateSharesForServer(String domainName, Properties shareProperties, String computerName) {
        DataObject shareDO = null;
        try {
            ArrayList<String> printerNameList = new ArrayList<String>();
            shareDO = CommonUtil.getPersistence(new boolean[0]).constructDataObject();
            if (shareProperties != null && !shareProperties.isEmpty() && PrintHandler.deleteTableRows("\\\\" + computerName, SHARE_TABLE_NAME, "HOST_COMPUTER")) {
                ArrayList shareList = (ArrayList)shareProperties.get("printers");
                for (Object object : shareList) {
                    Row shareRow = new Row(SHARE_TABLE_NAME);
                    Properties properties = (Properties)object;
                    for (int i = 0; i < printShareProps.length; ++i) {
                        ArrayList arrayList = (ArrayList)properties.get(printShareProps[i]);
                        if (arrayList == null || arrayList.isEmpty()) continue;
                        String shareProperty = (String)arrayList.get(0);
                        if (sharePropDataType[i].equalsIgnoreCase("Long")) {
                            shareRow.set(sharePropColumns[i], (Object)CommonUtil.getLong(shareProperty));
                            continue;
                        }
                        if (sharePropDataType[i].equalsIgnoreCase("Boolean")) {
                            shareRow.set(sharePropColumns[i], (Object)(shareProperty.length() > 0 ? 1 : 0));
                            continue;
                        }
                        if (sharePropColumns[i].equalsIgnoreCase("PRINTER_NAME")) {
                            printerNameList.add(shareProperty);
                        }
                        shareRow.set(sharePropColumns[i], (Object)shareProperty);
                    }
                    shareRow.set("DOMAIN_NAME", (Object)domainName);
                    shareDO.addRow(shareRow);
                }
                CommonUtil.getPersistence(new boolean[0]).add(shareDO);
                PrintHandler.updatePrinterTable(printerNameList, computerName);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return shareDO;
    }

    public static void updatePrinterTable(ArrayList printersList, String computerName) {
        try {
            Criteria criteria = new Criteria(Column.getColumn((String)PRINTER_TABLE_NAME, (String)"OBJECT_GUID"), (Object)PrintHandler.GetComputerName(computerName, "NAME", "OBJECT_GUID"), 0);
            criteria = criteria.and(new Criteria(Column.getColumn((String)PRINTER_TABLE_NAME, (String)"PRINTER_NAME"), (Object)printersList.toArray(), 9));
            CommonUtil.getPersistenceLite().delete(criteria);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static boolean deleteTableRows(String computerName, String tableName, String columnName) {
        boolean isDeleted = false;
        try {
            Criteria criteria = new Criteria(Column.getColumn((String)tableName, (String)columnName), (Object)computerName, 0);
            CommonUtil.getPersistenceLite().delete(criteria);
            isDeleted = true;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return isDeleted;
    }

    public static boolean deletePrintServer(String guidName) {
        boolean isDeleted = false;
        try {
            Criteria criteria = new Criteria(Column.getColumn((String)PRINTER_TABLE_NAME, (String)"OBJECT_GUID"), (Object)guidName, 0);
            CommonUtil.getPersistenceLite().delete(criteria);
            PrintHandler.interruptThread(PrintHandler.GetComputerName(guidName, "OBJECT_GUID", "NAME"));
            isDeleted = true;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return isDeleted;
    }

    public static boolean deleteConfiguredPrinters(List<String> printerList, String objectGuid, boolean start) {
        boolean isDeleted = false;
        try {
            String[] printerArray = printerList.toArray(new String[printerList.size()]);
            Criteria criteria = new Criteria(Column.getColumn((String)PRINTER_TABLE_NAME, (String)"PRINTER_NAME"), (Object)printerArray, 8);
            Criteria criteria2 = criteria.and(new Criteria(Column.getColumn((String)PRINTER_TABLE_NAME, (String)"OBJECT_GUID"), (Object)objectGuid, 0));
            CommonUtil.getPersistenceLite().delete(criteria2);
            String machineName = PrintHandler.GetComputerName(objectGuid, "OBJECT_GUID", "NAME");
            if (start) {
                PrintHandler.startThread(machineName, machineName, PrintHandler.GetComputerName(objectGuid, "OBJECT_GUID", "DOMAIN_NAME"), objectGuid);
            }
            isDeleted = true;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return isDeleted;
    }

    public static boolean startThread(String threadName, String machineName, String domainName, String guidName) {
        threadName = threadName.replace("\\\\", "");
        machineName = machineName.replace("\\\\", "");
        boolean available = false;
        try {
            for (Thread t : Thread.getAllStackTraces().keySet()) {
                if (!t.getName().equalsIgnoreCase(threadName)) continue;
                t.interrupt();
                PrintServerEnabled.getInstance();
                PrintServerEnabled.serverStatus.put(machineName, false);
                Thread.sleep(1000L);
            }
            new PrinterListenerThread(machineName, domainName, guidName);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        PrintServerEnabled.getInstance();
        PrintServerEnabled.serverStatus.put(machineName, true);
        return available;
    }

    public static boolean threadAvailable(String threadName) {
        boolean bl;
        PrintServerEnabled.getInstance();
        if (PrintServerEnabled.serverStatus.get(threadName) != null) {
            PrintServerEnabled.getInstance();
            bl = PrintServerEnabled.serverStatus.get(threadName);
        } else {
            bl = false;
        }
        return bl;
    }

    public static boolean interruptThread(String machineName) {
        machineName = machineName.replace("\\\\", "");
        boolean interrupted = false;
        try {
            for (Thread t : Thread.getAllStackTraces().keySet()) {
                if (!t.getName().equalsIgnoreCase(machineName) || t.isInterrupted()) continue;
                t.interrupt();
                interrupted = true;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        PrintServerEnabled.getInstance();
        PrintServerEnabled.serverStatus.put(machineName, false);
        return interrupted;
    }

    public static boolean addOrUpdatePrinters(HashMap selectedObjectsMap, String action, String domainName) {
        boolean isLicensed = false;
        try {
            String serverMapMessage;
            List SelectedObjectList = (List)selectedObjectsMap.get("selectedObjectsList");
            List SharedObjectList = (List)selectedObjectsMap.get("sharesList");
            List seletedPortList = (List)selectedObjectsMap.get("seletedPortList");
            String computerName = (String)selectedObjectsMap.get("hostName");
            String guidName = (String)selectedObjectsMap.get("guidName");
            Long time = System.currentTimeMillis();
            boolean proceed = true;
            HashMap<String, Object> updationVariables = new HashMap<String, Object>();
            if (action.equalsIgnoreCase("update") || action.equalsIgnoreCase("all")) {
                PrintHandler.interruptThread(computerName);
                proceed = PrintHandler.deleteTableRows((String)selectedObjectsMap.get("guidName"), PRINTER_TABLE_NAME, "OBJECT_GUID");
            }
            boolean availableThread = PrintHandler.threadAvailable(computerName) || action.equalsIgnoreCase("all");
            isLicensed = !action.equalsIgnoreCase("all") || PrintHandler.isLicensed(guidName);
            String string = serverMapMessage = printServerStatusMap.get(computerName) != null ? (String)printServerStatusMap.get(computerName) : null;
            if (proceed) {
                boolean startThread;
                boolean modifyThread;
                PrintHandler.deleteConfiguredPrinters(SelectedObjectList, guidName, false);
                DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).constructDataObject();
                for (int i = 0; i < SelectedObjectList.size() && !action.equalsIgnoreCase("modify"); ++i) {
                    Row row = new Row(PRINTER_TABLE_NAME);
                    row.set("PRINTER_NAME", (Object)((String)SelectedObjectList.get(i)));
                    row.set("OBJECT_GUID", (Object)guidName);
                    row.set("IS_SHARED", (Object)(((String)SharedObjectList.get(i)).length() > 0 ? 1 : 0));
                    row.set("PORT_NAME", (Object)((String)seletedPortList.get(i)));
                    row.set("IS_ENABLED", (Object)(isLicensed && availableThread ? 1 : 0));
                    row.set("MODIFIED_TIME", (Object)time);
                    if (serverMapMessage != null && !serverMapMessage.equalsIgnoreCase("success")) {
                        row.set("MESSAGE", (Object)serverMapMessage);
                    }
                    dataObject.addRow(row);
                }
                boolean bl = modifyThread = action.equalsIgnoreCase("modify") && isLicensed && availableThread;
                if (action.equalsIgnoreCase("modify")) {
                    PrintHandler.deleteConfiguredPrinters(SelectedObjectList, guidName, modifyThread);
                } else {
                    CommonUtil.getPersistence(new boolean[0]).add(dataObject);
                }
                if (printServerStatusMap.isEmpty()) {
                    PrintHandler.loadServerStatusMap();
                }
                serverMapMessage = printServerStatusMap.get(computerName) != null ? (String)printServerStatusMap.get(computerName) : null;
                updationVariables.put("MODIFIED_TIME", time);
                updationVariables.put("MESSAGE", serverMapMessage != null ? serverMapMessage : "SUCCESS");
                updationVariables.put("IS_ENABLED", isLicensed && availableThread);
                PrintHandler.updateModificationTime(guidName, updationVariables);
                boolean bl2 = startThread = !action.equalsIgnoreCase("modify") && isLicensed && availableThread;
                if (startThread && (serverMapMessage == null || !serverMapMessage.equalsIgnoreCase("disable"))) {
                    PrintHandler.startThread(computerName, computerName, domainName, guidName);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return isLicensed;
    }

    public static boolean updateModificationTime(String guidName, HashMap updationVariables) {
        boolean updated = false;
        try {
            Criteria criteria = new Criteria(Column.getColumn((String)PRINTER_TABLE_NAME, (String)"OBJECT_GUID"), (Object)guidName, 0);
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get(PRINTER_TABLE_NAME, criteria);
            Iterator iterator = dataObject.getRows(PRINTER_TABLE_NAME);
            while (iterator.hasNext()) {
                Row row = (Row)iterator.next();
                Set keySet = updationVariables.keySet();
                for (Object string : keySet) {
                    row.set((String)string, updationVariables.get(string));
                }
                dataObject.updateRow(row);
            }
            CommonUtil.getPersistence(new boolean[0]).update(dataObject);
            updated = true;
        }
        catch (Exception ex) {
            updated = false;
            ex.printStackTrace();
        }
        return updated;
    }

    public static int getConfiguredServerCount(String domainName, String searchCriteria) {
        int count = 0;
        try {
            StringBuilder queryBuilder = new StringBuilder("SELECT COUNT(*) FROM AudPrinterDetails JOIN ADSMComputerGeneralDetails ON AudPrinterDetails.OBJECT_GUID = ADSMComputerGeneralDetails.OBJECT_GUID WHERE  ADSMComputerGeneralDetails.DOMAIN_NAME='" + domainName + "'");
            if (searchCriteria != null) {
                queryBuilder.append(" AND ADSMComputerGeneralDetails.NAME like '%" + searchCriteria + "%'");
            }
            count = QueryUtil.getRowsCount(queryBuilder.toString());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return count;
    }

    public static boolean enableDiablePrintServers(boolean enableOrDiable, ArrayList objectGuidList, String domainName, HashMap guidComputerNameMap) {
        boolean success = false;
        HashMap<String, ArrayList<String>> guidComputerDomainMap = PrintHandler.getComputerDomainNameMap(objectGuidList);
        try {
            for (int i = 0; i < objectGuidList.size(); ++i) {
                String Objectguid = objectGuidList.get(i).toString();
                ArrayList<String> printerData = guidComputerDomainMap.get(Objectguid);
                Criteria criteria = new Criteria(Column.getColumn((String)PRINTER_TABLE_NAME, (String)"OBJECT_GUID"), null, 1);
                if (Objectguid != null) {
                    criteria = new Criteria(Column.getColumn((String)PRINTER_TABLE_NAME, (String)"OBJECT_GUID"), (Object)Objectguid, 0);
                    PrintHandler.interruptThread(printerData.get(0));
                }
                Long time = System.currentTimeMillis();
                if ((!enableOrDiable || !PrintHandler.isLicensed(Objectguid)) && enableOrDiable) continue;
                DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get(PRINTER_TABLE_NAME, criteria);
                Iterator iterator = dataObject.getRows(PRINTER_TABLE_NAME);
                while (iterator.hasNext()) {
                    Row row = (Row)iterator.next();
                    row.set("IS_ENABLED", (Object)enableOrDiable);
                    row.set("MODIFIED_TIME", (Object)time);
                    PrintHandler.interruptThread(printerData.get(0));
                    dataObject.updateRow(row);
                }
                if (enableOrDiable) {
                    String domainNameForPrinter = domainName == null ? printerData.get(1) : domainName;
                    PrintHandler.startThread(printerData.get(0), printerData.get(0), domainNameForPrinter, Objectguid);
                    printServerStatusMap.put(printerData.get(0), "success");
                } else {
                    printServerStatusMap.put(printerData.get(0), "diable");
                }
                CommonUtil.getPersistence(new boolean[0]).update(dataObject);
                success = true;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return success;
    }

    public static String GetComputerName(String objectGuid, String searchColumn, String receiveColumn) {
        String computerName = "";
        try {
            Criteria criteria = new Criteria(Column.getColumn((String)"ADSMComputerGeneralDetails", (String)searchColumn), (Object)objectGuid, 0);
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get("ADSMComputerGeneralDetails", criteria);
            Row row = dataObject.getFirstRow("ADSMComputerGeneralDetails");
            computerName = (String)row.get(receiveColumn);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return computerName;
    }

    public static HashMap<String, ArrayList<String>> getComputerDomainNameMap(ArrayList<String> objectGuidList) {
        HashMap<String, ArrayList<String>> guidComputerDomainName = new HashMap<String, ArrayList<String>>();
        try {
            Criteria criteria = null;
            criteria = objectGuidList == null || objectGuidList.isEmpty() ? new Criteria(Column.getColumn((String)"ADSMComputerGeneralDetails", (String)"OBJECT_GUID"), null, 1) : new Criteria(Column.getColumn((String)"ADSMComputerGeneralDetails", (String)"OBJECT_GUID"), (Object)objectGuidList.toArray(), 8);
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get("ADSMComputerGeneralDetails", criteria);
            Iterator iterator = dataObject.getRows("ADSMComputerGeneralDetails");
            while (iterator.hasNext()) {
                Row row = (Row)iterator.next();
                ArrayList<String> dataList = new ArrayList<String>();
                dataList.add((String)row.get("NAME"));
                dataList.add((String)row.get("DOMAIN_NAME"));
                guidComputerDomainName.put((String)row.get("OBJECT_GUID"), dataList);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return guidComputerDomainName;
    }

    public static int getPrintersCount(String computerName) {
        int printersCount = 0;
        try {
            Criteria criteria = new Criteria(Column.getColumn((String)SHARE_TABLE_NAME, (String)"HOST_COMPUTER"), (Object)("*" + computerName + "*"), 2);
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get(SHARE_TABLE_NAME, criteria);
            printersCount = dataObject.size(SHARE_TABLE_NAME);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return printersCount;
    }

    public static ArrayList<String> getPrinters(String objectGuid) {
        ArrayList<String> printerList = new ArrayList<String>();
        try {
            Criteria criteria = new Criteria(Column.getColumn((String)PRINTER_TABLE_NAME, (String)"OBJECT_GUID"), (Object)objectGuid, 0);
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get(PRINTER_TABLE_NAME, criteria);
            Iterator iterator = dataObject.getRows(PRINTER_TABLE_NAME);
            while (iterator.hasNext()) {
                Row row = (Row)iterator.next();
                printerList.add(PrintHandler.htmlEscape((String)row.get("PRINTER_NAME")));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return printerList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList getConfiguredServers(String domainName, HashMap addnParamsMap) {
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        ArrayList<Properties> serverList = new ArrayList<Properties>();
        try {
            String searchValue;
            StringBuilder queryBuilder = new StringBuilder();
            String dbServerName = CommonUtil.getDBServerName();
            String string = searchValue = addnParamsMap.get("searchString") != null ? (String)addnParamsMap.get("searchString") : null;
            if (dbServerName.equalsIgnoreCase("mssql") && addnParamsMap != null && !addnParamsMap.isEmpty()) {
                queryBuilder.append("SELECT TOP " + ((Integer)addnParamsMap.get("noOfObjects")).toString());
            } else {
                queryBuilder.append("SELECT ");
            }
            queryBuilder.append("ADSMComputerGeneralDetails.OBJECT_GUID,ADSMComputerGeneralDetails.NAME,AudPrinterDetails.IS_ENABLED,AudPrinterDetails.MESSAGE,AudPrinterDetails.MODIFIED_TIME FROM AudPrinterDetails JOIN ADSMComputerGeneralDetails ON AudPrinterDetails.OBJECT_GUID = ADSMComputerGeneralDetails.OBJECT_GUID ");
            if (domainName != null) {
                queryBuilder.append("WHERE  ADSMComputerGeneralDetails.DOMAIN_NAME='" + domainName + "'");
            }
            if (searchValue != null) {
                queryBuilder.append(" AND  ADSMComputerGeneralDetails.NAME like '%" + searchValue + "%'");
            }
            queryBuilder.append(" GROUP BY ADSMComputerGeneralDetails.OBJECT_GUID,ADSMComputerGeneralDetails.NAME,AudPrinterDetails.IS_ENABLED,AudPrinterDetails.MESSAGE,AudPrinterDetails.MODIFIED_TIME");
            if (!dbServerName.equalsIgnoreCase("mssql") && addnParamsMap != null && !addnParamsMap.isEmpty()) {
                queryBuilder.append(" ORDER BY ");
                queryBuilder.append((String)addnParamsMap.get("sortTableName"));
                queryBuilder.append(".");
                queryBuilder.append((String)addnParamsMap.get("sortColumn"));
                queryBuilder.append(" ");
                queryBuilder.append((String)addnParamsMap.get("sortOrder"));
                int startIndex = (Integer)addnParamsMap.get("startIndex");
                String orderBy = ADAPSQLQueryUtil.getLimitValue(startIndex, (Integer)addnParamsMap.get("noOfObjects"));
                queryBuilder.append(orderBy);
            } else if (CommonUtil.getDBServerName().equalsIgnoreCase("mssql") && addnParamsMap != null && !addnParamsMap.isEmpty()) {
                String query = ServerConfigAPI.buildMssqlQuery(queryBuilder.toString(), addnParamsMap, (Integer)addnParamsMap.get("count"));
                queryBuilder = new StringBuilder();
                queryBuilder.append(query);
            }
            connection = RelationalAPI.getInstance().getConnection();
            statement = connection.createStatement();
            String query = queryBuilder.toString();
            resultSet = QueryUtil.executeQuery("Getting Configured Servers", statement, query);
            while (resultSet.next()) {
                Properties msProps = new Properties();
                msProps.put("COMPUTER_NAME", resultSet.getString("NAME"));
                msProps.put("NAME", resultSet.getString("NAME"));
                msProps.put("ENABLED", (Object)resultSet.getBoolean("IS_ENABLED"));
                msProps.put("OBJECT_GUID", resultSet.getString("OBJECT_GUID"));
                msProps.put("PRINTERS_TOTAL_COUNT", (Object)PrintHandler.getPrintersCount(resultSet.getString("NAME")));
                msProps.put("LISTENING", (Object)PrintHandler.threadAvailable(resultSet.getString("NAME")));
                msProps.put("MESSAGE", resultSet.getString("MESSAGE") != null ? resultSet.getString("MESSAGE") : null);
                msProps.put("MODIFIED_TIME", resultSet.getString("MODIFIED_TIME"));
                serverList.add(msProps);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (SQLException se) {
                se.printStackTrace();
            }
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException se) {
                se.printStackTrace();
            }
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException se) {
                se.printStackTrace();
            }
        }
        return serverList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList getRows(Long uniqueId) {
        ArrayList<Properties> serverList = new ArrayList<Properties>();
        StringBuilder queryBuilder = new StringBuilder();
        String dbServerName = CommonUtil.getDBServerName();
        queryBuilder.append("SELECT * from AUDPrintJObsINqueue where UNIQUE_ID=" + uniqueId);
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            connection = RelationalAPI.getInstance().getConnection();
            statement = connection.createStatement();
            String query = queryBuilder.toString();
            resultSet = QueryUtil.executeQuery("Getting Configured Servers", statement, query);
            String[] columnNames = new String[]{"PRINTER_NAME", "FILE_NAME", "PAGES", "DOC_SIZE", "MACHINE_NAME", "USERNAME", "SERVERNAME", "COPIES"};
            while (resultSet.next()) {
                Properties msProps = new Properties();
                for (int i = 0; i < columnNames.length; ++i) {
                    msProps.put(columnNames[i], resultSet.getString(columnNames[i]));
                }
                serverList.add(msProps);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (SQLException se) {
                se.printStackTrace();
            }
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException se) {
                se.printStackTrace();
            }
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException se) {
                se.printStackTrace();
            }
        }
        return serverList;
    }

    private static boolean isLicensed(String guid) {
        try {
            if (guid == null) {
                return false;
            }
            if (ServerConfigAPI.isConfiguredSyncedDevice(guid)) {
                logger.info("Requted to configure Synced device : granting permission blindly");
                return true;
            }
            if (ServerConfigAPI.isConfiguredPrintServer(guid)) {
                return true;
            }
            int memberServersCount = ServerConfigAPI.getConfiguredServerCount(new int[]{16});
            memberServersCount += ServerConfigAPI.getPrintServerCount();
            memberServersCount -= ServerConfigAPI.getPrintMemberServerCount(16);
            int n = memberServersCount = ServerConfigAPI.isEnableddMemberServer(guid) ? memberServersCount : ++memberServersCount;
            if (memberServersCount <= MSHandler.getLicenseCount(new Integer(16))) {
                return true;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return false;
    }

    private static void loadServerStatusMap() {
        try {
            Criteria criteria = new Criteria(Column.getColumn((String)PRINTER_TABLE_NAME, (String)"OBJECT_GUID"), null, 1);
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get(PRINTER_TABLE_NAME, criteria);
            Iterator iterator = dataObject.getRows(PRINTER_TABLE_NAME);
            while (iterator.hasNext()) {
                Row row = (Row)iterator.next();
                printServerStatusMap.put(PrintHandler.GetComputerName((String)row.get("OBJECT_GUID"), "OBJECT_GUID", "NAME"), row.get("MESSAGE"));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static String htmlEscape(String str) {
        if (str == null) {
            return null;
        }
        String[] vals = new String[]{"&", ">", "<", "\""};
        String[] chars = new String[]{"&amp;", "&gt;", "&lt;", "&quot;"};
        for (int i = 0; i < chars.length; ++i) {
            String s = chars[i];
            if (str == null || !str.contains(s)) continue;
            str = str.replaceAll(s, vals[i]);
        }
        return str;
    }

    public static String escapeRevert(String str) {
        if (str == null) {
            return null;
        }
        String[] chars = new String[]{"&", ">", "<", "\""};
        String[] vals = new String[]{"&amp;", "&gt;", "&lt;", "&quot;"};
        for (int i = 0; i < vals.length; ++i) {
            String s = vals[i];
            if (str == null || !str.contains(s)) continue;
            str = str.replaceAll(s, chars[i]);
        }
        return str;
    }

    public static boolean addOrUpdatePrintersEmber(HashMap selectedObjectsMap, String action, String domainName) {
        boolean isLicensed = false;
        try {
            String serverMapMessage;
            List SelectedObjectList = (List)selectedObjectsMap.get("selectedObjectsList");
            List seletedPortList = (List)selectedObjectsMap.get("seletedPortList");
            String computerName = (String)selectedObjectsMap.get("hostName");
            String guidName = (String)selectedObjectsMap.get("guidName");
            Long time = System.currentTimeMillis();
            boolean proceed = true;
            HashMap<String, Object> updationVariables = new HashMap<String, Object>();
            if (action.equalsIgnoreCase("update") || action.equalsIgnoreCase("all")) {
                PrintHandler.interruptThread(computerName);
                proceed = PrintHandler.deleteTableRows((String)selectedObjectsMap.get("guidName"), PRINTER_TABLE_NAME, "OBJECT_GUID");
            }
            boolean availableThread = PrintHandler.threadAvailable(computerName) || action.equalsIgnoreCase("all");
            isLicensed = !action.equalsIgnoreCase("all") || PrintHandler.isLicensed(guidName);
            String string = serverMapMessage = printServerStatusMap.get(computerName) != null ? (String)printServerStatusMap.get(computerName) : null;
            if (proceed) {
                boolean startThread;
                boolean modifyThread;
                PrintHandler.deleteConfiguredPrinters(SelectedObjectList, guidName, false);
                DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).constructDataObject();
                for (int i = 0; i < SelectedObjectList.size() && !action.equalsIgnoreCase("modify"); ++i) {
                    Row row = new Row(PRINTER_TABLE_NAME);
                    row.set("PRINTER_NAME", (Object)((String)SelectedObjectList.get(i)));
                    row.set("OBJECT_GUID", (Object)guidName);
                    row.set("IS_SHARED", (Object)true);
                    row.set("PORT_NAME", (Object)((String)seletedPortList.get(i)));
                    row.set("IS_ENABLED", (Object)(isLicensed && availableThread ? 1 : 0));
                    row.set("MODIFIED_TIME", (Object)time);
                    if (serverMapMessage != null && !serverMapMessage.equalsIgnoreCase("success")) {
                        row.set("MESSAGE", (Object)serverMapMessage);
                    }
                    dataObject.addRow(row);
                }
                boolean bl = modifyThread = action.equalsIgnoreCase("modify") && isLicensed && availableThread;
                if (action.equalsIgnoreCase("modify")) {
                    PrintHandler.deleteConfiguredPrinters(SelectedObjectList, guidName, modifyThread);
                } else {
                    CommonUtil.getPersistence(new boolean[0]).add(dataObject);
                }
                if (printServerStatusMap.isEmpty()) {
                    PrintHandler.loadServerStatusMap();
                }
                serverMapMessage = printServerStatusMap.get(computerName) != null ? (String)printServerStatusMap.get(computerName) : null;
                updationVariables.put("MODIFIED_TIME", time);
                updationVariables.put("MESSAGE", serverMapMessage != null ? serverMapMessage : "SUCCESS");
                updationVariables.put("IS_ENABLED", isLicensed && availableThread);
                PrintHandler.updateModificationTime(guidName, updationVariables);
                boolean bl2 = startThread = !action.equalsIgnoreCase("modify") && isLicensed && availableThread;
                if (startThread && (serverMapMessage == null || !serverMapMessage.equalsIgnoreCase("disable"))) {
                    PrintHandler.startThread(computerName, computerName, domainName, guidName);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return isLicensed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList<Properties> getConfiguredServersEmber(String domainName, HashMap addnParamsMap) {
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        ArrayList<Properties> serverList = new ArrayList<Properties>();
        try {
            String searchValue;
            StringBuilder queryBuilder = new StringBuilder();
            String dbServerName = CommonUtil.getDBServerName();
            String string = searchValue = addnParamsMap.get("searchString") != null ? (String)addnParamsMap.get("searchString") : null;
            if (dbServerName.equalsIgnoreCase("mssql") && addnParamsMap != null && !addnParamsMap.isEmpty()) {
                queryBuilder.append("SELECT TOP " + ((Integer)addnParamsMap.get("noOfObjects")).toString());
            } else {
                queryBuilder.append("SELECT ");
            }
            queryBuilder.append("ADSMComputerGeneralDetails.OBJECT_GUID,ADSMComputerGeneralDetails.NAME,AudPrinterDetails.IS_ENABLED,AudPrinterDetails.MESSAGE,AudPrinterDetails.MODIFIED_TIME FROM AudPrinterDetails JOIN ADSMComputerGeneralDetails ON AudPrinterDetails.OBJECT_GUID = ADSMComputerGeneralDetails.OBJECT_GUID ");
            if (domainName != null) {
                queryBuilder.append("WHERE  ADSMComputerGeneralDetails.DOMAIN_NAME='" + domainName + "'");
            }
            if (searchValue != null) {
                queryBuilder.append(" AND  ADSMComputerGeneralDetails.NAME like '%" + searchValue + "%'");
            }
            queryBuilder.append(" GROUP BY ADSMComputerGeneralDetails.OBJECT_GUID,ADSMComputerGeneralDetails.NAME,AudPrinterDetails.IS_ENABLED,AudPrinterDetails.MESSAGE,AudPrinterDetails.MODIFIED_TIME");
            if (!dbServerName.equalsIgnoreCase("mssql") && addnParamsMap != null && !addnParamsMap.isEmpty()) {
                queryBuilder.append(" ORDER BY ");
                queryBuilder.append((String)addnParamsMap.get("sortTableName"));
                queryBuilder.append(".");
                queryBuilder.append((String)addnParamsMap.get("sortColumn"));
                queryBuilder.append(" ");
                queryBuilder.append((String)addnParamsMap.get("sortOrder"));
                int startIndex = (Integer)addnParamsMap.get("startIndex");
                String orderBy = ADAPSQLQueryUtil.getLimitValue(startIndex, (Integer)addnParamsMap.get("noOfObjects"));
                queryBuilder.append(orderBy);
            } else if (CommonUtil.getDBServerName().equalsIgnoreCase("mssql") && addnParamsMap != null && !addnParamsMap.isEmpty()) {
                String query = ServerConfigAPI.buildMssqlQuery(queryBuilder.toString(), addnParamsMap, (Integer)addnParamsMap.get("count"));
                queryBuilder = new StringBuilder();
                queryBuilder.append(query);
            }
            connection = RelationalAPI.getInstance().getConnection();
            statement = connection.createStatement();
            String query = queryBuilder.toString();
            resultSet = QueryUtil.executeQuery("Getting Configured Servers", statement, query);
            while (resultSet.next()) {
                Properties msProps = new Properties();
                msProps.put("COMPUTER_NAME", resultSet.getString("NAME"));
                msProps.put("ENABLED", (Object)resultSet.getBoolean("IS_ENABLED"));
                msProps.put("NAME", resultSet.getString("NAME"));
                msProps.put("IS_ENABLED", (Object)resultSet.getBoolean("IS_ENABLED"));
                msProps.put("OBJECT_GUID", resultSet.getString("OBJECT_GUID"));
                ArrayList<String> printerList = PrintHandler.getPrinters(resultSet.getString("OBJECT_GUID"));
                msProps.put("PRINTERS_TOTAL_COUNT", printerList.size() + " " + rb.getString("adap.common.Printer_Out_Of") + " " + PrintHandler.getPrintersCount(resultSet.getString("NAME")));
                msProps.put("PRINTERS_TOTAL_COUNT1", (Object)PrintHandler.getPrintersCount(resultSet.getString("NAME")));
                msProps.put("LISTENING", (Object)PrintHandler.threadAvailable(resultSet.getString("NAME")));
                msProps.put("MESSAGE", resultSet.getString("MESSAGE") != null ? resultSet.getString("MESSAGE") : null);
                String message = (String)msProps.get("MESSAGE");
                Boolean listening = (Boolean)msProps.get("LISTENING");
                boolean enabled = (Boolean)msProps.get("ENABLED");
                if (listening.booleanValue()) {
                    msProps.put("MESSAGE", rb.getString("adap.common.text.status_msg.running"));
                } else if (enabled) {
                    if (message.equalsIgnoreCase("success")) {
                        message = rb.getString("adap.common.printer.UnableServer");
                        msProps.put("MESSAGE", message);
                    }
                } else {
                    msProps.put("MESSAGE", rb.getString("adap.common.text.filter_link.disabled"));
                }
                msProps.put("MODIFIED_TIME", resultSet.getString("MODIFIED_TIME"));
                serverList.add(msProps);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (SQLException se) {
                se.printStackTrace();
            }
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException se) {
                se.printStackTrace();
            }
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException se) {
                se.printStackTrace();
            }
        }
        return serverList;
    }
}

