/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.ntfs;

import com.adventnet.db.api.RelationalAPI;
import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.Range;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.SortColumn;
import com.adventnet.ds.query.Table;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.ADHandler;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.ntfs.PrintHandler;
import com.adventnet.sym.adsm.common.server.sql.QueryUtil;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.EscapeUtil;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PrintSystemAPI {
    private static PrintSystemAPI api = null;
    private static AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle();
    private static Logger logger = Logger.getLogger("ReportLogger");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PrintSystemAPI getInstance() {
        Class<PrintSystemAPI> clazz = PrintSystemAPI.class;
        synchronized (PrintSystemAPI.class) {
            if (api == null) {
                api = new PrintSystemAPI();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return api;
        }
    }

    private PrintSystemAPI() {
    }

    public ArrayList<Row> getPrinterNames(String domainName, String computerName, String refresh) {
        ArrayList shareList = new ArrayList();
        try {
            Properties shareProperties = ADHandler.GetPrinterNames(domainName, computerName);
            if (shareProperties != null && !shareProperties.isEmpty()) {
                shareList = (ArrayList)shareProperties.get("printers");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return shareList;
    }

    public Hashtable<String, Object> getSharesForServer(HashMap params, HashMap shareMap, String searchString, Integer count) {
        Hashtable<String, Object> result = new Hashtable<String, Object>();
        ArrayList<Row> shareList = new ArrayList<Row>();
        String message = null;
        String errorCode = "";
        String shareAction = "";
        try {
            ArrayList<String> conShareList;
            boolean isSearch = false;
            SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)"ADSMPrinterGeneralDetails"));
            Column column = Column.getColumn((String)"ADSMPrinterGeneralDetails", (String)"*");
            query.addSelectColumn(column);
            Criteria criteria = new Criteria(Column.getColumn((String)"ADSMPrinterGeneralDetails", (String)"HOST_COMPUTER"), (Object)("\\\\" + (String)shareMap.get("HOST_NAME")), 0);
            if (searchString != null && !"".equalsIgnoreCase(searchString)) {
                Criteria criteria1 = new Criteria(Column.getColumn((String)"ADSMPrinterGeneralDetails", (String)"PRINTER_NAME"), (Object)searchString, 12);
                criteria = criteria.and(criteria1);
                isSearch = true;
            }
            logger.log(Level.INFO, "SHARE_ACTION is:" + (String)shareMap.get("SHARE_ACTION"));
            if ((((String)shareMap.get("SHARE_ACTION")).equalsIgnoreCase("ADD") || ((String)shareMap.get("SHARE_ACTION")).equalsIgnoreCase("MODIFY")) && !(conShareList = PrintHandler.getPrinters((String)shareMap.get("HOST_GUID"))).isEmpty()) {
                Criteria criteria2 = new Criteria(Column.getColumn((String)"ADSMPrinterGeneralDetails", (String)"PRINTER_NAME"), (Object)conShareList.toArray(new String[conShareList.size()]), ((String)shareMap.get("SHARE_ACTION")).equalsIgnoreCase("ADD") ? 9 : 8, false);
                criteria = criteria.and(criteria2);
                shareAction = (String)shareMap.get("SHARE_ACTION");
            }
            query.setCriteria(criteria);
            if (params != null && !params.isEmpty()) {
                Integer fromIndex = (Integer)params.get("FROM_INDEX");
                Integer range = (Integer)params.get("RANGE");
                Integer innerTopVal = fromIndex - 1 + range;
                if (count > 0 && count < innerTopVal) {
                    range = count % range;
                }
                Range rangeObj = new Range(fromIndex.intValue(), range.intValue());
                query.setRange(rangeObj);
            }
            query.addSortColumn(new SortColumn(Column.getColumn((String)"ADSMPrinterGeneralDetails", (String)"PRINTER_NAME"), true));
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)query);
            try {
                if (!isSearch && (dataObject.isEmpty() && shareAction != null && !shareAction.equalsIgnoreCase("ADD") || ((String)shareMap.get("REFRESH")).equals("true"))) {
                    String domainName = (String)shareMap.get("DOMAIN_NAME");
                    Properties shareProperties = ADHandler.GetPrinterNames(domainName, (String)shareMap.get("HOST_NAME"));
                    if (shareProperties.get("errorCode") != null) {
                        errorCode = (String)shareProperties.get("errorCode");
                    } else {
                        dataObject = PrintHandler.updateSharesForServer(domainName, shareProperties, (String)shareMap.get("HOST_NAME"));
                        dataObject = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)query);
                    }
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                message = ex.getMessage();
            }
            Iterator iterator = dataObject.getRows("ADSMPrinterGeneralDetails");
            while (iterator.hasNext()) {
                Row shareRow = (Row)iterator.next();
                shareList.add(shareRow);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            message = e.getMessage();
        }
        if (message != null) {
            result.put("message", message);
        }
        if (!errorCode.equalsIgnoreCase("")) {
            result.put("errorCode", errorCode);
            result.put("message", errorCode);
            result.put("printers", shareList);
        } else {
            result.put("printers", shareList);
        }
        return result;
    }

    public Iterator getShareRows(String domainName, ArrayList selectedSharesList, String objClassName, String machineName) throws Exception {
        Iterator iterator = null;
        try {
            String[] shareNames = new String[selectedSharesList.size()];
            String dbName = CommonUtil.getDBServerName();
            for (int k = 0; k < selectedSharesList.size(); ++k) {
                String selectedShareName = (String)selectedSharesList.get(k);
                logger.log(Level.INFO, "selectedShareName in FileSystemAPI " + selectedShareName);
                if (dbName.equalsIgnoreCase("mssql")) {
                    selectedShareName = EscapeUtil.escSplCharsAsMSSQL(selectedShareName);
                }
                shareNames[k] = selectedShareName;
            }
            String tableName = "ADSMPrinterGeneralDetails";
            Criteria crit = new Criteria(Column.getColumn((String)tableName, (String)"PRINTER_NAME"), (Object)shareNames, 8);
            Criteria crit1 = new Criteria(Column.getColumn((String)tableName, (String)"HOST_COMPUTER"), (Object)machineName, 0);
            Criteria crit2 = new Criteria(Column.getColumn((String)tableName, (String)"DOMAIN_NAME"), (Object)domainName, 0);
            crit = crit.and(crit1);
            crit = crit.and(crit2);
            DataObject dataObj = CommonUtil.getPersistence(new boolean[0]).get(tableName, crit);
            if (!dataObj.isEmpty()) {
                iterator = dataObj.getRows(tableName);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return iterator;
    }

    public static int getSharesCount(String hostName) {
        String query = "SELECT COUNT(*) FROM ADSMPrinterGeneralDetails WHERE HOST_COMPUTER='" + hostName + "'";
        int count = QueryUtil.getRowsCount(query);
        return count;
    }

    public static int getSharesCount(HashMap params, String searchPattern) throws Exception {
        if (PrintSystemAPI.getSharesCount((String)params.get("HOST_NAME")) == 0) {
            String domainName = (String)params.get("DOMAIN_NAME");
            Properties shareProperties = ADHandler.getSharesForServer(domainName, (String)params.get("HOST_NAME"));
            PrintHandler.updateSharesForServer(domainName, shareProperties, (String)params.get("HOST_NAME"));
        }
        String query = "SELECT COUNT(*) FROM ADSMPrinterGeneralDetails WHERE HOST_COMPUTER=${hostName} AND PRINTER_NAME LIKE '${SCRITERIA}'";
        int count = 0;
        try {
            query = searchPattern != null ? query.replace("${SCRITERIA}", searchPattern) : query.replace("AND PRINTER_NAME LIKE '${SCRITERIA}'", "");
            query = query.replace("${hostName}", "'" + (String)params.get("HOST_NAME") + "'");
            count = QueryUtil.getRowsCount(query);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Long getReportId(String cvName) {
        Long reportId = 0L;
        StringBuilder queryBuilder = new StringBuilder();
        String dbServerName = CommonUtil.getDBServerName();
        queryBuilder.append("SELECT AUDIT_REPORT_ID FROM AUDReportcvmapping JOIN AUDcvconfig ON AUDReportcvmapping.cv_id=AUDcvconfig.cv_id WHERE CV_NAME='" + cvName + "'");
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            connection = RelationalAPI.getInstance().getConnection();
            statement = connection.createStatement();
            String query = queryBuilder.toString();
            resultSet = QueryUtil.executeQuery("Getting ReportId From CvName", statement, query);
            while (resultSet.next()) {
                reportId = resultSet.getLong("AUDIT_REPORT_ID");
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (SQLException se) {
                se.printStackTrace();
            }
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException se) {
                se.printStackTrace();
            }
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException se) {
                se.printStackTrace();
            }
        }
        return reportId;
    }

    public static DataObject getShareDO(Object[] shareIds, String columnName) {
        DataObject dataObject = null;
        try {
            Criteria criteria = new Criteria(Column.getColumn((String)"ADSMPrinterGeneralDetails", (String)columnName), (Object)shareIds, 8);
            dataObject = CommonUtil.getPersistence(new boolean[0]).get("ADSMPrinterGeneralDetails", criteria);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return dataObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void startThread(String guidName) {
        StringBuilder queryBuilder = new StringBuilder();
        String dbServerName = CommonUtil.getDBServerName();
        queryBuilder.append("SELECT AudPrinterDetails.OBJECT_GUID,ADSMPrinterGeneralDetails.HOST_COMPUTER,ADSMPrinterGeneralDetails.DOMAIN_NAME FROM AudPrinterDetails JOIN ADSMPrinterGeneralDetails ON AudPrinterDetails.PRINTER_NAME = ADSMPrinterGeneralDetails.PRINTER_NAME  WHERE AudPrinterDetails.IS_ENABLED=" + (dbServerName.equalsIgnoreCase("mssql") ? "1" : "TRUE"));
        if (guidName != null) {
            queryBuilder.append(" AND  AudPrinterDetails.OBJECT_GUID=" + guidName);
        }
        queryBuilder.append(" GROUP BY ADSMPrinterGeneralDetails.DOMAIN_NAME,ADSMPrinterGeneralDetails.HOST_COMPUTER,AudPrinterDetails.OBJECT_GUID");
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            connection = RelationalAPI.getInstance().getConnection();
            statement = connection.createStatement();
            String query = queryBuilder.toString();
            resultSet = QueryUtil.executeQuery("Getting Configured Servers", statement, query);
            while (resultSet.next()) {
                PrintHandler.startThread(resultSet.getString("HOST_COMPUTER"), resultSet.getString("HOST_COMPUTER"), resultSet.getString("DOMAIN_NAME"), resultSet.getString("OBJECT_GUID"));
                String computerName = resultSet.getString("HOST_COMPUTER").replace("\\\\", "");
                PrintSystemAPI.updateStatusMessage("SUCCESS", computerName);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (SQLException se) {
                se.printStackTrace();
            }
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException se) {
                se.printStackTrace();
            }
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException se) {
                se.printStackTrace();
            }
        }
    }

    public static void updateStatusMessage(String statusMessage, String serverName) {
        try {
            Criteria criteria = new Criteria(Column.getColumn((String)"AudPrinterDetails", (String)"OBJECT_GUID"), (Object)PrintHandler.GetComputerName(serverName, "NAME", "OBJECT_GUID"), 0);
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get("AudPrinterDetails", criteria);
            Iterator iterator = dataObject.getRows("AudPrinterDetails");
            while (iterator.hasNext()) {
                Row row = (Row)iterator.next();
                if (statusMessage == null || statusMessage.equalsIgnoreCase("")) {
                    statusMessage = rb.getString("adap.common.printer.UnableServer");
                }
                row.set("MESSAGE", (Object)statusMessage);
                dataObject.updateRow(row);
            }
            PrintHandler.printServerStatusMap.put(serverName, statusMessage);
            CommonUtil.getPersistence(new boolean[0]).update(dataObject);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

