/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.ntfs;

import com.adventnet.db.api.RelationalAPI;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.auditing.server.util.MetaTableHandler;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.ntfs.ExcludeFilesHandler;
import com.adventnet.sym.adsm.common.server.sql.FileWriterObject;
import com.adventnet.sym.adsm.common.server.sql.QueryUtil;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.EscapeUtil;
import com.adventnet.sym.adsm.common.server.util.TimeUtil;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Logger;

public class ProcessCreatedFiles {
    private static AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle();
    private static String dbServerName = CommonUtil.getDBServerName();
    private static volatile ProcessCreatedFiles processCreatedFiles = null;
    private static Logger delegLogger = Logger.getLogger("DelegLogger");
    private static String[] toBeCopiedProps = new String[]{"EVENT_NUMBER", "TIME_GENERATED", "EVENT_TYPE", "EVENT_TYPE_TEXT", "SOURCE", "OBJECT_SERVER", "HANDLE_ID", "OPERATION_ID", "PRIMARY_USER_NAME", "PRIMARY_DOMAIN", "PRIMARY_LOGIN_ID", "CLIENT_USER_NAME", "CLIENT_USER_NAME", "CLIENT_DOMAIN", "CLIENT_LOGIN_ID", "DOMAIN", "LOGON_ID", "ACCESSES", "PROCESS_ID", "PROCESS_NAME", "ACCESS_MASK", "USERNAME", "RECORD_NUMBER"};
    private Vector<Properties> inQ = new Vector();
    private final int limit = 5000;
    private boolean isProcessCompleted = true;

    private ProcessCreatedFiles() {
        try {
            new Action().start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ProcessCreatedFiles getInstance() {
        if (processCreatedFiles != null) return processCreatedFiles;
        Class<ProcessCreatedFiles> clazz = ProcessCreatedFiles.class;
        synchronized (ProcessCreatedFiles.class) {
            if (processCreatedFiles != null) return processCreatedFiles;
            processCreatedFiles = new ProcessCreatedFiles();
            // ** MonitorExit[var0] (shouldn't be in output)
            return processCreatedFiles;
        }
    }

    public synchronized void addToQueue(Properties properties) throws InterruptedException {
        while (this.inQ.size() == this.limit) {
            this.wait();
        }
        if (this.inQ.size() == 0) {
            this.notifyAll();
        }
        this.inQ.add(properties);
    }

    public synchronized Vector<Properties> removeFromQueue() throws InterruptedException {
        while (this.inQ.size() == 0) {
            this.wait();
        }
        if (this.inQ.size() == this.limit) {
            this.notifyAll();
        }
        Vector<Properties> outQ = this.inQ;
        this.inQ = new Vector();
        return outQ;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Row getEventRow(String domainName, String[] serverNames, long timeGenerated, String localPath, String uncPath, String type) {
        Row newRow = null;
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        String[] fileDetails = ProcessCreatedFiles.getFileDetails(uncPath);
        String baseTableName = "AUDFileAuditInfo";
        String folderName = EscapeUtil.escSplCharsAsSQL(fileDetails[0]);
        long timeGenerated2 = timeGenerated + 10L;
        ArrayList<String> tableList = MetaTableHandler.getTableList(baseTableName, timeGenerated);
        boolean isEventLogged = false;
        try {
            if (!ExcludeFilesHandler.getInstance().isPatternMatches(localPath)) {
                connection = RelationalAPI.getInstance().getConnection();
                statement = connection.createStatement();
                for (String tableName : tableList) {
                    String query = "SELECT * FROM " + tableName + " WHERE SOURCE IN (";
                    for (int i = 0; i < serverNames.length; ++i) {
                        if (i > 0) {
                            query = query + ", ";
                        }
                        query = query + "'" + serverNames[i] + "'";
                    }
                    query = dbServerName.equalsIgnoreCase("mssql") ? query + ") AND (cast(UNC_NAME as nvarchar)='" + folderName + "' OR cast(UNC_NAME as nvarchar)='" + EscapeUtil.escSplCharsAsSQL(uncPath) + "')" : query + ") AND (UNC_NAME='" + folderName + "' OR UNC_NAME='" + EscapeUtil.escSplCharsAsSQL(uncPath) + "')";
                    query = query + " AND TIME_GENERATED >= " + timeGenerated + " AND TIME_GENERATED <=" + timeGenerated2;
                    newRow = this.getFileEventRow(statement, resultSet, query, localPath, uncPath, type, fileDetails);
                    if (resultSet != null) {
                        resultSet.close();
                    }
                    if (newRow == null) continue;
                    isEventLogged = true;
                    break;
                }
                if (!isEventLogged) {
                    timeGenerated2 += 20L;
                    long timeGenerated3 = timeGenerated - 20L;
                    for (String tableName : tableList) {
                        String query = "SELECT * FROM " + tableName + " WHERE SOURCE IN (";
                        for (int i = 0; i < serverNames.length; ++i) {
                            if (i > 0) {
                                query = query + ", ";
                            }
                            query = query + "'" + serverNames[i] + "'";
                        }
                        query = query + ") AND (UNC_NAME LIKE '%" + EscapeUtil.escSplCharsAsSQLForLike(folderName) + "%')" + " AND TIME_GENERATED >= " + timeGenerated3 + " AND TIME_GENERATED <=" + timeGenerated2;
                        newRow = this.getFileEventRow(statement, resultSet, query, localPath, uncPath, type, fileDetails);
                        if (resultSet != null) {
                            resultSet.close();
                        }
                        if (newRow == null) continue;
                        isEventLogged = true;
                        break;
                    }
                    if (!isEventLogged) {
                        newRow = new Row(baseTableName);
                        newRow.set("EVENT_NUMBER", (Object)10);
                        newRow.set("TIME_GENERATED", (Object)timeGenerated);
                        newRow.set("EVENT_TYPE", (Object)8);
                        newRow.set("EVENT_TYPE_TEXT", (Object)"success");
                        newRow.set("SOURCE", (Object)serverNames[0]);
                        newRow.set("OBJECT_SERVER", (Object)"Security");
                        newRow.set("DOMAIN", (Object)domainName);
                        newRow.set("ACCESSES", (Object)"ReadData (or ListDirectory)");
                        newRow.set("ACCESS_MASK", (Object)1);
                        newRow.set("USERNAME", (Object)"-");
                        newRow.set("RECORD_NUMBER", newRow.get("UNIQUE_ID"));
                        newRow.set("USER_SID", (Object)"-");
                        newRow.set("OBJECT_TYPE", (Object)type);
                        newRow.set("REMARKS", (Object)rb.handleGetObject("adap.ProcessCreatedFiles.created", new String[]{type}));
                        newRow.set("MONITOR_ID", (Object)0);
                        newRow.set("ACCESS_TYPE", (Object)5);
                        newRow.set("ACCESS_TYPE_TEXT", (Object)rb.handleGetObject("adap.ProcessCreatedFiles.created", new String[]{type}));
                        newRow.set("OBJECT_NAME", (Object)localPath);
                        newRow.set("UNC_NAME", (Object)uncPath);
                        if (localPath != null) {
                            String[] objectFileDetails = ProcessCreatedFiles.getFileDetails(localPath);
                            newRow.set("FILE_LOCATION", (Object)objectFileDetails[0]);
                            newRow.set("FILE_NAME", (Object)objectFileDetails[1]);
                        }
                        String formatMessage = ProcessCreatedFiles.getFileCreationFormatMessage(newRow);
                        newRow.set("FORMAT_MESSAGE", (Object)formatMessage);
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return newRow;
    }

    private Row getFileEventRow(Statement statement, ResultSet resultSet, String query, String localPath, String uncPath, String type, String[] fileDetails) {
        Row newRow = null;
        String baseTableName = "AUDFileAuditInfo";
        try {
            resultSet = QueryUtil.executeQuery("Getting Rows for File Creation", statement, query);
            if (resultSet.next()) {
                ResultSetMetaData metaData = resultSet.getMetaData();
                newRow = new Row(baseTableName);
                for (int i = 1; i <= metaData.getColumnCount(); ++i) {
                    String columnName = metaData.getColumnName(i);
                    if (columnName.equalsIgnoreCase("UNIQUE_ID")) continue;
                    newRow.set(columnName.toUpperCase(), resultSet.getObject(columnName));
                }
                newRow.set("OBJECT_TYPE", (Object)type);
                newRow.set("REMARKS", (Object)rb.handleGetObject("adap.ProcessCreatedFiles.created", new String[]{type}));
                newRow.set("MONITOR_ID", (Object)0);
                newRow.set("ACCESS_TYPE", (Object)5);
                newRow.set("ACCESS_TYPE_TEXT", (Object)rb.handleGetObject("adap.ProcessCreatedFiles.created", new String[]{type}));
                newRow.set("OBJECT_NAME", (Object)localPath);
                newRow.set("UNC_NAME", (Object)uncPath);
                newRow.set("RECORD_NUMBER", newRow.get("UNIQUE_ID"));
                if (localPath != null) {
                    String[] objectFileDetails = ProcessCreatedFiles.getFileDetails(localPath);
                    newRow.set("FILE_LOCATION", (Object)objectFileDetails[0]);
                    newRow.set("FILE_NAME", (Object)objectFileDetails[1]);
                }
                String formatMessage = ProcessCreatedFiles.getFileCreationFormatMessage(newRow);
                newRow.set("FORMAT_MESSAGE", (Object)formatMessage);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return newRow;
    }

    private static String getFileCreationFormatMessage(Row newRow) {
        StringBuffer message = new StringBuffer();
        message.append(rb.getString("adap.ADMPObjects.display_text.User"));
        message.append(" '" + newRow.get("USERNAME") + "' ");
        message.append(rb.getString("adap.AUDComplianceReports.title.Users_Created") + " ");
        message.append(newRow.get("OBJECT_TYPE"));
        message.append(" '" + newRow.get("UNC_NAME") + "'.");
        return message.toString();
    }

    private static String[] getFileDetails(String absoluteName) {
        String[] fileDetails = new String[2];
        if (absoluteName.indexOf("\\") != -1) {
            int lastIndex = absoluteName.lastIndexOf("\\");
            fileDetails[0] = absoluteName.substring(0, lastIndex);
            fileDetails[1] = absoluteName.substring(lastIndex + 1, absoluteName.length());
        } else if (absoluteName.indexOf("/") != -1) {
            int lastIndex = absoluteName.lastIndexOf("/");
            fileDetails[0] = absoluteName.substring(0, lastIndex);
            fileDetails[1] = absoluteName.substring(lastIndex + 1, absoluteName.length());
        } else {
            fileDetails[0] = "-";
            fileDetails[1] = absoluteName;
        }
        return fileDetails;
    }

    class Action
    extends Thread {
        private boolean shutDown = false;

        Action() {
        }

        @Override
        public void run() {
            try {
                while (!this.shutDown) {
                    this.checkAndProcess();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public void checkAndProcess() {
            this.waitForUpdate(300L);
            if (ProcessCreatedFiles.this.isProcessCompleted) {
                this.process();
            }
        }

        public boolean isShutDown() {
            return this.shutDown;
        }

        public void setShutDown(boolean shutDown) {
            this.shutDown = shutDown;
        }

        public synchronized void waitForUpdate(long t) {
            try {
                super.wait(t);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public void process() {
            ProcessCreatedFiles.this.isProcessCompleted = false;
            try {
                Vector<Properties> outQ = ProcessCreatedFiles.this.removeFromQueue();
                if (outQ.size() > 0) {
                    ArrayList<Row> rowList = new ArrayList<Row>();
                    for (int i = 0; i < outQ.size(); ++i) {
                        Properties properties = outQ.get(i);
                        String[] serverName = null;
                        boolean isClusterCap = (Boolean)properties.get("isClusterCap");
                        if (isClusterCap) {
                            ArrayList nodeList = (ArrayList)properties.get("clusterNodes");
                            if (nodeList != null) {
                                serverName = new String[nodeList.size()];
                                for (int j = 0; j < nodeList.size(); ++j) {
                                    Properties nodeProps = (Properties)nodeList.get(j);
                                    serverName[j] = (String)nodeProps.get("COMPUTER_NAME");
                                }
                            }
                        } else {
                            serverName = new String[]{properties.getProperty("serverName")};
                        }
                        long creationTime = Long.parseLong((String)((ArrayList)properties.get("Creation Time")).get(0));
                        long unixTime = TimeUtil.getUnixTimeFromFileTime(creationTime);
                        String localPath = (String)((ArrayList)properties.get("Local Path")).get(0);
                        String uncPath = (String)((ArrayList)properties.get("Location")).get(0);
                        String type = (String)((ArrayList)properties.get("Type")).get(0);
                        String domainName = properties.getProperty("domainName");
                        Row creationRow = ProcessCreatedFiles.this.getEventRow(domainName, serverName, unixTime, localPath, uncPath, type);
                        if (creationRow == null) continue;
                        rowList.add(creationRow);
                    }
                    FileWriterObject.getInstance().addRows(rowList, null, false);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ProcessCreatedFiles.this.isProcessCompleted = true;
        }
    }
}

