/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.ntfs;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import java.util.ArrayList;
import java.util.Properties;

public class ShareHandler {
    private static String[] nativeShareProps = new String[]{"Name", "Location", "Host Computer", "Local Path", "Current User Count", "Description", "Max User Count"};
    private static String[] sharePropColumns = new String[]{"SHARE_NAME", "LOCATION", "HOST_COMPUTER", "LOCAL_PATH", "CURRENT_USER_COUNT", "DESCRIPTION", "MAX_USER_COUNT"};
    private static String[] sharePropDataType = new String[]{"String", "String", "String", "String", "Long", "String", "Long"};
    public static final String SHARE_TABLE_NAME = "ADSMShareGeneralDetails";

    public static DataObject updateSharesForServer(String domainName, Properties shareProperties, String computerName) {
        DataObject shareDO = null;
        try {
            shareDO = CommonUtil.getPersistence(new boolean[0]).constructDataObject();
            if (shareProperties != null && !shareProperties.isEmpty() && ShareHandler.deleteSharesForServer(computerName)) {
                ArrayList shareList = (ArrayList)shareProperties.get("shares");
                for (Object object : shareList) {
                    Row shareRow = new Row(SHARE_TABLE_NAME);
                    Properties properties = (Properties)object;
                    for (int i = 0; i < nativeShareProps.length; ++i) {
                        ArrayList arrayList = (ArrayList)properties.get(nativeShareProps[i]);
                        if (arrayList == null || arrayList.isEmpty()) continue;
                        String shareProperty = (String)arrayList.get(0);
                        if (sharePropDataType[i].equalsIgnoreCase("Long")) {
                            shareRow.set(sharePropColumns[i], (Object)CommonUtil.getLong(shareProperty));
                            continue;
                        }
                        shareRow.set(sharePropColumns[i], (Object)shareProperty);
                    }
                    shareRow.set("DOMAIN_NAME", (Object)domainName);
                    shareDO.addRow(shareRow);
                }
                CommonUtil.getPersistence(new boolean[0]).add(shareDO);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return shareDO;
    }

    public static boolean deleteSharesForServer(String computerName) {
        boolean isDeleted = false;
        try {
            Criteria criteria = new Criteria(Column.getColumn((String)SHARE_TABLE_NAME, (String)"HOST_COMPUTER"), (Object)computerName, 0);
            CommonUtil.getPersistenceLite().delete(criteria);
            isDeleted = true;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return isDeleted;
    }
}

