/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.ntfs.cluster;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.Range;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.SortColumn;
import com.adventnet.ds.query.Table;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.auditing.server.fileaudit.cluster.ClusterUtil;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ClusterConfigAPI {
    private static AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle();
    private static ClusterConfigAPI api = null;
    private static Logger logger = Logger.getLogger("ReportLogger");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ClusterConfigAPI getInstance() {
        if (api != null) return api;
        Class<ClusterConfigAPI> clazz = ClusterConfigAPI.class;
        synchronized (ClusterConfigAPI.class) {
            if (api != null) return api;
            api = new ClusterConfigAPI();
            // ** MonitorExit[var0] (shouldn't be in output)
            return api;
        }
    }

    public static Long validateClusterName(String clusterName, String domainName) throws Exception {
        boolean status = ClusterUtil.isClusterConfigured(domainName, clusterName, null);
        if (status) {
            throw new Exception(rb.getString("adap.ClusterConfigAPI.The_cluster_is_already_configured"));
        }
        ArrayList clusterNameDetails = ClusterUtil.getClusterInfo(domainName, clusterName, "MSCluster_Cluster");
        if (clusterNameDetails != null && clusterNameDetails.size() > 0 && !clusterNameDetails.isEmpty()) {
            Properties clusterNameProperty = (Properties)clusterNameDetails.get(0);
            Long clusterId = ClusterUtil.addClusterDetails(domainName, clusterName, clusterNameProperty);
            return clusterId;
        }
        throw new Exception(rb.getString("adap.ClusterConfigAPI.Invalid_Cluster_Name"));
    }

    public Hashtable<String, Object> getClusterNodeInfo(String domainName, String clusterName, Long clusterId, String searchString, String refresh) throws Exception {
        Hashtable<String, Object> result = new Hashtable<String, Object>();
        ArrayList<Row> clusterNodeList = new ArrayList<Row>();
        String message = null;
        try {
            boolean isSearch = false;
            SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)"AUDClusterDetails"));
            query.addSelectColumn(Column.getColumn(null, (String)"*"));
            Join clusterNameJoin = new Join("AUDClusterDetails", "AUDClusterNodeDetails", new String[]{"CLUSTER_ID"}, new String[]{"CLUSTER_ID"}, 2);
            query.addJoin(clusterNameJoin);
            Criteria cri = new Criteria(Column.getColumn((String)"AUDClusterDetails", (String)"CLUSTER_ID"), (Object)clusterId, 0);
            if (searchString != null && !"".equalsIgnoreCase(searchString)) {
                Criteria cri2 = new Criteria(Column.getColumn((String)"AUDClusterNodeDetails", (String)"CLUSTER_NODE_NAME"), (Object)searchString, 12, false);
                cri = cri.and(cri2);
                isSearch = true;
            }
            query.setCriteria(cri);
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)query);
            try {
                ArrayList clusterNodeListNative;
                if ((!isSearch && dataObject.isEmpty() || refresh != null && refresh.equals("true")) && (clusterNodeListNative = ClusterUtil.getClusterInfo(domainName, clusterName, "MSCluster_Node")) != null && clusterNodeListNative.size() > 0) {
                    clusterNodeListNative = this.getClusterNodeGuid(domainName, clusterName, clusterNodeListNative);
                    logger.log(Level.INFO, "clusterNodeList after geot GUID" + clusterNodeListNative);
                    dataObject = ClusterUtil.updateClusterNodes(domainName, clusterId, clusterNodeListNative);
                    dataObject = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)query);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                message = ex.getMessage();
            }
            Iterator iterator = dataObject.getRows("AUDClusterNodeDetails");
            while (iterator.hasNext()) {
                Row clusterNodeRow = (Row)iterator.next();
                clusterNodeList.add(clusterNodeRow);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            message = e.getMessage();
        }
        if (message != null) {
            result.put("message", message);
        }
        result.put("Nodes", clusterNodeList);
        return result;
    }

    public Hashtable<String, Object> getClusterResourceInfo(String domainName, String clusterName, Long clusterId, String searchString, Integer fromIndex, Integer range, String refresh) throws Exception {
        Hashtable<String, Object> result = new Hashtable<String, Object>();
        ArrayList<Row> clusterResourceList = new ArrayList<Row>();
        String message = null;
        try {
            boolean isSearch = false;
            SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)"AUDClusterDetails"));
            query.addSelectColumn(Column.getColumn((String)"AUDClusterDetails", (String)"CLUSTER_ID", (String)"CLUSTER_TABLE_CLUSTER_ID"));
            query.addSelectColumn(Column.getColumn((String)"AUDClusterDetails", (String)"CLUSTER_NAME"));
            query.addSelectColumn(Column.getColumn((String)"AUDClusterDetails", (String)"DOMAIN_NAME"));
            query.addSelectColumn(Column.getColumn((String)"AUDClusterDetails", (String)"MESSAGE", (String)"CLUSTER_TABLE_MESSAGE"));
            query.addSelectColumn(Column.getColumn((String)"AUDClusterCAPDetails", (String)"CLUSTER_CAP_ID"));
            query.addSelectColumn(Column.getColumn((String)"AUDClusterCAPDetails", (String)"CLUSTER_ID", (String)"CLUSTER_CAP_TABLE_CLUSTER_ID"));
            query.addSelectColumn(Column.getColumn((String)"AUDClusterCAPDetails", (String)"CLUSTER_CAP_NAME"));
            query.addSelectColumn(Column.getColumn((String)"AUDClusterCAPDetails", (String)"MESSAGE", (String)"CLUSTER_CAP_TABLE_MESSAGE"));
            Join clusterNameJoin = new Join("AUDClusterDetails", "AUDClusterCAPDetails", new String[]{"CLUSTER_ID"}, new String[]{"CLUSTER_ID"}, 2);
            query.addJoin(clusterNameJoin);
            Criteria cri = new Criteria(Column.getColumn((String)"AUDClusterDetails", (String)"CLUSTER_ID"), (Object)clusterId, 0);
            if (searchString != null && !"".equalsIgnoreCase(searchString)) {
                Criteria cri2 = new Criteria(Column.getColumn((String)"AUDClusterCAPDetails", (String)"CLUSTER_CAP_NAME"), (Object)searchString, 12, false);
                cri = cri.and(cri2);
                isSearch = true;
            }
            query.setCriteria(cri);
            if (fromIndex != null && range != null) {
                Range rangeR = new Range(fromIndex.intValue(), range.intValue());
                query.setRange(rangeR);
            }
            query.addSortColumn(new SortColumn(Column.getColumn((String)"AUDClusterDetails", (String)"CLUSTER_NAME"), false));
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)query);
            try {
                ArrayList clusterResourceListFromNative;
                if ((!isSearch && dataObject.isEmpty() || refresh != null && refresh.equals("true")) && (clusterResourceListFromNative = ClusterUtil.getClusterInfo(domainName, clusterName, "MSCluster_Resource")) != null && clusterResourceListFromNative.size() > 0) {
                    clusterResourceListFromNative = this.validateClusterResources(domainName, clusterName, clusterResourceListFromNative);
                    dataObject = ClusterUtil.updateClusterResources(domainName, clusterId, clusterResourceListFromNative);
                    dataObject = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)query);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                message = ex.getMessage();
            }
            Iterator iterator = dataObject.getRows("AUDClusterCAPDetails");
            while (iterator.hasNext()) {
                Row clusterNodeRow = (Row)iterator.next();
                clusterResourceList.add(clusterNodeRow);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            message = e.getMessage();
        }
        if (message != null) {
            result.put("message", message);
        }
        result.put("Caps", clusterResourceList);
        return result;
    }

    public ArrayList validateClusterResources(String domainName, String clusterName, ArrayList clusterResourceList) throws Exception {
        ArrayList<Properties> clusterResourceDetails = new ArrayList<Properties>();
        for (int i = 0; i < clusterResourceList.size(); ++i) {
            Properties clusterResourceTempProp = (Properties)clusterResourceList.get(i);
            String clusterCAPName = (String)clusterResourceTempProp.get("NetBiosName");
            String resourceName = (String)clusterResourceTempProp.get("Name");
            Properties clusterResourceProp = new Properties();
            clusterResourceProp.put("CLUSTER_NAME", clusterName);
            clusterResourceProp.put("CLUSTER_CAP_NAME", clusterCAPName);
            clusterResourceDetails.add(clusterResourceProp);
        }
        return clusterResourceDetails;
    }

    public ArrayList getClusterNodeGuid(String domainName, String clusterName, ArrayList clusterNodeList) throws Exception {
        ArrayList<Properties> clusterNodeDetails = new ArrayList<Properties>();
        for (int i = 0; i < clusterNodeList.size(); ++i) {
            Properties clusterNodeTempProp = (Properties)clusterNodeList.get(i);
            String netBiosName = (String)clusterNodeTempProp.get("Name");
            Properties nodeProps = ClusterUtil.getNodeGuid(domainName, netBiosName);
            if (nodeProps == null || nodeProps.getProperty("nodeName") == null || nodeProps.getProperty("nodeGuid") == null) continue;
            Properties clusterNodeProp = new Properties();
            clusterNodeProp.put("CLUSTER_NAME", clusterName);
            clusterNodeProp.put("CLUSTER_NODE_NAME", nodeProps.getProperty("nodeName"));
            clusterNodeProp.put("OBJECT_GUID", nodeProps.getProperty("nodeGuid"));
            clusterNodeDetails.add(clusterNodeProp);
        }
        return clusterNodeDetails;
    }
}

