/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.objects;

import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.objects.DirectoryObjectAPI;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class ADAPObjectCacheAPI {
    private static volatile ADAPObjectCacheAPI objectCacheAPI = null;
    private static final String[] SECURITY_PRINCIPALS = new String[]{"group", "user", "computer", "foreignSecurityPrincipal"};
    private static Hashtable<String, Hashtable<String, String>> sidMap = new Hashtable();
    private static final String[] NAME_COLUMNS = new String[]{"SAM_ACCOUNT_NAME", "LOGON_NAME"};
    private static Hashtable<String, Hashtable<String, String>> nameToSidMap = new Hashtable();
    private static Logger reportLogger = Logger.getLogger("ReportLogger");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ADAPObjectCacheAPI getInstance() {
        if (objectCacheAPI != null) return objectCacheAPI;
        Class<ADAPObjectCacheAPI> clazz = ADAPObjectCacheAPI.class;
        synchronized (ADAPObjectCacheAPI.class) {
            if (objectCacheAPI != null) return objectCacheAPI;
            objectCacheAPI = new ADAPObjectCacheAPI();
            // ** MonitorExit[var0] (shouldn't be in output)
            return objectCacheAPI;
        }
    }

    private ADAPObjectCacheAPI() {
        this.initCacheVariables();
    }

    public void initCacheVariables() {
        try {
            Hashtable uniqueKeyMap;
            sidMap = new Hashtable();
            for (String securityPrincipalType : SECURITY_PRINCIPALS) {
                uniqueKeyMap = new Hashtable();
                sidMap.put(securityPrincipalType, uniqueKeyMap);
            }
            nameToSidMap = new Hashtable();
            for (String columnName : NAME_COLUMNS) {
                uniqueKeyMap = new Hashtable();
                nameToSidMap.put(columnName, uniqueKeyMap);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void checkCacheStatus() {
        try {
            Hashtable<String, String> uniqueKeyMap;
            for (String securityPrincipalType : SECURITY_PRINCIPALS) {
                uniqueKeyMap = sidMap.get(securityPrincipalType);
                reportLogger.log(Level.INFO, "ADAPObjectCacheAPI status " + securityPrincipalType + " :: " + uniqueKeyMap.size());
            }
            for (String columnName : NAME_COLUMNS) {
                uniqueKeyMap = nameToSidMap.get(columnName);
                reportLogger.log(Level.INFO, "ADAPObjectCacheAPI status " + columnName + " :: " + uniqueKeyMap.size());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getObjectNameFromSID(String domainName, String sidString, String nameType, String sidType) {
        return this.getObjectNameFromSID(domainName, sidString, sidType);
    }

    public String getObjectNameFromSID(String domainName, String sidString, String sidType) {
        Row r = null;
        String retObjectName = sidString;
        Hashtable<String, String> uniqueKeyMap = null;
        String[] security_principals2 = SECURITY_PRINCIPALS;
        if (sidType != null) {
            security_principals2 = new String[]{sidType};
        }
        for (String securityPrincipalType : security_principals2) {
            uniqueKeyMap = sidMap.get(securityPrincipalType);
            if (uniqueKeyMap == null || !uniqueKeyMap.containsKey(sidString)) continue;
            return uniqueKeyMap.get(sidString);
        }
        try {
            for (String securityPrincipalType : security_principals2) {
                r = DirectoryObjectAPI.getInstance().getObjectRowFromDB(domainName, sidString, "SID_STRING", securityPrincipalType);
                if (r == null) continue;
                uniqueKeyMap = sidMap.get(securityPrincipalType);
                retObjectName = (String)r.get("NAME");
                uniqueKeyMap.put(sidString, retObjectName);
                return retObjectName;
            }
            Hashtable<String, String> retHash = DirectoryObjectAPI.getInstance().getObjectRowFromADWithoutListener(domainName, sidString);
            if (retHash.containsKey("name")) {
                uniqueKeyMap = sidMap.get(retHash.get("objectClass"));
                uniqueKeyMap.put(sidString, retHash.get("name"));
                retObjectName = retHash.get("name");
            } else {
                retObjectName = sidString;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return retObjectName;
    }

    public String getObjectClassFromSIDGC(String domainName, String sidString) {
        String retObjectName = "";
        Hashtable<String, String> uniqueKeyMap = null;
        for (String securityPrincipalType : SECURITY_PRINCIPALS) {
            uniqueKeyMap = sidMap.get(securityPrincipalType);
            if (uniqueKeyMap == null || !uniqueKeyMap.containsKey(sidString)) continue;
            return securityPrincipalType;
        }
        try {
            for (String securityPrincipalType : SECURITY_PRINCIPALS) {
                Row r = DirectoryObjectAPI.getInstance().getObjectRowFromDB(domainName, sidString, "SID_STRING", securityPrincipalType);
                if (r == null) continue;
                uniqueKeyMap = sidMap.get(securityPrincipalType);
                uniqueKeyMap.put(sidString, (String)r.get("NAME"));
                return securityPrincipalType;
            }
            Hashtable<String, String> retHash = DirectoryObjectAPI.getInstance().getObjectRowFromADWithoutListener(domainName, sidString);
            if (retHash.containsKey("name")) {
                uniqueKeyMap = sidMap.get(retHash.get("objectClass"));
                uniqueKeyMap.put(sidString, retHash.get("name"));
                return retHash.get("objectClass");
            }
            retObjectName = "";
        }
        catch (Exception e) {
            e.printStackTrace();
            retObjectName = "";
        }
        return retObjectName;
    }

    public String getSidFromName(String domainName, String columnName, String name, String dcName) {
        String sid = null;
        try {
            Hashtable<String, String> columnNameMap = nameToSidMap.get(columnName);
            sid = columnNameMap.get(domainName + name);
            int failureCount = 0;
            if (sid != null && sid.contains("failureCount")) {
                failureCount = Integer.parseInt(sid.replace("failureCount", ""));
                sid = null;
            }
            if (sid == null) {
                Row objectRow = DirectoryObjectAPI.getInstance().getObjectRow(domainName, name, columnName, "user", dcName);
                if (objectRow != null) {
                    sid = (String)objectRow.get("SID_STRING");
                    sid = "%{" + sid + "}";
                    columnNameMap.put(domainName + name, sid);
                } else if (++failureCount < 10) {
                    columnNameMap.put(domainName + name, "failureCount" + failureCount);
                } else {
                    columnNameMap.put(domainName + name, name);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (sid == null) {
            sid = name;
        }
        return sid;
    }
}

