/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.objects;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.persistence.DataAccessException;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.ADHandler;
import com.adventnet.sym.adsm.common.server.DomainDetailsAPI;
import com.adventnet.sym.adsm.common.server.DomainHandler;
import com.adventnet.sym.adsm.common.server.objects.DirectoryObjectAPI;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;

public class DHCPUtil {
    private static volatile DHCPUtil dhcpUtil = null;
    private static HashMap<String, ArrayList<String>> domainDHCPMap = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DHCPUtil getInstance() {
        if (dhcpUtil != null) return dhcpUtil;
        Class<DHCPUtil> clazz = DHCPUtil.class;
        synchronized (DHCPUtil.class) {
            if (dhcpUtil != null) return dhcpUtil;
            dhcpUtil = new DHCPUtil();
            // ** MonitorExit[var0] (shouldn't be in output)
            return dhcpUtil;
        }
    }

    private DHCPUtil() {
    }

    public ArrayList<String> getDHCPServers(String domainName) {
        if (domainDHCPMap.get(domainName) == null) {
            this.updateDHCPServers(domainName);
        }
        return domainDHCPMap.get(domainName);
    }

    public void updateDHCPServers(String domainName) {
        ArrayList<Properties> dhcpServerList = this.getDHCPServersFromAD(domainName);
        DataObject dataObject = null;
        try {
            dataObject = CommonUtil.getPersistence(new boolean[0]).constructDataObject();
            for (Properties properties : dhcpServerList) {
                String serverName = properties.getProperty("SERVER_NAME");
                Row row = DirectoryObjectAPI.getInstance().getComputerObjectRow("computer", null, serverName, domainName);
                if (row != null) {
                    serverName = (String)row.get("NAME");
                }
                Row row2 = new Row();
                row2.set("SERVER_NAME", (Object)properties.getProperty("SERVER_NAME"));
                row2.set("SERVER_IP_ADDRESS", (Object)properties.getProperty("SERVER_IP_ADDRESS"));
                row2.set("REL_ADS_PATH", (Object)properties.getProperty("REL_ADS_PATH"));
                row2.set("SERVER_FLAT_NAME", (Object)properties.getProperty("SERVER_FLAT_NAME"));
                row2.set("DOMAIN_NAME", (Object)domainName);
                dataObject.addRow(row2);
            }
            CommonUtil.getPersistence(new boolean[0]).update(dataObject);
            this.updateDHCPServerMap(domainName);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void updateDHCPServerMap(String domainName) {
        ArrayList<String> dhCPServerList = new ArrayList<String>();
        Criteria criteria = new Criteria(Column.getColumn((String)"AUDDHCPDetails", (String)"DOMAIN_NAME"), (Object)domainName, 0);
        try {
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get("AUDDHCPDetails", criteria);
            Iterator iterator = dataObject.getRows("AUDDHCPDetails");
            while (iterator.hasNext()) {
                Row row = (Row)iterator.next();
                dhCPServerList.add((String)row.get("SERVER_FLAT_NAME"));
            }
        }
        catch (DataAccessException e) {
            e.printStackTrace();
        }
        domainDHCPMap.put(domainName, dhCPServerList);
    }

    public ArrayList<Properties> getDHCPServersFromAD(String domainName) {
        ArrayList dhcpServerList = new ArrayList();
        try {
            String configurationNamingContext = DomainDetailsAPI.getConfigurationNamingContext(domainName);
            Properties domainDetails = DomainHandler.getConfiguredValues(domainName, 1L);
            String searchString = "(&(objectClass=dHCPClass)(!name=DhcpRoot))";
            ArrayList<String> attributeList = new ArrayList<String>();
            attributeList.add("distinguishedName");
            attributeList.add("cn");
            attributeList.add("dhcpServers");
            ArrayList dhcpClassList = ADHandler.getObjectsWithOutListener(domainDetails, configurationNamingContext, attributeList, searchString);
            if (!dhcpClassList.isEmpty()) {
                Properties properties = (Properties)dhcpClassList.get(0);
                dhcpServerList = (ArrayList)properties.get("dhcpServers");
                for (Object object : dhcpServerList) {
                    String string = (String)object;
                    String[] dsArray = string.split("\\$");
                    Properties dhcpServerProperty = new Properties();
                    for (String string2 : dsArray) {
                        if (string.startsWith("i")) {
                            dhcpServerProperty.setProperty("SERVER_IP_ADDRESS", string2.substring(1));
                            continue;
                        }
                        if (string.startsWith("r")) {
                            dhcpServerProperty.setProperty("REL_ADS_PATH", string2.substring(1));
                            continue;
                        }
                        if (string.startsWith("f")) {
                            dhcpServerProperty.setProperty("FLAGS", string2.substring(1));
                            continue;
                        }
                        if (!string.startsWith("s")) continue;
                        dhcpServerProperty.setProperty("SERVER_NAME", string2.substring(1));
                    }
                    dhcpServerList.add(dhcpServerProperty);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return dhcpServerList;
    }

    public boolean isDHCPServer(String serverName, String domainName) {
        return this.getDHCPServers(domainName).contains(serverName);
    }

    public boolean isDNSServer(String serverName, String domainName) {
        boolean isDNSServer = false;
        try {
            Row row;
            ArrayList<String> dnsServersList;
            DataObject dataObject = DomainHandler.getDomainDetailsDO(domainName);
            if (dataObject != null && !dataObject.isEmpty() && (dnsServersList = DomainDetailsAPI.getDNSServers(domainName = (String)(row = dataObject.getRow(DomainHandler.tableName)).get("DOMAIN_NAME"))) != null && !dnsServersList.isEmpty()) {
                isDNSServer = dnsServersList.contains(serverName);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return isDNSServer;
    }
}

