/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.objects;

import com.adventnet.db.api.RelationalAPI;
import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.DataSet;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.Query;
import com.adventnet.ds.query.Range;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.SortColumn;
import com.adventnet.ds.query.Table;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.auditing.server.reports.AUDCustomViewAPI;
import com.adventnet.sym.adsm.auditing.server.util.EventDataUtil;
import com.adventnet.sym.adsm.common.server.ADHandler;
import com.adventnet.sym.adsm.common.server.DomainDetailsAPI;
import com.adventnet.sym.adsm.common.server.DomainHandler;
import com.adventnet.sym.adsm.common.server.model.ObjectClass;
import com.adventnet.sym.adsm.common.server.objects.GroupHandler;
import com.adventnet.sym.adsm.common.server.objects.OUHandler;
import com.adventnet.sym.adsm.common.server.objects.ObjectAttributeHandler;
import com.adventnet.sym.adsm.common.server.objects.ObjectUpdateHandler;
import com.adventnet.sym.adsm.common.server.objects.ObjectUpdateTask;
import com.adventnet.sym.adsm.common.server.objects.ObjectUpdateUtil;
import com.adventnet.sym.adsm.common.server.objects.UserObjectUtil;
import com.adventnet.sym.adsm.common.server.sql.ADAPSQLQueryUtil;
import com.adventnet.sym.adsm.common.server.sql.query.QueryBuilderAPI;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.DBObjectUtil;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DirectoryObjectAPI {
    private static DirectoryObjectAPI api = null;
    private Hashtable objectClasses = null;
    private static Logger reportLogger = Logger.getLogger("ReportLogger");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DirectoryObjectAPI getInstance() {
        if (api != null) return api;
        Class<DirectoryObjectAPI> clazz = DirectoryObjectAPI.class;
        synchronized (DirectoryObjectAPI.class) {
            if (api != null) return api;
            api = new DirectoryObjectAPI();
            // ** MonitorExit[var0] (shouldn't be in output)
            return api;
        }
    }

    private DirectoryObjectAPI() {
        try {
            this.objectClasses = new Hashtable();
            ArrayList<String> tablesList = new ArrayList<String>();
            tablesList.add("ADMPObjects");
            DataObject obj = CommonUtil.getPersistence(new boolean[0]).get(tablesList, new Criteria(Column.getColumn((String)"ADMPObjects", (String)"OBJECT_CLASS"), (Object)"", 1));
            Iterator iterator = obj.getRows("ADMPObjects");
            while (iterator.hasNext()) {
                Row r1 = (Row)iterator.next();
                String objectClass = (String)r1.get("OBJECT_CLASS");
                this.objectClasses.put(objectClass.toLowerCase(), new ObjectClass(objectClass, obj));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public ObjectClass getObjectClass(String objClass) {
        return (ObjectClass)this.objectClasses.get(objClass.toLowerCase());
    }

    public Row getObjectRow(String domainName, String guid, String objClassName) throws Exception {
        Row r = null;
        try {
            ObjectClass object = this.getObjectClass(objClassName);
            if (object != null) {
                String tableName = object.getBaseTable();
                Criteria crit = null;
                crit = objClassName.equalsIgnoreCase("share") ? new Criteria(Column.getColumn((String)tableName, (String)"LOCATION"), (Object)guid, 0, false) : (tableName.equalsIgnoreCase("ADSMPrinterGeneralDetails") ? new Criteria(Column.getColumn((String)tableName, (String)"PRINTER_NAME"), (Object)guid, 0, false) : new Criteria(Column.getColumn((String)tableName, (String)"OBJECT_GUID"), (Object)guid, 0, false));
                DataObject dataObj = CommonUtil.getPersistence(new boolean[0]).get(tableName, crit);
                if (dataObj.isEmpty() && domainName != null) {
                    ObjectUpdateUtil.updateObjectFromGUID(domainName, guid, object, null, false);
                    dataObj = CommonUtil.getPersistence(new boolean[0]).get(tableName, crit);
                }
                if (!dataObj.isEmpty()) {
                    r = dataObj.getRow(tableName);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return r;
    }

    public static String getComputerPropFromAD(String domainName, String name) {
        String osVersion = null;
        try {
            ObjectClass object = DirectoryObjectAPI.getInstance().getObjectClass("computer");
            Integer reportId = object.getReportId();
            ArrayList arrayList = ObjectAttributeHandler.getInstance().getTotalColumn(reportId);
            ArrayList<String> attributeList = new ArrayList<String>();
            for (Object object2 : arrayList) {
                Properties properties = (Properties)object2;
                attributeList.add(properties.getProperty("ATTRIB_LDAP_NAME"));
            }
            attributeList.add("pwdLastSet");
            String searchString = "(&(objectClass=computer)(|(sAMAccountName=" + name + "$)(dNSHostName=" + name + ")))";
            reportLogger.log(Level.INFO, "searchString getComputerPropFromAD: " + searchString);
            Properties domainDetails = DomainHandler.getConfiguredValues(domainName, 1L);
            reportLogger.log(Level.INFO, "attributeList getComputerPropFromAD: " + attributeList);
            ArrayList objectsList = ADHandler.getObjectsWithOutListener(domainDetails, domainDetails.getProperty("DEFAULT_NAMING_CONTEXT"), attributeList, searchString);
            reportLogger.log(Level.INFO, "objectsList getComputerPropFromAD: " + objectsList);
            if (objectsList != null && !objectsList.isEmpty()) {
                Properties properties = null;
                Long pwdLastSet = 0L;
                for (int i = 0; i < objectsList.size(); ++i) {
                    Properties prop = (Properties)objectsList.get(i);
                    ArrayList list = (ArrayList)prop.get("pwdLastSet");
                    String temp = (String)list.get(0);
                    Long pwdLastSet1 = Long.parseLong(temp);
                    if (pwdLastSet1 <= pwdLastSet) continue;
                    pwdLastSet = pwdLastSet1;
                    properties = prop;
                }
                reportLogger.log(Level.INFO, "final properties getComputerPropFromAD: " + properties);
                Criteria criteria1 = new Criteria(Column.getColumn((String)DomainHandler.tableDCName, (String)"DOMAIN_NAME"), (Object)domainName, 0);
                Criteria criteria2 = criteria1.and(new Criteria(Column.getColumn((String)DomainHandler.tableDCName, (String)"DOMAIN_CONTROLLER_NAME"), (Object)name, 0));
                DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get(DomainHandler.tableDCName, criteria2);
                if (!dataObject.isEmpty()) {
                    Row dcRow = dataObject.getRow(DomainHandler.tableDCName);
                    Long dcId = (Long)dcRow.get("DOMAIN_CONTROLLER_ID");
                    Criteria criteria3 = new Criteria(Column.getColumn((String)DomainHandler.tableEventDCRead, (String)"DOMAIN_CONTROLLER_ID"), (Object)dcId, 0);
                    DataObject dcEventObj = CommonUtil.getPersistence(new boolean[0]).get(DomainHandler.tableEventDCRead, criteria3);
                    if (!dcEventObj.isEmpty()) {
                        Row dcEventRow = dcEventObj.getRow(DomainHandler.tableEventDCRead);
                        ArrayList list = (ArrayList)properties.get("operatingSystemVersion");
                        dcEventRow.set("OS_VERSION", (Object)((String)list.get(0)));
                        dcEventObj.updateRow(dcEventRow);
                        DataObject dataObj = CommonUtil.getPersistence(new boolean[0]).update(dcEventObj);
                        osVersion = (String)list.get(0);
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return osVersion;
    }

    public String getObjectOsVersion(String domainName, String guid, String name, String objClassName) throws Exception {
        Row row = null;
        String osVersion = null;
        try {
            row = this.getComputerObjectRow(objClassName, guid, name, domainName);
            if (row != null) {
                osVersion = (String)row.get("VERSION");
            }
            reportLogger.log(Level.INFO, "Os Version for [{0}]:[{1}]", new Object[]{name, osVersion});
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return osVersion;
    }

    public String getComputerOsVersion(String domainName, String guid, String name, String objClassName) throws Exception {
        Row row = null;
        String osVersion = null;
        try {
            if (guid == null || guid.equals("")) {
                osVersion = DirectoryObjectAPI.getComputerPropFromAD(domainName, name);
            }
            if (osVersion == null && (row = this.getComputerObjectRow(objClassName, guid, name, domainName)) != null) {
                osVersion = (String)row.get("VERSION");
            }
            if (osVersion != null) {
                EventDataUtil.setComputerOsVersion(name, domainName, osVersion);
            }
            reportLogger.log(Level.INFO, "Os Version for getComputerOsVersion [{0}]:[{1}]", new Object[]{name, osVersion});
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return osVersion;
    }

    public Row getComputerObjectRow(String objClassName, String guid, String name, String domainName) {
        Row row = null;
        try {
            ObjectClass object = this.getObjectClass(objClassName);
            if (object != null) {
                String tableName = object.getBaseTable();
                Criteria crit = null;
                if (guid != null && !guid.equals("")) {
                    crit = new Criteria(Column.getColumn((String)tableName, (String)"OBJECT_GUID"), (Object)guid, 0, false);
                } else {
                    crit = new Criteria(Column.getColumn((String)tableName, (String)"NAME"), (Object)name, 0, false);
                    Criteria crit2 = new Criteria(Column.getColumn((String)tableName, (String)"DNS_NAME"), (Object)name, 0, false);
                    crit = crit.or(crit2);
                    if (domainName != null) {
                        Criteria domainCrit = new Criteria(Column.getColumn((String)tableName, (String)"DOMAIN_NAME"), (Object)domainName, 0, false);
                        crit = crit.and(domainCrit);
                    }
                }
                DataObject dataObj = CommonUtil.getPersistence(new boolean[0]).get(tableName, crit);
                String osVersion = null;
                if (!dataObj.isEmpty() && (row = dataObj.getRow(tableName)).get("VERSION") != null) {
                    osVersion = row.get("VERSION").toString();
                }
                if ((dataObj.isEmpty() || osVersion == null || osVersion.equals("")) && domainName != null) {
                    if (guid != null && !guid.equals("")) {
                        ObjectUpdateUtil.updateObjectFromGUID(domainName, guid, object, null, true);
                    } else {
                        ObjectUpdateUtil.updateComputerFromName(domainName, name, true);
                    }
                    dataObj = CommonUtil.getPersistence(new boolean[0]).get(tableName, crit);
                }
                row = dataObj.getRow(tableName);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return row;
    }

    public Row getObjectRow(String domainName, String guid, String queryColumnName, String objClassName, String dcName) throws Exception {
        Row row = null;
        try {
            ObjectClass object = this.getObjectClass(objClassName);
            row = this.getObjectRowFromTable(domainName, guid, queryColumnName, objClassName, dcName);
            if (row == null) {
                if (queryColumnName.equalsIgnoreCase("OBJECT_GUID")) {
                    ObjectUpdateUtil.updateObjectFromGUID(domainName, guid, object, dcName, false);
                } else if (queryColumnName.equalsIgnoreCase("SID_STRING")) {
                    reportLogger.log(Level.INFO, "For domainName [{0}], getting [{1}] with sid [{2}].", new Object[]{domainName, objClassName, guid});
                    ObjectUpdateUtil.updateObjectFromSID(domainName, guid, objClassName);
                } else if ((queryColumnName.equalsIgnoreCase("SAM_ACCOUNT_NAME") || queryColumnName.equalsIgnoreCase("LOGON_NAME")) && objClassName.equalsIgnoreCase("user")) {
                    String ldapStr = "sAMAccountName";
                    boolean checkForObject = true;
                    if (queryColumnName.equalsIgnoreCase("LOGON_NAME")) {
                        ldapStr = "userPrincipalName";
                        if (!guid.split("@")[1].equalsIgnoreCase(DomainDetailsAPI.getDomainDNSName(domainName))) {
                            checkForObject = false;
                        }
                    }
                    if (checkForObject) {
                        reportLogger.log(Level.INFO, "For domainName [{0}], getting [{1}] with samaccoutname [{2}] ", new Object[]{domainName, objClassName, guid});
                        UserObjectUtil.updateUserFromAccountName(domainName, guid, dcName, ldapStr);
                    } else {
                        reportLogger.log(Level.INFO, "For domainName [{0}], [{1}] [{2}] may be from another trusted domain, skipping LDAP Query ", new Object[]{domainName, objClassName, guid});
                    }
                } else if (queryColumnName.equalsIgnoreCase("NAME") && objClassName.equalsIgnoreCase("computer")) {
                    ObjectUpdateUtil.updateComputerFromName(domainName, guid, false);
                }
                row = this.getObjectRowFromTable(domainName, guid, queryColumnName, objClassName, dcName);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return row;
    }

    public Row getObjectRow(String domainName, String guid, String queryColumnName, String objClassName) throws Exception {
        Row r = null;
        try {
            ObjectClass object = this.getObjectClass(objClassName);
            if (object != null) {
                String tableName = object.getBaseTable();
                Criteria crit = new Criteria(Column.getColumn((String)tableName, (String)queryColumnName), (Object)guid, 0);
                crit = crit.and(new Criteria(Column.getColumn((String)tableName, (String)"DOMAIN_NAME"), (Object)domainName, 0));
                DataObject dataObj = CommonUtil.getPersistence(new boolean[0]).get(tableName, crit);
                if (dataObj.isEmpty()) {
                    if (queryColumnName.equalsIgnoreCase("SID_STRING")) {
                        reportLogger.log(Level.INFO, "For domainName [{0}], getting [{1}] with sid [{2}].", new Object[]{domainName, objClassName, guid});
                        ObjectUpdateUtil.updateObjectFromSID(domainName, guid, objClassName);
                    } else if (queryColumnName.equalsIgnoreCase("SAM_ACCOUNT_NAME") && objClassName.equalsIgnoreCase("user")) {
                        reportLogger.log(Level.INFO, "For domainName [{0}], getting [{1}] with samaccoutname [{2}] ", new Object[]{domainName, objClassName, guid});
                        UserObjectUtil.updateUserFromAccountName(domainName, guid, null, "sAMAccountName");
                    } else if (queryColumnName.equalsIgnoreCase("NAME") && objClassName.equalsIgnoreCase("computer")) {
                        ObjectUpdateUtil.updateComputerFromName(domainName, guid, false);
                    }
                }
                dataObj = CommonUtil.getPersistence(new boolean[0]).get(tableName, crit);
                r = dataObj.getRow(tableName);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return r;
    }

    public Row getObjectRowFromDB(String domainName, String guid, String queryColumnName, String objClassName) throws Exception {
        Row r = null;
        try {
            ObjectClass object = this.getObjectClass(objClassName);
            if (object != null) {
                DataObject dataObj;
                String tableName = object.getBaseTable();
                Criteria crit = new Criteria(Column.getColumn((String)tableName, (String)queryColumnName), (Object)guid, 0);
                if (!queryColumnName.equalsIgnoreCase("SID_STRING") && !queryColumnName.equalsIgnoreCase("OBJECT_GUID")) {
                    crit = crit.and(new Criteria(Column.getColumn((String)tableName, (String)"DOMAIN_NAME"), (Object)domainName, 0));
                }
                if ((dataObj = CommonUtil.getPersistence(new boolean[0]).get(tableName, crit)).isEmpty()) {
                    return r;
                }
                r = dataObj.getRow(tableName);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return r;
    }

    public Row getObjectRowFromAD(String domainName, String guid, String queryColumnName, String objClassName) throws Exception {
        Row r = null;
        try {
            ObjectClass object = this.getObjectClass(objClassName);
            if (object != null) {
                String tableName = object.getBaseTable();
                Criteria crit = new Criteria(Column.getColumn((String)tableName, (String)queryColumnName), (Object)guid, 0);
                crit = crit.and(new Criteria(Column.getColumn((String)tableName, (String)"DOMAIN_NAME"), (Object)domainName, 0));
                if (queryColumnName.equalsIgnoreCase("SID_STRING")) {
                    reportLogger.log(Level.INFO, "-->For domainNameAD [{0}], getting [{1}] with sid [{2}].", new Object[]{domainName, objClassName, guid});
                    ObjectUpdateUtil.updateObjectFromSID(domainName, guid, objClassName);
                } else if (queryColumnName.equalsIgnoreCase("SAM_ACCOUNT_NAME") && objClassName.equalsIgnoreCase("user")) {
                    reportLogger.log(Level.INFO, "-->For domainNameAD [{0}], getting [{1}] with samaccoutname [{2}] ", new Object[]{domainName, objClassName, guid});
                    UserObjectUtil.updateUserFromAccountName(domainName, guid, null, "SAM_ACCOUNT_NAME");
                } else if (queryColumnName.equalsIgnoreCase("NAME") && objClassName.equalsIgnoreCase("computer")) {
                    ObjectUpdateUtil.updateComputerFromName(domainName, guid, false);
                }
                DataObject dataObj = CommonUtil.getPersistence(new boolean[0]).get(tableName, crit);
                r = dataObj.getRow(tableName);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return r;
    }

    public Hashtable<String, String> getObjectRowFromADWithoutListener(String domainName, String sidString) {
        Hashtable<String, String> retHash = new Hashtable<String, String>();
        try {
            ArrayList<String> attributeList = new ArrayList<String>(Arrays.asList("canonicalName", "cn", "distinguishedName", "objectGUID", "objectSID", "objectClass", "name"));
            reportLogger.log(Level.INFO, "Getting Object From AD (GC Bind) , SID is " + sidString);
            ArrayList ret = ADHandler.getObjectsWithoutListenerWithSIDFromGC(domainName, attributeList, sidString);
            Properties p = (Properties)ret.get(0);
            ArrayList objClass = (ArrayList)p.get("objectClass");
            String objClassName = "";
            if (objClass.contains("user")) {
                objClassName = "user";
            } else if (objClass.contains("group")) {
                objClassName = "group";
            } else if (objClass.contains("computer")) {
                objClassName = "computer";
            } else if (objClass.contains("foreignSecurityPrincipal")) {
                DirectoryObjectAPI.getInstance().getObjectRowFromAD(domainName, sidString, "SID_STRING", "foreignSecurityPrincipal");
                objClassName = "foreignSecurityPrincipal";
            }
            ObjectClass object = this.getObjectClass(objClassName);
            Integer reportId = object.getReportId();
            ArrayList tempList = (ArrayList)p.get("name");
            retHash.put("objectClass", objClassName);
            retHash.put("name", (String)tempList.get(0));
            tempList = (ArrayList)p.get("distinguishedName");
            String name = (String)tempList.get(0);
            String[] dnParts = name.split(",");
            String domainNameBuilder = "";
            for (int i = 0; i < dnParts.length; ++i) {
                if (!dnParts[i].contains("DC")) continue;
                domainNameBuilder = domainNameBuilder + dnParts[i].replace("DC=", "") + ".";
            }
            domainNameBuilder = domainNameBuilder.substring(0, domainNameBuilder.length() - 1);
            DataObject d = CommonUtil.getPersistence(new boolean[0]).get("ADSMDomainConfiguration", new Criteria(Column.getColumn((String)"ADSMDomainConfiguration", (String)"DOMAIN_DNS_NAME"), (Object)domainNameBuilder, 0));
            if (!d.isEmpty() && !objClassName.equals("foreignSecurityPrincipal")) {
                domainName = (String)d.getFirstRow("ADSMDomainConfiguration").get("DOMAIN_NAME");
                ObjectUpdateUtil.updateObjects(reportId, p, domainName, false);
            }
        }
        catch (Exception e) {
            reportLogger.log(Level.INFO, "Unable to find Object with sid " + sidString + " in domain " + domainName);
        }
        return retHash;
    }

    public String getColumnName(String objClassName, String ldapName) {
        String columnName = null;
        try {
            ObjectClass objClass = this.getObjectClass(objClassName);
            if (objClass != null) {
                Criteria crit = new Criteria(Column.getColumn((String)"ADSMAttributeDetails", (String)"ATTRIB_LDAP_NAME"), (Object)ldapName, 0);
                crit = crit.and(new Criteria(Column.getColumn((String)"ADSMAttributeDetails", (String)"ATTRIB_ID"), (Object)objClass.getStartRange(), 4));
                crit = crit.and(new Criteria(Column.getColumn((String)"ADSMAttributeDetails", (String)"ATTRIB_ID"), (Object)objClass.getEndRange(), 6));
                DataObject dataObj = CommonUtil.getPersistence(new boolean[0]).get("ADSMAttributeDetails", crit);
                if (!dataObj.isEmpty()) {
                    Row r = dataObj.getRow("ADSMAttributeDetails");
                    columnName = (String)r.get("ATTRIB_COLUMN_NAME");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return columnName;
    }

    public ArrayList getChildObjects(String domainName, String objectClass, String childObjectClass, String guid) {
        ArrayList objectsList = new ArrayList();
        try {
            if (objectClass.equalsIgnoreCase("organizationalUnit")) {
                Row objectRow = this.getObjectRow(domainName, guid, "organizationalUnit");
                if (objectRow != null) {
                    String distinguishedName = (String)objectRow.get("DISTINGUISHED_NAME");
                    objectsList = OUHandler.getChildObjects(childObjectClass, distinguishedName);
                }
            } else if (objectClass.equalsIgnoreCase("group")) {
                objectsList = GroupHandler.getChildObjects(domainName, childObjectClass, guid);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return objectsList;
    }

    public int getDomainObjectsCount(String domainName, String objectClass, String searchPattern, Long cvId) {
        int ret1 = 0;
        String defaultNamingContext = DomainDetailsAPI.getDefaultNamingContext(domainName);
        ret1 = this.getObjectsCount(defaultNamingContext, objectClass, searchPattern, cvId);
        return ret1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getObjectsCount(String defaultNamingContext, String objectClass, String searchPattern, Long loginId, ArrayList ouList) {
        Connection connection = null;
        Integer ret = null;
        DataSet dataSet = null;
        try {
            ObjectClass objectClass2 = this.getObjectClass(objectClass);
            Integer reportId = objectClass2.getReportId();
            loginId = 1L;
            Long ret1 = ObjectUpdateHandler.getRecentlyGeneratedReports(reportId, loginId);
            String domainName = DomainDetailsAPI.getDomainName(defaultNamingContext);
            if (ret1 == null) {
                DirectoryObjectAPI.runObjectUpdate(domainName, defaultNamingContext, reportId);
            }
            String tableName = objectClass2.getBaseTable();
            Column column = Column.getColumn((String)tableName, (String)"NAME");
            Criteria criteria = new Criteria(Column.getColumn((String)tableName, (String)"DOMAIN_NAME"), (Object)domainName, 0);
            if (searchPattern != null) {
                criteria = criteria.and(new Criteria(column, (Object)searchPattern, 2, false));
            }
            Criteria ouCrit = null;
            if (ouList != null && !ouList.isEmpty()) {
                for (int i = 0; i < ouList.size(); ++i) {
                    String ouDN = (String)ouList.get(i);
                    Criteria crite = new Criteria(Column.getColumn((String)tableName, (String)"DISTINGUISHED_NAME"), (Object)ouDN, 11);
                    ouCrit = ouCrit == null ? crite : ouCrit.or(crite);
                }
                criteria = criteria.and(ouCrit);
            }
            SelectQueryImpl sq = new SelectQueryImpl(Table.getTable((String)tableName));
            if (criteria != null) {
                sq.setCriteria(criteria);
            }
            sq.addSortColumn(new SortColumn(tableName, "NAME", true));
            Column countColumn = Column.getColumn(null, (String)"*");
            sq.addSelectColumn(countColumn.count());
            RelationalAPI relationalAPI = RelationalAPI.getInstance();
            connection = relationalAPI.getConnection();
            dataSet = relationalAPI.executeQuery((Query)sq, connection);
            while (dataSet.next()) {
                ret = (Integer)dataSet.getValue(1);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (dataSet != null) {
                    dataSet.close();
                }
            }
            catch (Exception se) {
                se.printStackTrace();
            }
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException se) {
                se.printStackTrace();
            }
        }
        return ret;
    }

    public static void runObjectUpdate(String domainName, String defaultNamingContext, Integer reportId) {
        try {
            DataObject obj = ObjectUpdateHandler.getReportDetails(reportId);
            Row r = obj.getFirstRow("ADSMReports");
            String className = (String)r.get("CLASS_NAME");
            Class<?> classToInvoke = Class.forName(className.trim());
            ObjectUpdateTask listener = (ObjectUpdateTask)classToInvoke.newInstance();
            listener.init(r);
            ArrayList<String> containerList = new ArrayList<String>();
            containerList.add(defaultNamingContext);
            Hashtable<String, String> dnDomainNameMap = new Hashtable<String, String>();
            dnDomainNameMap.put(defaultNamingContext, domainName);
            listener.executeTask(containerList, dnDomainNameMap, null, null, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public DataObject getObjects(String defaultNamingContext, String objectClass, String searchPattern, int startIndex, int numOfObjects, Criteria c) {
        ObjectClass objectClass2 = this.getObjectClass(objectClass);
        Integer reportId = objectClass2.getReportId();
        Long loginId = 1L;
        Long ret = ObjectUpdateHandler.getRecentlyGeneratedReports(reportId, loginId);
        String domainName = DomainDetailsAPI.getDomainName(defaultNamingContext);
        if (ret == null) {
            DirectoryObjectAPI.runObjectUpdate(domainName, defaultNamingContext, reportId);
        }
        return this.getObjectProps(domainName, objectClass, searchPattern, startIndex, numOfObjects, c, loginId, null);
    }

    public DataObject getObjectProps(String domainName, String objectClass, String searchPattern, int startIndex, int numOfObjects, Criteria c, Long loginId, ArrayList ouList) {
        DataObject dataObj = null;
        try {
            ObjectClass objectClass2 = this.getObjectClass(objectClass);
            String tableName = objectClass2.getBaseTable();
            Column column = Column.getColumn((String)tableName, (String)"NAME");
            Criteria criteria = new Criteria(Column.getColumn((String)tableName, (String)"DOMAIN_NAME"), (Object)domainName, 0);
            if (searchPattern != null) {
                criteria = criteria.and(new Criteria(column, (Object)searchPattern, 2, false));
            }
            if (c != null) {
                criteria = criteria.and(c);
            }
            Criteria ouCrit = null;
            if (ouList != null && !ouList.isEmpty()) {
                for (int i = 0; i < ouList.size(); ++i) {
                    String ouDN = (String)ouList.get(i);
                    Criteria crite = new Criteria(Column.getColumn((String)tableName, (String)"DISTINGUISHED_NAME"), (Object)ouDN, 11);
                    ouCrit = ouCrit == null ? crite : ouCrit.or(crite);
                }
                criteria = criteria.and(ouCrit);
            }
            SelectQueryImpl sq = new SelectQueryImpl(Table.getTable((String)tableName));
            if (criteria != null) {
                sq.setCriteria(criteria);
            }
            sq.addSortColumn(new SortColumn(tableName, "NAME", true));
            if (startIndex != -1) {
                sq.setRange(new Range(startIndex, numOfObjects));
            }
            sq.addSelectColumn(Column.getColumn((String)tableName, (String)"*"));
            sq.addSelectColumn(column);
            dataObj = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)sq);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return dataObj;
    }

    public ArrayList getObjectsGenerationId(String objectClass, String searchPattern, Long generationId, Long objectType) throws Exception {
        Iterator iterator = null;
        ArrayList rowsList = new ArrayList();
        String columnName = "NAME";
        String canonicalName = "CANONICAL_NAME";
        String samAccountName = "SAM_ACCOUNT_NAME";
        String objectGuid = "OBJECT_GUID";
        try {
            ObjectClass object = this.getObjectClass(objectClass);
            if (object != null) {
                String tableName = object.getBaseTable();
                DataObject dataObj = this.getObjectRowsGenerationId(null, objectClass, generationId, objectType, searchPattern);
                if (dataObj != null && !dataObj.isEmpty()) {
                    iterator = dataObj.getRows(tableName);
                }
            }
            HashMap<String, String> valueMap = null;
            if (iterator != null) {
                while (iterator.hasNext()) {
                    Row row = (Row)iterator.next();
                    valueMap = new HashMap<String, String>();
                    valueMap.put("NAME", (String)row.get(columnName));
                    valueMap.put("CANONICAL_NAME", (String)row.get(canonicalName));
                    if (objectClass.equalsIgnoreCase("user")) {
                        valueMap.put("SAM_ACCOUNT_NAME", (String)row.get(samAccountName));
                    }
                    valueMap.put("OBJECT_GUID", (String)row.get(objectGuid));
                    rowsList.add(valueMap);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return rowsList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList getObjects(String defaultNamingContext, String objectClass, String searchPattern, int startIndex, int numOfObjects, Long cvId, Long count) {
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        ArrayList rowsList = new ArrayList();
        String columnName = "NAME";
        String canonicalName = "CANONICAL_NAME";
        String samAccountName = "SAM_ACCOUNT_NAME";
        String objectGuid = "OBJECT_GUID";
        try {
            if (cvId.equals(DBObjectUtil.getUVHValues("AUDCVConfig", "AUDCVConfig:cv_id:897"))) {
                columnName = "LOCATION";
                canonicalName = "LOCAL_PATH";
                objectGuid = columnName;
            }
            if (cvId.equals(DBObjectUtil.getUVHValues("AUDCVConfig", "AUDCVConfig:cv_id:100005"))) {
                objectGuid = "PRINTER_NAME";
            }
            String dbServerName = CommonUtil.getDBServerName();
            ObjectClass objectClass2 = this.getObjectClass(objectClass);
            Integer reportId = objectClass2.getReportId();
            Long loginId = 1L;
            Long ret = ObjectUpdateHandler.getRecentlyGeneratedReports(reportId, loginId);
            String domainName = DomainDetailsAPI.getDomainName(defaultNamingContext);
            if (ret == null && !cvId.equals(DBObjectUtil.getUVHValues("AUDCVConfig", "AUDCVConfig:cv_id:897"))) {
                DirectoryObjectAPI.runObjectUpdate(domainName, defaultNamingContext, reportId);
            }
            String sqlQuery = DirectoryObjectAPI.getSQLQuery(cvId, startIndex, numOfObjects, domainName, searchPattern, count);
            RelationalAPI relationalAPI = RelationalAPI.getInstance();
            connection = relationalAPI.getConnection();
            statement = connection.createStatement();
            resultSet = statement.executeQuery(sqlQuery);
            while (resultSet.next()) {
                HashMap<String, String> valueMap = new HashMap<String, String>();
                if (objectClass.equalsIgnoreCase("printer")) {
                    valueMap.put("NAME", resultSet.getString("PRINTER_NAME"));
                    valueMap.put("OBJECT_GUID", resultSet.getString(objectGuid));
                } else {
                    valueMap.put("NAME", resultSet.getString(columnName));
                    valueMap.put("CANONICAL_NAME", resultSet.getString(canonicalName));
                    if (objectClass.equalsIgnoreCase("user")) {
                        valueMap.put("SAM_ACCOUNT_NAME", resultSet.getString(samAccountName));
                    }
                    valueMap.put("OBJECT_GUID", resultSet.getString(objectGuid));
                }
                rowsList.add(valueMap);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (SQLException se) {
                se.printStackTrace();
            }
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException se) {
                se.printStackTrace();
            }
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException se) {
                se.printStackTrace();
            }
        }
        return rowsList;
    }

    public static String getSQLQuery(Long cvId, Integer startIndex, Integer range, String domainName, String searchPattern, Long count) {
        String sqlQuery = "";
        try {
            DataObject cvDO = AUDCustomViewAPI.getInstance().getCustomViewDO(cvId);
            if (cvDO != null && cvDO.size("AUDSQLQuery") > 0) {
                Row row = cvDO.getRow("AUDSQLQuery");
                sqlQuery = row.get("SQL_STRING").toString();
                if (cvDO.size("AUDUnionQuery") > 0) {
                    row = cvDO.getRow("AUDUnionQuery");
                    String unionQuery = row.get("UNION_QUERY").toString();
                    unionQuery = DirectoryObjectAPI.replaceSearchPattern(unionQuery, searchPattern, cvId);
                    unionQuery = unionQuery.replace("${domainName}", "'" + domainName + "'");
                    Integer innerTopVal = startIndex - 1 + range;
                    Integer countValue = count.intValue();
                    if (countValue > 0 && countValue < innerTopVal) {
                        range = countValue % range;
                    }
                    if (countValue == 0) {
                        sqlQuery = unionQuery;
                        sqlQuery = ADAPSQLQueryUtil.removeCharSequence(sqlQuery, new String[]{"${TOPVAL}", "${INNERTOPVAL}", "${LIMIT}", "${INNERLIMIT}"});
                    } else {
                        sqlQuery = sqlQuery.replace("${UNION_QUERY}", unionQuery);
                        sqlQuery = QueryBuilderAPI.getInstance().getQueryBuilder().replaceRangeValues(sqlQuery, range.toString(), innerTopVal.toString());
                    }
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return sqlQuery;
    }

    public int getObjectsCountGenerationId(String objectClass, String searchPattern, Long generationId, Long objectType) throws Exception {
        int count = 0;
        try {
            ObjectClass object = this.getObjectClass(objectClass);
            if (object != null) {
                String tableName = object.getBaseTable();
                DataObject dataObj = this.getObjectRowsGenerationId(null, objectClass, generationId, objectType, searchPattern);
                if (dataObj != null && !dataObj.isEmpty()) {
                    count = dataObj.size(tableName);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getObjectsCount(String defaultNamingContext, String objectClass, String searchPattern, Long cvId) {
        int ret1 = 0;
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        ArrayList rowsList = new ArrayList();
        String dbServerName = CommonUtil.getDBServerName();
        try {
            ObjectClass objectClass2 = this.getObjectClass(objectClass);
            Integer reportId = objectClass2.getReportId();
            Long loginId = 1L;
            Long ret = ObjectUpdateHandler.getRecentlyGeneratedReports(reportId, loginId);
            String domainName = DomainDetailsAPI.getDomainName(defaultNamingContext);
            if (ret == null && !cvId.equals(DBObjectUtil.getUVHValues("AUDCVConfig", "AUDCVConfig:cv_id:897"))) {
                DirectoryObjectAPI.runObjectUpdate(domainName, defaultNamingContext, reportId);
            }
            String countQuery = DirectoryObjectAPI.getCountSqlQuery(cvId, searchPattern, domainName);
            RelationalAPI relationalAPI = RelationalAPI.getInstance();
            connection = relationalAPI.getConnection();
            statement = connection.createStatement();
            resultSet = statement.executeQuery(countQuery);
            while (resultSet.next()) {
                ret1 = resultSet.getInt(1);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (SQLException se) {
                se.printStackTrace();
            }
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException se) {
                se.printStackTrace();
            }
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException se) {
                se.printStackTrace();
            }
        }
        return ret1;
    }

    public static String getCountSqlQuery(Long cvId, String searchPattern, String domainName) {
        String countQuery = "";
        try {
            DataObject cvDO = AUDCustomViewAPI.getInstance().getCustomViewDO(cvId);
            if (cvDO != null && cvDO.size("AUDSQLQuery") > 0) {
                Row row = cvDO.getRow("AUDSQLQuery");
                countQuery = row.get("COUNT_SQL_STRING").toString();
                if (cvDO.size("AUDUnionQuery") > 0) {
                    row = cvDO.getRow("AUDUnionQuery");
                    String unionCountQuery = row.get("UNION_COUNT_QUERY").toString();
                    unionCountQuery = DirectoryObjectAPI.replaceSearchPattern(unionCountQuery, searchPattern, cvId);
                    unionCountQuery = unionCountQuery.replace("${domainName}", "'" + domainName + "'");
                    countQuery = countQuery.replace("${UNION_COUNT_QUERY}", unionCountQuery);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return countQuery;
    }

    public DataObject getObjectRowsGenerationId(ArrayList selectedObjectsList, String objClassName, Long generationId, Long objectType, String searchPattern) throws Exception {
        DataObject dataObj = null;
        try {
            ObjectClass object;
            String[] guid = null;
            if (selectedObjectsList != null) {
                guid = new String[selectedObjectsList.size()];
                for (int k = 0; k < selectedObjectsList.size(); ++k) {
                    guid[k] = (String)selectedObjectsList.get(k);
                }
            }
            if ((object = this.getObjectClass(objClassName)) != null) {
                String tableName = object.getBaseTable();
                Criteria crit = null;
                String resultTable = object.getResultTable();
                SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)tableName));
                query.addSelectColumn(Column.getColumn((String)tableName, (String)"*"));
                query.addJoin(new Join(tableName, resultTable, new String[]{"OBJECT_GUID"}, new String[]{"OBJECT_GUID"}, 1));
                SortColumn sortColumn = new SortColumn(tableName, "NAME", true);
                query.addSortColumn(sortColumn);
                Criteria criteria = new Criteria(Column.getColumn((String)resultTable, (String)"REPORT_GENERATION_ID"), (Object)generationId, 0);
                if (searchPattern != null) {
                    crit = new Criteria(Column.getColumn((String)tableName, (String)"NAME"), (Object)searchPattern, 2);
                    criteria = criteria.and(crit);
                }
                if (guid != null) {
                    crit = new Criteria(Column.getColumn((String)tableName, (String)"OBJECT_GUID"), (Object)guid, 8);
                    criteria = criteria.and(crit);
                }
                if (objectType == 5L || objectType == DBObjectUtil.getUVHValues("AUDCVConfig", "AUDCVConfig:cv_id:9")) {
                    criteria = criteria.and(new Criteria(Column.getColumn((String)tableName, (String)"ROLE"), (Object)"*DomainController*", 2));
                    criteria = criteria.and(new Criteria(Column.getColumn((String)tableName, (String)"OPERATING_SYSTEM"), (Object)"*Server*", 2));
                } else if (objectType == 7L || objectType == DBObjectUtil.getUVHValues("AUDCVConfig", "AUDCVConfig:cv_id:10") || objectType == DBObjectUtil.getUVHValues("AUDCVConfig", "AUDCVConfig:cv_id:18")) {
                    query.addJoin(new Join(tableName, "AUDComputerEventRead", new String[]{"OBJECT_GUID"}, new String[]{"OBJECT_GUID"}, 1));
                    criteria = criteria.and(new Criteria(Column.getColumn((String)"AUDComputerEventRead", (String)"OBJECT_GUID"), null, 0));
                    criteria = criteria.and(new Criteria(Column.getColumn((String)tableName, (String)"ROLE"), (Object)"*Server*", 2));
                    criteria = criteria.and(new Criteria(Column.getColumn((String)tableName, (String)"OPERATING_SYSTEM"), (Object)"*Server*", 3));
                    criteria = criteria.and(new Criteria(Column.getColumn((String)tableName, (String)"OPERATING_SYSTEM"), (Object)"*windows*", 2));
                } else if (objectType == 6L || objectType == DBObjectUtil.getUVHValues("AUDCVConfig", "AUDCVConfig:cv_id:11")) {
                    criteria = criteria.and(new Criteria(Column.getColumn((String)tableName, (String)"ROLE"), (Object)"*Server*", 2));
                    criteria = criteria.and(new Criteria(Column.getColumn((String)tableName, (String)"OPERATING_SYSTEM"), (Object)"*Server*", 2));
                    criteria = criteria.and(new Criteria(Column.getColumn((String)tableName, (String)"OPERATING_SYSTEM"), (Object)"*EMC*", 3));
                } else if (objectType == DBObjectUtil.getUVHValues("AUDCVConfig", "AUDCVConfig:cv_id:19")) {
                    criteria = criteria.and(new Criteria(Column.getColumn((String)tableName, (String)"OPERATING_SYSTEM"), (Object)"*Server*", 2));
                    criteria = criteria.and(new Criteria(Column.getColumn((String)tableName, (String)"OPERATING_SYSTEM"), (Object)"*EMC*", 3));
                } else if (objectType == DBObjectUtil.getUVHValues("AUDCVConfig", "AUDCVConfig:cv_id:20")) {
                    Criteria cr = new Criteria(Column.getColumn((String)tableName, (String)"OPERATING_SYSTEM"), (Object)"*netapp*", 2);
                    cr = cr.or(new Criteria(Column.getColumn((String)tableName, (String)"OPERATING_SYSTEM"), (Object)"*OnTap*", 2));
                    criteria = criteria.and(cr);
                } else if (objectType == DBObjectUtil.getUVHValues("AUDCVConfig", "AUDCVConfig:cv_id:21")) {
                    criteria = criteria.and(new Criteria(Column.getColumn((String)tableName, (String)"OPERATING_SYSTEM"), (Object)"*EMC*", 2));
                }
                query.setCriteria(criteria);
                dataObj = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)query);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return dataObj;
    }

    public Iterator getObjectRows(String domainName, ArrayList selectedObjectsList, String objClassName) throws Exception {
        Iterator iterator = null;
        try {
            String[] guid = new String[selectedObjectsList.size()];
            for (int k = 0; k < selectedObjectsList.size(); ++k) {
                guid[k] = (String)selectedObjectsList.get(k);
            }
            ObjectClass object = this.getObjectClass(objClassName);
            if (object != null) {
                String tableName = object.getBaseTable();
                Criteria crit = null;
                crit = tableName.equalsIgnoreCase("ADSMShareGeneralDetails") ? new Criteria(Column.getColumn((String)tableName, (String)"LOCATION"), (Object)guid, 8) : (tableName.equalsIgnoreCase("ADSMPrinterGeneralDetails") ? new Criteria(Column.getColumn((String)tableName, (String)"PRINTER_NAME"), (Object)guid, 8) : new Criteria(Column.getColumn((String)tableName, (String)"OBJECT_GUID"), (Object)guid, 8));
                DataObject dataObj = CommonUtil.getPersistence(new boolean[0]).get(tableName, crit);
                if (!dataObj.isEmpty()) {
                    iterator = dataObj.getRows(tableName);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return iterator;
    }

    public int getObjectRowsCount(ArrayList containerList, Hashtable dnDomainNameMap, String objClassName) {
        int doSize = 0;
        try {
            String domainName = (String)dnDomainNameMap.get(containerList.get(0));
            ObjectClass object = this.getObjectClass(objClassName);
            if (object != null) {
                String tableName = object.getBaseTable();
                Criteria crit = new Criteria(Column.getColumn((String)tableName, (String)"DOMAIN_NAME"), (Object)domainName, 0);
                DataObject dataObj = CommonUtil.getPersistence(new boolean[0]).get(tableName, crit);
                if (!dataObj.isEmpty()) {
                    doSize = dataObj.size(tableName);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return doSize;
    }

    public Hashtable<String, String> getMapFromDB(String queryColumnName, String objClassName) throws Exception {
        Hashtable<String, String> uniqueKeyMap = new Hashtable<String, String>();
        try {
            ObjectClass object = this.getObjectClass(objClassName);
            if (object != null) {
                String tableName = object.getBaseTable();
                Criteria crit = new Criteria(Column.getColumn((String)tableName, (String)queryColumnName), null, 1);
                DataObject dataObj = CommonUtil.getPersistence(new boolean[0]).get(tableName, crit);
                Iterator iterator = dataObj.getRows(tableName);
                while (iterator.hasNext()) {
                    Row r = (Row)iterator.next();
                    String key = (String)r.get(queryColumnName);
                    String value = (String)r.get("NAME");
                    uniqueKeyMap.put(key, value);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return uniqueKeyMap;
    }

    public ArrayList getObjectGuid(String domainName, String objClassName, String objectName) {
        ArrayList<Object> guidList = new ArrayList<Object>();
        try {
            ObjectClass object = this.getObjectClass(objClassName);
            if (object != null) {
                String tableName = object.getBaseTable();
                Criteria crit = new Criteria(Column.getColumn((String)tableName, (String)"NAME"), (Object)objectName, 0);
                crit = crit.and(new Criteria(Column.getColumn((String)tableName, (String)"DOMAIN_NAME"), (Object)domainName, 0));
                DataObject dataObj = CommonUtil.getPersistence(new boolean[0]).get(tableName, crit);
                Row row = dataObj.getFirstRow(tableName);
                guidList.add(row.get("OBJECT_GUID"));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return guidList;
    }

    private static String replaceSearchPattern(String query, String searchPattern, Long cvId) throws Exception {
        if (searchPattern != null) {
            query = query.replace("${SCRITERIA}", searchPattern);
        } else {
            query = query.replaceAll("AND[ ]{1,}NAME[ ]{1,}LIKE[ ]{1,}'\\$\\{SCRITERIA}'", "");
            query = query.replaceAll("AND[ ]{1,}LOCATION[ ]{1,}LIKE[ ]{1,}'\\$\\{SCRITERIA}'", "");
            query = query.replaceAll("AND[ ]{1,}CANONICAL_NAME[ ]{1,}LIKE[ ]{1,}'\\$\\{SCRITERIA}'", "");
            query = query.replaceAll("AND[ ]{1,}PRINTER_NAME[ ]{1,}LIKE[ ]{1,}'\\$\\{SCRITERIA}'", "");
            query = query.replaceAll("AND[ ]{1,}ADSMComputerGeneralDetails.CANONICAL_NAME[ ]{1,}LIKE[ ]{1,}'\\$\\{SCRITERIA}'", "");
        }
        return query;
    }

    public Row getObjectRowFromTable(String domainName, String guid, String queryColumnName, String objClassName, String dcName) throws Exception {
        Row row = null;
        try {
            ObjectClass object = this.getObjectClass(objClassName);
            String tableName = null;
            String domainNameColumn = "DOMAIN_NAME";
            if (object != null) {
                tableName = object.getBaseTable();
                if (tableName.equalsIgnoreCase("ADSMDomainGeneralDetails")) {
                    domainNameColumn = "NAME";
                }
            } else if (objClassName.equalsIgnoreCase("dnsNode") || objClassName.equalsIgnoreCase("dnsZone")) {
                tableName = "AUDDNSObjectDetails";
            }
            if (tableName != null) {
                Criteria crit = new Criteria(Column.getColumn((String)tableName, (String)queryColumnName), (Object)guid, 0);
                crit = crit.and(new Criteria(Column.getColumn((String)tableName, (String)domainNameColumn), (Object)domainName, 0));
                DataObject dataObj = CommonUtil.getPersistence(new boolean[0]).get(tableName, crit);
                if (!dataObj.isEmpty()) {
                    row = dataObj.getRow(tableName);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return row;
    }
}

